/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class TileEntityForceField
extends TileEntity {
    private BlockPos blockPosProjector;
    private int cache_beamFrequency;
    public IBlockState cache_blockStateCamouflage;
    protected int cache_colorMultiplierCamouflage;
    protected int cache_lightCamouflage;
    private int gracePeriod_calls = 3;

    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("projector")) {
            this.blockPosProjector = Commons.createBlockPosFromNBT(tagCompound.func_74775_l("projector"));
            this.cache_beamFrequency = tagCompound.func_74762_e("beamFrequency");
        } else {
            this.blockPosProjector = null;
            this.cache_beamFrequency = -1;
        }
        if (tagCompound.func_74764_b("camouflage")) {
            NBTTagCompound nbtCamouflage = tagCompound.func_74775_l("camouflage");
            try {
                this.cache_blockStateCamouflage = Block.func_149684_b((String)nbtCamouflage.func_74779_i("block")).func_176203_a((int)nbtCamouflage.func_74771_c("meta"));
                this.cache_colorMultiplierCamouflage = nbtCamouflage.func_74762_e("color");
                this.cache_lightCamouflage = nbtCamouflage.func_74771_c("light");
                if (Dictionary.BLOCKS_NOCAMOUFLAGE.contains(this.cache_blockStateCamouflage.func_177230_c())) {
                    this.cache_blockStateCamouflage = null;
                    this.cache_colorMultiplierCamouflage = 0;
                    this.cache_lightCamouflage = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                this.cache_blockStateCamouflage = null;
                this.cache_colorMultiplierCamouflage = 0;
                this.cache_lightCamouflage = 0;
            }
        } else {
            this.cache_blockStateCamouflage = null;
            this.cache_colorMultiplierCamouflage = 0;
            this.cache_lightCamouflage = 0;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.blockPosProjector != null) {
            tagCompound.func_74782_a("projector", (NBTBase)Commons.writeBlockPosToNBT(this.blockPosProjector, new NBTTagCompound()));
            tagCompound.func_74768_a("beamFrequency", this.cache_beamFrequency);
            if (this.cache_blockStateCamouflage != null && this.cache_blockStateCamouflage.func_177230_c() != Blocks.field_150350_a) {
                NBTTagCompound nbtCamouflage = new NBTTagCompound();
                assert (this.cache_blockStateCamouflage.func_177230_c().getRegistryName() != null);
                nbtCamouflage.func_74778_a("block", this.cache_blockStateCamouflage.func_177230_c().getRegistryName().toString());
                nbtCamouflage.func_74774_a("meta", (byte)this.cache_blockStateCamouflage.func_177230_c().func_176201_c(this.cache_blockStateCamouflage));
                nbtCamouflage.func_74768_a("color", this.cache_colorMultiplierCamouflage);
                nbtCamouflage.func_74774_a("light", (byte)this.cache_lightCamouflage);
                tagCompound.func_74782_a("camouflage", (NBTBase)nbtCamouflage);
            }
        }
        return tagCompound;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = this.func_189515_b(super.func_189517_E_());
        tagCompound.func_82580_o("projector");
        tagCompound.func_82580_o("beamFrequency");
        return tagCompound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public void setProjector(BlockPos blockPos) {
        this.blockPosProjector = blockPos.func_185334_h();
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
        if (forceFieldSetup != null) {
            this.cache_beamFrequency = forceFieldSetup.beamFrequency;
            IBlockState blockStateCamouflage = forceFieldSetup.getCamouflageBlockState();
            if (blockStateCamouflage == null || this.func_145832_p() == blockStateCamouflage.func_177230_c().func_176201_c(blockStateCamouflage)) {
                this.cache_blockStateCamouflage = blockStateCamouflage;
                this.cache_colorMultiplierCamouflage = forceFieldSetup.getCamouflageColorMultiplier();
                this.cache_lightCamouflage = forceFieldSetup.getCamouflageLight();
            }
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    public TileEntityForceFieldProjector getProjector(@Nullable TileEntityForceFieldProjector tileEntityForceFieldProjectorCandidate) {
        if (this.blockPosProjector != null) {
            if (tileEntityForceFieldProjectorCandidate != null && this.blockPosProjector.equals((Object)tileEntityForceFieldProjectorCandidate.func_174877_v())) {
                return tileEntityForceFieldProjectorCandidate;
            }
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.blockPosProjector);
            if (tileEntity instanceof TileEntityForceFieldProjector) {
                TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)tileEntity;
                if (this.field_145850_b.field_72995_K) {
                    return tileEntityForceFieldProjector;
                }
                if (tileEntityForceFieldProjector.isPartOfForceField(new VectorI(this))) {
                    if (tileEntityForceFieldProjector.isActive()) {
                        return tileEntityForceFieldProjector;
                    }
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.info(String.format("Removed a force field from an offline projector %s", Commons.format(this.field_145850_b, this.field_174879_c)));
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            --this.gracePeriod_calls;
            if (this.gracePeriod_calls < 0) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
                if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                    WarpDrive.logger.info(String.format("Removed a force field with no projector defined %s", Commons.format(this.field_145850_b, this.field_174879_c)));
                }
            }
        }
        return null;
    }

    public ForceFieldSetup getForceFieldSetup() {
        TileEntityForceFieldProjector tileEntityForceFieldProjector = this.getProjector(null);
        if (tileEntityForceFieldProjector == null) {
            return null;
        }
        return tileEntityForceFieldProjector.getForceFieldSetup();
    }
}

