/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.BlockForceFieldProjector;
import cr0s.warpdrive.block.forcefield.TileEntityAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumForceFieldShape;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.FluidWrapper;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Optional;

public class TileEntityForceFieldProjector
extends TileEntityAbstractForceField {
    private static final int PROJECTOR_COOLDOWN_TICKS = 300;
    public static final int PROJECTOR_PROJECTION_UPDATE_TICKS = 8;
    private static final int PROJECTOR_SETUP_TICKS = 20;
    private static final int PROJECTOR_SOUND_UPDATE_TICKS = 60;
    private static final int PROJECTOR_GUIDE_UPDATE_TICKS = 300;
    public boolean isDoubleSided;
    private EnumForceFieldShape shape;
    private float rotationYaw;
    private float rotationPitch;
    private float rotationRoll;
    private Vector3 v3Min = new Vector3(-1.0, -1.0, -1.0);
    private Vector3 v3Max = new Vector3(1.0, 1.0, 1.0);
    private Vector3 v3Translation = new Vector3(0.0, 0.0, 0.0);
    private boolean isActive = false;
    private int cooldownTicks;
    private int setupTicks;
    private int updateTicks;
    private int soundTicks;
    private int guideTicks;
    private double damagesEnergyCost = 0.0;
    private final HashSet<UUID> setInteractedEntities = new HashSet();
    private ForceFieldSetup cache_forceFieldSetup;
    private ForceFieldSetup legacy_forceFieldSetup;
    private double consumptionLeftOver = 0.0;
    public EnumFacing enumFacing = EnumFacing.UP;
    private float carryScanSpeed;
    private float carryPlaceSpeed;
    private Set<VectorI> calculated_interiorField = null;
    private Set<VectorI> calculated_forceField = null;
    private Iterator<VectorI> iteratorForceField = null;
    private final Set<VectorI> vForceFields = new HashSet<VectorI>();
    final CopyOnWriteArraySet<VectorI> vForceFields_forRemoval = new CopyOnWriteArraySet();

    public TileEntityForceFieldProjector() {
        this.peripheralName = "warpdriveForceFieldProjector";
        this.addMethods(new String[]{"min", "max", "rotation", "state", "translation"});
        this.CC_scripts = Arrays.asList("enable", "disable");
        this.doRequireUpgradeToInterface();
        for (EnumForceFieldUpgrade enumForceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            if (enumForceFieldUpgrade.maxCountOnProjector <= 0) continue;
            this.registerUpgradeSlot(enumForceFieldUpgrade.getProjectorUpgradeSlot());
        }
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()], 4096, 0, "EV", 2, "EV", 0);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.cooldownTicks = 0;
        this.setupTicks = this.field_145850_b.field_73012_v.nextInt(20);
        this.updateTicks = this.field_145850_b.field_73012_v.nextInt(8);
        this.guideTicks = 300;
        this.enumFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockProperties.FACING);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)blockState.func_177229_b((IProperty)BlockForceFieldProjector.IS_DOUBLE_SIDED)).booleanValue()) {
            this.isDoubleSided = true;
        } else if (this.isDoubleSided) {
            this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a((IProperty)BlockForceFieldProjector.IS_DOUBLE_SIDED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public void func_73660_a() {
        block22: {
            boolean isEnabledAndValid;
            block21: {
                boolean new_isActive;
                int energyRequired;
                super.func_73660_a();
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (!this.isConnected) {
                    return;
                }
                --this.setupTicks;
                if (this.setupTicks <= 0) {
                    this.setupTicks = 20;
                    if (this.cache_forceFieldSetup != null) {
                        this.legacy_forceFieldSetup = this.cache_forceFieldSetup;
                        this.cache_forceFieldSetup = null;
                    }
                }
                if (this.cooldownTicks > 0) {
                    --this.cooldownTicks;
                }
                if (this.guideTicks > 0) {
                    --this.guideTicks;
                }
                this.doScheduledForceFieldRemoval();
                ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
                int countEntityInteractions = this.setInteractedEntities.size();
                if (countEntityInteractions > 0) {
                    this.setInteractedEntities.clear();
                    this.consumeEnergy(forceFieldSetup.getEntityEnergyCost(countEntityInteractions), false);
                }
                if (this.damagesEnergyCost > 0.0) {
                    if (WarpDriveConfig.LOGGING_WEAPON) {
                        WarpDrive.logger.info(String.format("%s damages received, energy lost %.2f / %d", this, this.damagesEnergyCost, this.energy_getEnergyStored()));
                    }
                    this.consumeEnergy(this.damagesEnergyCost, false);
                    this.damagesEnergyCost = 0.0;
                }
                if ((long)(energyRequired = !this.isActive ? (int)Math.round(forceFieldSetup.startupEnergyCost + forceFieldSetup.placeEnergyCost * (double)forceFieldSetup.placeSpeed * 8.0 / 20.0) : (int)Math.round(forceFieldSetup.scanEnergyCost * (double)forceFieldSetup.scanSpeed * 8.0 / 20.0)) > this.energy_getMaxStorage()) {
                    WarpDrive.logger.error(String.format("Force field projector requires %d to get started bu can only store %d", energyRequired, this.energy_getMaxStorage()));
                }
                boolean isPowered = this.energy_getEnergyStored() >= (long)energyRequired;
                isEnabledAndValid = this.isEnabled && this.isAssemblyValid;
                boolean bl = new_isActive = isEnabledAndValid && this.cooldownTicks <= 0 && isPowered;
                if (!new_isActive) break block21;
                if (!this.isActive) {
                    this.consumeEnergy(forceFieldSetup.startupEnergyCost, false);
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.info(String.format("%s starting up...", this));
                    }
                    this.isActive = true;
                    this.func_70296_d();
                }
                this.cooldownTicks = 0;
                --this.updateTicks;
                if (this.updateTicks <= 0) {
                    this.updateTicks = 8;
                    if (!this.isCalculated()) {
                        if (forceFieldSetup.shapeProvider != EnumForceFieldShape.NONE) {
                            this.calculation_start();
                        }
                    } else {
                        this.projectForceField();
                    }
                }
                --this.soundTicks;
                if (this.soundTicks >= 0) break block22;
                this.soundTicks = 60;
                assert (EnumForceFieldUpgrade.SILENCER.getProjectorUpgradeSlot() != null);
                if (this.hasUpgrade(EnumForceFieldUpgrade.SILENCER.getProjectorUpgradeSlot())) break block22;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.PROJECTING, SoundCategory.BLOCKS, 1.0f, 0.85f + 0.15f * this.field_145850_b.field_73012_v.nextFloat());
                break block22;
            }
            if (this.isActive) {
                if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                    WarpDrive.logger.info(String.format("%s shutting down...", this));
                }
                this.isActive = false;
                this.func_70296_d();
                this.cooldownTicks = 300;
                this.guideTicks = 0;
                this.destroyForceField("projector deactivation");
            }
            if (isEnabledAndValid && this.guideTicks <= 0) {
                this.guideTicks = 300;
                WarpDriveText msg = Commons.getChatPrefix(this.func_145838_q());
                msg.appendSibling(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.force_field.guide.low_power", new Object[0]));
                AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 10), (double)(this.field_174879_c.func_177956_o() - 10), (double)(this.field_174879_c.func_177952_p() - 10), (double)(this.field_174879_c.func_177958_n() + 10), (double)(this.field_174879_c.func_177956_o() + 10), (double)(this.field_174879_c.func_177952_p() + 10));
                List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
                for (Entity entity : list) {
                    if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) continue;
                    Commons.addChatMessage((ICommandSender)entity, (ITextComponent)msg);
                }
            }
        }
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        this.destroyForceField("projector block broken");
        try {
            this.doScheduledForceFieldRemoval();
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        if (this.getShape() == EnumForceFieldShape.NONE) {
            textReason.append(Commons.getStyleWarning(), "warpdrive.force_field.shape.status_line.none", new Object[0]);
            return false;
        }
        return isValid;
    }

    @Override
    protected boolean calculation_start() {
        boolean isStarting = super.calculation_start();
        if (isStarting) {
            if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                WarpDrive.logger.info(String.format("Calculation initiated for %s", this));
            }
            this.iteratorForceField = null;
            this.calculated_interiorField = null;
            this.calculated_forceField = null;
            this.vForceFields.clear();
            new ThreadCalculation(this).start();
        }
        return isStarting;
    }

    private void calculation_done(Set<VectorI> interiorField, Set<VectorI> forceField) {
        if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
            WarpDrive.logger.info(String.format("Calculation done for %s", this));
        }
        if (interiorField == null || forceField == null) {
            this.calculated_interiorField = new HashSet<VectorI>(0);
            this.calculated_forceField = new HashSet<VectorI>(0);
        } else {
            this.calculated_interiorField = interiorField;
            this.calculated_forceField = forceField;
        }
        this.calculation_done();
    }

    boolean isActive() {
        return this.isActive;
    }

    boolean isPartOfForceField(VectorI vector) {
        if (!(!this.vForceFields_forRemoval.isEmpty() || this.isEnabled && this.isAssemblyValid)) {
            return false;
        }
        if (!this.isCalculated()) {
            return true;
        }
        return this.calculated_forceField.contains(vector);
    }

    private boolean isPartOfInterior(VectorI vector) {
        if (!this.isEnabled || !this.isAssemblyValid) {
            return false;
        }
        if (!this.isCalculated()) {
            return false;
        }
        return this.calculated_interiorField.contains(vector);
    }

    public boolean onEntityInteracted(UUID uniqueID) {
        return this.setInteractedEntities.add(uniqueID);
    }

    public void onEnergyDamage(double energyCost) {
        this.damagesEnergyCost += energyCost;
    }

    private void projectForceField() {
        assert (!this.field_145850_b.field_72995_K && this.isCalculated());
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
        int countScanned = 0;
        float floatScanSpeed = Math.min(forceFieldSetup.scanSpeed * 8.0f / 20.0f + this.carryScanSpeed, (float)this.calculated_forceField.size());
        int countMaxScanned = (int)Math.floor(floatScanSpeed);
        this.carryScanSpeed = floatScanSpeed - (float)countMaxScanned;
        int countPlaced = 0;
        float floatPlaceSpeed = Math.min(forceFieldSetup.placeSpeed * 8.0f / 20.0f + this.carryPlaceSpeed, (float)this.calculated_forceField.size());
        int countMaxPlaced = (int)Math.floor(floatPlaceSpeed);
        this.carryPlaceSpeed = floatPlaceSpeed - (float)countMaxPlaced;
        IBlockState blockStateCamouflage = forceFieldSetup.getCamouflageBlockState();
        int metadata = blockStateCamouflage == null ? Math.min(15, this.beamFrequency * 16 / 65000) : blockStateCamouflage.func_177230_c().func_176201_c(blockStateCamouflage);
        IBlockState blockStateForceField = WarpDrive.blockForceFields[this.enumTier.getIndex()].func_176203_a(metadata);
        while (countScanned < countMaxScanned && countPlaced < countMaxPlaced && this.consumeEnergy(Math.max(forceFieldSetup.scanEnergyCost, forceFieldSetup.placeEnergyCost), true)) {
            if (this.iteratorForceField == null || !this.iteratorForceField.hasNext()) {
                this.iteratorForceField = this.calculated_forceField.iterator();
            }
            ++countScanned;
            VectorI vector = this.iteratorForceField.next();
            if (!this.field_145850_b.func_175668_a(vector.getBlockPos(), false) || !this.field_145850_b.func_175726_f(vector.getBlockPos()).func_177410_o()) continue;
            IBlockState blockState = vector.getBlockState((IBlockAccess)this.field_145850_b);
            boolean doProjectThisBlock = true;
            if (forceFieldSetup.hasFusion) {
                for (TileEntityForceFieldProjector projector : forceFieldSetup.projectors) {
                    if (!projector.isPartOfInterior(vector)) continue;
                    doProjectThisBlock = false;
                    break;
                }
            }
            Fluid fluid = null;
            if (doProjectThisBlock && blockState.func_177230_c() != Blocks.field_150329_H && blockState.func_177230_c() != Blocks.field_150330_I && !Dictionary.BLOCKS_EXPANDABLE.contains(blockState.func_177230_c())) {
                Block block = blockState.func_177230_c();
                fluid = FluidWrapper.getFluid(blockState);
                if (fluid != null) {
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.info(String.format("Block %s %s Fluid %s with viscosity %d, projector max is %.1f: %s %s", block.func_149739_a(), blockState, fluid.getName(), fluid.getViscosity(), Float.valueOf(forceFieldSetup.pumping_maxViscosity), block, fluid));
                    }
                    doProjectThisBlock = forceFieldSetup.pumping_maxViscosity >= (float)fluid.getViscosity();
                } else if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                    float blockHardness = blockState.func_185887_b(this.field_145850_b, vector.getBlockPos());
                    if (blockHardness == -1.0f || blockHardness > forceFieldSetup.breaking_maxHardness || this.field_145850_b.func_175623_d(vector.getBlockPos())) {
                        doProjectThisBlock = false;
                    }
                } else {
                    if (blockState.func_177230_c() instanceof BlockForceField) {
                        TileEntity tileEntity = vector.getTileEntity((IBlockAccess)this.field_145850_b);
                        if (!(tileEntity instanceof TileEntityForceField)) {
                            this.field_145850_b.func_175698_g(vector.getBlockPos());
                            blockState = Blocks.field_150350_a.func_176223_P();
                        } else {
                            TileEntityForceField tileEntityForceField = (TileEntityForceField)tileEntity;
                            TileEntityForceFieldProjector tileEntityForceFieldProjector = tileEntityForceField.getProjector(this);
                            if (tileEntityForceFieldProjector == null) {
                                tileEntityForceField.setProjector(this.field_174879_c);
                                tileEntityForceField.cache_blockStateCamouflage = forceFieldSetup.getCamouflageBlockState();
                            } else if (tileEntityForceFieldProjector == this && (tileEntityForceField.cache_blockStateCamouflage == null && forceFieldSetup.getCamouflageBlockState() != null || tileEntityForceField.cache_blockStateCamouflage != null && !tileEntityForceField.cache_blockStateCamouflage.equals(forceFieldSetup.getCamouflageBlockState()) || !blockState.equals(blockStateForceField))) {
                                this.field_145850_b.func_175698_g(vector.getBlockPos());
                                blockState = Blocks.field_150350_a.func_176223_P();
                            }
                        }
                    }
                    boolean bl = doProjectThisBlock = blockState.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, vector.getBlockPos()) || blockState.func_177230_c() == WarpDrive.blockForceFields[this.enumTier.getIndex()];
                }
            }
            if (doProjectThisBlock) {
                if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                    doProjectThisBlock = !this.isBlockBreakCanceled(null, this.field_145850_b, vector.getBlockPos());
                } else if (!(blockState.func_177230_c() instanceof BlockForceField)) {
                    boolean bl = doProjectThisBlock = !this.isBlockPlaceCanceled(null, this.field_145850_b, vector.getBlockPos(), blockStateForceField);
                }
            }
            if (doProjectThisBlock) {
                TileEntity tileEntity;
                if (blockState.func_177230_c() != WarpDrive.blockForceFields[this.enumTier.getIndex()] && !vector.equals(this)) {
                    boolean hasPlaced = false;
                    if (fluid != null) {
                        hasPlaced = true;
                        this.doPumping(forceFieldSetup, blockStateForceField, vector, blockState, fluid);
                    } else if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                        hasPlaced = true;
                        if (this.doBreaking(forceFieldSetup, vector, blockState)) {
                            return;
                        }
                    } else if (forceFieldSetup.hasStabilize) {
                        hasPlaced = true;
                        if (this.doStabilize(forceFieldSetup, vector)) {
                            return;
                        }
                    } else if (forceFieldSetup.isInverted && (forceFieldSetup.temperatureLevel < 295.0f || forceFieldSetup.temperatureLevel > 305.0f)) {
                        this.doTerraforming(forceFieldSetup, vector, blockState);
                    } else if (!forceFieldSetup.isInverted) {
                        hasPlaced = true;
                        this.field_145850_b.func_180501_a(vector.getBlockPos(), blockStateForceField, 2);
                        TileEntity tileEntity2 = this.field_145850_b.func_175625_s(vector.getBlockPos());
                        if (tileEntity2 instanceof TileEntityForceField) {
                            ((TileEntityForceField)tileEntity2).setProjector(this.field_174879_c);
                        }
                        this.vForceFields.add(vector);
                    }
                    if (hasPlaced) {
                        ++countPlaced;
                        this.consumeEnergy(forceFieldSetup.placeEnergyCost, false);
                        continue;
                    }
                    this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
                    continue;
                }
                this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
                if (blockState.func_177230_c() != WarpDrive.blockForceFields[this.enumTier.getIndex()] || this.vForceFields.contains(vector) || !((tileEntity = this.field_145850_b.func_175625_s(vector.getBlockPos())) instanceof TileEntityForceField) || ((TileEntityForceField)tileEntity).getProjector(this) != this) continue;
                this.vForceFields.add(vector);
                continue;
            }
            this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
            if (blockState.func_177230_c() != WarpDrive.blockForceFields[this.enumTier.getIndex()]) continue;
            assert (blockState.func_177230_c() instanceof BlockForceField);
            if (((BlockForceField)blockState.func_177230_c()).getProjector(this.field_145850_b, vector.getBlockPos(), this) != this) continue;
            this.field_145850_b.func_175698_g(vector.getBlockPos());
            this.vForceFields.remove(vector);
        }
    }

    private void doPumping(ForceFieldSetup forceFieldSetup, IBlockState blockStateForceField, VectorI vector, IBlockState blockState, Fluid fluid) {
        Block block = blockState.func_177230_c();
        boolean isAlreadyRemoved = false;
        boolean isSourceBlock = FluidWrapper.isSourceBlock(this.field_145850_b, vector.getBlockPos(), blockState);
        if (isSourceBlock) {
            FluidStack fluidStack;
            if (block instanceof IFluidBlock) {
                fluidStack = ((IFluidBlock)block).drain(this.field_145850_b, vector.getBlockPos(), true);
                assert (fluidStack != null);
                isAlreadyRemoved = true;
            } else {
                fluidStack = new FluidStack(fluid, 1000);
            }
            if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                WarpDrive.logger.info(String.format("Fluid source found! %s x %d mB", fluidStack.getUnlocalizedName(), fluidStack.amount));
            }
        } else if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
            WarpDrive.logger.info(String.format("Fluid flow found! %s", fluid.getUnlocalizedName()));
        }
        if (forceFieldSetup.isInverted || forceFieldSetup.breaking_maxHardness > 0.0f) {
            if (!isAlreadyRemoved) {
                this.field_145850_b.func_180501_a(vector.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        } else {
            this.field_145850_b.func_180501_a(vector.getBlockPos(), blockStateForceField, 2);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(vector.getBlockPos());
            if (tileEntity instanceof TileEntityForceField) {
                ((TileEntityForceField)tileEntity).setProjector(this.field_174879_c);
            }
            this.vForceFields.add(vector);
        }
    }

    private boolean doStabilize(ForceFieldSetup forceFieldSetup, VectorI vector) {
        int slotIndex = 0;
        boolean found = false;
        int countItemBlocks = 0;
        Block blockToPlace = null;
        int metadataToPlace = -1;
        Object inventory = null;
        BlockPos blockPos = vector.getBlockPos();
        for (Object inventoryLoop : forceFieldSetup.inventories) {
            if (!found) {
                slotIndex = 0;
            }
            while (slotIndex < InventoryWrapper.getSize(inventoryLoop) && !found) {
                ItemStack itemStack = InventoryWrapper.getStackInSlot(inventoryLoop, slotIndex);
                if (itemStack.func_190926_b()) {
                    ++slotIndex;
                    continue;
                }
                blockToPlace = Block.func_149634_a((Item)itemStack.func_77973_b());
                if (blockToPlace == Blocks.field_150350_a) {
                    ++slotIndex;
                    continue;
                }
                ++countItemBlocks;
                metadataToPlace = itemStack.func_77973_b().func_77647_b(itemStack.func_77952_i());
                if (metadataToPlace == 0 && itemStack.func_77952_i() != 0) {
                    metadataToPlace = itemStack.func_77952_i();
                }
                if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                    WarpDrive.logger.info(String.format("Slot %d as %s known as block %s:%d", slotIndex, itemStack, blockToPlace, metadataToPlace));
                }
                if (!blockToPlace.func_176196_c(this.field_145850_b, blockPos)) {
                    ++slotIndex;
                    continue;
                }
                found = true;
                inventory = inventoryLoop;
            }
        }
        if (countItemBlocks <= 0) {
            return true;
        }
        if (inventory == null) {
            if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                WarpDrive.logger.debug("No item to place found");
            }
            return true;
        }
        assert (found);
        IBlockState blockStateToPlace = blockToPlace.func_176203_a(metadataToPlace);
        if (this.isBlockPlaceCanceled(null, this.field_145850_b, blockPos, blockStateToPlace)) {
            if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                WarpDrive.logger.info(String.format("%s Placing cancelled %s", this, Commons.format(this.field_145850_b, blockPos)));
            }
            return true;
        }
        InventoryWrapper.decrStackSize(inventory, slotIndex, 1);
        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(vector.x, vector.y, vector.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
        SoundType soundType = blockStateToPlace.func_177230_c().getSoundType(blockStateToPlace, this.field_145850_b, blockPos, null);
        this.field_145850_b.func_184133_a(null, blockPos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        this.field_145850_b.func_180501_a(blockPos, blockStateToPlace, 3);
        return false;
    }

    private void doTerraforming(ForceFieldSetup forceFieldSetup, VectorI vector, IBlockState blockState) {
        assert (vector != null);
        assert (blockState != null);
        if (forceFieldSetup.temperatureLevel > 300.0f) {
            // empty if block
        }
    }

    private boolean doBreaking(ForceFieldSetup forceFieldSetup, VectorI vector, IBlockState blockState) {
        List itemStacks;
        try {
            itemStacks = blockState.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, vector.getBlockPos(), blockState, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            itemStacks = null;
        }
        if (itemStacks != null) {
            if (forceFieldSetup.hasCollection) {
                if (InventoryWrapper.addToInventories(this.field_145850_b, this.field_174879_c, forceFieldSetup.inventories, itemStacks)) {
                    return true;
                }
            } else {
                for (ItemStack itemStackDrop : itemStacks) {
                    ItemStack drop = itemStackDrop.func_77946_l();
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)vector.x + 0.5, (double)vector.y + 1.0, (double)vector.z + 0.5, drop);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            }
        }
        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(vector.x, vector.y, vector.z).translate(0.5), new Vector3(this).translate(0.5), 0.7f, 0.4f, 0.2f, age, 0, 50);
        this.field_145850_b.func_175718_b(2001, vector.getBlockPos(), Block.func_176210_f((IBlockState)blockState));
        this.field_145850_b.func_175698_g(vector.getBlockPos());
        return false;
    }

    private void destroyForceField(String context) {
        int countCalculated;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        int countPlaced = this.vForceFields != null ? this.vForceFields.size() : 0;
        int n = countCalculated = this.calculated_forceField != null ? this.calculated_forceField.size() : 0;
        if (countPlaced + countCalculated > 0) {
            WarpDrive.logger.info(String.format("%s destroying force field of %d placed out of %d calculated blocks due to %s", this, countPlaced, countCalculated, context));
            if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                new RuntimeException().printStackTrace(WarpDrive.printStreamInfo);
            }
        }
        if (countPlaced > 0) {
            this.vForceFields_forRemoval.addAll(this.vForceFields);
            this.vForceFields.clear();
        }
        if (this.isCalculated() && this.vForceFields_forRemoval.size() < this.calculated_forceField.size()) {
            this.vForceFields_forRemoval.addAll(this.calculated_forceField);
        }
        this.isActive = false;
        if (Commons.isSafeThread()) {
            this.doScheduledForceFieldRemoval();
        }
    }

    private void doScheduledForceFieldRemoval() {
        VectorI[] vForceFields_cache;
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.warn("Removing force field blocks outside main thread, bad things may happen...");
        }
        for (VectorI vector : vForceFields_cache = this.vForceFields_forRemoval.toArray(new VectorI[0])) {
            TileEntity tileEntity;
            BlockPos blockPos = vector.getBlockPos();
            IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
            if (blockState.func_177230_c() != WarpDrive.blockForceFields[this.enumTier.getIndex()] || !((tileEntity = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEntityForceField) || ((TileEntityForceField)tileEntity).getProjector(this) != this) continue;
            this.field_145850_b.func_175698_g(vector.getBlockPos());
        }
        this.vForceFields_forRemoval.clear();
    }

    public IForceFieldShape getShapeProvider() {
        return this.getShape();
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int beamFrequency) {
        super.setBeamFrequency(beamFrequency);
        this.cache_forceFieldSetup = null;
    }

    public Vector3 getMin() {
        assert (EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot())) {
            return this.v3Min;
        }
        return new Vector3(-1.0, -1.0, -1.0);
    }

    private void setMin(float x, float y, float z) {
        this.v3Min = new Vector3(Commons.clamp(-1.0, 0.0, (double)x), Commons.clamp(-1.0, 0.0, (double)y), Commons.clamp(-1.0, 0.0, (double)z));
    }

    public Vector3 getMax() {
        assert (EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot())) {
            return this.v3Max;
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    private void setMax(float x, float y, float z) {
        this.v3Max = new Vector3(Commons.clamp(0.0, 1.0, (double)x), Commons.clamp(0.0, 1.0, (double)y), Commons.clamp(0.0, 1.0, (double)z));
    }

    public float getRotationYaw() {
        float totalYaw;
        int metadata = this.func_145832_p();
        switch (EnumFacing.func_82600_a((int)(metadata & 7))) {
            case DOWN: {
                totalYaw = 0.0f;
                break;
            }
            case UP: {
                totalYaw = 0.0f;
                break;
            }
            case NORTH: {
                totalYaw = 90.0f;
                break;
            }
            case SOUTH: {
                totalYaw = 270.0f;
                break;
            }
            case WEST: {
                totalYaw = 0.0f;
                break;
            }
            case EAST: {
                totalYaw = 180.0f;
                break;
            }
            default: {
                totalYaw = 0.0f;
            }
        }
        assert (EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot())) {
            totalYaw += this.rotationYaw;
        }
        return (totalYaw + 540.0f) % 360.0f - 180.0f;
    }

    public float getRotationPitch() {
        float totalPitch;
        int metadata = this.func_145832_p();
        switch (EnumFacing.func_82600_a((int)(metadata & 7))) {
            case DOWN: {
                totalPitch = 180.0f;
                break;
            }
            case UP: {
                totalPitch = 0.0f;
                break;
            }
            case NORTH: {
                totalPitch = -90.0f;
                break;
            }
            case SOUTH: {
                totalPitch = -90.0f;
                break;
            }
            case WEST: {
                totalPitch = -90.0f;
                break;
            }
            case EAST: {
                totalPitch = -90.0f;
                break;
            }
            default: {
                totalPitch = 0.0f;
            }
        }
        assert (EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot())) {
            totalPitch += this.rotationPitch;
        }
        return (totalPitch + 540.0f) % 360.0f - 180.0f;
    }

    public float getRotationRoll() {
        assert (EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot())) {
            return (this.rotationRoll + 540.0f) % 360.0f - 180.0f;
        }
        return 0.0f;
    }

    private void setRotation(float rotationYaw, float rotationPitch, float rotationRoll) {
        float oldYaw = this.rotationYaw;
        float oldPitch = this.rotationPitch;
        float oldRoll = this.rotationRoll;
        this.rotationYaw = Commons.clamp(-45.0f, 45.0f, rotationYaw);
        this.rotationPitch = Commons.clamp(-45.0f, 45.0f, rotationPitch);
        this.rotationRoll = (rotationRoll + 540.0f) % 360.0f - 180.0f;
        if (oldYaw != this.rotationYaw || oldPitch != this.rotationPitch || oldRoll != this.rotationRoll) {
            this.cache_forceFieldSetup = null;
        }
    }

    public EnumForceFieldShape getShape() {
        if (this.shape == null) {
            return EnumForceFieldShape.NONE;
        }
        return this.shape;
    }

    void setShape(EnumForceFieldShape shape) {
        if (this.shape != shape) {
            this.shape = shape;
            this.cache_forceFieldSetup = null;
            this.func_70296_d();
        }
    }

    public Vector3 getTranslation() {
        assert (EnumForceFieldUpgrade.TRANSLATION.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.TRANSLATION.getProjectorUpgradeSlot())) {
            return this.v3Translation;
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    private void setTranslation(float x, float y, float z) {
        Vector3 oldTranslation = this.v3Translation;
        this.v3Translation = new Vector3(Commons.clamp(-1.0, 1.0, (double)x), Commons.clamp(-1.0, 1.0, (double)y), Commons.clamp(-1.0, 1.0, (double)z));
        if (!oldTranslation.equals(this.v3Translation)) {
            this.cache_forceFieldSetup = null;
        }
    }

    @Override
    protected void onUpgradeChanged(@Nonnull TileEntityAbstractBase.UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
        super.onUpgradeChanged(upgradeSlot, countNew, isAdded);
        this.cache_forceFieldSetup = null;
    }

    @Nonnull
    private WarpDriveText getShapeStatus() {
        EnumForceFieldShape enumForceFieldShape = this.getShape();
        WarpDriveText displayName = new WarpDriveText(null, "warpdrive.force_field.shape.status_line." + enumForceFieldShape.func_176610_l(), new Object[0]);
        if (enumForceFieldShape == EnumForceFieldShape.NONE) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.force_field.shape.status_line.none", new Object[]{displayName});
        }
        if (this.isDoubleSided) {
            return new WarpDriveText(null, "warpdrive.force_field.shape.status_line.double", new Object[]{displayName});
        }
        return new WarpDriveText(null, "warpdrive.force_field.shape.status_line.single", new Object[]{displayName});
    }

    @Override
    public WarpDriveText getStatus() {
        return super.getStatus().append((ITextComponent)this.getShapeStatus());
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isDoubleSided = tagCompound.func_74767_n("isDoubleSided");
        if (tagCompound.func_74764_b("minX")) {
            this.setMin(tagCompound.func_74760_g("minX"), tagCompound.func_74760_g("minY"), tagCompound.func_74760_g("minZ"));
        } else {
            this.setMin(-1.0f, -1.0f, -1.0f);
        }
        if (tagCompound.func_74764_b("maxX")) {
            this.setMax(tagCompound.func_74760_g("maxX"), tagCompound.func_74760_g("maxY"), tagCompound.func_74760_g("maxZ"));
        } else {
            this.setMax(1.0f, 1.0f, 1.0f);
        }
        this.setRotation(tagCompound.func_74760_g("rotationYaw"), tagCompound.func_74760_g("rotationPitch"), tagCompound.func_74760_g("rotationRoll"));
        this.setShape(EnumForceFieldShape.get(tagCompound.func_74771_c("shape")));
        this.setTranslation(tagCompound.func_74760_g("translationX"), tagCompound.func_74760_g("translationY"), tagCompound.func_74760_g("translationZ"));
        this.isActive = tagCompound.func_74767_n("isOn");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("isDoubleSided", this.isDoubleSided);
        if (this.v3Min.x != -1.0 || this.v3Min.y != -1.0 || this.v3Min.z != -1.0) {
            tagCompound.func_74776_a("minX", (float)this.v3Min.x);
            tagCompound.func_74776_a("minY", (float)this.v3Min.y);
            tagCompound.func_74776_a("minZ", (float)this.v3Min.z);
        }
        if (this.v3Max.x != 1.0 || this.v3Max.y != 1.0 || this.v3Max.z != 1.0) {
            tagCompound.func_74776_a("maxX", (float)this.v3Max.x);
            tagCompound.func_74776_a("maxY", (float)this.v3Max.y);
            tagCompound.func_74776_a("maxZ", (float)this.v3Max.z);
        }
        if (this.rotationYaw != 0.0f) {
            tagCompound.func_74776_a("rotationYaw", this.rotationYaw);
        }
        if (this.rotationPitch != 0.0f) {
            tagCompound.func_74776_a("rotationPitch", this.rotationPitch);
        }
        if (this.rotationRoll != 0.0f) {
            tagCompound.func_74776_a("rotationRoll", this.rotationRoll);
        }
        tagCompound.func_74774_a("shape", (byte)this.getShape().ordinal());
        if (this.v3Translation.x != 0.0 || this.v3Translation.y != 0.0 || this.v3Translation.z != 0.0) {
            tagCompound.func_74776_a("translationX", (float)this.v3Translation.x);
            tagCompound.func_74776_a("translationY", (float)this.v3Translation.y);
            tagCompound.func_74776_a("translationZ", (float)this.v3Translation.z);
        }
        tagCompound.func_74757_a("isOn", this.isActive);
        return tagCompound;
    }

    public ForceFieldSetup getForceFieldSetup() {
        if (this.cache_forceFieldSetup == null) {
            if (this.isFirstTick()) {
                return null;
            }
            this.cache_forceFieldSetup = new ForceFieldSetup(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, this.enumTier, this.beamFrequency);
            this.setupTicks = Math.max(this.setupTicks, 10);
            if (this.legacy_forceFieldSetup != null) {
                int energyRequired = (int)Math.max(0L, Math.round(this.cache_forceFieldSetup.startupEnergyCost - this.legacy_forceFieldSetup.startupEnergyCost));
                IBlockState blockStateLegacyCamouflage = this.legacy_forceFieldSetup.getCamouflageBlockState();
                IBlockState blockStateCachedCamouflage = this.cache_forceFieldSetup.getCamouflageBlockState();
                if (blockStateLegacyCamouflage == null && blockStateCachedCamouflage != null || blockStateLegacyCamouflage != null && !blockStateLegacyCamouflage.equals(blockStateCachedCamouflage) || this.legacy_forceFieldSetup.beamFrequency != this.cache_forceFieldSetup.beamFrequency || !this.energy_consume(energyRequired, false)) {
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.info(this + " rebooting with new rendering...");
                    }
                    this.destroyForceField("new rendering");
                } else if (this.legacy_forceFieldSetup.isInverted != this.cache_forceFieldSetup.isInverted || this.legacy_forceFieldSetup.shapeProvider != this.cache_forceFieldSetup.shapeProvider || this.legacy_forceFieldSetup.thickness != this.cache_forceFieldSetup.thickness || !this.legacy_forceFieldSetup.vMin.equals(this.cache_forceFieldSetup.vMin) || !this.legacy_forceFieldSetup.vMax.equals(this.cache_forceFieldSetup.vMax) || !this.legacy_forceFieldSetup.vTranslation.equals(this.cache_forceFieldSetup.vTranslation) || this.legacy_forceFieldSetup.rotationYaw != this.cache_forceFieldSetup.rotationYaw || this.legacy_forceFieldSetup.rotationPitch != this.cache_forceFieldSetup.rotationPitch || this.legacy_forceFieldSetup.rotationRoll != this.cache_forceFieldSetup.rotationRoll || this.legacy_forceFieldSetup.breaking_maxHardness <= 0.0f && this.cache_forceFieldSetup.breaking_maxHardness > 0.0f) {
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.info(this + " rebooting with new shape...");
                    }
                    this.destroyForceField("new shape");
                    this.isDirty.set(true);
                }
            }
        }
        return this.cache_forceFieldSetup;
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    public boolean consumeEnergy(double amount_internal, boolean simulate) {
        long longAmount = (long)Math.min((double)this.energy_getEnergyStored(), Math.floor(amount_internal + this.consumptionLeftOver));
        boolean bResult = this.energy_consume(longAmount, simulate);
        if (!simulate) {
            this.consumptionLeftOver = amount_internal + this.consumptionLeftOver - (double)longAmount;
        }
        return bResult;
    }

    @Override
    public Object[] getEnergyRequired() {
        return new Object[0];
    }

    private Object[] state() {
        long energy = this.energy_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isEnabled, this.isConnected, this.isActive, this.getShape().name(), energy};
    }

    public Object[] min(Object[] arguments) {
        assert (EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot() != null);
        return this.computer_getOrSetVector3(this::getMin, this::setMin, EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot(), arguments);
    }

    public Object[] max(Object[] arguments) {
        assert (EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot() != null);
        return this.computer_getOrSetVector3(this::getMax, this::setMax, EnumForceFieldUpgrade.RANGE.getProjectorUpgradeSlot(), arguments);
    }

    public Object[] rotation(Object[] arguments) {
        if (arguments != null && arguments.length > 0 && arguments[0] != null) {
            try {
                if (arguments.length == 1) {
                    float value = Commons.toFloat(arguments[0]);
                    this.setRotation(value, 0.0f, 0.0f);
                } else if (arguments.length == 2) {
                    float value1 = Commons.toFloat(arguments[0]);
                    float value2 = Commons.toFloat(arguments[1]);
                    this.setRotation(value1, value2, 0.0f);
                } else if (arguments.length == 3) {
                    float value1 = Commons.toFloat(arguments[0]);
                    float value2 = Commons.toFloat(arguments[1]);
                    float value3 = Commons.toFloat(arguments[2]);
                    this.setRotation(value1, value2, value3);
                }
            }
            catch (Exception exception) {
                String message = String.format("Float expected for all arguments %s", Arrays.toString(arguments));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(String.format("%s LUA error on rotation(): %s", this, message));
                }
                return new Object[]{Float.valueOf(this.rotationYaw), Float.valueOf(this.rotationPitch), Float.valueOf(this.rotationRoll), message};
            }
        }
        assert (EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot() != null);
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot())) {
            return new Float[]{Float.valueOf(this.rotationYaw), Float.valueOf(this.rotationPitch), Float.valueOf(this.rotationRoll)};
        }
        return new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), "Missing " + EnumForceFieldUpgrade.ROTATION.getProjectorUpgradeSlot().itemStack.func_82833_r()};
    }

    public Object[] translation(Object[] arguments) {
        assert (EnumForceFieldUpgrade.TRANSLATION.getProjectorUpgradeSlot() != null);
        return this.computer_getOrSetVector3(this::getTranslation, this::setTranslation, EnumForceFieldUpgrade.TRANSLATION.getProjectorUpgradeSlot(), arguments);
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] min(Context context, Arguments arguments) {
        return this.min(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] max(Context context, Arguments arguments) {
        return this.max(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] rotation(Context context, Arguments arguments) {
        return this.rotation(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] translation(Context context, Arguments arguments) {
        return this.translation(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "min": {
                return this.min(arguments);
            }
            case "max": {
                return this.max(arguments);
            }
            case "rotation": {
                return this.rotation(arguments);
            }
            case "state": {
                return this.state();
            }
            case "translation": {
                return this.translation(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    private static class ThreadCalculation
    extends Thread {
        private final WeakReference<TileEntityForceFieldProjector> weakProjector;
        private final String stringProjector;

        ThreadCalculation(TileEntityForceFieldProjector projector) {
            this.weakProjector = new WeakReference<TileEntityForceFieldProjector>(projector);
            this.stringProjector = projector.toString();
        }

        @Override
        public void run() {
            TileEntityForceFieldProjector projector;
            HashSet<VectorI> vPerimeterBlocks = null;
            HashSet<VectorI> vInteriorBlocks = null;
            try {
                projector = (TileEntityForceFieldProjector)this.weakProjector.get();
                if (projector != null && !projector.func_145837_r() && projector.isEnabled && projector.isAssemblyValid) {
                    ForceFieldSetup forceFieldSetup = projector.getForceFieldSetup();
                    if (forceFieldSetup.shapeProvider == EnumForceFieldShape.NONE) {
                        if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                            WarpDrive.logger.warn(String.format("%s Calculation aborted (no shape)", this));
                        }
                        projector.calculation_done(null, null);
                        return;
                    }
                    int heightWorld = projector.field_145850_b.func_72800_K();
                    projector = null;
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.debug(String.format("%s Calculation started for %s", this, this.stringProjector));
                    }
                    VectorI vScale = forceFieldSetup.vMax.clone().subtract(forceFieldSetup.vMin);
                    vInteriorBlocks = new HashSet<VectorI>(vScale.x * vScale.y * vScale.z);
                    vPerimeterBlocks = new HashSet<VectorI>(2 * vScale.x * vScale.y + 2 * vScale.x * vScale.z + 2 * vScale.y * vScale.z);
                    Map<VectorI, Boolean> vertexes = forceFieldSetup.shapeProvider.getVertexes(forceFieldSetup);
                    if (vertexes.isEmpty()) {
                        WarpDrive.logger.error(String.format("%s No vertexes for %s at %s", this, forceFieldSetup, this.stringProjector));
                    }
                    for (Map.Entry<VectorI, Boolean> entry : vertexes.entrySet()) {
                        VectorI vPosition = entry.getKey();
                        if (!forceFieldSetup.isDoubleSided && vPosition.y < 0) continue;
                        if (forceFieldSetup.rotationYaw != 0.0f || forceFieldSetup.rotationPitch != 0.0f || forceFieldSetup.rotationRoll != 0.0f) {
                            vPosition.rotateByAngle(forceFieldSetup.rotationYaw, forceFieldSetup.rotationPitch, forceFieldSetup.rotationRoll);
                        }
                        vPosition.translate(forceFieldSetup.vTranslation);
                        if (vPosition.y <= 0 || vPosition.y > heightWorld) continue;
                        if (entry.getValue().booleanValue()) {
                            vPerimeterBlocks.add(vPosition);
                            continue;
                        }
                        vInteriorBlocks.add(vPosition);
                    }
                    if (forceFieldSetup.isInverted) {
                        vPerimeterBlocks = new HashSet(vInteriorBlocks);
                    }
                    if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                        WarpDrive.logger.debug(String.format("%s Calculation done: %s blocks inside, including %s blocks to place", this, vInteriorBlocks.size(), vPerimeterBlocks.size()));
                    }
                } else if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
                    WarpDrive.logger.error(String.format("%s Calculation aborted", this));
                }
            }
            catch (Exception exception) {
                vInteriorBlocks = null;
                vPerimeterBlocks = null;
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("%s Calculation failed for %s", this, this.stringProjector));
            }
            projector = (TileEntityForceFieldProjector)this.weakProjector.get();
            if (projector != null) {
                projector.calculation_done(vInteriorBlocks, vPerimeterBlocks);
            }
        }
    }
}

