/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.hull.ItemBlockHull;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumHullPlainType;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHullPlain
extends BlockAbstractBase
implements IDamageReceiver {
    final EnumHullPlainType enumHullPlainType;

    public BlockHullPlain(String registryName, EnumTier enumTier, EnumHullPlainType enumHullPlainType) {
        super(registryName, enumTier, Material.field_151576_e);
        this.enumHullPlainType = enumHullPlainType;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[enumTier.getIndex()]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[enumTier.getIndex()] * 5.0f / 3.0f);
        this.setHarvestLevel("pickaxe", WarpDriveConfig.HULL_HARVEST_LEVEL[enumTier.getIndex()]);
        this.func_149663_c("warpdrive.hull." + enumTier.func_176610_l() + ".plain.");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        this.func_149647_a(WarpDrive.creativeTabHull);
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockHull(this);
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        return EnumPushReaction.BLOCK;
    }

    public int func_180651_a(@Nonnull IBlockState blockState) {
        return ((EnumDyeColor)blockState.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            list.add((Object)new ItemStack((Block)this, 1, enumDyeColor.func_176765_a()));
        }
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)blockState.func_177229_b((IProperty)BlockColored.field_176581_a)));
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)metadata));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((EnumDyeColor)blockState.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockColored.field_176581_a});
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.enumTier.getIndex()];
    }

    @Override
    public int applyDamage(IBlockState blockState, World world, BlockPos blockPos, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.enumTier == EnumTier.BASIC) {
            world.func_175698_g(blockPos);
        } else {
            world.func_180501_a(blockPos, WarpDrive.blockHulls_plain[this.enumTier.getIndex() - 1][this.enumHullPlainType.ordinal()].func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, blockState.func_177229_b((IProperty)BlockColored.field_176581_a)), 2);
        }
        return 0;
    }
}

