/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.movement.ItemBlockTransporterBeacon;
import cr0s.warpdrive.block.movement.TileEntityTransporterBeacon;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnumTier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTransporterBeacon
extends BlockAbstractContainer {
    private static final double BOUNDING_RADIUS = 0.09375;
    private static final double BOUNDING_HEIGHT = 0.65625;
    private static final AxisAlignedBB AABB_BEACON = new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 0.65625, 0.59375);
    public static final PropertyBool DEPLOYED = PropertyBool.func_177716_a((String)"deployed");

    public BlockTransporterBeacon(String registryName, EnumTier enumTier) {
        super(registryName, enumTier, Material.field_151573_f);
        this.func_149711_c(0.5f);
        this.func_149663_c("warpdrive.movement.transporter_beacon");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DEPLOYED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public ItemBlock createItemBlock() {
        return new ItemBlockTransporterBeacon((Block)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.ACTIVE, DEPLOYED});
    }

    @Nonnull
    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((metadata & 2) != 0)).func_177226_a((IProperty)DEPLOYED, (Comparable)Boolean.valueOf((metadata & 1) != 0));
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        return ((Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE) != false ? 2 : 0) + ((Boolean)blockState.func_177229_b((IProperty)DEPLOYED) != false ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modelInitialisation() {
        super.modelInitialisation();
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        return enumFacing == EnumFacing.DOWN ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return AABB_BEACON;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return field_185506_k;
    }

    public int getLightValue(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        boolean isActive = (Boolean)blockState.func_177229_b((IProperty)BlockProperties.ACTIVE);
        return isActive ? 6 : 0;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityTransporterBeacon();
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand enumHand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        if (enumHand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(enumHand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityTransporterBeacon)) {
            return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
        }
        TileEntityTransporterBeacon tileEntityTransporterBeacon = (TileEntityTransporterBeacon)tileEntity;
        if (itemStackHeld.func_190926_b()) {
            if (!entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix((Block)this).func_150257_a((ITextComponent)new TextComponentString(tileEntityTransporterBeacon.stateTransporter)));
                return true;
            }
            boolean isEnabledOld = tileEntityTransporterBeacon.getIsEnabled();
            tileEntityTransporterBeacon.setIsEnabled(!isEnabledOld);
            boolean isEnabledNew = tileEntityTransporterBeacon.getIsEnabled();
            if (isEnabledOld != isEnabledNew) {
                if (isEnabledNew) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix((Block)this).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.set.enabled", new Object[0])));
                } else {
                    Commons.addChatMessage((ICommandSender)entityPlayer, Commons.getChatPrefix((Block)this).func_150257_a((ITextComponent)new TextComponentTranslation("warpdrive.machine.is_enabled.set.disabled", new Object[0])));
                }
            }
            return true;
        }
        return super.func_180639_a(world, blockPos, blockState, entityPlayer, enumHand, enumFacing, hitX, hitY, hitZ);
    }
}

