/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IItemTransporterBeacon;
import cr0s.warpdrive.api.computer.ITransporterCore;
import cr0s.warpdrive.block.movement.ItemBlockController;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTransporterBeacon
extends ItemBlockController
implements IItemTransporterBeacon {
    public ItemBlockTransporterBeacon(Block block) {
        super(block);
        this.func_77625_d(1);
        this.func_77656_e(800);
        this.func_185043_a(new ResourceLocation("warpdrive", "active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entity) {
                boolean isActive = ItemBlockTransporterBeacon.this.isActive(itemStack);
                return isActive ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(@Nonnull ItemStack itemStack) {
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        return new ModelResourceLocation(resourceLocation.toString() + "-item", "inventory");
    }

    private static int getEnergy(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return 0;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        if (tagCompound.func_74764_b("energy")) {
            return tagCompound.func_74762_e("energy");
        }
        return 0;
    }

    private static ItemStack setEnergy(@Nonnull ItemStack itemStack, int energy) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("energy", energy);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    private static ItemStack updateDamage(@Nonnull ItemStack itemStack, int energy, boolean isActive) {
        int maxDamage = itemStack.func_77958_k();
        int metadataEnergy = maxDamage - maxDamage * energy / WarpDriveConfig.TRANSPORTER_BEACON_MAX_ENERGY_STORED;
        int metadataNew = (metadataEnergy & 0xFFFFFFFC) + (isActive ? 2 : 0);
        if (metadataNew != itemStack.func_77952_i()) {
            itemStack.func_77964_b(metadataNew);
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean isActive(@Nonnull ItemStack itemStack) {
        return ItemBlockTransporterBeacon.getEnergy(itemStack) > WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int indexSlot, boolean isHeld) {
        if (entity instanceof EntityPlayer) {
            ItemStack itemStackNew;
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            ItemStack itemStackCheck = entityPlayer.field_71071_by.func_70301_a(indexSlot);
            if (itemStackCheck != itemStack) {
                WarpDrive.logger.error(String.format("Invalid item selection: possible dup tentative from %s", entityPlayer));
                return;
            }
            int energy = ItemBlockTransporterBeacon.getEnergy(itemStack) - WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK;
            if (isHeld && energy >= 0) {
                ItemStack itemStackNew2 = ItemBlockTransporterBeacon.setEnergy(itemStack, energy);
                ItemBlockTransporterBeacon.updateDamage(itemStackNew2, energy, true);
                ((EntityPlayer)entity).field_71071_by.func_70299_a(indexSlot, itemStackNew2);
            } else if (itemStack.func_77952_i() != 0 && (itemStackNew = ItemBlockTransporterBeacon.updateDamage(itemStack, energy, false)) != null) {
                ((EntityPlayer)entity).field_71071_by.func_70299_a(indexSlot, itemStackNew);
            }
        }
        super.func_77663_a(itemStack, world, entity, indexSlot, isHeld);
    }

    @Override
    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        if (itemStackHeld.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof ITransporterCore)) {
            return super.func_180614_a(entityPlayer, world, blockPos, hand, facing, hitX, hitY, hitZ);
        }
        if (!entityPlayer.func_175151_a(blockPos, facing, itemStackHeld)) {
            return EnumActionResult.FAIL;
        }
        UUID uuidBeacon = ItemBlockTransporterBeacon.getSignature(itemStackHeld);
        String nameBeacon = ItemBlockTransporterBeacon.getName(itemStackHeld);
        UUID uuidTransporter = ((ITransporterCore)tileEntity).getSignatureUUID();
        if (entityPlayer.func_70093_af()) {
            String nameTransporter = ((ITransporterCore)tileEntity).getSignatureName();
            if (uuidTransporter == null || nameTransporter == null || nameTransporter.isEmpty()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.get_missing", new Object[0]));
            } else if (uuidTransporter.equals(uuidBeacon)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.get_same", new Object[]{nameTransporter}));
            } else {
                ItemStack itemStackNew = ItemBlockTransporterBeacon.setNameAndSignature(itemStackHeld, nameTransporter, uuidTransporter);
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.get", new Object[]{nameTransporter}));
                world.func_184134_a(entityPlayer.field_70165_t + 0.5, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v + 0.5, SoundEvents.field_187942_hp, SoundCategory.PLAYERS, 1.0f, 1.8f + 0.2f * world.field_73012_v.nextFloat(), false);
            }
        } else {
            UUID uuidRemoteLocation;
            Object[] remoteLocation = ((ITransporterCore)tileEntity).remoteLocation(new Object[0]);
            if (remoteLocation == null || remoteLocation.length != 1 || !(remoteLocation[0] instanceof String)) {
                uuidRemoteLocation = null;
            } else {
                try {
                    uuidRemoteLocation = UUID.fromString((String)remoteLocation[0]);
                }
                catch (IllegalArgumentException exception) {
                    uuidRemoteLocation = null;
                }
            }
            if (uuidBeacon == null) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.set_missing", new Object[]{nameBeacon}));
            } else if (uuidBeacon.equals(uuidTransporter)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.set_self", new Object[]{nameBeacon}));
            } else if (uuidBeacon.equals(uuidRemoteLocation)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.set_same", new Object[]{nameBeacon}));
            } else {
                ((ITransporterCore)tileEntity).remoteLocation(new Object[]{uuidBeacon});
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.transporter_signature.set", new Object[]{nameBeacon}));
                world.func_184134_a(entityPlayer.field_70165_t + 0.5, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v + 0.5, SoundEvents.field_187941_ho, SoundCategory.PLAYERS, 1.0f, 1.2f + 0.2f * world.field_73012_v.nextFloat(), false);
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

