/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.ILift;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.block.movement.BlockLift;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.EnumLiftMode;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Optional;

public class TileEntityLift
extends TileEntityAbstractEnergyConsumer
implements ILift {
    private static final double LIFT_GRAB_RADIUS = 0.4;
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotSecurity = new TileEntityAbstractBase.UpgradeSlot("lift.security", ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_CRYSTAL, 1), 1);
    private EnumLiftMode mode = EnumLiftMode.INACTIVE;
    private EnumLiftMode computerMode = EnumLiftMode.REDSTONE;
    private int updateTicks = 0;
    private boolean isActive = false;
    private boolean isValid = false;
    private int firstUncoveredY;

    public TileEntityLift() {
        this.peripheralName = "warpdriveLift";
        this.addMethods(new String[]{"mode", "state"});
        this.doRequireUpgradeToInterface();
        this.registerUpgradeSlot(upgradeSlotSecurity);
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.LIFT_MAX_ENERGY_STORED, 1024, 0, "MV", 2, "MV", 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateTicks;
        if (this.updateTicks < 0) {
            this.updateTicks = WarpDriveConfig.LIFT_UPDATE_INTERVAL_TICKS;
            this.mode = this.computerMode == EnumLiftMode.DOWN || this.computerMode == EnumLiftMode.REDSTONE && this.field_145850_b.func_175687_A(this.field_174879_c) > 0 ? EnumLiftMode.DOWN : EnumLiftMode.UP;
            this.isValid = this.isPassableBlock(this.field_174879_c.func_177956_o() + 1) && this.isPassableBlock(this.field_174879_c.func_177956_o() + 2) && this.isPassableBlock(this.field_174879_c.func_177956_o() - 1) && this.isPassableBlock(this.field_174879_c.func_177956_o() - 2);
            this.isActive = this.isEnabled && this.isValid;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.energy_getEnergyStored() < (long)WarpDriveConfig.LIFT_ENERGY_PER_ENTITY || !this.isActive) {
                this.mode = EnumLiftMode.INACTIVE;
                if (blockState.func_177229_b(BlockLift.MODE) != EnumLiftMode.INACTIVE) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a(BlockLift.MODE, (Comparable)((Object)EnumLiftMode.INACTIVE)));
                }
                return;
            }
            if (blockState.func_177229_b(BlockLift.MODE) != this.mode) {
                this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a(BlockLift.MODE, (Comparable)((Object)this.mode)));
            }
            for (int ny = this.field_174879_c.func_177956_o() - 2; ny > 0; --ny) {
                if (this.isPassableBlock(ny)) continue;
                this.firstUncoveredY = ny + 1;
                break;
            }
            if (this.field_174879_c.func_177956_o() - this.firstUncoveredY >= 2) {
                if (this.mode == EnumLiftMode.UP) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.firstUncoveredY, (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), 0.0f, 1.0f, 0.0f, 40, 0, 100);
                } else if (this.mode == EnumLiftMode.DOWN) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.firstUncoveredY, (double)this.field_174879_c.func_177952_p() + 0.5), 0.0f, 0.0f, 1.0f, 40, 0, 100);
                }
                if (this.liftEntity()) {
                    this.updateTicks = WarpDriveConfig.LIFT_ENTITY_COOLDOWN_TICKS;
                }
            }
        }
    }

    private boolean isPassableBlock(int yPosition) {
        BlockPos blockPos = new BlockPos(this.field_174879_c.func_177958_n(), yPosition, this.field_174879_c.func_177952_p());
        IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
        return blockState.func_177230_c() == Blocks.field_150350_a || this.field_145850_b.func_175623_d(blockPos) || blockState.func_185890_d((IBlockAccess)this.field_145850_b, blockPos) == null;
    }

    private boolean liftEntity() {
        AxisAlignedBB aabb;
        double xMin = (double)this.field_174879_c.func_177958_n() + 0.5 - 0.4;
        double xMax = (double)this.field_174879_c.func_177958_n() + 0.5 + 0.4;
        double zMin = (double)this.field_174879_c.func_177952_p() + 0.5 - 0.4;
        double zMax = (double)this.field_174879_c.func_177952_p() + 0.5 + 0.4;
        if (this.mode == EnumLiftMode.UP) {
            aabb = new AxisAlignedBB(xMin, (double)this.firstUncoveredY, zMin, xMax, (double)this.field_174879_c.func_177956_o(), zMax);
        } else if (this.mode == EnumLiftMode.DOWN) {
            aabb = new AxisAlignedBB(xMin, Math.min((double)this.firstUncoveredY + 4.0, (double)this.field_174879_c.func_177956_o()), zMin, xMax, (double)this.field_174879_c.func_177956_o() + 2.0, zMax);
        } else {
            return false;
        }
        List list = this.field_145850_b.func_72839_b(null, aabb);
        if (list.isEmpty()) {
            return false;
        }
        ArrayList globalRegions = this.getUpgradeCount(upgradeSlotSecurity) <= 0 ? new ArrayList(0) : GlobalRegionManager.getContainers(EnumGlobalRegionType.SHIP, this.field_145850_b, this.field_174879_c);
        ArrayList<TileEntityShipCore> tileEntityShipCores = new ArrayList<TileEntityShipCore>(globalRegions.size());
        if (!globalRegions.isEmpty()) {
            for (GlobalRegion globalRegion : globalRegions) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(globalRegion.getBlockPos());
                if (!(tileEntity instanceof TileEntityShipCore)) {
                    if (Commons.throttleMe("liftEntity-InvalidInstance")) {
                        WarpDrive.logger.error(String.format("Unable to lift entity due to invalid tile entity for global region, expecting TileEntityShipCore, got %s", tileEntity));
                    }
                    return false;
                }
                TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
                if (!tileEntityShipCore.isAssemblyValid()) {
                    if (Commons.throttleMe("liftEntity-InvalidAssembly")) {
                        WarpDrive.logger.error(String.format("Unable to lift entity due to invalid ship assembly for %s", tileEntity));
                    }
                    return false;
                }
                tileEntityShipCores.add(tileEntityShipCore);
            }
        }
        boolean isTransferDone = false;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLivingBase)) continue;
            if (!globalRegions.isEmpty()) {
                if (!(entity instanceof EntityPlayer)) continue;
                boolean isCrewMember = true;
                for (TileEntityShipCore tileEntityShipCore : tileEntityShipCores) {
                    isCrewMember &= tileEntityShipCore.isCrewMember((EntityPlayer)entity);
                }
                if (!isCrewMember) continue;
            }
            if (!this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, true)) continue;
            if (this.mode == EnumLiftMode.UP) {
                entity.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.firstUncoveredY, (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
            } else {
                entity.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.firstUncoveredY, (double)this.field_174879_c.func_177952_p() + 0.5);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, this.firstUncoveredY, (double)this.field_174879_c.func_177952_p() + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.LASER_HIGH, SoundCategory.AMBIENT, 1.0f, 1.0f);
            this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, false);
            isTransferDone = true;
        }
        return isTransferDone;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        byte byteValue;
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("mode")) {
            byteValue = tagCompound.func_74771_c("mode");
            this.mode = EnumLiftMode.get(Commons.clamp(0, 3, byteValue == -1 ? 3 : (int)byteValue));
        }
        if (tagCompound.func_74764_b("computerMode")) {
            byteValue = tagCompound.func_74771_c("computerMode");
            this.computerMode = EnumLiftMode.get(Commons.clamp(0, 3, byteValue == -1 ? 3 : (int)byteValue));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("mode", (byte)this.mode.ordinal());
        tagCompound.func_74774_a("computerMode", (byte)this.computerMode.ordinal());
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("mode");
        return tagCompound;
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, units)};
    }

    @Override
    public Object[] mode(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] instanceof String) {
            String stringValue = (String)arguments[0];
            this.computerMode = stringValue.equalsIgnoreCase("up") ? EnumLiftMode.UP : (stringValue.equalsIgnoreCase("down") ? EnumLiftMode.DOWN : EnumLiftMode.REDSTONE);
            this.func_70296_d();
        }
        return new Object[]{this.computerMode.func_176610_l()};
    }

    @Override
    public Object[] state() {
        long energy = this.energy_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isActive, energy, this.isValid, this.isEnabled, this.computerMode.func_176610_l()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] mode(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.mode(new Object[]{arguments.checkString(0)});
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "mode": {
                return this.mode(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

