/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.ITransporterBeacon;
import cr0s.warpdrive.block.TileEntityAbstractEnergyConsumer;
import cr0s.warpdrive.block.movement.BlockTransporterBeacon;
import cr0s.warpdrive.block.movement.TileEntityTransporterCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Optional;

public class TileEntityTransporterBeacon
extends TileEntityAbstractEnergyConsumer
implements ITransporterBeacon {
    private String nameTransporterCore;
    private UUID uuidTransporterCore;
    private int tickDeploying = 0;
    private boolean isActive = false;
    protected String stateTransporter = "";

    public TileEntityTransporterBeacon() {
        this.isEnergyLostWhenBroken = false;
        this.peripheralName = "warpdriveTransporterBeacon";
        this.addMethods(new String[]{"isActive"});
        this.doRequireUpgradeToInterface();
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.TRANSPORTER_BEACON_MAX_ENERGY_STORED, 1024, 0, "MV", 2, "MV", 0);
    }

    @Override
    public void func_73660_a() {
        boolean isDeployed;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = isDeployed = this.tickDeploying > WarpDriveConfig.TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS;
        if (!isDeployed) {
            ++this.tickDeploying;
        }
        if (!this.isEnabled) {
            this.isActive = false;
        } else {
            boolean isConnected = this.uuidTransporterCore != null && (this.uuidTransporterCore.getLeastSignificantBits() != 0L || this.uuidTransporterCore.getMostSignificantBits() != 0L);
            boolean isPowered = this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, true);
            boolean isActiveNew = false;
            if (isPowered) {
                if (isConnected) {
                    isActiveNew = this.pingTransporter();
                    if (isActiveNew) {
                        this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, false);
                    }
                } else {
                    this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, false);
                }
            }
            this.isActive = isActiveNew;
        }
        IBlockState blockState_actual = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateBlockState(blockState_actual, blockState_actual.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)).func_177226_a((IProperty)BlockTransporterBeacon.DEPLOYED, (Comparable)Boolean.valueOf(isDeployed)));
    }

    private boolean pingTransporter() {
        GlobalRegion globalRegion = GlobalRegionManager.getByUUID(EnumGlobalRegionType.TRANSPORTER, this.uuidTransporterCore);
        if (globalRegion == null) {
            return false;
        }
        WorldServer worldTransporter = Commons.getOrCreateWorldServer(globalRegion.dimensionId);
        if (worldTransporter == null) {
            WarpDrive.logger.error(String.format("%s Unable to load dimension %d for transporter with UUID %s", this, globalRegion.dimensionId, this.uuidTransporterCore));
            return false;
        }
        TileEntity tileEntity = worldTransporter.func_175625_s(globalRegion.getBlockPos());
        if (!(tileEntity instanceof TileEntityTransporterCore)) {
            WarpDrive.logger.warn(String.format("%s Transporter has gone missing for %s, found %s", this, globalRegion, tileEntity));
            return false;
        }
        TileEntityTransporterCore tileEntityTransporterCore = (TileEntityTransporterCore)tileEntity;
        boolean isActive = tileEntityTransporterCore.updateBeacon(this, this.uuidTransporterCore);
        Object[] state = tileEntityTransporterCore.state();
        this.stateTransporter = (String)state[1];
        return isActive;
    }

    @Override
    public void energizeDone() {
        this.isEnabled = false;
    }

    @Override
    public void setIsEnabled(boolean isEnabled) {
        super.setIsEnabled(isEnabled);
        if (isEnabled) {
            this.tickDeploying = 0;
        }
        this.stateTransporter = "";
    }

    @Override
    public Boolean[] isActive(Object[] arguments) {
        return new Boolean[]{this.isActive};
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, units)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isActive(Context context, Arguments arguments) {
        return this.isActive(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "isActive": {
                return this.isActive(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    private WarpDriveText getSignatureStatus() {
        if (this.uuidTransporterCore == null) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.transporter_signature.status_line.invalid", new Object[0]);
        }
        return new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.transporter_signature.status_line.valid", this.nameTransporterCore, this.uuidTransporterCore);
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textSignatureStatus = this.getSignatureStatus();
        if (textSignatureStatus.func_150260_c().isEmpty()) {
            return super.getStatus();
        }
        return super.getStatus().append((ITextComponent)textSignatureStatus);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return from == EnumFacing.DOWN;
    }

    @Override
    public boolean energy_canOutput(EnumFacing to) {
        return false;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.uuidTransporterCore != null) {
            tagCompound.func_74778_a("name", this.nameTransporterCore);
            tagCompound.func_74772_a("uuidMost", this.uuidTransporterCore.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuidTransporterCore.getLeastSignificantBits());
        }
        tagCompound.func_74768_a("tickDeploying", this.tickDeploying);
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.nameTransporterCore = tagCompound.func_74779_i("name");
        this.uuidTransporterCore = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (this.uuidTransporterCore.getMostSignificantBits() == 0L && this.uuidTransporterCore.getLeastSignificantBits() == 0L) {
            this.uuidTransporterCore = null;
            this.nameTransporterCore = "";
        }
        this.tickDeploying = tagCompound.func_74762_e("tickDeploying");
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("tickDeploying");
        return tagCompound;
    }

    @Override
    public String toString() {
        return String.format("%s %s %8d EU linked to %s %s", this.getClass().getSimpleName(), Commons.format(this.field_145850_b, this.field_174879_c), this.energy_getEnergyStored(), this.nameTransporterCore, this.uuidTransporterCore);
    }
}

