/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.IItemTransporterBeacon;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.ITransporterBeacon;
import cr0s.warpdrive.api.computer.ITransporterCore;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.movement.BlockTransporterBeacon;
import cr0s.warpdrive.block.movement.BlockTransporterContainment;
import cr0s.warpdrive.block.movement.BlockTransporterCore;
import cr0s.warpdrive.block.movement.BlockTransporterScanner;
import cr0s.warpdrive.block.movement.TileEntityTransporterBeacon;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.EnumTransporterState;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.network.PacketHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.Optional;

public class TileEntityTransporterCore
extends TileEntityAbstractEnergyCoreOrController
implements ITransporterCore,
IBeamFrequency,
IGlobalRegionProvider {
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotEnergyStorage = new TileEntityAbstractBase.UpgradeSlot("transporter.energy_storage", ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1), WarpDriveConfig.TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY);
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotFocus = new TileEntityAbstractBase.UpgradeSlot("transporter.focus", ItemComponent.getItemStackNoCache(EnumComponentType.EMERALD_CRYSTAL, 1), WarpDriveConfig.TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY);
    private static final TileEntityAbstractBase.UpgradeSlot upgradeSlotRange = new TileEntityAbstractBase.UpgradeSlot("transporter.range", ItemComponent.getItemStackNoCache(EnumComponentType.ENDER_COIL, 1), WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY);
    private ArrayList<BlockPos> vLocalScanners = null;
    private int beamFrequency = -1;
    private boolean isLockRequested = false;
    private boolean isEnergizeRequested = false;
    private Object remoteLocationRequested = null;
    private double energyFactor = 1.0;
    private double lockStrengthActual = 0.0;
    private int tickCooldown = 0;
    private EnumTransporterState transporterState = EnumTransporterState.DISABLED;
    private ArrayList<BlockPos> vLocalContainments = null;
    private AxisAlignedBB aabbLocalScanners = null;
    private int tickComputerPulse = 0;
    private boolean isConnected = false;
    private GlobalPosition globalPositionBeacon = null;
    private ForgeChunkManager.Ticket ticketChunkloading;
    private double energyCostForAcquiring = 0.0;
    private double energyCostForEnergizing = 0.0;
    private double lockStrengthOptimal = -1.0;
    private double lockStrengthSpeed = 0.0;
    private boolean isJammed = false;
    private String reasonJammed = "";
    private GlobalPosition globalPositionLocal = null;
    private GlobalPosition globalPositionRemote = null;
    private ArrayList<BlockPos> vRemoteScanners = null;
    private final HashMap<Integer, MovingEntity> movingEntitiesLocal = new HashMap(8);
    private final HashMap<Integer, MovingEntity> movingEntitiesRemote = new HashMap(8);
    private int tickEnergizing = 0;

    public TileEntityTransporterCore() {
        this.peripheralName = "warpdriveTransporterCore";
        this.addMethods(new String[]{"beamFrequency", "state", "remoteLocation", "lock", "energyFactor", "getLockStrength", "energize"});
        this.CC_scripts = Collections.singletonList("startup");
        this.registerUpgradeSlot(upgradeSlotEnergyStorage);
        this.registerUpgradeSlot(upgradeSlotFocus);
        this.registerUpgradeSlot(upgradeSlotRange);
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.refreshEnergyParameters();
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.globalPositionLocal = new GlobalPosition(this);
    }

    @Override
    public void func_73660_a() {
        boolean isPowered;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.isConnected = IBeamFrequency.isValid(this.beamFrequency);
        this.tickCooldown = this.tickCooldown > 0 ? --this.tickCooldown : 0;
        if (!this.isEnabled) {
            this.transporterState = EnumTransporterState.DISABLED;
            isPowered = false;
        } else {
            int energyRequired = this.getEnergyRequired(this.transporterState);
            if (energyRequired > 0) {
                isPowered = this.energy_consume(energyRequired, false);
                if (!isPowered) {
                    this.reasonJammed = "Insufficient energy for operation";
                    this.transporterState = EnumTransporterState.IDLE;
                    this.tickCooldown = Math.max(this.tickCooldown, WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS);
                }
            } else {
                isPowered = true;
            }
            if (isPowered && (this.transporterState == EnumTransporterState.ACQUIRING || this.transporterState == EnumTransporterState.ENERGIZING)) {
                double overshoot = 0.01;
                this.lockStrengthActual = Math.min(this.lockStrengthOptimal, this.lockStrengthActual + this.lockStrengthSpeed * (this.lockStrengthOptimal - this.lockStrengthActual + 0.01));
            } else {
                this.lockStrengthActual = Math.max(0.0, this.lockStrengthActual * WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK);
            }
        }
        this.updateBlockState((IBlockState)null, BlockTransporterCore.VARIANT, !this.isConnected ? EnumTransporterState.DISABLED : (!this.isEnabled ? EnumTransporterState.IDLE : (!isPowered ? EnumTransporterState.ACQUIRING : EnumTransporterState.ENERGIZING)));
        if (this.isConnected && this.isEnabled) {
            if (this.isLockRequested && this.isJammed) {
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            }
            if (this.lockStrengthActual > (double)0.01f || this.transporterState == EnumTransporterState.ENERGIZING && this.tickEnergizing > 0 || this.tickCooldown > 0) {
                PacketHandler.sendTransporterEffectPacket(this.field_145850_b, this.globalPositionLocal, this.globalPositionRemote, this.lockStrengthActual, this.movingEntitiesLocal.values(), this.movingEntitiesRemote.values(), this.tickEnergizing, this.tickCooldown, 64);
            }
        }
        --this.tickComputerPulse;
        if (this.tickComputerPulse < 0) {
            this.tickComputerPulse = 20;
            if (this.lockStrengthActual > (double)0.01f) {
                this.sendEvent("transporterPulse", this.lockStrengthActual);
            }
        }
        switch (this.transporterState) {
            case DISABLED: {
                this.releaseChunks();
                this.isLockRequested = false;
                this.isEnergizeRequested = false;
                this.lockStrengthActual = 0.0;
                if (!this.isConnected || !this.isEnabled) break;
                this.transporterState = EnumTransporterState.IDLE;
                break;
            }
            case IDLE: {
                if (this.isLockRequested && this.tickCooldown == 0) {
                    this.markDirtyParameters();
                    this.transporterState = EnumTransporterState.ACQUIRING;
                    break;
                }
                this.releaseChunks();
                break;
            }
            case ACQUIRING: {
                if (!this.isLockRequested) {
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.isJammed) {
                    this.tickCooldown += WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS;
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.tickCooldown != 0) break;
                if (this.globalPositionBeacon != null && !this.isEnergizeRequested && this.lockStrengthActual >= 0.85) {
                    this.isEnergizeRequested = true;
                    break;
                }
                if (!this.isEnergizeRequested) break;
                this.markDirtyParameters();
                this.tickEnergizing = WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS;
                this.transporterState = EnumTransporterState.ENERGIZING;
                break;
            }
            case ENERGIZING: {
                if (!this.isLockRequested) {
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (!this.isEnergizeRequested) {
                    this.transporterState = EnumTransporterState.ACQUIRING;
                    break;
                }
                if (this.isJammed) {
                    this.tickCooldown += WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS;
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.tickCooldown > 0) break;
                this.state_energizing();
                break;
            }
            default: {
                this.transporterState = EnumTransporterState.DISABLED;
            }
        }
    }

    @Override
    public void onChunkUnload() {
        this.releaseChunks();
        super.onChunkUnload();
    }

    @Override
    public void onBlockBroken(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (!world.field_72995_K) {
            this.rebootTransporter();
        }
        super.onBlockBroken(world, blockPos, blockState);
    }

    private void rebootTransporter() {
        if (this.vLocalScanners != null) {
            for (BlockPos vScanner : this.vLocalScanners) {
                IBlockState blockState = this.field_145850_b.func_180495_p(vScanner);
                if (!(blockState.func_177230_c() instanceof BlockTransporterScanner)) continue;
                this.field_145850_b.func_180501_a(vScanner, blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        this.releaseChunks();
    }

    private void state_energizing() {
        WorldServer worldRemote = Commons.getOrCreateWorldServer(this.globalPositionRemote.dimensionId);
        if (worldRemote == null) {
            WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", this.globalPositionRemote.dimensionId, this));
            this.isJammed = true;
            this.reasonJammed = String.format("Unable to initialize dimension %d", this.globalPositionRemote.dimensionId);
            return;
        }
        EntityValues entityValues = this.updateEntitiesToEnergize(worldRemote);
        if (this.tickEnergizing == WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS) {
            this.sendEvent("transporterEnergizing", entityValues.count);
        }
        if (entityValues.count == 0) {
            this.isEnergizeRequested = false;
            this.tickCooldown += WarpDriveConfig.TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
            this.transporterState = EnumTransporterState.ACQUIRING;
            return;
        }
        if (this.tickEnergizing > 0) {
            --this.tickEnergizing;
            return;
        }
        if (this.vRemoteScanners == null || this.vRemoteScanners.isEmpty()) {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesLocal, (World)worldRemote, this.globalPositionRemote.getBlockPos());
        } else {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesLocal, (World)worldRemote, this.vRemoteScanners);
        }
        if (this.vLocalScanners != null && !this.vLocalScanners.isEmpty()) {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesRemote, this.field_145850_b, this.vLocalScanners);
        }
        this.isEnergizeRequested = false;
        this.markDirtyParameters();
        this.tickCooldown += WarpDriveConfig.TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
        this.lockStrengthActual = Math.max(0.0, this.lockStrengthActual - WarpDriveConfig.TRANSPORTER_ENERGIZING_LOCKING_LOST);
        this.transporterState = EnumTransporterState.ACQUIRING;
        if (this.globalPositionBeacon != null) {
            WorldServer world = this.globalPositionBeacon.getWorldServerIfLoaded();
            if (world == null) {
                WarpDrive.logger.warn(String.format("Unable to disable TransporterBeacon %s: world isn't loaded", this.globalPositionBeacon));
            } else {
                TileEntity tileEntity = world.func_175625_s(this.globalPositionBeacon.getBlockPos());
                if (tileEntity instanceof ITransporterBeacon) {
                    ((ITransporterBeacon)tileEntity).energizeDone();
                } else {
                    WarpDrive.logger.warn(String.format("Unable to disable TransporterBeacon %s: unsupported tile entity %s", this.globalPositionBeacon, tileEntity));
                }
            }
        }
    }

    private void energizeEntities(double lockStrength, HashMap<Integer, MovingEntity> movingEntities, World world, BlockPos vPosition) {
        for (Map.Entry<Integer, MovingEntity> entryEntity : movingEntities.entrySet()) {
            MovingEntity movingEntity = entryEntity.getValue();
            this.energizeEntity(lockStrength, movingEntity, world, vPosition);
        }
    }

    private void energizeEntities(double lockStrength, HashMap<Integer, MovingEntity> movingEntities, World world, ArrayList<BlockPos> vScanners) {
        for (Map.Entry<Integer, MovingEntity> entryEntity : movingEntities.entrySet()) {
            int indexEntity = entryEntity.getKey();
            MovingEntity movingEntity = entryEntity.getValue();
            BlockPos vScanner = vScanners.get(indexEntity);
            this.energizeEntity(lockStrength, movingEntity, world, vScanner);
        }
    }

    private void energizeEntity(double lockStrength, MovingEntity movingEntity, World world, BlockPos vPosition) {
        if (movingEntity == MovingEntity.INVALID) {
            return;
        }
        if (movingEntity == null || vPosition == null) {
            WarpDrive.logger.warn(String.format("Invalid entity %s for position %s, skipping transportation...", movingEntity, vPosition));
            return;
        }
        Entity entity = movingEntity.getEntity();
        if (entity == null) {
            WarpDrive.logger.warn("Entity went missing, skipping transportation...");
            return;
        }
        String nameEntity = entity.func_70005_c_();
        if (lockStrength < 1.0 && world.field_73012_v.nextDouble() > lockStrength) {
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("Insufficient lock strength %.3f to transport %s", lockStrength, entity));
            }
            TileEntityTransporterCore.applyTeleportationDamages(false, entity, lockStrength);
            this.sendEvent("transporterFailure", nameEntity);
            return;
        }
        Vector3 v3Target = new Vector3((double)vPosition.func_177958_n() + 0.5, (double)vPosition.func_177956_o() + 0.99, (double)vPosition.func_177952_p() + 0.5);
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporting entity %s to %s", entity, v3Target));
        }
        Commons.moveEntity(entity, world, v3Target);
        TileEntityTransporterCore.applyTeleportationDamages(false, entity, lockStrength);
        this.sendEvent("transporterSuccess", nameEntity);
    }

    @Override
    public WarpDriveText getStatusHeader() {
        if (this.globalPositionLocal == null || this.globalPositionRemote == null) {
            return super.getStatusHeader();
        }
        return super.getStatusHeader().append(null, "warpdrive.transporter.status_line.from_to", this.globalPositionLocal.x, this.globalPositionLocal.y, this.globalPositionLocal.z, this.globalPositionRemote.x, this.globalPositionRemote.y, this.globalPositionRemote.z);
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && IBeamFrequency.isValid(parBeamFrequency)) {
            int beamFrequencyOld = this.beamFrequency;
            this.beamFrequency = parBeamFrequency;
            this.markDirtyParameters();
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("%s Beam frequency set from %d to %d", this, beamFrequencyOld, this.beamFrequency));
            }
        }
        this.func_70296_d();
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.TRANSPORTER;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        return new AxisAlignedBB(Math.min((double)(this.field_174879_c.func_177958_n() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177958_n() : this.aabbLocalScanners.field_72340_a), Math.min((double)(this.field_174879_c.func_177956_o() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177956_o() : this.aabbLocalScanners.field_72338_b), Math.min((double)(this.field_174879_c.func_177952_p() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177952_p() : this.aabbLocalScanners.field_72339_c), Math.max((double)(this.field_174879_c.func_177958_n() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177958_n() : this.aabbLocalScanners.field_72336_d), Math.max((double)(this.field_174879_c.func_177956_o() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177956_o() : this.aabbLocalScanners.field_72337_e), Math.max((double)(this.field_174879_c.func_177952_p() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_174879_c.func_177952_p() : this.aabbLocalScanners.field_72334_f));
    }

    @Override
    public int getMass() {
        return this.vLocalScanners == null ? 0 : this.vLocalScanners.size();
    }

    @Override
    public double getIsolationRate() {
        return 0.0;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        if (this.isDirtyAssembly()) {
            return true;
        }
        Block block = blockState.func_177230_c();
        if (block instanceof BlockTransporterScanner || block instanceof BlockTransporterContainment) {
            this.markDirtyAssembly();
            return true;
        }
        if (this.aabbLocalScanners != null && (double)blockPos.func_177958_n() >= this.aabbLocalScanners.field_72340_a && (double)blockPos.func_177956_o() >= this.aabbLocalScanners.field_72338_b && (double)blockPos.func_177952_p() >= this.aabbLocalScanners.field_72339_c && (double)blockPos.func_177958_n() < this.aabbLocalScanners.field_72336_d && (double)blockPos.func_177956_o() < this.aabbLocalScanners.field_72337_e && (double)blockPos.func_177952_p() < this.aabbLocalScanners.field_72334_f) {
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("onBlockUpdatingInArea %s %s", blockState, Commons.format(this.field_145850_b, blockPos)));
            }
            this.markDirtyAssembly();
        }
        return true;
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        int xMin = this.field_174879_c.func_177958_n() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int xMax = this.field_174879_c.func_177958_n() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int yMin = this.field_174879_c.func_177956_o() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS;
        int yMax = this.field_174879_c.func_177956_o() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS;
        int zMin = this.field_174879_c.func_177952_p() - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int zMax = this.field_174879_c.func_177952_p() + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        ArrayList<BlockPos> vScanners = new ArrayList<BlockPos>(16);
        HashSet<BlockPos> vContainments = new HashSet<BlockPos>(64);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                if (y < 0 || y > 254) continue;
                for (int z = zMin; z <= zMax; ++z) {
                    mutableBlockPos.func_181079_c(x, y, z);
                    IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos);
                    Block block = blockState.func_177230_c();
                    if (!(block instanceof BlockTransporterScanner)) continue;
                    Collection<BlockPos> vValidContainments = ((BlockTransporterScanner)block).getValidContainment(this.field_145850_b, (BlockPos)mutableBlockPos);
                    if (vValidContainments == null || vValidContainments.isEmpty()) {
                        textReason.append(Commons.getStyleWarning(), "warpdrive.transporter.status_line.missing_containment", Commons.format(this.field_145850_b, (BlockPos)mutableBlockPos));
                        this.field_145850_b.func_180501_a((BlockPos)mutableBlockPos, blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
                        PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)x + 0.5, (double)y + 1.5, (double)z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                        continue;
                    }
                    vScanners.add(mutableBlockPos.func_185334_h());
                    vContainments.addAll(vValidContainments);
                    this.field_145850_b.func_180501_a((BlockPos)mutableBlockPos, blockState.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
        this.setLocalScanners(vScanners, vContainments);
        this.markDirtyParameters();
        this.markDirtyGlobalRegion();
        return isValid;
    }

    private void setLocalScanners(ArrayList<BlockPos> vScanners, Collection<BlockPos> vContainments) {
        if (vScanners == null || vScanners.isEmpty()) {
            this.vLocalScanners = null;
            this.vLocalContainments = null;
            this.aabbLocalScanners = null;
            return;
        }
        VectorI vMin = new VectorI(vScanners.get(0));
        VectorI vMax = new VectorI(vScanners.get(0));
        for (BlockPos vScanner : vScanners) {
            vMin.x = Math.min(vMin.x, vScanner.func_177958_n() - 1);
            vMin.y = Math.min(vMin.y, vScanner.func_177956_o());
            vMin.z = Math.min(vMin.z, vScanner.func_177952_p() - 1);
            vMax.x = Math.max(vMax.x, vScanner.func_177958_n() + 1);
            vMax.y = Math.max(vMax.y, vScanner.func_177956_o() + 2);
            vMax.z = Math.max(vMax.z, vScanner.func_177952_p() + 1);
        }
        this.vLocalScanners = vScanners;
        this.vLocalContainments = new ArrayList<BlockPos>(vContainments);
        this.aabbLocalScanners = new AxisAlignedBB((double)vMin.x, (double)vMin.y, (double)vMin.z, (double)vMax.x + 1.0, (double)vMax.y + 1.0, (double)vMax.z + 1.0);
    }

    public Collection<BlockPos> getContainments() {
        return this.vLocalContainments;
    }

    private void checkBeaconObsolescence() {
        if (this.globalPositionBeacon != null) {
            WorldServer worldBeacon = this.globalPositionBeacon.getWorldServerIfLoaded();
            if (worldBeacon == null) {
                this.globalPositionBeacon = null;
                this.isLockRequested = false;
                this.isEnergizeRequested = false;
                this.isJammed = false;
                this.reasonJammed = "";
            } else {
                TileEntity tileEntity = worldBeacon.func_175625_s(this.globalPositionBeacon.getBlockPos());
                if (!(tileEntity instanceof ITransporterBeacon) || !((ITransporterBeacon)tileEntity).isActive()) {
                    this.globalPositionBeacon = null;
                    this.isLockRequested = false;
                    this.isEnergizeRequested = false;
                    this.isJammed = false;
                    this.reasonJammed = "";
                }
            }
        }
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
        WorldServer worldRemote;
        this.isJammed = false;
        this.reasonJammed = "";
        if (this.transporterState != EnumTransporterState.ENERGIZING) {
            this.movingEntitiesLocal.clear();
            this.movingEntitiesRemote.clear();
        }
        if (!this.isConnected) {
            this.isJammed = true;
            this.reasonJammed = "Beam frequency not set";
            return;
        }
        CelestialObject celestialObjectLocal = CelestialObjectManager.get(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        Vector3 v3Local_universal = GlobalRegionManager.getUniversalCoordinates(celestialObjectLocal, this.globalPositionLocal.x, this.globalPositionLocal.y, this.globalPositionLocal.z);
        this.checkBeaconObsolescence();
        GlobalPosition globalPositionRemoteNew = null;
        if (this.globalPositionBeacon != null) {
            globalPositionRemoteNew = this.globalPositionBeacon;
        } else if (this.remoteLocationRequested instanceof VectorI) {
            VectorI vRequest = ((VectorI)this.remoteLocationRequested).clone();
            if (vRequest.y < 0) {
                CelestialObject celestialObjectChild = CelestialObjectManager.getClosestChild(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                if (celestialObjectChild == null) {
                    this.reasonJammed = "Not in orbit of a planet!\nIncrease target Y coordinate.";
                } else {
                    vRequest.translate(celestialObjectChild.getEntryOffset());
                    globalPositionRemoteNew = new GlobalPosition(celestialObjectChild.dimensionId, vRequest.x, (vRequest.y + 1024) % 256, vRequest.z);
                }
            } else if (vRequest.y > 256) {
                if (celestialObjectLocal == null) {
                    this.reasonJammed = "Unknown local celestial object!\nThere's no orbit to reach from here.\nReduce target Y coordinate.";
                } else if (celestialObjectLocal.parent == null) {
                    this.reasonJammed = "No parent dimension!\nThere's no orbit to reach from here.\nReduce target Y coordinate.";
                } else {
                    vRequest.translateBack(celestialObjectLocal.getEntryOffset());
                    globalPositionRemoteNew = new GlobalPosition(celestialObjectLocal.parent.dimensionId, vRequest.x, vRequest.y % 256, vRequest.z);
                }
            } else {
                globalPositionRemoteNew = new GlobalPosition(this.field_145850_b.field_73011_w.getDimension(), vRequest.x, vRequest.y, vRequest.z);
            }
        } else if (this.remoteLocationRequested instanceof UUID) {
            globalPositionRemoteNew = GlobalRegionManager.getByUUID(EnumGlobalRegionType.TRANSPORTER, (UUID)this.remoteLocationRequested);
            if (globalPositionRemoteNew == null) {
                this.reasonJammed = "Unknown transporter signature";
            }
        } else if (this.remoteLocationRequested instanceof String) {
            EntityPlayerMP entityPlayer = Commons.getOnlinePlayerByName((String)this.remoteLocationRequested);
            if (entityPlayer == null) {
                this.reasonJammed = "No player by that name";
            } else {
                ItemStack itemStackHeld = entityPlayer.func_184586_b(EnumHand.MAIN_HAND);
                if (itemStackHeld.func_190926_b() || !(itemStackHeld.func_77973_b() instanceof IItemTransporterBeacon)) {
                    itemStackHeld = entityPlayer.func_184586_b(EnumHand.OFF_HAND);
                }
                if (itemStackHeld.func_190926_b() || !(itemStackHeld.func_77973_b() instanceof IItemTransporterBeacon)) {
                    this.reasonJammed = "No transporter beacon in player hand";
                } else if (!((IItemTransporterBeacon)itemStackHeld.func_77973_b()).isActive(itemStackHeld)) {
                    this.reasonJammed = "Player beacon is out of power";
                } else {
                    globalPositionRemoteNew = new GlobalPosition((Entity)entityPlayer);
                }
            }
        } else {
            this.reasonJammed = "No remote location defined";
        }
        if (globalPositionRemoteNew == null || !globalPositionRemoteNew.equals(this.globalPositionRemote)) {
            this.globalPositionRemote = globalPositionRemoteNew;
            this.lockStrengthActual = 0.0;
            if (this.transporterState == EnumTransporterState.ENERGIZING) {
                this.transporterState = EnumTransporterState.ACQUIRING;
            }
            boolean bl = this.isJammed = globalPositionRemoteNew == null;
            if (this.isJammed) {
                return;
            }
        }
        CelestialObject celestialObjectRemote = this.globalPositionRemote.getCelestialObject(this.field_145850_b.field_72995_K);
        Vector3 v3Remote_universal = this.globalPositionRemote.getUniversalCoordinates(this.field_145850_b.field_72995_K);
        if (celestialObjectRemote == null) {
            this.isJammed = true;
            this.reasonJammed = "Unknown remote celestial object";
            return;
        }
        if (celestialObjectLocal != celestialObjectRemote) {
            if (celestialObjectLocal != null && celestialObjectLocal.isHyperspace() || celestialObjectRemote.isHyperspace()) {
                this.isJammed = true;
                this.reasonJammed = "Blocked by warp field barrier!\nExit hyperspace to use transporter room.";
                return;
            }
            if (celestialObjectRemote.isVirtual()) {
                this.isJammed = true;
                this.reasonJammed = "Unable to reach virtual planet";
                return;
            }
        }
        if (this.transporterState == EnumTransporterState.ACQUIRING || this.transporterState == EnumTransporterState.ENERGIZING) {
            worldRemote = Commons.getOrCreateWorldServer(celestialObjectRemote.dimensionId);
            if (worldRemote == null) {
                WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", celestialObjectRemote.dimensionId, this));
                this.isJammed = true;
                this.reasonJammed = String.format("Unable to initialize dimension %d", celestialObjectRemote.dimensionId);
                return;
            }
        } else {
            worldRemote = DimensionManager.getWorld((int)celestialObjectRemote.dimensionId);
        }
        double rangeActualSquared = v3Local_universal.clone().subtract(v3Remote_universal).getMagnitudeSquared();
        int rangeActual = (int)Math.ceil(Math.sqrt(rangeActualSquared));
        FocusValues focusValuesLocal = TileEntityTransporterCore.getFocusValueAtCoordinates(this.field_145850_b, this.globalPositionLocal.getBlockPos(), 0);
        FocusValues focusValuesRemote = TileEntityTransporterCore.getFocusValueAtCoordinates((World)worldRemote, this.globalPositionRemote.getBlockPos(), WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS);
        double focusBoost = Commons.interpolate(1.0, 0.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR, this.energyFactor);
        this.lockStrengthOptimal = (focusValuesLocal.strength + focusValuesRemote.strength) / 2.0 + focusBoost;
        this.lockStrengthSpeed = (focusValuesLocal.speed + focusValuesRemote.speed) / 2.0 / (double)WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS;
        int rangeMax = WarpDriveConfig.TRANSPORTER_RANGE_BASE_BLOCKS + WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_BLOCKS * focusValuesLocal.countRangeUpgrades + WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_BLOCKS * focusValuesRemote.countRangeUpgrades;
        this.vRemoteScanners = focusValuesRemote.vScanners;
        EntityValues entityValues = this.updateEntitiesToEnergize(worldRemote);
        this.energyCostForAcquiring = Math.max(0.0, WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[0] + WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[1] * (double)(this.vLocalScanners == null ? 1 : this.vLocalScanners.size()) * (Math.log(1.0 + WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[2] * (double)rangeActual) + Math.pow(WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[3] + (double)rangeActual, WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[4])));
        this.energyCostForEnergizing = Math.max(0.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[0] + WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[1] * (double)entityValues.mass * (Math.log(1.0 + WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[2] * (double)rangeActual) + Math.pow(WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[3] + (double)rangeActual, WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[4])));
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporter parameters at %s are range (actual %d max %d) lockStrength (actual %.5f optimal %.5f speed %.5f)", Commons.format(this.field_145850_b, this.field_174879_c), rangeActual, rangeMax, this.lockStrengthActual, this.lockStrengthOptimal, this.lockStrengthSpeed));
        }
        if (rangeActual < 16) {
            this.isJammed = true;
            this.reasonJammed = "Remote location is too close";
            return;
        }
        if (rangeActual > rangeMax) {
            this.isJammed = true;
            this.reasonJammed = String.format("Out of range: %d > %d m", rangeActual, rangeMax);
            return;
        }
        if (this.field_145850_b == worldRemote) {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getBlockPos(), this.globalPositionRemote.getBlockPos(), this.beamFrequency);
        } else if (v3Local_universal.y > v3Remote_universal.y) {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getBlockPos(), new BlockPos(this.globalPositionLocal.x, -1, this.globalPositionLocal.z), this.beamFrequency);
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory((World)worldRemote, new BlockPos(this.globalPositionRemote.x, 256, this.globalPositionRemote.z), this.globalPositionRemote.getBlockPos(), this.beamFrequency);
        } else {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getBlockPos(), new BlockPos(this.globalPositionLocal.x, 256, this.globalPositionLocal.z), this.beamFrequency);
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory((World)worldRemote, new BlockPos(this.globalPositionRemote.x, -1, this.globalPositionRemote.z), this.globalPositionRemote.getBlockPos(), this.beamFrequency);
        }
        if (this.isJammed) {
            this.reasonJammed = "Blocked by force field or unbreakable block";
        }
    }

    boolean updateBeacon(TileEntity tileEntity, UUID uuidTransporterCore) {
        if (tileEntity == null || this.uuid == null || !this.uuid.equals(uuidTransporterCore)) {
            WarpDrive.logger.error(String.format("%s Invalid parameters in beacon call to transporter as %s, %s", this, tileEntity, uuidTransporterCore));
            return false;
        }
        if (this.globalPositionBeacon != null && !this.globalPositionBeacon.equals(tileEntity)) {
            int radius2 = WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS * WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS;
            if (this.globalPositionBeacon.distance2To(tileEntity) <= radius2) {
                return true;
            }
            this.checkBeaconObsolescence();
            if (this.globalPositionBeacon != null) {
                if (!this.isJammed && WarpDriveConfig.LOGGING_TRANSPORTER) {
                    WarpDrive.logger.info(String.format("%s Conflicting beacon requests received %s is not %s", this, tileEntity, this.uuid));
                }
                this.isJammed = true;
                this.reasonJammed = "Conflicting beacon requests received";
                this.tickCooldown = Math.max(this.tickCooldown, WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS);
                return false;
            }
        }
        if (this.globalPositionBeacon == null) {
            this.globalPositionBeacon = new GlobalPosition(tileEntity);
            this.energyFactor = Math.max(4.0, this.energyFactor);
            this.isJammed = true;
            this.reasonJammed = "Beacon request received";
            this.lockStrengthActual = 0.0;
            this.forceChunks();
            if (this.transporterState == EnumTransporterState.ENERGIZING) {
                this.transporterState = EnumTransporterState.ACQUIRING;
            }
        }
        this.isLockRequested = true;
        return true;
    }

    private void forceChunks() {
        if (this.ticketChunkloading != null) {
            WarpDrive.logger.warn(String.format("%s Already chunkloading...", this));
            return;
        }
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("%s Forcing chunks", this));
        }
        this.ticketChunkloading = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketChunkloading == null) {
            WarpDrive.logger.error(String.format("%s Chunkloading rejected", this));
            return;
        }
        AxisAlignedBB aabbArea = this.getGlobalRegionArea();
        int minX = (int)aabbArea.field_72340_a >> 4;
        int maxX = (int)aabbArea.field_72336_d >> 4;
        int minZ = (int)aabbArea.field_72339_c >> 4;
        int maxZ = (int)aabbArea.field_72334_f >> 4;
        int chunkCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (++chunkCount > this.ticketChunkloading.getMaxChunkListDepth()) {
                    WarpDrive.logger.error(String.format("%s Too many chunks to load: %d > %d", this, (maxX - minX + 1) * (maxZ - minZ + 1), this.ticketChunkloading.getMaxChunkListDepth()));
                    return;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketChunkloading, (ChunkPos)new ChunkPos(x, z));
            }
        }
    }

    private void releaseChunks() {
        if (this.ticketChunkloading == null) {
            return;
        }
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(this + " Releasing chunks");
        }
        if (this.ticketChunkloading != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketChunkloading);
            this.ticketChunkloading = null;
        }
    }

    private static FocusValues getFocusValueAtCoordinates(World world, BlockPos blockPos, int radius) {
        if (world == null) {
            FocusValues result = new FocusValues();
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
            return result;
        }
        int countBeacons = 0;
        int countTransporters = 0;
        int sumRangeUpgrades = 0;
        int sumFocusUpgrades = 0;
        int xMin = blockPos.func_177958_n() - radius;
        int xMax = blockPos.func_177958_n() + radius;
        int yMin = blockPos.func_177956_o() - radius;
        int yMax = blockPos.func_177956_o() + radius;
        int zMin = blockPos.func_177952_p() - radius;
        int zMax = blockPos.func_177952_p() + radius;
        ArrayList<BlockPos> vScanners = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                if (y < 0 || y > 254) continue;
                for (int z = zMin; z <= zMax; ++z) {
                    TileEntity tileEntity;
                    mutableBlockPos.func_181079_c(x, y, z);
                    Block block = world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
                    if (block instanceof BlockTransporterBeacon) {
                        tileEntity = world.func_175625_s((BlockPos)mutableBlockPos);
                        if (!(tileEntity instanceof TileEntityTransporterBeacon) || !((TileEntityTransporterBeacon)tileEntity).isActive()) continue;
                        ++countBeacons;
                        continue;
                    }
                    if (!(block instanceof BlockTransporterCore) || !((tileEntity = world.func_175625_s((BlockPos)mutableBlockPos)) instanceof TileEntityTransporterCore) || !((TileEntityTransporterCore)tileEntity).isEnabled || !((TileEntityTransporterCore)tileEntity).isConnected) continue;
                    ++countTransporters;
                    vScanners = ((TileEntityTransporterCore)tileEntity).vLocalScanners;
                    sumRangeUpgrades += ((TileEntityTransporterCore)tileEntity).getUpgradeCount(upgradeSlotRange);
                    sumFocusUpgrades += ((TileEntityTransporterCore)tileEntity).getUpgradeCount(upgradeSlotFocus);
                }
            }
        }
        FocusValues result = new FocusValues();
        if (countTransporters == 1) {
            result.vScanners = vScanners;
            result.countRangeUpgrades = sumRangeUpgrades;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER + (double)sumFocusUpgrades * WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_UPGRADE;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER + (double)sumFocusUpgrades * WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_UPGRADE;
        } else if (countBeacons > 0) {
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_AT_BEACON;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_AT_BEACON;
        } else {
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
        }
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporter getFocusValueAtCoordinates %s gives range %d speed %.3f strength %.3f", blockPos, result.countRangeUpgrades, result.speed, result.strength));
        }
        return result;
    }

    private static boolean isJammedTrajectory(World world, BlockPos blockPosSource, BlockPos blockPosDestination, int beamFrequency) {
        if (world == null) {
            return false;
        }
        Vec3d v3dPath = new Vec3d((double)(blockPosDestination.func_177958_n() - blockPosSource.func_177958_n()), (double)(blockPosDestination.func_177956_o() - blockPosSource.func_177956_o()), (double)(blockPosDestination.func_177952_p() - blockPosSource.func_177952_p()));
        int length = (int)Math.ceil(3.0 * v3dPath.func_72433_c());
        Vec3d v3Delta = new Vec3d(v3dPath.field_72450_a / (double)length, v3dPath.field_72448_b / (double)length, v3dPath.field_72449_c / (double)length);
        Vector3 v3Current = new Vector3((double)blockPosSource.func_177958_n() + 0.5, (double)blockPosSource.func_177956_o() + 0.5, (double)blockPosSource.func_177952_p() + 0.5);
        BlockPos.MutableBlockPos blockPosCurrent = new BlockPos.MutableBlockPos(blockPosSource);
        BlockPos.MutableBlockPos blockPosPrevious = new BlockPos.MutableBlockPos((BlockPos)blockPosCurrent);
        for (int step = 0; step < length; ++step) {
            v3Current.translate(v3Delta);
            blockPosCurrent.func_181079_c((int)Math.round(v3Current.x), (int)Math.round(v3Current.y), (int)Math.round(v3Current.z));
            if (blockPosCurrent.equals((Object)blockPosPrevious)) continue;
            if (TileEntityTransporterCore.isJammedCoordinate(world, (BlockPos)blockPosCurrent, beamFrequency)) {
                return true;
            }
            blockPosPrevious.func_189533_g((Vec3i)blockPosCurrent);
        }
        return false;
    }

    private static boolean isJammedCoordinate(World world, BlockPos blockPos, int beamFrequency) {
        TileEntity tileEntity;
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (Dictionary.BLOCKS_NOBLINK.contains(block)) {
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("Transporter beam jammed by blacklisted block %s", block));
            }
            return true;
        }
        if (block instanceof BlockForceField && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityForceField) {
            ForceFieldSetup forceFieldSetup = ((TileEntityForceField)tileEntity).getForceFieldSetup();
            if (forceFieldSetup == null) {
                WarpDrive.logger.warn(String.format("Transporter beam jammed by non-loaded force field projector at %s", tileEntity));
                return true;
            }
            if (forceFieldSetup.beamFrequency != beamFrequency) {
                if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                    WarpDrive.logger.info(String.format("Transporter beam jammed by invalid frequency against %s", tileEntity));
                }
                return true;
            }
        }
        return false;
    }

    private int getEnergyRequired(EnumTransporterState transporterState) {
        switch (transporterState) {
            case DISABLED: {
                return 0;
            }
            case IDLE: {
                return 0;
            }
            case ACQUIRING: {
                return (int)Math.ceil(this.energyCostForAcquiring * this.energyFactor);
            }
            case ENERGIZING: {
                return (int)Math.ceil(this.energyCostForEnergizing * this.energyFactor / (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS);
            }
        }
        return 0;
    }

    private static void applyTeleportationDamages(boolean isPreTeleportation, Entity entity, double strength) {
        BlockPos blockPos;
        if (entity.field_70128_L || entity.func_180431_b((DamageSource)WarpDrive.damageTeleportation)) {
            return;
        }
        double strengthToUse = isPreTeleportation ? strength : Math.random() * WarpDriveConfig.TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS + strength;
        double strengthSafe = 0.95;
        double strengthMaxDamage = 0.65;
        double strengthNoDamage = 0.1;
        if (strengthToUse > 0.95) {
            return;
        }
        double damageNormalized = (0.95 - strengthToUse) / 0.29999999999999993;
        double damageMax = isPreTeleportation ? (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE : (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE;
        double damageAmount = Commons.clamp(1.0, 1000.0, damageMax * damageNormalized);
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Applying teleportation damages %s transport with %.3f strength, %.2f damage towards %s", isPreTeleportation ? "pre" : "post", strengthToUse, damageAmount, entity));
        }
        if (entity instanceof EntityLivingBase) {
            boolean isCreative;
            entity.func_70097_a((DamageSource)WarpDrive.damageTeleportation, (float)damageAmount);
            boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_();
            if (!isCreative) {
                if (isPreTeleportation) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 20));
                } else {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                }
            }
        } else if (strengthToUse > 0.1 && entity.field_70170_p.func_175623_d(blockPos = new BlockPos(entity))) {
            entity.field_70170_p.func_180501_a(blockPos, Blocks.field_150356_k.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(6)), 2);
        }
    }

    private EntityValues updateEntitiesToEnergize(WorldServer worldRemote) {
        int countLocalScanners = this.vLocalScanners == null ? 0 : this.vLocalScanners.size();
        int countScanners = this.vRemoteScanners == null ? countLocalScanners : Math.min(countLocalScanners, this.vRemoteScanners.size());
        EntityValues entityValues = new EntityValues();
        if (this.transporterState != EnumTransporterState.ENERGIZING && this.transporterState != EnumTransporterState.ACQUIRING) {
            entityValues.count = countScanners;
            entityValues.mass = 2 * countScanners;
            return entityValues;
        }
        EntityValues entityValuesLocal = TileEntityTransporterCore.updateEntitiesOnScanners(this.field_145850_b, this.vLocalScanners, countScanners, this.movingEntitiesLocal);
        EntityValues entityValuesRemote = this.vRemoteScanners != null ? TileEntityTransporterCore.updateEntitiesOnScanners((World)worldRemote, this.vRemoteScanners, countScanners, this.movingEntitiesRemote) : TileEntityTransporterCore.updateEntitiesInArea((World)worldRemote, this.globalPositionRemote, countScanners, this.movingEntitiesRemote);
        entityValues.count = entityValuesLocal.count + entityValuesRemote.count;
        entityValues.mass = entityValuesLocal.mass + entityValuesRemote.mass;
        return entityValues;
    }

    private static EntityValues updateEntitiesOnScanners(World world, ArrayList<BlockPos> vScanners, int countScanners, HashMap<Integer, MovingEntity> movingEntities) {
        double tolerance2 = WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS * WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
        HashSet<Entity> entitiesOnScanners = new HashSet<Entity>(countScanners);
        EntityValues entityValues = new EntityValues();
        for (int index = 0; index < countScanners; ++index) {
            Entity entityOnScanner;
            MovingEntity movingEntity = movingEntities.get(index);
            if (movingEntity == MovingEntity.INVALID) continue;
            if (movingEntity != null) {
                Entity entity = movingEntity.getEntity();
                if (entity == null || entity.field_70128_L) {
                    movingEntity = null;
                } else {
                    double distance2 = movingEntity.getDistanceMoved_square();
                    if (distance2 > tolerance2) {
                        double strength = Math.sqrt(distance2) / Math.sqrt(tolerance2) / 2.0;
                        TileEntityTransporterCore.applyTeleportationDamages(true, entity, strength);
                        movingEntity = MovingEntity.INVALID;
                    }
                }
            }
            if (movingEntity == null && vScanners != null && (entityOnScanner = TileEntityTransporterCore.getCandidateEntityOnScanner(world, vScanners.get(index), entitiesOnScanners)) != null) {
                movingEntity = new MovingEntity(entityOnScanner);
                entitiesOnScanners.add(entityOnScanner);
            }
            if (movingEntity == null) {
                movingEntities.put(index, MovingEntity.INVALID);
                continue;
            }
            movingEntities.put(index, movingEntity);
            ++entityValues.count;
            entityValues.mass = (long)((float)entityValues.mass + movingEntity.getMassFactor());
        }
        return entityValues;
    }

    private static EntityValues updateEntitiesInArea(World world, GlobalPosition globalPosition, int countScanners, HashMap<Integer, MovingEntity> movingEntities) {
        double tolerance2 = WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS * WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
        LinkedHashSet<Entity> entities = TileEntityTransporterCore.getCandidateEntitiesInArea(world, globalPosition);
        EntityValues entityValues = new EntityValues();
        for (int index = 0; index < countScanners; ++index) {
            Iterator entityIterable;
            Entity entity;
            MovingEntity movingEntity = movingEntities.get(index);
            if (movingEntity == MovingEntity.INVALID) continue;
            if (movingEntity != null) {
                Entity entity2 = movingEntity.getEntity();
                if (entity2 == null || entity2.field_70128_L) {
                    movingEntity = null;
                } else if (entities.contains(entity2)) {
                    double distance2 = movingEntity.getDistanceMoved_square();
                    if (distance2 > tolerance2) {
                        double strength = Math.sqrt(distance2) / Math.sqrt(tolerance2) / 2.0;
                        TileEntityTransporterCore.applyTeleportationDamages(true, entity2, strength);
                        movingEntity = MovingEntity.INVALID;
                    } else {
                        entities.remove(entity2);
                    }
                } else {
                    movingEntity = MovingEntity.INVALID;
                }
            }
            if (movingEntity == null && !entities.isEmpty() && (entity = (Entity)(entityIterable = entities.iterator()).next()) != null) {
                movingEntity = new MovingEntity(entity);
                entityIterable.remove();
            }
            if (movingEntity == null) {
                movingEntities.put(index, MovingEntity.INVALID);
                continue;
            }
            movingEntities.put(index, movingEntity);
            ++entityValues.count;
            entityValues.mass = (long)((float)entityValues.mass + movingEntity.getMassFactor());
        }
        return entityValues;
    }

    private static Entity getCandidateEntityOnScanner(World world, BlockPos blockPos, HashSet<Entity> entitiesOnScanners) {
        if (blockPos == null || world == null) {
            return null;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)blockPos.func_177958_n() - 0.05, (double)blockPos.func_177956_o() - 1.0, (double)blockPos.func_177952_p() - 0.05, (double)blockPos.func_177958_n() + 1.05, (double)blockPos.func_177956_o() + 2.0, (double)blockPos.func_177952_p() + 1.05);
        List entities = world.func_72839_b(null, aabb);
        Entity entityReturn = null;
        int countEntities = 0;
        for (Object object : entities) {
            if (!(object instanceof Entity)) continue;
            Entity entity = (Entity)object;
            if (Dictionary.isLeftBehind(entity)) {
                if (!WarpDriveConfig.LOGGING_TRANSPORTER) continue;
                WarpDrive.logger.info(String.format("Entity is not valid for transportation (id %s) %s", Dictionary.getId(entity), entity));
                continue;
            }
            if (entitiesOnScanners.contains(entity)) continue;
            entityReturn = entity;
            ++countEntities;
        }
        if (countEntities > 1) {
            PacketHandler.sendSpawnParticlePacket(world, "jammed", (byte)5, new Vector3((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.5, (double)blockPos.func_177952_p() + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            return null;
        }
        return entityReturn;
    }

    private static LinkedHashSet<Entity> getCandidateEntitiesInArea(World world, GlobalPosition globalPosition) {
        if (world == null) {
            return new LinkedHashSet<Entity>(0);
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)(globalPosition.x - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)globalPosition.y - 1.0, (double)(globalPosition.z - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)(globalPosition.x + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0, (double)globalPosition.y + 2.0, (double)(globalPosition.z + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0);
        List entities = world.func_72839_b(null, aabb);
        LinkedHashSet<Entity> entitiesReturn = new LinkedHashSet<Entity>(entities.size());
        for (Object object : entities) {
            if (!(object instanceof Entity)) continue;
            Entity entity = (Entity)object;
            if (Dictionary.isLeftBehind(entity)) {
                if (!WarpDriveConfig.LOGGING_TRANSPORTER) continue;
                WarpDrive.logger.info(String.format("Entity is not valid for transportation (id %s) %s", Dictionary.getId(entity), entity));
                continue;
            }
            entitiesReturn.add(entity);
        }
        return entitiesReturn;
    }

    @Override
    protected void onUpgradeChanged(@Nonnull TileEntityAbstractBase.UpgradeSlot upgradeSlot, int countNew, boolean isAdded) {
        if (upgradeSlot == upgradeSlotEnergyStorage) {
            this.refreshEnergyParameters();
        }
        super.onUpgradeChanged(upgradeSlot, countNew, isAdded);
    }

    private void refreshEnergyParameters() {
        int energyUpgrades = this.getUpgradeCount(upgradeSlotEnergyStorage);
        this.energy_setParameters(WarpDriveConfig.TRANSPORTER_MAX_ENERGY_STORED + energyUpgrades * WarpDriveConfig.TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS, 4096, 0, "HV", 2, "HV", 0);
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.vLocalScanners != null && this.vLocalContainments != null) {
            NBTTagList tagListScanners = new NBTTagList();
            for (BlockPos vScanner : this.vLocalScanners) {
                NBTTagCompound tagCompoundScanner = Commons.writeBlockPosToNBT(vScanner, new NBTTagCompound());
                tagListScanners.func_74742_a((NBTBase)tagCompoundScanner);
            }
            tagCompound.func_74782_a("scanners", (NBTBase)tagListScanners);
            NBTTagList tagListContainments = new NBTTagList();
            for (BlockPos vContainment : this.vLocalContainments) {
                NBTTagCompound tagCompoundContainment = Commons.writeBlockPosToNBT(vContainment, new NBTTagCompound());
                tagListContainments.func_74742_a((NBTBase)tagCompoundContainment);
            }
            tagCompound.func_74782_a("containments", (NBTBase)tagListContainments);
        }
        tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
        tagCompound.func_74757_a("isLockRequested", this.isLockRequested);
        tagCompound.func_74757_a("isEnergizeRequested", this.isEnergizeRequested);
        NBTTagCompound tagRemoteLocation = new NBTTagCompound();
        if (this.remoteLocationRequested instanceof UUID) {
            tagRemoteLocation.func_74772_a("uuidMost", ((UUID)this.remoteLocationRequested).getMostSignificantBits());
            tagRemoteLocation.func_74772_a("uuidLeast", ((UUID)this.remoteLocationRequested).getLeastSignificantBits());
        } else if (this.remoteLocationRequested instanceof VectorI) {
            tagRemoteLocation = ((VectorI)this.remoteLocationRequested).writeToNBT(tagRemoteLocation);
        } else if (this.remoteLocationRequested instanceof String) {
            tagRemoteLocation.func_74778_a("playerName", (String)this.remoteLocationRequested);
        }
        tagCompound.func_74782_a("remoteLocation", (NBTBase)tagRemoteLocation);
        tagCompound.func_74780_a("energyFactor", this.energyFactor);
        tagCompound.func_74780_a("lockStrengthActual", this.lockStrengthActual);
        tagCompound.func_74768_a("tickCooldown", this.tickCooldown);
        tagCompound.func_74778_a("state", this.transporterState.toString());
        return tagCompound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_150297_b("scanners", 9) && tagCompound.func_150297_b("containments", 9)) {
            NBTTagList tagListScanners = (NBTTagList)tagCompound.func_74781_a("scanners");
            ArrayList<BlockPos> vScanners = new ArrayList<BlockPos>(tagListScanners.func_74745_c());
            for (int indexScanner = 0; indexScanner < tagListScanners.func_74745_c(); ++indexScanner) {
                BlockPos vScanner = Commons.createBlockPosFromNBT(tagListScanners.func_150305_b(indexScanner));
                vScanners.add(vScanner);
            }
            NBTTagList tagListContainments = (NBTTagList)tagCompound.func_74781_a("containments");
            ArrayList<BlockPos> vContainments = new ArrayList<BlockPos>(tagListContainments.func_74745_c());
            for (int indexContainment = 0; indexContainment < tagListContainments.func_74745_c(); ++indexContainment) {
                BlockPos vContainment = Commons.createBlockPosFromNBT(tagListContainments.func_150305_b(indexContainment));
                vContainments.add(vContainment);
            }
            this.setLocalScanners(vScanners, vContainments);
        }
        this.beamFrequency = tagCompound.func_74762_e("beamFrequency");
        this.isLockRequested = tagCompound.func_74767_n("isLockRequested");
        this.isEnergizeRequested = tagCompound.func_74767_n("isEnergizeRequested");
        NBTBase tagRemoteLocation = tagCompound.func_74781_a("remoteLocation");
        if (tagRemoteLocation instanceof NBTTagCompound) {
            NBTTagCompound tagCompoundRemoteLocation = (NBTTagCompound)tagRemoteLocation;
            if (tagCompoundRemoteLocation.func_74764_b("uuidMost")) {
                this.remoteLocationRequested = new UUID(tagCompoundRemoteLocation.func_74763_f("uuidMost"), tagCompoundRemoteLocation.func_74763_f("uuidLeast"));
            } else if (tagCompoundRemoteLocation.func_74764_b("x")) {
                this.remoteLocationRequested = new VectorI();
                ((VectorI)this.remoteLocationRequested).readFromNBT(tagCompoundRemoteLocation);
            } else if (tagCompoundRemoteLocation.func_74764_b("playerName")) {
                this.remoteLocationRequested = tagCompoundRemoteLocation.func_74779_i("playerName");
            }
        }
        this.energyFactor = Commons.clamp(1.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, tagCompound.func_74769_h("energyFactor"));
        this.lockStrengthActual = tagCompound.func_74769_h("lockStrengthActual");
        this.tickCooldown = tagCompound.func_74762_e("tickCooldown");
        try {
            this.transporterState = EnumTransporterState.valueOf(tagCompound.func_74779_i("state"));
        }
        catch (IllegalArgumentException exception) {
            this.transporterState = EnumTransporterState.DISABLED;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_82580_o("uuidMost");
        tagCompound.func_82580_o("uuidLeast");
        tagCompound.func_82580_o("beamFrequency");
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        return tagCompound;
    }

    @Override
    public String[] name(Object[] arguments) {
        String name_old = this.name;
        super.name(arguments);
        if (!name_old.equals(this.name)) {
            this.uuid = UUID.randomUUID();
        }
        return new String[]{this.name, this.uuid == null ? null : this.uuid.toString()};
    }

    public Object[] beamFrequency(Object[] arguments) {
        if (arguments.length == 1) {
            this.setBeamFrequency(Commons.toInt(arguments[0]));
        }
        return new Integer[]{this.getBeamFrequency()};
    }

    @Override
    public Object[] state() {
        long energy = this.energy_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        String state = this.isJammed ? this.reasonJammed : (this.tickCooldown > 0 ? String.format("Cooling down %d s", Math.round(this.tickCooldown / 20)) : this.transporterState.func_176610_l());
        return new Object[]{status, state, this.isConnected, this.isEnabled, this.isJammed, energy, this.lockStrengthActual};
    }

    @Override
    public Object[] remoteLocation(Object[] arguments) {
        if (arguments.length == 3) {
            VectorI vNew;
            if (this.remoteLocationRequested instanceof VectorI) {
                vNew = this.computer_getVectorI((VectorI)this.remoteLocationRequested, arguments);
                if (!vNew.equals(this.remoteLocationRequested)) {
                    this.remoteLocationRequested = vNew;
                    this.markDirtyParameters();
                }
            } else {
                vNew = this.computer_getVectorI(null, arguments);
                if (vNew != null) {
                    this.remoteLocationRequested = vNew;
                    this.markDirtyParameters();
                }
            }
        } else if (arguments.length == 1 && arguments[0] != null) {
            UUID uuidNew = this.computer_getUUID(null, arguments);
            if (uuidNew != null) {
                if (this.remoteLocationRequested instanceof UUID) {
                    if (!uuidNew.equals(this.remoteLocationRequested)) {
                        this.remoteLocationRequested = uuidNew;
                        this.markDirtyParameters();
                    }
                } else {
                    this.remoteLocationRequested = uuidNew;
                    this.markDirtyParameters();
                }
            } else {
                String playerNameNew = (String)arguments[0];
                if (playerNameNew != null && !playerNameNew.equals(this.remoteLocationRequested)) {
                    this.remoteLocationRequested = playerNameNew;
                    this.markDirtyParameters();
                }
            }
        }
        if (this.remoteLocationRequested instanceof VectorI) {
            VectorI vRemoteLocation = (VectorI)this.remoteLocationRequested;
            return new Integer[]{vRemoteLocation.x, vRemoteLocation.y, vRemoteLocation.z};
        }
        return new Object[]{this.remoteLocationRequested == null ? null : this.remoteLocationRequested.toString()};
    }

    public Boolean[] lock(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isLockRequested = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Boolean[]{this.isLockRequested};
    }

    public Double[] energyFactor(Object[] arguments) {
        try {
            if (arguments.length >= 1) {
                this.energyFactor = Commons.clamp(1.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, Commons.toDouble(arguments[0]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Double[]{this.energyFactor};
    }

    public Double[] getLockStrength() {
        return new Double[]{this.lockStrengthActual};
    }

    @Override
    public Object[] getEnergyRequired() {
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(this.getEnergyRequired(EnumTransporterState.ACQUIRING), units), EnergyWrapper.convert(this.getEnergyRequired(EnumTransporterState.ENERGIZING), units)};
    }

    public Boolean[] energize(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnergizeRequested = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Boolean[]{this.isEnergizeRequested};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        return this.beamFrequency(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] state(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.state();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] remoteLocation(Context context, Arguments arguments) {
        return this.remoteLocation(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] lock(Context context, Arguments arguments) {
        return this.lock(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] energyFactor(Context context, Arguments arguments) {
        return this.energyFactor(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getLockStrength(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getLockStrength();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] energize(Context context, Arguments arguments) {
        return this.energize(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "beamFrequency": {
                return this.beamFrequency(arguments);
            }
            case "state": {
                return this.state();
            }
            case "remoteLocation": {
                return this.remoteLocation(arguments);
            }
            case "lock": {
                return this.lock(arguments);
            }
            case "energyFactor": {
                return this.energyFactor(arguments);
            }
            case "getLockStrength": {
                return this.getLockStrength();
            }
            case "energize": {
                return this.energize(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s '%s' %s Beam %d %s", this.getClass().getSimpleName(), this.name, this.uuid, this.beamFrequency, Commons.format(this.field_145850_b, this.field_174879_c));
    }

    private static class EntityValues {
        int count;
        long mass;

        private EntityValues() {
        }
    }

    private static class FocusValues {
        ArrayList<BlockPos> vScanners;
        int countRangeUpgrades;
        double strength;
        double speed;

        private FocusValues() {
        }
    }
}

