/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.data.InventoryWrapper;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CommandDump
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "wdump";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/" + this.func_71517_b() + " (<inventory type>) (<player selector>)\nWrite loot table in console for selected inventory type of selected player\nInventory types are:\n- container: any item container below or next to player\n- enderchest: player's enderchest\n- hand: player's main hand\n- player: player's inventory";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        Object inventory;
        String subCommand;
        EntityPlayerMP entityPlayer;
        if (args.length > 2) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        EntityPlayerMP entityPlayerMP = entityPlayer = commandSender instanceof EntityPlayerMP ? (EntityPlayerMP)commandSender : null;
        if (args.length == 0) {
            subCommand = "container";
        } else {
            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            if (args.length == 2) {
                EntityPlayerMP[] entityPlayers = Commons.getOnlinePlayerByNameOrSelector(commandSender, args[1]);
                if (entityPlayers == null || entityPlayers.length < 1) {
                    Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.player_not_found", args[1]));
                    return;
                }
                entityPlayer = entityPlayers[0];
            }
            subCommand = args[0];
        }
        if (entityPlayer == null) {
            Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.player_required", new Object[0]));
            return;
        }
        switch (subCommand.toLowerCase()) {
            case "container": {
                World world = entityPlayer.func_130014_f_();
                BlockPos blockPos = entityPlayer.func_180425_c();
                if (world == null || blockPos == null) {
                    Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.invalid_location", new Object[0]));
                    return;
                }
                Collection<Object> inventories = InventoryWrapper.getConnectedInventories(world, blockPos);
                if (inventories.isEmpty()) {
                    Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.no_container", new Object[0]));
                    return;
                }
                inventory = inventories.iterator().next();
                WarpDrive.logger.info(String.format("Dumping content from container %s:", Commons.format(world, blockPos)));
                break;
            }
            case "enderchest": {
                inventory = entityPlayer.func_71005_bN();
                WarpDrive.logger.info(String.format("Dumping content from %s ender chest:", entityPlayer.getDisplayNameString()));
                break;
            }
            case "hand": {
                inventory = entityPlayer.func_184614_ca();
                WarpDrive.logger.info(String.format("Dumping content from %s main hand:", entityPlayer.getDisplayNameString()));
                break;
            }
            case "player": {
                inventory = entityPlayer.field_71071_by;
                WarpDrive.logger.info(String.format("Dumping content from %s inventory:", entityPlayer.getDisplayNameString()));
                break;
            }
            default: {
                Commons.addChatMessage(commandSender, new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.invalid_parameter", args[0]).appendLineBreak().func_150257_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender))));
                return;
            }
        }
        int size = InventoryWrapper.getSize(inventory);
        if (size == 0) {
            Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.empty_inventory", new Object[0]));
        }
        for (int indexSlot = 0; indexSlot < size; ++indexSlot) {
            ItemStack itemStack = InventoryWrapper.getStackInSlot(inventory, indexSlot);
            if (itemStack == ItemStack.field_190927_a || itemStack.func_190926_b()) continue;
            ResourceLocation uniqueIdentifier = itemStack.func_77973_b().getRegistryName();
            assert (uniqueIdentifier != null);
            String stringDamage = itemStack.func_77952_i() == 0 ? "" : String.format(" damage=\"%d\"", itemStack.func_77952_i());
            String stringNBT = !itemStack.func_77942_o() ? "" : String.format(" nbt=\"%s\"", itemStack.func_77978_p());
            WarpDrive.logger.info(String.format("Slot %3d is <loot item=\"%s:%s\"%s minQuantity=\"%d\" maxQuantity=\"%d\"%s weight=\"1\" /><!-- %s -->", indexSlot, uniqueIdentifier.func_110624_b(), uniqueIdentifier.func_110623_a(), stringDamage, itemStack.func_190916_E(), itemStack.func_190916_E(), stringNBT, itemStack.func_82833_r()));
        }
    }
}

