/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.command.AbstractCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;

public class CommandEntity
extends AbstractCommand {
    private static final List<String> entitiesNoRemoval = Arrays.asList("item.EntityItemFrame_", "item.EntityPainting_");
    private static final List<String> entitiesNoCount = Arrays.asList("item.EntityItemFrame_", "item.EntityPainting_");
    private static final Style styleFound = new Style().func_150238_a(TextFormatting.WHITE);
    private static final Style styleNumber = new Style().func_150238_a(TextFormatting.WHITE);
    private static final Style styleFactor = new Style().func_150238_a(TextFormatting.DARK_GRAY);
    private static final Style styleName = new Style().func_150238_a(TextFormatting.LIGHT_PURPLE);

    @Nonnull
    public String func_71517_b() {
        return "wentity";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/" + this.func_71517_b() + " <radius> <filter> <kill?>\nradius: - or <= 0 to check all loaded in current world, 1+ blocks around player\nfilter: * to get all, anything else is a case insensitive string\nkill: yes/y/1 to kill, anything else is ignored";
    }

    /*
     * WARNING - void declaration
     */
    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        ITextComponent textComponent;
        List entities;
        if (args.length > 3) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        int radius = 20;
        String filter = "";
        boolean kill = false;
        try {
            String par;
            if (args.length > 0) {
                par = args[0].toLowerCase();
                radius = par.equals("-") || par.equals("world") || par.equals("global") || par.equals("*") ? -1 : Integer.parseInt(par);
            }
            if (args.length > 1 && !args[1].equalsIgnoreCase("*")) {
                filter = args[1];
            }
            if (args.length > 2) {
                par = args[2].toLowerCase();
                kill = par.equals("y") || par.equals("yes") || par.equals("1");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        WarpDrive.logger.info(String.format("/%s %d '*%s*' %s", this.func_71517_b(), radius, filter, kill));
        if (radius <= 0) {
            Object world = commandSender instanceof EntityPlayerMP ? ((EntityPlayerMP)commandSender).field_70170_p : DimensionManager.getWorld((int)0);
            entities = new ArrayList(world.field_72996_f);
        } else {
            if (!(commandSender instanceof EntityPlayerMP)) {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            EntityPlayerMP entityPlayer = (EntityPlayerMP)commandSender;
            entities = entityPlayer.field_70170_p.func_72839_b((Entity)entityPlayer, new AxisAlignedBB(Math.floor(entityPlayer.field_70165_t), Math.floor(entityPlayer.field_70163_u), Math.floor(entityPlayer.field_70161_v), Math.floor(entityPlayer.field_70165_t + 1.0), Math.floor(entityPlayer.field_70163_u + 1.0), Math.floor(entityPlayer.field_70161_v + 1.0)).func_72314_b((double)radius, (double)radius, (double)radius));
        }
        HashMap<void, Integer> counts = new HashMap<void, Integer>(entities.size());
        int count = 0;
        for (Object entity : entities) {
            void var12_14;
            String string = entity.getClass().getCanonicalName();
            if (string == null) {
                String string2 = "-null-";
            } else {
                String string3 = string.replaceAll("net\\.minecraft\\.entity\\.", "") + "_";
            }
            if (filter.isEmpty() && !entitiesNoCount.isEmpty()) {
                boolean isCountable = true;
                for (String entityNoCount : entitiesNoCount) {
                    if (!var12_14.contains(entityNoCount)) continue;
                    isCountable = false;
                    break;
                }
                if (!isCountable) continue;
            }
            if (!filter.isEmpty() && !var12_14.contains(filter)) continue;
            ++count;
            if (!counts.containsKey(var12_14)) {
                counts.put(var12_14, 1);
            } else {
                counts.put(var12_14, (Integer)counts.get(var12_14) + 1);
            }
            if (!filter.isEmpty()) {
                if (count == 1) {
                    Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText(styleFound, "warpdrive.command.found_title", new Object[0]));
                }
                Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText(styleFound, "warpdrive.command.found_line", entity));
            }
            if (!kill || entity.func_180431_b((DamageSource)WarpDrive.damageAsphyxia)) continue;
            if (!entitiesNoRemoval.isEmpty()) {
                boolean isRemovable = true;
                for (String entityNoRemoval : entitiesNoRemoval) {
                    if (!var12_14.contains(entityNoRemoval)) continue;
                    isRemovable = false;
                    break;
                }
                if (!isRemovable) continue;
            }
            entity.func_70106_y();
        }
        if (count == 0) {
            textComponent = new TextComponentTranslation("warpdrive.command.no_matching_entity", new Object[]{radius}).func_150255_a(Commons.getStyleWarning());
            Commons.addChatMessage(commandSender, textComponent);
            return;
        }
        textComponent = new TextComponentTranslation("warpdrive.command.x_matching_entities", new Object[]{count, radius}).func_150255_a(Commons.getStyleCorrect());
        Commons.addChatMessage(commandSender, textComponent);
        if (counts.size() < 10) {
            for (Map.Entry entry : counts.entrySet()) {
                textComponent = new TextComponentString(((Integer)entry.getValue()).toString()).func_150255_a(styleNumber).func_150257_a(new TextComponentString("x").func_150255_a(styleFactor)).func_150257_a(new TextComponentString((String)entry.getKey()).func_150255_a(styleName));
                textComponent.func_150256_b().func_150238_a(TextFormatting.WHITE);
                Commons.addChatMessage(commandSender, textComponent);
            }
        } else {
            textComponent = new TextComponentString("");
            boolean isFirst = true;
            for (Map.Entry entry : counts.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    textComponent.func_150257_a(new TextComponentString(", ").func_150255_a(styleFactor));
                }
                textComponent.func_150257_a(new TextComponentString(((Integer)entry.getValue()).toString()).func_150255_a(styleNumber)).func_150257_a(new TextComponentString("x").func_150255_a(styleFactor)).func_150257_a(new TextComponentString((String)entry.getKey()).func_150255_a(styleName));
            }
            Commons.addChatMessage(commandSender, textComponent);
        }
    }
}

