/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandFind
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "wfind";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/" + this.func_71517_b() + " (<shipName>)\nshipName: name of the ship to find. Exact casing is preferred.";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        String nameToken;
        EntityPlayerMP entityPlayer;
        EntityPlayerMP entityPlayerMP = entityPlayer = commandSender instanceof EntityPlayerMP ? (EntityPlayerMP)commandSender : null;
        if (args.length == 0) {
            if (entityPlayer == null) {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            GlobalRegion globalRegion = GlobalRegionManager.getNearest(EnumGlobalRegionType.SHIP, entityPlayer.field_70170_p, entityPlayer.func_180425_c());
            if (globalRegion != null) {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(String.format("Ship '%s' found in %s", globalRegion.name, globalRegion.getFormattedLocation())));
            } else {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(String.format("No ship found in %s", Commons.format(entityPlayer.field_70170_p))));
            }
            return;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            nameToken = args[0];
        } else {
            StringBuilder nameBuilder = new StringBuilder();
            for (String param : args) {
                if (nameBuilder.length() > 0) {
                    nameBuilder.append(" ");
                }
                nameBuilder.append(param);
            }
            nameToken = nameBuilder.toString();
        }
        String result = GlobalRegionManager.listByKeyword(EnumGlobalRegionType.SHIP, nameToken);
        Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(result));
    }
}

