/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumStructureGroup;
import cr0s.warpdrive.world.WorldGenSmallShip;
import cr0s.warpdrive.world.WorldGenStation;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandGenerate
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "generate";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return String.format("/%s <structure group> (<structure name>)\nStructure groups are ship, station, astfield, %s", this.func_71517_b(), StructureManager.getGroups().replace("\"", ""));
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        World world = commandSender.func_130014_f_();
        BlockPos blockPos = commandSender.func_180425_c();
        if (world == null || blockPos == null) {
            Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.invalid_location", new Object[0]).func_150255_a(Commons.getStyleWarning())));
            return;
        }
        if (args.length <= 0 || args.length == 3 || args.length > 5) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        if (args.length > 3) {
            blockPos = new BlockPos(this.AdjustAxis(blockPos.func_177958_n(), args[args.length - 3]), this.AdjustAxis(blockPos.func_177956_o(), args[args.length - 2]), this.AdjustAxis(blockPos.func_177952_p(), args[args.length - 1]));
        }
        String structure = args[0];
        if (!CelestialObjectManager.isInSpace(world, blockPos.func_177958_n(), blockPos.func_177952_p()) && !"ship".equals(structure)) {
            Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.only_in_space", new Object[0]).func_150255_a(Commons.getStyleWarning())));
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            String name = args.length > 1 ? args[1] : null;
            switch (structure) {
                case "": {
                    Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                    break;
                }
                case "ship": {
                    WarpDrive.logger.info(String.format("/generate: generating NPC ship %s", Commons.format(world, blockPos)));
                    new WorldGenSmallShip(false, true).func_180709_b(world, world.field_73012_v, blockPos);
                    break;
                }
                case "station": {
                    WarpDrive.logger.info(String.format("/generate: generating station %s", Commons.format(world, blockPos)));
                    new WorldGenStation(false).func_180709_b(world, world.field_73012_v, blockPos);
                    break;
                }
                case "astfield": {
                    this.generateStructure(commandSender, EnumStructureGroup.ASTEROIDS_FIELDS.func_176610_l(), name, world, blockPos);
                    break;
                }
                case "gascloud": {
                    this.generateStructure(commandSender, EnumStructureGroup.GAS_CLOUDS.func_176610_l(), name, world, blockPos);
                    break;
                }
                default: {
                    this.generateStructure(commandSender, structure, name, world, blockPos);
                }
            }
        }
    }

    private int AdjustAxis(int axis, String param) {
        if (param.isEmpty() || param.equals("~")) {
            return axis;
        }
        if (param.charAt(0) == '~') {
            return axis + Integer.parseInt(param.substring(1));
        }
        return Integer.parseInt(param);
    }

    private void generateStructure(ICommandSender commandSender, String group, String name, World world, BlockPos blockPos) {
        AbstractStructure structure = StructureManager.getStructure(world.field_73012_v, group, name);
        if (structure == null) {
            Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("Invalid %1$s:%2$s, try one of the followings:\n%3$s", new Object[]{group, name, StructureManager.getStructureNames(group)}).func_150255_a(Commons.getStyleWarning())));
        } else {
            WarpDrive.logger.info(String.format("/generate: Generating %s:%s %s", group, structure.func_176610_l(), Commons.format(world, blockPos)));
            structure.func_180709_b(world, world.field_73012_v, blockPos);
            if (commandSender instanceof EntityPlayerMP) {
                int newY;
                for (newY = blockPos.func_177956_o() + 1; newY < 256 && !world.func_175623_d(new BlockPos(blockPos.func_177958_n(), newY, blockPos.func_177952_p())); ++newY) {
                }
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)commandSender;
                entityPlayerMP.func_70107_b(entityPlayerMP.field_70165_t, (double)newY, entityPlayerMP.field_70161_v);
            }
        }
    }
}

