/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.command.AbstractCommand;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommandRender
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "wrender";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/" + this.func_71517_b();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        EntityPlayerMP entityPlayer;
        if (args.length > 0) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        EntityPlayerMP entityPlayerMP = entityPlayer = commandSender instanceof EntityPlayerMP ? (EntityPlayerMP)commandSender : null;
        if (entityPlayer == null) {
            Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.player_required", new Object[0]));
            return;
        }
        World world = entityPlayer.func_130014_f_();
        BlockPos blockPos = entityPlayer.func_180425_c();
        if (world == null || blockPos == null) {
            Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).append(Commons.getStyleWarning(), "warpdrive.command.invalid_location", new Object[0]));
            return;
        }
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos)) {
            blockPos = blockPos.func_177977_b();
            blockState = world.func_180495_p(blockPos);
        }
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(this.getPrefix()).appendInLine(Commons.getStyleCorrect(), "Dumping render details %s", Commons.format(world, blockPos)));
        Block block = blockState.func_177230_c();
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "Blockstate is %s (%s)", new Object[]{Commons.getChatValue(blockState.toString()), Commons.getChatValue(block.func_176201_c(blockState))}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "Light opacity is %s / useNeighborBrightness is %s", new Object[]{Commons.getChatValue(block.func_149717_k(blockState)), Commons.getChatValue(block.func_149710_n(blockState))}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "isFullBlock is %s / isFullCube is %s / isAir is %s", new Object[]{Commons.getChatValue(block.func_149730_j(blockState)), Commons.getChatValue(block.func_149686_d(blockState)), Commons.getChatValue(block.isAir(blockState, (IBlockAccess)world, blockPos))}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "isBlockNormalCube is %s / isNormalCube is %s", new Object[]{Commons.getChatValue(block.func_149637_q(blockState)), Commons.getChatValue(block.func_149721_r(blockState))}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "isTopSolid is %s / causesSuffocation is %s", new Object[]{Commons.getChatValue(block.func_185481_k(blockState)), Commons.getChatValue(block.func_176214_u(blockState))}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "Material isOpaque %s / Material blocksLight is %s", new Object[]{Commons.getChatValue(blockState.func_185904_a().func_76218_k()), Commons.getChatValue(blockState.func_185904_a().func_76228_b())}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "Material isLiquid %s / Material isSolid %s", new Object[]{Commons.getChatValue(blockState.func_185904_a().func_76224_d()), Commons.getChatValue(blockState.func_185904_a().func_76220_a())}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "isOpaqueCube is %s  / isTranslucent %s", new Object[]{Commons.getChatValue(blockState.func_185914_p()), WarpDrive.proxy.isDedicatedServer() ? Commons.getChatValue("???") : Commons.getChatValue(blockState.func_185895_e())}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "renderLayer is %s  / renderType is %s", new Object[]{WarpDrive.proxy.isDedicatedServer() ? Commons.getChatValue("???") : Commons.getChatValue(block.func_180664_k().toString()), Commons.getChatValue(block.func_149645_b(blockState).toString())}));
        Commons.addChatMessage(commandSender, (ITextComponent)new WarpDriveText().append(Commons.getStyleNormal(), "isSideSolid D %s, U %s, N %s, S %s, W %s, E %s", new Object[]{Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.DOWN)), Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.UP)), Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.NORTH)), Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.SOUTH)), Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.WEST)), Commons.getChatValue(block.isSideSolid(blockState, (IBlockAccess)world, blockPos, EnumFacing.EAST))}));
    }
}

