/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatBiblioCraft
implements IBlockTransformer {
    private static Class<?> classBiblioBlock;
    private static final int[] rotAngle;

    public static void register() {
        try {
            classBiblioBlock = Class.forName("jds.bibliocraft.blocks.BiblioBlock");
            WarpDriveConfig.registerBlockTransformer("BiblioCraft", new CompatBiblioCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBiblioBlock.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("angle")) {
            int angle = nbtTileEntity.func_74762_e("angle");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("angle", rotAngle[angle]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("angle", rotAngle[rotAngle[angle]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("angle", rotAngle[rotAngle[rotAngle[angle]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotAngle = new int[]{1, 2, 3, 0};
    }
}

