/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatBotania
implements IBlockTransformer {
    private static Class<?> classBlockMod;
    private static Class<?> classBlockAvatar;
    private static Class<?> classBlockFelPumpkin;
    private static Class<?> classBlockSpecialFlower;
    private static Class<?> classBlockRedString;
    private static Class<?> classBlockTinyPotato;
    private static final int[] mrotFacing;
    private static final int[] mrotFelPumpkin;

    public static void register() {
        try {
            classBlockMod = Class.forName("vazkii.botania.common.block.BlockMod");
            classBlockAvatar = Class.forName("vazkii.botania.common.block.BlockAvatar");
            classBlockFelPumpkin = Class.forName("vazkii.botania.common.block.BlockFelPumpkin");
            classBlockSpecialFlower = Class.forName("vazkii.botania.common.block.BlockSpecialFlower");
            classBlockRedString = Class.forName("vazkii.botania.common.block.string.BlockRedString");
            classBlockTinyPotato = Class.forName("vazkii.botania.common.block.decor.BlockTinyPotato");
            WarpDriveConfig.registerBlockTransformer("botania", new CompatBotania());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockMod.isInstance(block) || classBlockSpecialFlower.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagCompound nbtSubTileCmp;
        byte rotationSteps = transformation.getRotationSteps();
        if (classBlockAvatar.isInstance(block) || classBlockRedString.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFacing[metadata];
                }
                case 2: {
                    return mrotFacing[mrotFacing[metadata]];
                }
                case 3: {
                    return mrotFacing[mrotFacing[mrotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockFelPumpkin.isInstance(block) || classBlockTinyPotato.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFelPumpkin[metadata];
                }
                case 2: {
                    return mrotFelPumpkin[mrotFelPumpkin[metadata]];
                }
                case 3: {
                    return mrotFelPumpkin[mrotFelPumpkin[mrotFelPumpkin[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("bindX") && nbtTileEntity.func_74764_b("bindY") && nbtTileEntity.func_74764_b("bindZ")) {
            BlockPos targetBind = transformation.apply(nbtTileEntity.func_74762_e("bindX"), nbtTileEntity.func_74762_e("bindY"), nbtTileEntity.func_74762_e("bindZ"));
            nbtTileEntity.func_74768_a("bindX", targetBind.func_177958_n());
            nbtTileEntity.func_74768_a("bindY", targetBind.func_177956_o());
            nbtTileEntity.func_74768_a("bindZ", targetBind.func_177952_p());
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("subTileCmp") && (nbtSubTileCmp = nbtTileEntity.func_74775_l("subTileCmp")).func_74764_b("collectorX") && nbtSubTileCmp.func_74764_b("collectorY") && nbtSubTileCmp.func_74764_b("collectorZ")) {
            BlockPos targetCollector = transformation.apply(nbtSubTileCmp.func_74762_e("collectorX"), nbtSubTileCmp.func_74762_e("collectorY"), nbtSubTileCmp.func_74762_e("collectorZ"));
            nbtSubTileCmp.func_74768_a("collectorX", targetCollector.func_177958_n());
            nbtSubTileCmp.func_74768_a("collectorY", targetCollector.func_177956_o());
            nbtSubTileCmp.func_74768_a("collectorZ", targetCollector.func_177952_p());
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("rotationX")) {
            float rotationX = nbtTileEntity.func_74762_e("rotationX");
            nbtTileEntity.func_74776_a("rotationX", (rotationX + 270.0f * (float)rotationSteps) % 360.0f);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotFelPumpkin = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

