/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatDraconicEvolution
implements IBlockTransformer {
    private static Class<?> classBlockBlockDE;
    private static Class<?> classBlockDislocatorReceptacle;
    private static Class<?> classBlockPortal;
    private static Class<?> classBlockFlowGate;
    private static Class<?> classBlockGenerator;
    private static Class<?> classBlockGrinder;
    private static Class<?> classBlockPotentiometer;
    private static Class<?> classBlockDislocatorPedestal;
    private static Class<?> classBlockDraconiumChest;
    private static Class<?> classBlockPlacedItem;
    private static Class<?> classBlockInvisECoreBlock;
    private static final byte[] byteFacing;
    private static final int[] intFacing;
    private static final int[] rotFlowGate;
    private static final int[] rotPotentiometer;

    public static void register() {
        try {
            classBlockBlockDE = Class.forName("com.brandon3055.brandonscore.blocks.BlockBCore");
            classBlockDislocatorReceptacle = Class.forName("com.brandon3055.draconicevolution.blocks.DislocatorReceptacle");
            classBlockPortal = Class.forName("com.brandon3055.draconicevolution.blocks.Portal");
            classBlockFlowGate = Class.forName("com.brandon3055.draconicevolution.blocks.machines.FlowGate");
            classBlockGenerator = Class.forName("com.brandon3055.draconicevolution.blocks.machines.Generator");
            classBlockGrinder = Class.forName("com.brandon3055.draconicevolution.blocks.machines.Grinder");
            classBlockPotentiometer = Class.forName("com.brandon3055.draconicevolution.blocks.Potentiometer");
            classBlockDislocatorPedestal = Class.forName("com.brandon3055.draconicevolution.blocks.DislocatorPedestal");
            classBlockDraconiumChest = Class.forName("com.brandon3055.draconicevolution.blocks.DraconiumChest");
            classBlockPlacedItem = Class.forName("com.brandon3055.draconicevolution.blocks.PlacedItem");
            classBlockInvisECoreBlock = Class.forName("com.brandon3055.draconicevolution.blocks.InvisECoreBlock");
            WarpDriveConfig.registerBlockTransformer("DraconicEvolution", new CompatDraconicEvolution());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBlockDE.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        if (classBlockDislocatorReceptacle.isInstance(block) || classBlockPortal.isInstance(block)) {
            reason.append(Commons.getStyleWarning(), "warpdrive.compat.guide.draconic_evolution_portal", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagList tagListOldLinkedCrystals;
        int countLinks;
        int facing;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 && nbtTileEntity == null) {
            return metadata;
        }
        if (classBlockFlowGate.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFlowGate[metadata];
                }
                case 2: {
                    return rotFlowGate[rotFlowGate[metadata]];
                }
                case 3: {
                    return rotFlowGate[rotFlowGate[rotFlowGate[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockGenerator.isInstance(block) || classBlockGrinder.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return intFacing[metadata];
                }
                case 2: {
                    return intFacing[intFacing[metadata]];
                }
                case 3: {
                    return intFacing[intFacing[intFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPotentiometer.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotPotentiometer[metadata];
                }
                case 2: {
                    return rotPotentiometer[rotPotentiometer[metadata]];
                }
                case 3: {
                    return rotPotentiometer[rotPotentiometer[rotPotentiometer[metadata]]];
                }
            }
            return metadata;
        }
        NBTTagCompound tagCompoundBCManagedData = nbtTileEntity != null && nbtTileEntity.func_74764_b("BCManagedData") ? nbtTileEntity.func_74775_l("BCManagedData") : null;
        if (classBlockDislocatorPedestal.isInstance(block)) {
            if (tagCompoundBCManagedData == null) {
                return metadata;
            }
            if (rotationSteps > 0) {
                int rotationOld = tagCompoundBCManagedData.func_74762_e("rotation");
                int rotationNew = (rotationOld + 8 + 4 * rotationSteps) % 16 - 8;
                tagCompoundBCManagedData.func_74768_a("rotation", rotationNew);
            }
            return metadata;
        }
        if (classBlockDraconiumChest.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotPotentiometer[metadata];
                }
                case 2: {
                    return rotPotentiometer[rotPotentiometer[metadata]];
                }
                case 3: {
                    return rotPotentiometer[rotPotentiometer[rotPotentiometer[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPlacedItem.isInstance(block)) {
            if (tagCompoundBCManagedData == null) {
                return metadata;
            }
            if (metadata == 0 || metadata == 1) {
                int rotationOld = tagCompoundBCManagedData.func_74762_e("rotation0");
                int rotationNew = metadata == 0 ? (rotationOld + 4 * rotationSteps) % 16 : (rotationOld + 12 * rotationSteps) % 16;
                tagCompoundBCManagedData.func_74768_a("rotation0", rotationNew);
                return metadata;
            }
            byte facing2 = nbtTileEntity.func_74771_c("Facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("Facing", byteFacing[facing2]);
                    return intFacing[metadata];
                }
                case 2: {
                    nbtTileEntity.func_74774_a("Facing", byteFacing[byteFacing[facing2]]);
                    return intFacing[intFacing[metadata]];
                }
                case 3: {
                    nbtTileEntity.func_74774_a("Facing", byteFacing[byteFacing[byteFacing[facing2]]]);
                    return intFacing[intFacing[intFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (tagCompoundBCManagedData == null) {
            return metadata;
        }
        if (tagCompoundBCManagedData.func_74764_b("facing")) {
            facing = tagCompoundBCManagedData.func_74762_e("facing");
            switch (rotationSteps) {
                case 1: {
                    tagCompoundBCManagedData.func_74768_a("facing", intFacing[facing]);
                    break;
                }
                case 2: {
                    tagCompoundBCManagedData.func_74768_a("facing", intFacing[intFacing[facing]]);
                    break;
                }
                case 3: {
                    tagCompoundBCManagedData.func_74768_a("facing", intFacing[intFacing[intFacing[facing]]]);
                    break;
                }
            }
        }
        if (tagCompoundBCManagedData.func_74764_b("CoreDirection")) {
            facing = tagCompoundBCManagedData.func_74762_e("CoreDirection");
            switch (rotationSteps) {
                case 1: {
                    tagCompoundBCManagedData.func_74768_a("CoreDirection", intFacing[facing]);
                    break;
                }
                case 2: {
                    tagCompoundBCManagedData.func_74768_a("CoreDirection", intFacing[intFacing[facing]]);
                    break;
                }
                case 3: {
                    tagCompoundBCManagedData.func_74768_a("CoreDirection", intFacing[intFacing[intFacing[facing]]]);
                    break;
                }
            }
        }
        if (tagCompoundBCManagedData.func_74764_b("lastCorePos")) {
            int z;
            int y;
            NBTTagList tagListLastCorePos = tagCompoundBCManagedData.func_150295_c("lastCorePos", 3);
            int x = tagListLastCorePos.func_186858_c(0);
            if (transformation.isInside(x, y = tagListLastCorePos.func_186858_c(1), z = tagListLastCorePos.func_186858_c(2))) {
                BlockPos targetLink = transformation.apply(x, y, z);
                tagListLastCorePos.func_150304_a(0, (NBTBase)new NBTTagInt(targetLink.func_177958_n()));
                tagListLastCorePos.func_150304_a(1, (NBTBase)new NBTTagInt(targetLink.func_177956_o()));
                tagListLastCorePos.func_150304_a(2, (NBTBase)new NBTTagInt(targetLink.func_177952_p()));
            } else {
                tagListLastCorePos.func_150304_a(0, (NBTBase)new NBTTagInt(0));
                tagListLastCorePos.func_150304_a(1, (NBTBase)new NBTTagInt(0));
                tagListLastCorePos.func_150304_a(2, (NBTBase)new NBTTagInt(0));
            }
        }
        BlockPos blockPosOld = new BlockPos(nbtTileEntity.func_74762_e("x"), nbtTileEntity.func_74762_e("y"), nbtTileEntity.func_74762_e("z"));
        BlockPos blockPosNew = transformation.apply(blockPosOld);
        if (nbtTileEntity.func_74764_b("LinkedCrystals") && (countLinks = (tagListOldLinkedCrystals = nbtTileEntity.func_150295_c("LinkedCrystals", 7)).func_74745_c()) > 0) {
            NBTTagList tagListNewLinkedCrystals = new NBTTagList();
            for (int index = 0; index < countLinks; ++index) {
                int z;
                int y;
                NBTTagByteArray listLinkedCrystal = (NBTTagByteArray)tagListOldLinkedCrystals.func_179238_g(index);
                byte[] byteLink = listLinkedCrystal.func_150292_c();
                int x = blockPosOld.func_177958_n() - byteLink[0];
                if (transformation.isInside(x, y = blockPosOld.func_177956_o() - byteLink[1], z = blockPosOld.func_177952_p() - byteLink[2])) {
                    BlockPos targetLink = transformation.apply(x, y, z);
                    byteLink[0] = (byte)(blockPosNew.func_177958_n() - targetLink.func_177958_n());
                    byteLink[1] = (byte)(blockPosNew.func_177956_o() - targetLink.func_177956_o());
                    byteLink[2] = (byte)(blockPosNew.func_177952_p() - targetLink.func_177952_p());
                    tagListNewLinkedCrystals.func_74742_a((NBTBase)listLinkedCrystal);
                    continue;
                }
                byteLink[0] = 0;
                byteLink[1] = 0;
                byteLink[2] = 0;
            }
            nbtTileEntity.func_74782_a("LinkedCrystals", (NBTBase)tagListNewLinkedCrystals);
        }
        if (tagCompoundBCManagedData.func_74767_n("stabilizersOK")) {
            for (int index = 0; index < 4; ++index) {
                int z;
                int y;
                String tagName = String.format("stabOffset%d", index);
                NBTTagList tagListOffset = tagCompoundBCManagedData.func_150295_c(tagName, 3);
                int x = blockPosOld.func_177958_n() - tagListOffset.func_186858_c(0);
                if (transformation.isInside(x, y = blockPosOld.func_177956_o() - tagListOffset.func_186858_c(1), z = blockPosOld.func_177952_p() - tagListOffset.func_186858_c(2))) {
                    BlockPos targetStabilizer = transformation.apply(x, y, z);
                    tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(blockPosNew.func_177958_n() - targetStabilizer.func_177958_n()));
                    tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(blockPosNew.func_177956_o() - targetStabilizer.func_177956_o()));
                    tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(blockPosNew.func_177952_p() - targetStabilizer.func_177952_p()));
                    continue;
                }
                tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(0));
                tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(0));
                tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(0));
            }
        }
        if (tagCompoundBCManagedData.func_74764_b("coreOffset")) {
            NBTTagList tagListOffset = tagCompoundBCManagedData.func_150295_c("coreOffset", 3);
            if (tagCompoundBCManagedData.func_74767_n("structureValid") || classBlockInvisECoreBlock.isInstance(block) || tagCompoundBCManagedData.func_74767_n("hasCoreLock") || tagCompoundBCManagedData.func_74767_n("isBound")) {
                int z;
                int y;
                int x = blockPosOld.func_177958_n() - tagListOffset.func_186858_c(0);
                if (transformation.isInside(x, y = blockPosOld.func_177956_o() - tagListOffset.func_186858_c(1), z = blockPosOld.func_177952_p() - tagListOffset.func_186858_c(2))) {
                    BlockPos targetStabilizer = transformation.apply(x, y, z);
                    tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(blockPosNew.func_177958_n() - targetStabilizer.func_177958_n()));
                    tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(blockPosNew.func_177956_o() - targetStabilizer.func_177956_o()));
                    tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(blockPosNew.func_177952_p() - targetStabilizer.func_177952_p()));
                } else {
                    tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(0));
                    tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(0));
                    tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(0));
                }
            } else {
                tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(0));
                tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(0));
                tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(0));
            }
        }
        if (tagCompoundBCManagedData.func_74764_b("componentPosition0")) {
            HashMap<String, NBTTagList> mapNewPosition = new HashMap<String, NBTTagList>(6);
            for (int facing3 = 0; facing3 < 6; ++facing3) {
                String tagNewName;
                String tagOldName = String.format("componentPosition%d", facing3);
                switch (rotationSteps) {
                    case 1: {
                        tagNewName = String.format("componentPosition%d", intFacing[facing3]);
                        break;
                    }
                    case 2: {
                        tagNewName = String.format("componentPosition%d", intFacing[intFacing[facing3]]);
                        break;
                    }
                    case 3: {
                        tagNewName = String.format("componentPosition%d", intFacing[intFacing[intFacing[facing3]]]);
                        break;
                    }
                    default: {
                        tagNewName = tagOldName;
                    }
                }
                NBTTagList tagListOffset = tagCompoundBCManagedData.func_150295_c(tagOldName, 3);
                if (tagListOffset.func_186858_c(0) != 0 || tagListOffset.func_186858_c(1) != 0 || tagListOffset.func_186858_c(2) != 0) {
                    int z;
                    int y;
                    int x = blockPosOld.func_177958_n() - tagListOffset.func_186858_c(0);
                    if (transformation.isInside(x, y = blockPosOld.func_177956_o() - tagListOffset.func_186858_c(1), z = blockPosOld.func_177952_p() - tagListOffset.func_186858_c(2))) {
                        BlockPos targetComponent = transformation.apply(x, y, z);
                        tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(blockPosNew.func_177958_n() - targetComponent.func_177958_n()));
                        tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(blockPosNew.func_177956_o() - targetComponent.func_177956_o()));
                        tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(blockPosNew.func_177952_p() - targetComponent.func_177952_p()));
                    } else {
                        tagListOffset.func_150304_a(0, (NBTBase)new NBTTagInt(0));
                        tagListOffset.func_150304_a(1, (NBTBase)new NBTTagInt(0));
                        tagListOffset.func_150304_a(2, (NBTBase)new NBTTagInt(0));
                    }
                }
                mapNewPosition.put(tagNewName, tagListOffset);
                tagCompoundBCManagedData.func_82580_o(tagOldName);
            }
            for (Map.Entry entry : mapNewPosition.entrySet()) {
                tagCompoundBCManagedData.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        byteFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        intFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFlowGate = new int[]{0, 3, 4, 2, 1, 5, 6, 7, 8, 11, 12, 10, 9, 13, 14, 15};
        rotPotentiometer = new int[]{0, 3, 4, 2, 1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

