/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatEmbers
implements IBlockTransformer {
    private static final Set<String> registryNameRotating;
    private static final Set<String> registryNameFacing;
    private static final Map<String, String> rotSideNames;
    private static final int[] rotStoneEdge;
    private static final int[] rotMechEdge;
    private static final int[] rotForgeEdge;
    private static final int[] rotFacing;
    private static final int[] rotDawnstoneAnvil;
    private static final int[] rotHorizontal;
    private static final int[] rotFacingOr6;
    private static final int[] rot1or2xFacing;
    private static final int[] rotSplitter;

    public static void register() {
        try {
            Class<?> classDummyCheck = Class.forName("teamroots.embers.block.BlockBase");
            WarpDriveConfig.registerBlockTransformer("Embers", new CompatEmbers());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        ResourceLocation registryName = block.getRegistryName();
        assert (registryName != null);
        if (!registryName.func_110624_b().equals("embers")) {
            return false;
        }
        return registryNameRotating.contains(registryName.func_110623_a());
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        int n;
        int targetY;
        int targetX;
        byte rotationSteps = transformation.getRotationSteps();
        ResourceLocation registryName = block.getRegistryName();
        assert (registryName != null);
        String registryPath = registryName.func_110623_a();
        if (registryPath.equals("advanced_edge") || registryPath.equals("field_chart") || registryPath.equals("stone_edge")) {
            switch (rotationSteps) {
                case 1: {
                    return rotStoneEdge[metadata];
                }
                case 2: {
                    return rotStoneEdge[rotStoneEdge[metadata]];
                }
                case 3: {
                    return rotStoneEdge[rotStoneEdge[rotStoneEdge[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("mech_edge")) {
            switch (rotationSteps) {
                case 1: {
                    return rotMechEdge[metadata];
                }
                case 2: {
                    return rotMechEdge[rotMechEdge[metadata]];
                }
                case 3: {
                    return rotMechEdge[rotMechEdge[rotMechEdge[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("inferno_forge_edge")) {
            switch (rotationSteps) {
                case 1: {
                    return rotForgeEdge[metadata];
                }
                case 2: {
                    return rotForgeEdge[rotForgeEdge[metadata]];
                }
                case 3: {
                    return rotForgeEdge[rotForgeEdge[rotForgeEdge[metadata]]];
                }
            }
            return metadata;
        }
        if (registryNameFacing.contains(registryPath)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("dawnstone_anvil")) {
            switch (rotationSteps) {
                case 1: {
                    return rotDawnstoneAnvil[metadata];
                }
                case 2: {
                    return rotDawnstoneAnvil[rotDawnstoneAnvil[metadata]];
                }
                case 3: {
                    return rotDawnstoneAnvil[rotDawnstoneAnvil[rotDawnstoneAnvil[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("mini_boiler")) {
            switch (rotationSteps) {
                case 1: {
                    return rotHorizontal[metadata];
                }
                case 2: {
                    return rotHorizontal[rotHorizontal[metadata]];
                }
                case 3: {
                    return rotHorizontal[rotHorizontal[rotHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("mechanical_pump")) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacingOr6[metadata];
                }
                case 2: {
                    return rotFacingOr6[rotFacingOr6[metadata]];
                }
                case 3: {
                    return rotFacingOr6[rotFacingOr6[rotFacingOr6[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("east") || nbtTileEntity.func_74764_b("eastTank") || nbtTileEntity.func_74764_b("from2")) {
            HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
            for (String string : rotSideNames.keySet()) {
                if (!nbtTileEntity.func_74764_b(string)) continue;
                NBTBase tag = nbtTileEntity.func_74781_a(string);
                switch (rotationSteps) {
                    case 1: {
                        map.put(rotSideNames.get(string), tag);
                        break;
                    }
                    case 2: {
                        map.put(rotSideNames.get(rotSideNames.get(string)), tag);
                        break;
                    }
                    case 3: {
                        map.put(rotSideNames.get(rotSideNames.get(rotSideNames.get(string))), tag);
                        break;
                    }
                    default: {
                        map.put(string, tag);
                    }
                }
                nbtTileEntity.func_82580_o(string);
            }
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
                }
            }
        }
        if (nbtTileEntity.func_74764_b("targetX") && transformation.isInside(targetX = nbtTileEntity.func_74762_e("targetX"), targetY = nbtTileEntity.func_74762_e("targetY"), n = nbtTileEntity.func_74762_e("targetZ"))) {
            BlockPos chunkCoordinates = transformation.apply(targetX, targetY, n);
            nbtTileEntity.func_74768_a("targetX", chunkCoordinates.func_177958_n());
            nbtTileEntity.func_74768_a("targetY", chunkCoordinates.func_177956_o());
            nbtTileEntity.func_74768_a("targetZ", chunkCoordinates.func_177952_p());
        }
        if (registryPath.equals("beam_cannon") || registryPath.equals("ember_emitter") || registryPath.equals("ember_pulser")) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("fluid_transfer") || registryPath.equals("item_transfer")) {
            switch (rotationSteps) {
                case 1: {
                    return rot1or2xFacing[metadata];
                }
                case 2: {
                    return rot1or2xFacing[rot1or2xFacing[metadata]];
                }
                case 3: {
                    return rot1or2xFacing[rot1or2xFacing[rot1or2xFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (registryPath.equals("beam_splitter")) {
            int n2;
            BlockPos chunkCoordinates;
            int targetLeftX = -1;
            int targetLeftY = -1;
            int n3 = -1;
            int targetRightX = -1;
            int targetRightY = -1;
            int targetRightZ = -1;
            if (nbtTileEntity.func_74764_b("targetLeftX")) {
                int n4;
                targetLeftX = nbtTileEntity.func_74762_e("targetLeftX");
                if (transformation.isInside(targetLeftX, targetLeftY = nbtTileEntity.func_74762_e("targetLeftY"), n4 = nbtTileEntity.func_74762_e("targetLeftZ"))) {
                    chunkCoordinates = transformation.apply(targetLeftX, targetLeftY, n4);
                    targetLeftX = chunkCoordinates.func_177958_n();
                    targetLeftY = chunkCoordinates.func_177956_o();
                    n2 = chunkCoordinates.func_177952_p();
                }
                nbtTileEntity.func_82580_o("targetLeftX");
                nbtTileEntity.func_82580_o("targetLeftY");
                nbtTileEntity.func_82580_o("targetLeftZ");
            }
            if (nbtTileEntity.func_74764_b("targetRightX")) {
                targetRightX = nbtTileEntity.func_74762_e("targetRightX");
                if (transformation.isInside(targetRightX, targetRightY = nbtTileEntity.func_74762_e("targetRightY"), targetRightZ = nbtTileEntity.func_74762_e("targetRightZ"))) {
                    chunkCoordinates = transformation.apply(targetRightX, targetRightY, targetRightZ);
                    targetRightX = chunkCoordinates.func_177958_n();
                    targetRightY = chunkCoordinates.func_177956_o();
                    targetRightZ = chunkCoordinates.func_177952_p();
                }
                nbtTileEntity.func_82580_o("targetRightX");
                nbtTileEntity.func_82580_o("targetRightY");
                nbtTileEntity.func_82580_o("targetRightZ");
            }
            if (rotationSteps == 0 || metadata == 0 && rotationSteps == 1 || metadata == 2 && rotationSteps == 3) {
                if (targetLeftY != -1) {
                    nbtTileEntity.func_74768_a("targetLeftX", targetLeftX);
                    nbtTileEntity.func_74768_a("targetLeftY", targetLeftY);
                    nbtTileEntity.func_74768_a("targetLeftZ", n2);
                }
                if (targetRightY != -1) {
                    nbtTileEntity.func_74768_a("targetRightX", targetRightX);
                    nbtTileEntity.func_74768_a("targetRightY", targetRightY);
                    nbtTileEntity.func_74768_a("targetRightZ", targetRightZ);
                }
            } else {
                if (targetRightY != -1) {
                    nbtTileEntity.func_74768_a("targetLeftX", targetRightX);
                    nbtTileEntity.func_74768_a("targetLeftY", targetRightY);
                    nbtTileEntity.func_74768_a("targetLeftZ", targetRightZ);
                }
                if (targetLeftY != -1) {
                    nbtTileEntity.func_74768_a("targetRightX", targetLeftX);
                    nbtTileEntity.func_74768_a("targetRightY", targetLeftY);
                    nbtTileEntity.func_74768_a("targetRightZ", n2);
                }
            }
            switch (rotationSteps) {
                case 1: {
                    return rotSplitter[metadata];
                }
                case 2: {
                    return rotSplitter[rotSplitter[metadata]];
                }
                case 3: {
                    return rotSplitter[rotSplitter[rotSplitter[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        HashSet<String> set = new HashSet<String>(30);
        set.add("advanced_edge");
        set.add("field_chart");
        set.add("stone_edge");
        set.add("inferno_forge_edge");
        set.add("mech_edge");
        set.add("auto_hammer");
        set.add("breaker");
        set.add("catalytic_plug");
        set.add("charger");
        set.add("clockwork_attenuator");
        set.add("ember_gauge");
        set.add("ember_funnel");
        set.add("ember_injector");
        set.add("fluid_gauge");
        set.add("mech_accessor");
        set.add("ember_receiver");
        set.add("ember_relay");
        set.add("stirling");
        set.add("vacuum");
        set.add("dawnstone_anvil");
        set.add("mini_boiler");
        set.add("mechanical_pump");
        set.add("alchemy_tablet");
        set.add("beam_cannon");
        set.add("beam_splitter");
        set.add("ember_emitter");
        set.add("fluid_transfer");
        set.add("item_transfer");
        set.add("mixer");
        set.add("ember_pulser");
        set.add("item_pipe");
        set.add("item_pump");
        set.add("pipe");
        set.add("pump");
        registryNameRotating = Collections.unmodifiableSet(set);
        set = new HashSet(15);
        set.add("auto_hammer");
        set.add("breaker");
        set.add("catalytic_plug");
        set.add("charger");
        set.add("clockwork_attenuator");
        set.add("ember_gauge");
        set.add("ember_funnel");
        set.add("ember_injector");
        set.add("fluid_gauge");
        set.add("mech_accessor");
        set.add("ember_receiver");
        set.add("ember_relay");
        set.add("stirling");
        set.add("vacuum");
        registryNameFacing = Collections.unmodifiableSet(set);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("east", "south");
        map.put("south", "west");
        map.put("west", "north");
        map.put("north", "east");
        map.put("eastTank", "southTank");
        map.put("southTank", "westTank");
        map.put("westTank", "northTank");
        map.put("northTank", "eastTank");
        map.put("from2", "from5");
        map.put("from5", "from3");
        map.put("from3", "from4");
        map.put("from4", "from2");
        rotSideNames = Collections.unmodifiableMap(map);
        rotStoneEdge = new int[]{0, 7, 9, 1, 2, 3, 4, 5, 8, 6, 10, 11, 12, 13, 14, 15};
        rotMechEdge = new int[]{6, 7, 0, 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15};
        rotForgeEdge = new int[]{6, 7, 0, 1, 2, 3, 4, 5, 14, 15, 8, 9, 10, 11, 12, 13};
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotDawnstoneAnvil = new int[]{1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotHorizontal = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacingOr6 = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        rot1or2xFacing = new int[]{0, 1, 2, 3, 10, 11, 8, 9, 4, 5, 6, 7, 12, 13, 14, 15};
        rotSplitter = new int[]{2, 1, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

