/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatEnderIO
implements IBlockTransformer {
    private static Class<?> classTileEntityEIO;
    private static final Map<String, String> rotSideNames;
    private static final String[] nameEnumMapEnumFacings;
    private static final int[] rotFacing;
    private static final int[] rotDialerFacing;
    private static final int[] mrotTelePad;

    public static void register() {
        try {
            classTileEntityEIO = Class.forName("crazypants.enderio.base.TileEntityEio");
            WarpDriveConfig.registerBlockTransformer("enderio", new CompatEnderIO());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityEIO.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private byte[] rotate_byteArray(byte rotationSteps, @Nonnull byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatEnderIO.rotFacing[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatEnderIO.rotFacing[CompatEnderIO.rotFacing[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatEnderIO.rotFacing[CompatEnderIO.rotFacing[CompatEnderIO.rotFacing[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    private int[] rotate_enumFacing(byte rotationSteps, @Nonnull int[] data) {
        if (data.length != 3 || data[0] != 3 || data[1] != 0) {
            WarpDrive.logger.error(String.format("Invalid EnumFacing encoding [%s], please report to mod author", Commons.formatHexadecimal(data)));
            return data;
        }
        int[] newData = (int[])data.clone();
        byte[] bytes = new byte[6];
        int value = data[2];
        for (int index = 0; index < 6; ++index) {
            bytes[index] = (byte)(value & 7);
            value >>= 3;
        }
        byte[] newBytes = this.rotate_byteArray(rotationSteps, bytes);
        int newValue = 0;
        for (int index = 5; index >= 0; --index) {
            newValue = newValue << 3 | newBytes[index] & 7;
        }
        newData[2] = newValue;
        return newData;
    }

    private NBTTagCompound rotate_conduit(byte rotationSteps, NBTTagCompound nbtConduit) {
        NBTTagCompound nbtNewConduit = new NBTTagCompound();
        Set keys = nbtConduit.func_150296_c();
        block14: for (String key : keys) {
            NBTBase base = nbtConduit.func_74781_a(key);
            switch (base.func_74732_a()) {
                case 11: {
                    int[] data = nbtConduit.func_74759_k(key);
                    int[] newData = (int[])data.clone();
                    block15: for (int index = 0; index < data.length; ++index) {
                        switch (rotationSteps) {
                            case 1: {
                                newData[index] = rotFacing[data[index]];
                                continue block15;
                            }
                            case 2: {
                                newData[index] = rotFacing[rotFacing[data[index]]];
                                continue block15;
                            }
                            case 3: {
                                newData[index] = rotFacing[rotFacing[rotFacing[data[index]]]];
                                continue block15;
                            }
                        }
                    }
                    nbtNewConduit.func_74783_a(key, newData);
                    continue block14;
                }
                case 7: {
                    nbtNewConduit.func_74773_a(key, this.rotate_byteArray(rotationSteps, nbtConduit.func_74770_j(key)));
                    continue block14;
                }
            }
            String[] parts = key.split("\\.");
            if (parts.length != 2 || !rotSideNames.containsKey(parts[1])) {
                nbtNewConduit.func_74782_a(key, base);
                continue;
            }
            switch (rotationSteps) {
                case 1: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(parts[1]), base);
                    continue block14;
                }
                case 2: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(rotSideNames.get(parts[1])), base);
                    continue block14;
                }
                case 3: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(rotSideNames.get(rotSideNames.get(parts[1]))), base);
                    continue block14;
                }
            }
            nbtNewConduit.func_74782_a(key, base);
        }
        return nbtNewConduit;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74779_i("id").equals("enderio:tile_tele_pad")) {
            switch (rotationSteps) {
                case 1: {
                    return mrotTelePad[metadata];
                }
                case 2: {
                    return mrotTelePad[mrotTelePad[metadata]];
                }
                case 3: {
                    return mrotTelePad[mrotTelePad[mrotTelePad[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("dialerFacing")) {
            int dialerFacing = nbtTileEntity.func_74762_e("dialerFacing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("dialerFacing", rotDialerFacing[dialerFacing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("dialerFacing", rotDialerFacing[rotDialerFacing[dialerFacing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("dialerFacing", rotDialerFacing[rotDialerFacing[rotDialerFacing[dialerFacing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("rotation")) {
            short rotation = nbtTileEntity.func_74765_d("rotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("rotation", rotFacing[rotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("rotation", rotFacing[rotFacing[rotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("rotation", rotFacing[rotFacing[rotFacing[rotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74765_d("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        for (String nameEnumFacing : nameEnumMapEnumFacings) {
            if (!nbtTileEntity.func_74764_b(nameEnumFacing)) continue;
            int[] ints = nbtTileEntity.func_74759_k(nameEnumFacing);
            int[] intsNew = this.rotate_enumFacing(rotationSteps, ints);
            nbtTileEntity.func_74783_a(nameEnumFacing, intsNew);
        }
        if (nbtTileEntity.func_74764_b("conduits")) {
            NBTTagCompound nbtConduits = nbtTileEntity.func_74775_l("conduits");
            int size = nbtConduits.func_74762_e("size");
            for (int index = 0; index < size; ++index) {
                String key = Integer.toString(index);
                NBTTagCompound nbtConduit = nbtConduits.func_74775_l(key);
                nbtConduits.func_74782_a(key, (NBTBase)this.rotate_conduit(rotationSteps, nbtConduit));
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EAST", "SOUTH");
        map.put("SOUTH", "WEST");
        map.put("WEST", "NORTH");
        map.put("NORTH", "EAST");
        rotSideNames = Collections.unmodifiableMap(map);
        nameEnumMapEnumFacings = new String[]{"faceModes", "faceDisplayTypes"};
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotDialerFacing = new int[]{3, 2, 0, 1, 7, 6, 4, 5, 20, 21, 22, 23, 16, 17, 18, 19, 9, 8, 10, 11, 13, 12, 14, 15};
        mrotTelePad = new int[]{0, 1, 4, 5, 6, 7, 8, 9, 2, 3, 10, 11, 12, 13, 14, 15};
    }
}

