/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CompatGalacticraft
implements IBlockTransformer {
    public static CompatGalacticraft INSTANCE;
    private static Class<?> classBlockAdvanced;
    private static Class<?> classBlockConcealedDetector;
    private static Class<?> classBlockParaChest;
    private static Class<?> classBlockTier1TreasureChest;
    private static Class<?> classBlockTorchBase;
    private static final int[] rotFacing;
    private static final int[] rotDetector;
    private static final int[] rotLighting23;
    private static final int[] rotLighting4;

    public static void register() {
        try {
            classBlockAdvanced = Class.forName("micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced");
            classBlockConcealedDetector = Class.forName("micdoodle8.mods.galacticraft.core.blocks.BlockConcealedDetector");
            classBlockParaChest = Class.forName("micdoodle8.mods.galacticraft.core.blocks.BlockParaChest");
            classBlockTier1TreasureChest = Class.forName("micdoodle8.mods.galacticraft.core.blocks.BlockTier1TreasureChest");
            classBlockTorchBase = Class.forName("micdoodle8.mods.galacticraft.core.blocks.BlockTorchBase");
            INSTANCE = new CompatGalacticraft();
            WarpDriveConfig.registerBlockTransformer("Galacticraft", INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onGCCoreOxygenSuffocationEventPre(GCCoreOxygenSuffocationEvent.Pre event) {
        int z;
        assert (event.getEntity() != null);
        Entity entity = event.getEntity();
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        CelestialObject celestialObject = CelestialObjectManager.get(entity.field_70170_p, x, z = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (celestialObject == null) {
            return;
        }
        GCPlayerStats gcPlayerStats = GCPlayerStats.get((Entity)event.getEntity());
        if (gcPlayerStats != null) {
            gcPlayerStats.setLastOxygenSetupValid(true);
        }
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        int z;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        int x = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
        CelestialObject celestialObject = CelestialObjectManager.get(entityLivingBase.field_70170_p, x, z = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v));
        if (celestialObject == null) {
            return;
        }
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)Minecraft.func_71410_x().field_71439_g);
        if (stats != null) {
            stats.setOxygenSetupValid(true);
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockAdvanced.isInstance(block) || classBlockConcealedDetector.isInstance(block) || classBlockParaChest.isInstance(block) || classBlockTier1TreasureChest.isInstance(block) || classBlockTorchBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagCompound tagCompoundMainBlockPosition;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("mainBlockPosition") && (tagCompoundMainBlockPosition = nbtTileEntity.func_74775_l("mainBlockPosition")).func_74764_b("x") && tagCompoundMainBlockPosition.func_74764_b("y") && tagCompoundMainBlockPosition.func_74764_b("z")) {
            int x = nbtTileEntity.func_74762_e("x");
            int y = nbtTileEntity.func_74762_e("y");
            int z = nbtTileEntity.func_74762_e("z");
            BlockPos blockPosMain = transformation.apply(x, y, z);
            tagCompoundMainBlockPosition.func_74768_a("x", blockPosMain.func_177958_n());
            tagCompoundMainBlockPosition.func_74768_a("y", blockPosMain.func_177956_o());
            tagCompoundMainBlockPosition.func_74768_a("z", blockPosMain.func_177952_p());
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74767_n("HasTarget") && nbtTileEntity.func_74764_b("TargetX") && nbtTileEntity.func_74764_b("TargetY") && nbtTileEntity.func_74764_b("TargetZ")) {
            int z;
            int y;
            int x = nbtTileEntity.func_74762_e("TargetX");
            if (transformation.isInside(x, y = nbtTileEntity.func_74762_e("TargetY"), z = nbtTileEntity.func_74762_e("TargetZ"))) {
                BlockPos blockPosTarget = transformation.apply(x, y, z);
                nbtTileEntity.func_74768_a("TargetX", blockPosTarget.func_177958_n());
                nbtTileEntity.func_74768_a("TargetY", blockPosTarget.func_177956_o());
                nbtTileEntity.func_74768_a("TargetZ", blockPosTarget.func_177952_p());
            } else {
                nbtTileEntity.func_74757_a("HasTarget", false);
            }
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74779_i("id").contains("beam receiver") && nbtTileEntity.func_74764_b("FacingSide")) {
            int facingSide = nbtTileEntity.func_74762_e("FacingSide");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("FacingSide", rotFacing[facingSide]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("FacingSide", rotFacing[rotFacing[facingSide]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("FacingSide", rotFacing[rotFacing[rotFacing[facingSide]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74779_i("id").contains("panel lighting") && nbtTileEntity.func_74764_b("meta")) {
            int meta = nbtTileEntity.func_74762_e("meta");
            if (metadata == 0 || metadata == 1) {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("meta", rotFacing[meta]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("meta", rotFacing[rotFacing[meta]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("meta", rotFacing[rotFacing[rotFacing[meta]]]);
                        break;
                    }
                }
            } else if (metadata == 2 || metadata == 3) {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("meta", rotLighting23[meta]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("meta", rotLighting23[rotLighting23[meta]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("meta", rotLighting23[rotLighting23[rotLighting23[meta]]]);
                        break;
                    }
                }
            } else if (metadata == 4) {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("meta", rotLighting4[meta]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("meta", rotLighting4[rotLighting4[meta]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("meta", rotLighting4[rotLighting4[rotLighting4[meta]]]);
                        break;
                    }
                }
            } else {
                WarpDrive.logger.error(String.format("Unsupported Galacticraft lighting panel %s:%d with nbt %s", block, metadata, nbtTileEntity));
            }
        }
        if (classBlockConcealedDetector.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotDetector[metadata];
                }
                case 2: {
                    return rotDetector[rotDetector[metadata]];
                }
                case 3: {
                    return rotDetector[rotDetector[rotDetector[metadata]]];
                }
            }
            return metadata;
        }
        return IBlockTransformer.rotateFirstEnumFacingProperty(block, metadata, rotationSteps);
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotDetector = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12};
        rotLighting23 = new int[]{0, 9, 5, 4, 2, 3, 6, 7, 0, 1, 13, 12, 10, 11, 14, 15};
        rotLighting4 = new int[]{8, 25, 21, 20, 2, 3, 6, 7, 16, 1, 29, 28, 10, 11, 14, 15, 24, 9, 5, 4, 18, 19, 22, 23, 0, 17, 13, 12, 26, 27, 30, 31};
    }
}

