/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatGregTech
implements IBlockTransformer {
    private static Class<?> classMetaTileEntityHolder;
    private static Class<?> classTileEntityPipeBase;
    private static final int[] rotFacing;

    public static void register() {
        try {
            classMetaTileEntityHolder = Class.forName("gregtech.api.metatileentity.MetaTileEntityHolder");
            classTileEntityPipeBase = Class.forName("gregtech.api.pipenet.tile.TileEntityPipeBase");
            WarpDriveConfig.registerBlockTransformer("gregtech", new CompatGregTech());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classMetaTileEntityHolder.isInstance(tileEntity) || classTileEntityPipeBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private void rotateConnection(@Nonnull NBTTagCompound tagCompound, @Nonnull String key, byte rotationSteps) {
        if (!tagCompound.func_74764_b(key)) {
            return;
        }
        int connectionsOld = tagCompound.func_74762_e(key);
        int connectionsNew = connectionsOld & 3;
        for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
            int indexFacingNew;
            boolean isBlocked;
            int indexFacingOld = enumFacing.func_176745_a();
            boolean bl = isBlocked = (connectionsOld & 1 << indexFacingOld) != 0;
            if (!isBlocked) continue;
            switch (rotationSteps) {
                case 1: {
                    indexFacingNew = rotFacing[indexFacingOld];
                    break;
                }
                case 2: {
                    indexFacingNew = rotFacing[rotFacing[indexFacingOld]];
                    break;
                }
                case 3: {
                    indexFacingNew = rotFacing[rotFacing[rotFacing[indexFacingOld]]];
                    break;
                }
                default: {
                    indexFacingNew = indexFacingOld;
                }
            }
            connectionsNew |= 1 << indexFacingNew;
        }
        tagCompound.func_74768_a(key, connectionsNew);
    }

    private void rotateFaceInteger(@Nonnull NBTTagCompound tagCompound, @Nonnull String key, byte rotationSteps) {
        if (!tagCompound.func_74764_b(key)) {
            return;
        }
        int frontFacing = tagCompound.func_74762_e(key);
        switch (rotationSteps) {
            case 1: {
                tagCompound.func_74768_a(key, rotFacing[frontFacing]);
                break;
            }
            case 2: {
                tagCompound.func_74768_a(key, rotFacing[rotFacing[frontFacing]]);
                break;
            }
            case 3: {
                tagCompound.func_74768_a(key, rotFacing[rotFacing[rotFacing[frontFacing]]]);
                break;
            }
        }
    }

    private void rotateCovers(@Nonnull NBTTagCompound tagCompound, byte rotationSteps) {
        String key = "Covers";
        if (!tagCompound.func_74764_b("Covers")) {
            return;
        }
        NBTTagList tagListCovers = tagCompound.func_150295_c("Covers", 10);
        int count = tagListCovers.func_74745_c();
        block5: for (int index = 0; index < count; ++index) {
            NBTTagCompound tagCover = (NBTTagCompound)tagListCovers.func_179238_g(index);
            byte side = tagCover.func_74771_c("Side");
            switch (rotationSteps) {
                case 1: {
                    tagCover.func_74774_a("Side", (byte)rotFacing[side]);
                    continue block5;
                }
                case 2: {
                    tagCover.func_74774_a("Side", (byte)rotFacing[rotFacing[side]]);
                    continue block5;
                }
                case 3: {
                    tagCover.func_74774_a("Side", (byte)rotFacing[rotFacing[rotFacing[side]]]);
                }
            }
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        this.rotateConnection(nbtTileEntity, "BlockedConnections", rotationSteps);
        this.rotateConnection(nbtTileEntity, "Connections", rotationSteps);
        this.rotateCovers(nbtTileEntity, rotationSteps);
        if (nbtTileEntity.func_74764_b("MetaTileEntity")) {
            NBTTagCompound tagCompoundMetaTileEntity = nbtTileEntity.func_74775_l("MetaTileEntity");
            this.rotateFaceInteger(tagCompoundMetaTileEntity, "FrontFacing", rotationSteps);
            this.rotateFaceInteger(tagCompoundMetaTileEntity, "OutputFacing", rotationSteps);
            this.rotateFaceInteger(tagCompoundMetaTileEntity, "OutputFacingF", rotationSteps);
            this.rotateCovers(tagCompoundMetaTileEntity, rotationSteps);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

