/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class CompatImmersiveEngineering
implements IBlockTransformer {
    private static Class<?> classTileEntityIEBase;
    private static final int[] rotFacing;

    public static void register() {
        try {
            classTileEntityIEBase = Class.forName("blusunrize.immersiveengineering.common.blocks.TileEntityIEBase");
            WarpDriveConfig.registerBlockTransformer("ImmersiveEngineering", new CompatImmersiveEngineering());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntity instanceof IImmersiveConnectable || classTileEntityIEBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    @Optional.Method(modid="immersiveengineering")
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (tileEntity instanceof IImmersiveConnectable) {
            BlockPos node = tileEntity.func_174877_v();
            Set connections = ImmersiveNetHandler.INSTANCE.getConnections(tileEntity.func_145831_w(), node);
            if (connections != null) {
                NBTTagList nbtImmersiveEngineering = new NBTTagList();
                for (ImmersiveNetHandler.Connection connection : connections) {
                    nbtImmersiveEngineering.func_74742_a((NBTBase)connection.writeToNBT());
                }
                ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(node, tileEntity.func_145831_w());
                return nbtImmersiveEngineering;
            }
        }
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (block instanceof BlockIEMultiblock && tileEntity instanceof TileEntityMultiblockPart) {
            ((TileEntityMultiblockPart)tileEntity).disassemble();
        }
        if (tileEntity instanceof TileEntityConnectorLV || tileEntity instanceof TileEntityConnectorRedstone) {
            BlockPos blockPos = tileEntity.func_174877_v();
            world.func_175713_t(blockPos);
            FastSetBlockState.setBlockStateNoLight(world, blockPos, Blocks.field_150348_b.func_176223_P(), 2);
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagCompound conveyorBeltSubtypeNBT;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("sideConfig_0")) {
            HashMap<String, NBTBase> mapNewSideConfig = new HashMap<String, NBTBase>(6);
            for (int facing = 0; facing < 6; ++facing) {
                String tagNewName;
                String tagOldName = String.format("sideConfig_%d", facing);
                switch (rotationSteps) {
                    case 1: {
                        tagNewName = String.format("sideConfig_%d", rotFacing[facing]);
                        break;
                    }
                    case 2: {
                        tagNewName = String.format("sideConfig_%d", rotFacing[rotFacing[facing]]);
                        break;
                    }
                    case 3: {
                        tagNewName = String.format("sideConfig_%d", rotFacing[rotFacing[rotFacing[facing]]]);
                        break;
                    }
                    default: {
                        tagNewName = tagOldName;
                    }
                }
                NBTBase tagListOldSideConfig = nbtTileEntity.func_74781_a(tagOldName);
                mapNewSideConfig.put(tagNewName, tagListOldSideConfig);
                nbtTileEntity.func_82580_o(tagOldName);
            }
            for (Map.Entry entry : mapNewSideConfig.entrySet()) {
                nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
            }
        }
        if (nbtTileEntity.func_74764_b("conveyorBeltSubtypeNBT") && (conveyorBeltSubtypeNBT = nbtTileEntity.func_74775_l("conveyorBeltSubtypeNBT")).func_74764_b("extractDirection")) {
            int extraDirection = conveyorBeltSubtypeNBT.func_74762_e("extractDirection");
            switch (rotationSteps) {
                case 1: {
                    conveyorBeltSubtypeNBT.func_74768_a("extractDirection", rotFacing[extraDirection]);
                    break;
                }
                case 2: {
                    conveyorBeltSubtypeNBT.func_74768_a("extractDirection", rotFacing[rotFacing[extraDirection]]);
                    break;
                }
                case 3: {
                    conveyorBeltSubtypeNBT.func_74768_a("extractDirection", rotFacing[rotFacing[rotFacing[extraDirection]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("side")) {
            int side = nbtTileEntity.func_74762_e("side");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("side", rotFacing[side]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("side", rotFacing[rotFacing[side]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("side", rotFacing[rotFacing[rotFacing[side]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("sideConfig")) {
            int[] intOldSideConfig = nbtTileEntity.func_74759_k("sideConfig");
            int[] intNewSideConfig = new int[6];
            for (int facingOld = 0; facingOld < 6; ++facingOld) {
                switch (rotationSteps) {
                    case 1: {
                        int facingNew = rotFacing[facingOld];
                        break;
                    }
                    case 2: {
                        int facingNew = rotFacing[rotFacing[facingOld]];
                        break;
                    }
                    case 3: {
                        int facingNew = rotFacing[rotFacing[rotFacing[facingOld]]];
                        break;
                    }
                    default: {
                        int facingNew = facingOld;
                    }
                }
                intNewSideConfig[facingNew] = intOldSideConfig[facingOld];
            }
            nbtTileEntity.func_74783_a("sideConfig", intNewSideConfig);
        }
        if (nbtTileEntity.func_74764_b("filter_0")) {
            HashMap<String, NBTBase> mapNewFilter = new HashMap<String, NBTBase>(6);
            for (int facing = 0; facing < 6; ++facing) {
                String tagNewName;
                String tagOldName = String.format("filter_%d", facing);
                switch (rotationSteps) {
                    case 1: {
                        tagNewName = String.format("filter_%d", rotFacing[facing]);
                        break;
                    }
                    case 2: {
                        tagNewName = String.format("filter_%d", rotFacing[rotFacing[facing]]);
                        break;
                    }
                    case 3: {
                        tagNewName = String.format("filter_%d", rotFacing[rotFacing[rotFacing[facing]]]);
                        break;
                    }
                    default: {
                        tagNewName = tagOldName;
                    }
                }
                NBTBase tagListOldFilter = nbtTileEntity.func_74781_a(tagOldName);
                mapNewFilter.put(tagNewName, tagListOldFilter);
                nbtTileEntity.func_82580_o(tagOldName);
            }
            for (Map.Entry entry : mapNewFilter.entrySet()) {
                nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
            }
        }
        if (nbtTileEntity.func_150297_b("offset", 11)) {
            EnumFacing enumFacingNew;
            BlockPos blockPosOld = new BlockPos(nbtTileEntity.func_74762_e("x"), nbtTileEntity.func_74762_e("y"), nbtTileEntity.func_74762_e("z"));
            BlockPos blockPosNew = transformation.apply(blockPosOld);
            int facing = nbtTileEntity.func_74762_e("facing");
            EnumFacing enumFacingOld = EnumFacing.func_82600_a((int)facing);
            switch (rotationSteps) {
                case 1: {
                    enumFacingNew = EnumFacing.func_82600_a((int)rotFacing[facing]);
                    break;
                }
                case 2: {
                    enumFacingNew = EnumFacing.func_82600_a((int)rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    enumFacingNew = EnumFacing.func_82600_a((int)rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
                default: {
                    enumFacingNew = enumFacingOld;
                }
            }
            int[] intOffsets = nbtTileEntity.func_74759_k("offset");
            if (intOffsets.length == 2) {
                int z;
                int y;
                int x = blockPosOld.func_177958_n() + (enumFacingOld.func_176740_k() == EnumFacing.Axis.Z ? intOffsets[0] : 0);
                if (transformation.isInside(x, y = blockPosOld.func_177956_o() + intOffsets[1], z = blockPosOld.func_177952_p() + (enumFacingOld.func_176740_k() == EnumFacing.Axis.X ? intOffsets[0] : 0))) {
                    BlockPos targetStabilizer = transformation.apply(x, y, z);
                    intOffsets[0] = enumFacingNew.func_176740_k() == EnumFacing.Axis.Z ? targetStabilizer.func_177958_n() - blockPosNew.func_177958_n() : targetStabilizer.func_177952_p() - blockPosNew.func_177952_p();
                    intOffsets[1] = targetStabilizer.func_177956_o() - blockPosNew.func_177956_o();
                } else {
                    intOffsets[0] = 0;
                    intOffsets[1] = 0;
                }
            } else if (nbtTileEntity.func_74767_n("formed")) {
                int z;
                int y;
                int x = blockPosOld.func_177958_n() + intOffsets[0];
                if (transformation.isInside(x, y = blockPosOld.func_177956_o() + intOffsets[1], z = blockPosOld.func_177952_p() + intOffsets[2])) {
                    BlockPos targetStabilizer = transformation.apply(x, y, z);
                    intOffsets[0] = targetStabilizer.func_177958_n() - blockPosNew.func_177958_n();
                    intOffsets[1] = targetStabilizer.func_177956_o() - blockPosNew.func_177956_o();
                    intOffsets[2] = targetStabilizer.func_177952_p() - blockPosNew.func_177952_p();
                } else {
                    intOffsets[0] = 0;
                    intOffsets[1] = 0;
                    intOffsets[2] = 0;
                }
            } else {
                WarpDrive.logger.error(String.format("Unexpected context for offset int array in %s for %s", nbtTileEntity, block));
            }
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            int facing = nbtTileEntity.func_74762_e("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        return metadata;
    }

    @Override
    @Optional.Method(modid="immersiveengineering")
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        if (nbtBase == null || nbtBase.func_82582_d()) {
            return;
        }
        if (!(nbtBase instanceof NBTTagList)) {
            WarpDrive.logger.warn(String.format("Invalid external data for %s %s with TileEntity %s: %s", blockState, Commons.format(world, blockPos), tileEntity, nbtBase));
            return;
        }
        NBTTagList nbtImmersiveEngineering = (NBTTagList)nbtBase;
        World targetWorld = transformation.getTargetWorld();
        if (nbtImmersiveEngineering.func_82582_d()) {
            return;
        }
        if (tileEntity == null) {
            WarpDrive.logger.warn(String.format("Invalid null tile entity for %s %s with external data %s", blockState, Commons.format(world, blockPos), nbtBase));
            return;
        }
        for (int indexConnectionToAdd = 0; indexConnectionToAdd < nbtImmersiveEngineering.func_74745_c(); ++indexConnectionToAdd) {
            ImmersiveNetHandler.Connection connectionToAdd = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)nbtImmersiveEngineering.func_150305_b(indexConnectionToAdd));
            connectionToAdd.start = transformation.apply(connectionToAdd.start);
            connectionToAdd.end = transformation.apply(connectionToAdd.end);
            BlockPos node = tileEntity.func_174877_v();
            Set connectionActuals = ImmersiveNetHandler.INSTANCE.getConnections(tileEntity.func_145831_w(), node);
            boolean existing = false;
            if (connectionActuals != null) {
                for (ImmersiveNetHandler.Connection connectionActual : connectionActuals) {
                    if (connectionActual.start.equals((Object)connectionToAdd.start) && connectionActual.end.equals((Object)connectionToAdd.end)) {
                        existing = true;
                        break;
                    }
                    if (!connectionActual.start.equals((Object)connectionToAdd.end) || !connectionActual.end.equals((Object)connectionToAdd.start)) continue;
                    existing = true;
                    break;
                }
            }
            if (existing) continue;
            ImmersiveNetHandler.INSTANCE.addConnection(targetWorld, connectionToAdd.start, connectionToAdd);
        }
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

