/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatIndustrialForegoing
implements IBlockTransformer {
    private static Class<?> classAxisAlignedBlock;
    private static Class<?> classBlockConveyor;
    private static Class<?> classBlockLabel;
    private static final byte[] rotFacing;
    private static final Map<String, String> rotFacingNames;

    public static void register() {
        try {
            classAxisAlignedBlock = Class.forName("net.ndrei.teslacorelib.blocks.AxisAlignedBlock");
            classBlockConveyor = Class.forName("com.buuz135.industrial.proxy.block.BlockConveyor");
            classBlockLabel = Class.forName("com.buuz135.industrial.proxy.block.BlockLabel");
            WarpDriveConfig.registerBlockTransformer("IndustrialForegoing", new CompatIndustrialForegoing());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classAxisAlignedBlock.isInstance(block) || classBlockConveyor.isInstance(block) || classBlockLabel.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockConveyor.isInstance(block)) {
            if (nbtTileEntity.func_74764_b("Facing")) {
                String facing = nbtTileEntity.func_74779_i("Facing");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74778_a("Facing", rotFacingNames.get(facing));
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74778_a("Facing", rotFacingNames.get(rotFacingNames.get(facing)));
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74778_a("Facing", rotFacingNames.get(rotFacingNames.get(rotFacingNames.get(facing))));
                        break;
                    }
                }
            }
            if (nbtTileEntity.func_74764_b("Upgrades")) {
                NBTTagCompound tagCompoundUpgrades = nbtTileEntity.func_74775_l("Upgrades");
                HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
                for (String string : rotFacingNames.keySet()) {
                    if (!tagCompoundUpgrades.func_74764_b(string)) continue;
                    NBTBase tagBase = tagCompoundUpgrades.func_74781_a(string);
                    switch (rotationSteps) {
                        case 1: {
                            map.put(rotFacingNames.get(string), tagBase);
                            break;
                        }
                        case 2: {
                            map.put(rotFacingNames.get(rotFacingNames.get(string)), tagBase);
                            break;
                        }
                        case 3: {
                            map.put(rotFacingNames.get(rotFacingNames.get(rotFacingNames.get(string))), tagBase);
                            break;
                        }
                        default: {
                            map.put(string, tagBase);
                        }
                    }
                    tagCompoundUpgrades.func_82580_o(string);
                }
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        tagCompoundUpgrades.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
                    }
                }
            }
        }
        switch (rotationSteps) {
            case 1: {
                return rotFacing[metadata];
            }
            case 2: {
                return rotFacing[rotFacing[metadata]];
            }
            case 3: {
                return rotFacing[rotFacing[rotFacing[metadata]]];
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("north", "east");
        map.put("east", "south");
        map.put("south", "west");
        map.put("west", "north");
        rotFacingNames = Collections.unmodifiableMap(map);
    }
}

