/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatIronChest
implements IBlockTransformer {
    private static Class<?> classBlockIronChest;
    private static Class<?> classBlockIronShulkerBox;
    private static final byte[] rotFacing;

    public static void register() {
        try {
            classBlockIronChest = Class.forName("cpw.mods.ironchest.common.blocks.chest.BlockIronChest");
            classBlockIronShulkerBox = Class.forName("cpw.mods.ironchest.common.blocks.shulker.BlockIronShulkerBox");
            WarpDriveConfig.registerBlockTransformer("IronChests", new CompatIronChest());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockIronChest.isInstance(block) || classBlockIronShulkerBox.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            byte facing = nbtTileEntity.func_74771_c("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

