/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatOpenComputers
implements IBlockTransformer {
    private static Class<?> classBlockSimpleBlock;
    private static Class<?> classBlockDiskDrive;
    private static Class<?> classBlockKeyboard;
    private static Class<?> classBlockRaid;
    private static Class<?> classBlockCase;
    private static Class<?> classBlockCharger;
    private static Class<?> classBlockMicrocontroller;
    private static Class<?> classBlockRack;
    private static Class<?> classBlockScreen;
    private static final int[] rotFacing;
    private static final byte[] mrotHorizontal;
    private static final byte[] mrotFull;
    private static final byte[] mrotCase;

    public static void register() {
        try {
            classBlockSimpleBlock = Class.forName("li.cil.oc.common.block.SimpleBlock");
            classBlockDiskDrive = Class.forName("li.cil.oc.common.block.DiskDrive");
            classBlockKeyboard = Class.forName("li.cil.oc.common.block.Keyboard");
            classBlockRaid = Class.forName("li.cil.oc.common.block.Raid");
            classBlockCase = Class.forName("li.cil.oc.common.block.Case");
            classBlockCharger = Class.forName("li.cil.oc.common.block.Charger");
            classBlockMicrocontroller = Class.forName("li.cil.oc.common.block.Microcontroller");
            classBlockRack = Class.forName("li.cil.oc.common.block.Rack");
            classBlockScreen = Class.forName("li.cil.oc.common.block.Screen");
            WarpDriveConfig.registerBlockTransformer("opencomputers", new CompatOpenComputers());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockSimpleBlock.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Nonnull
    private NBTTagList rotate_list(byte rotationSteps, @Nonnull NBTTagList listOldValues) {
        int index;
        NBTTagList listNewValues = new NBTTagList();
        for (index = 0; index < listOldValues.func_74745_c(); ++index) {
            listNewValues.func_74742_a(listOldValues.func_179238_g(index));
        }
        block6: for (index = 0; index < listOldValues.func_74745_c(); ++index) {
            NBTBase nbtValue = listOldValues.func_179238_g(index);
            switch (rotationSteps) {
                case 1: {
                    listNewValues.func_150304_a(rotFacing[index], nbtValue);
                    continue block6;
                }
                case 2: {
                    listNewValues.func_150304_a(rotFacing[rotFacing[index]], nbtValue);
                    continue block6;
                }
                case 3: {
                    listNewValues.func_150304_a(rotFacing[rotFacing[rotFacing[index]]], nbtValue);
                    continue block6;
                }
                default: {
                    listNewValues.func_150304_a(index, nbtValue);
                }
            }
        }
        return listNewValues;
    }

    @Nonnull
    private int[] rotate_intArray(byte rotationSteps, @Nonnull int[] intOldValues) {
        int[] intNewValues = (int[])intOldValues.clone();
        block5: for (int index = 0; index < intOldValues.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    intNewValues[CompatOpenComputers.rotFacing[index]] = intOldValues[index];
                    continue block5;
                }
                case 2: {
                    intNewValues[CompatOpenComputers.rotFacing[CompatOpenComputers.rotFacing[index]]] = intOldValues[index];
                    continue block5;
                }
                case 3: {
                    intNewValues[CompatOpenComputers.rotFacing[CompatOpenComputers.rotFacing[CompatOpenComputers.rotFacing[index]]]] = intOldValues[index];
                    continue block5;
                }
            }
        }
        return intNewValues;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity != null) {
            if (nbtTileEntity.func_150297_b("oc:adapter.blocks", 9)) {
                nbtTileEntity.func_74782_a("oc:adapter.blocks", (NBTBase)this.rotate_list(rotationSteps, nbtTileEntity.func_150295_c("oc:adapter.blocks", 10)));
            }
            if (nbtTileEntity.func_150297_b("oc:rs.bundledInput", 9)) {
                nbtTileEntity.func_74782_a("oc:rs.bundledInput", (NBTBase)this.rotate_list(rotationSteps, nbtTileEntity.func_150295_c("oc:rs.bundledInput", 11)));
            }
            if (nbtTileEntity.func_150297_b("oc:rs.bundledOutput", 9)) {
                nbtTileEntity.func_74782_a("oc:rs.bundledOutput", (NBTBase)this.rotate_list(rotationSteps, nbtTileEntity.func_150295_c("oc:rs.bundledOutput", 11)));
            }
            if (nbtTileEntity.func_150297_b("oc:rs.rednetInput", 9)) {
                nbtTileEntity.func_74782_a("oc:rs.rednetInput", (NBTBase)this.rotate_list(rotationSteps, nbtTileEntity.func_150295_c("oc:rs.rednetInput", 11)));
            }
            if (nbtTileEntity.func_150297_b("oc:rs.input", 11)) {
                nbtTileEntity.func_74783_a("oc:rs.input", this.rotate_intArray(rotationSteps, nbtTileEntity.func_74759_k("oc:rs.input")));
            }
            if (nbtTileEntity.func_150297_b("oc:rs.output", 11)) {
                nbtTileEntity.func_74783_a("oc:rs.output", this.rotate_intArray(rotationSteps, nbtTileEntity.func_74759_k("oc:rs.output")));
            }
            if (nbtTileEntity.func_150297_b("oc:yaw", 3)) {
                int facing = nbtTileEntity.func_74762_e("oc:yaw");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("oc:yaw", rotFacing[facing]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("oc:yaw", rotFacing[rotFacing[facing]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("oc:yaw", rotFacing[rotFacing[rotFacing[facing]]]);
                        break;
                    }
                }
            }
        }
        if (classBlockDiskDrive.isInstance(block) || classBlockRaid.isInstance(block) || classBlockCharger.isInstance(block) || classBlockMicrocontroller.isInstance(block) || classBlockRack.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHorizontal[metadata];
                }
                case 2: {
                    return mrotHorizontal[mrotHorizontal[metadata]];
                }
                case 3: {
                    return mrotHorizontal[mrotHorizontal[mrotHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockKeyboard.isInstance(block) || classBlockScreen.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFull[metadata];
                }
                case 2: {
                    return mrotFull[mrotFull[metadata]];
                }
                case 3: {
                    return mrotFull[mrotFull[mrotFull[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCase.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotCase[metadata];
                }
                case 2: {
                    return mrotCase[mrotCase[metadata]];
                }
                case 3: {
                    return mrotCase[mrotCase[mrotCase[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotHorizontal = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotFull = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
        mrotCase = new byte[]{2, 3, 4, 5, 6, 7, 0, 1, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

