/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatStorageDrawers
implements IBlockTransformer {
    private static Class<?> classBlockController;
    private static Class<?> classBlockDrawers;
    private static Class<?> classBlockFramingTable;
    private static final byte[] rotFacing;
    private static final byte[] rotFramingTable;

    public static void register() {
        try {
            classBlockController = Class.forName("com.jaquadro.minecraft.storagedrawers.block.BlockController");
            classBlockDrawers = Class.forName("com.jaquadro.minecraft.storagedrawers.block.BlockDrawers");
            classBlockFramingTable = Class.forName("com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable");
            WarpDriveConfig.registerBlockTransformer("StorageDrawers", new CompatStorageDrawers());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockController.isInstance(block) || classBlockDrawers.isInstance(block) || classBlockFramingTable.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (classBlockController.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Dir")) {
            byte facing = nbtTileEntity.func_74771_c("Dir");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("Dir", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("Dir", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("Dir", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
            return metadata;
        }
        if (classBlockFramingTable.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFramingTable[metadata];
                }
                case 2: {
                    return rotFramingTable[rotFramingTable[metadata]];
                }
                case 3: {
                    return rotFramingTable[rotFramingTable[rotFramingTable[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFramingTable = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 13, 12, 10, 11, 14, 15};
    }
}

