/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatTConstruct
implements IBlockTransformer {
    private static Class<?> classBlockChannel;
    private static Class<?> classBlockFaucet;
    private static Class<?> classBlockCasting;
    private static Class<?> classBlockToolForge;
    private static Class<?> classBlockToolTable;
    private static Class<?> classBlockRack;
    private static Class<?> classBlockSearedFurnaceController;
    private static Class<?> classBlockSmelteryController;
    private static Class<?> classBlockTinkerTankController;
    private static Class<?> classBlockSlimeChannel;
    private static Class<?> classBlockEnumSmeltery;
    private static Class<?> classBlockSmelteryIO;
    private static Class<?> classBlockStairsBase;
    private static Class<?> classEnumBlockSlab;
    private static final int[] mrotStair;
    private static final int[] mrotFacing;
    private static final int[] mrotHorizontal;
    private static final int[] mrotDrain;
    private static final int[] mrotRack;
    private static final int[] rotSlimeDirection;

    public static void register() {
        try {
            classBlockChannel = Class.forName("slimeknights.tconstruct.smeltery.block.BlockChannel");
            classBlockFaucet = Class.forName("slimeknights.tconstruct.smeltery.block.BlockFaucet");
            classBlockCasting = Class.forName("slimeknights.tconstruct.smeltery.block.BlockCasting");
            classBlockToolForge = Class.forName("slimeknights.tconstruct.tools.common.block.BlockToolForge");
            classBlockToolTable = Class.forName("slimeknights.tconstruct.tools.common.block.BlockToolTable");
            classBlockRack = Class.forName("slimeknights.tconstruct.gadgets.block.BlockRack");
            classBlockSearedFurnaceController = Class.forName("slimeknights.tconstruct.smeltery.block.BlockSearedFurnaceController");
            classBlockSmelteryController = Class.forName("slimeknights.tconstruct.smeltery.block.BlockSmelteryController");
            classBlockTinkerTankController = Class.forName("slimeknights.tconstruct.smeltery.block.BlockTinkerTankController");
            classBlockSlimeChannel = Class.forName("slimeknights.tconstruct.gadgets.block.BlockSlimeChannel");
            classBlockEnumSmeltery = Class.forName("slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery");
            classBlockSmelteryIO = Class.forName("slimeknights.tconstruct.smeltery.block.BlockSmelteryIO");
            classBlockStairsBase = Class.forName("slimeknights.mantle.block.BlockStairsBase");
            classEnumBlockSlab = Class.forName("slimeknights.mantle.block.EnumBlockSlab");
            WarpDriveConfig.registerBlockTransformer("tconstruct", new CompatTConstruct());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockChannel.isInstance(block) || classBlockFaucet.isInstance(block) || classBlockCasting.isInstance(block) || classBlockToolForge.isInstance(block) || classBlockToolTable.isInstance(block) || classBlockRack.isInstance(block) || classBlockSearedFurnaceController.isInstance(block) || classBlockSmelteryController.isInstance(block) || classBlockTinkerTankController.isInstance(block) || classBlockSlimeChannel.isInstance(block) || classBlockEnumSmeltery.isInstance(block) || classBlockStairsBase.isInstance(block) || classEnumBlockSlab.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity != null) {
            if (nbtTileEntity.func_150297_b("ForgeData", 10)) {
                NBTTagCompound nbtForgeData = nbtTileEntity.func_74775_l("ForgeData");
                if (nbtForgeData.func_74764_b("facing")) {
                    int facing = nbtForgeData.func_74762_e("facing");
                    switch (rotationSteps) {
                        case 1: {
                            nbtForgeData.func_74768_a("facing", mrotFacing[facing]);
                            break;
                        }
                        case 2: {
                            nbtForgeData.func_74768_a("facing", mrotFacing[mrotFacing[facing]]);
                            break;
                        }
                        case 3: {
                            nbtForgeData.func_74768_a("facing", mrotFacing[mrotFacing[mrotFacing[facing]]]);
                            break;
                        }
                    }
                }
                if (nbtForgeData.func_74764_b("side") && nbtForgeData.func_74764_b("direction")) {
                    int side = nbtForgeData.func_74762_e("side");
                    switch (rotationSteps) {
                        case 1: {
                            nbtForgeData.func_74768_a("side", mrotFacing[side]);
                            break;
                        }
                        case 2: {
                            nbtForgeData.func_74768_a("side", mrotFacing[mrotFacing[side]]);
                            break;
                        }
                        case 3: {
                            nbtForgeData.func_74768_a("side", mrotFacing[mrotFacing[mrotFacing[side]]]);
                            break;
                        }
                    }
                    if (side == 0 || side == 1) {
                        int direction = nbtForgeData.func_74762_e("direction");
                        switch (rotationSteps) {
                            case 1: {
                                nbtForgeData.func_74768_a("direction", rotSlimeDirection[direction]);
                                break;
                            }
                            case 2: {
                                nbtForgeData.func_74768_a("direction", rotSlimeDirection[rotSlimeDirection[direction]]);
                                break;
                            }
                            case 3: {
                                nbtForgeData.func_74768_a("direction", rotSlimeDirection[rotSlimeDirection[rotSlimeDirection[direction]]]);
                                break;
                            }
                        }
                    }
                }
            }
            if (nbtTileEntity.func_74764_b("connections")) {
                byte[] bytesOldConnections = nbtTileEntity.func_74770_j("connections");
                byte[] bytesNewConnections = (byte[])bytesOldConnections.clone();
                for (int sideOld = 0; sideOld < 4; ++sideOld) {
                    byte byteConnection;
                    bytesNewConnections[(sideOld + rotationSteps) % 4] = byteConnection = bytesOldConnections[sideOld];
                }
                nbtTileEntity.func_74773_a("connections", bytesNewConnections);
            }
            if (nbtTileEntity.func_74767_n("hasMaster")) {
                if (nbtTileEntity.func_150297_b("xCenter", 3) && nbtTileEntity.func_150297_b("yCenter", 3) && nbtTileEntity.func_150297_b("zCenter", 3)) {
                    BlockPos blockPosCenter = transformation.apply(nbtTileEntity.func_74762_e("xCenter"), nbtTileEntity.func_74762_e("yCenter"), nbtTileEntity.func_74762_e("zCenter"));
                    nbtTileEntity.func_74768_a("xCenter", blockPosCenter.func_177958_n());
                    nbtTileEntity.func_74768_a("yCenter", blockPosCenter.func_177956_o());
                    nbtTileEntity.func_74768_a("zCenter", blockPosCenter.func_177952_p());
                } else {
                    WarpDrive.logger.warn(String.format("Missing center coordinates for 'smeltery' component %s:%s %s", block, metadata, nbtTileEntity));
                }
            }
            if (nbtTileEntity.func_74767_n("active")) {
                if (nbtTileEntity.func_150297_b("minPos", 10) && nbtTileEntity.func_150297_b("maxPos", 10)) {
                    NBTTagCompound nbtMinOldPos = nbtTileEntity.func_74775_l("minPos");
                    NBTTagCompound nbtMaxOldPos = nbtTileEntity.func_74775_l("maxPos");
                    if (nbtMinOldPos.func_150297_b("X", 3) && nbtMinOldPos.func_150297_b("Y", 3) && nbtMinOldPos.func_150297_b("Z", 3) && nbtMaxOldPos.func_150297_b("X", 3) && nbtMaxOldPos.func_150297_b("Y", 3) && nbtMaxOldPos.func_150297_b("Z", 3)) {
                        BlockPos blockPosNew1 = transformation.apply(nbtMinOldPos.func_74762_e("X"), nbtMinOldPos.func_74762_e("Y"), nbtMinOldPos.func_74762_e("Z"));
                        BlockPos blockPosNew2 = transformation.apply(nbtMaxOldPos.func_74762_e("X"), nbtMaxOldPos.func_74762_e("Y"), nbtMaxOldPos.func_74762_e("Z"));
                        nbtMinOldPos.func_74768_a("X", Math.min(blockPosNew1.func_177958_n(), blockPosNew2.func_177958_n()));
                        nbtMinOldPos.func_74768_a("Y", Math.min(blockPosNew1.func_177956_o(), blockPosNew2.func_177956_o()));
                        nbtMinOldPos.func_74768_a("Z", Math.min(blockPosNew1.func_177952_p(), blockPosNew2.func_177952_p()));
                        nbtMaxOldPos.func_74768_a("X", Math.max(blockPosNew1.func_177958_n(), blockPosNew2.func_177958_n()));
                        nbtMaxOldPos.func_74768_a("Y", Math.max(blockPosNew1.func_177956_o(), blockPosNew2.func_177956_o()));
                        nbtMaxOldPos.func_74768_a("Z", Math.max(blockPosNew1.func_177952_p(), blockPosNew2.func_177952_p()));
                    } else {
                        WarpDrive.logger.warn(String.format("Missing X/Y/Z components for inner volume of controller %s:%s %s", block, metadata, nbtTileEntity));
                    }
                } else {
                    WarpDrive.logger.warn(String.format("Missing minPos/maxPos compound data for component %s:%s %s", block, metadata, nbtTileEntity));
                }
                if (nbtTileEntity.func_150297_b("tanks", 9)) {
                    NBTTagList listTanks = nbtTileEntity.func_150295_c("tanks", 10);
                    for (int index = 0; index < listTanks.func_74745_c(); ++index) {
                        NBTTagCompound nbtValue = (NBTTagCompound)listTanks.func_179238_g(index);
                        if (nbtValue.func_150297_b("X", 3) && nbtValue.func_150297_b("Y", 3) && nbtValue.func_150297_b("Z", 3)) {
                            BlockPos blockPosNew = transformation.apply(nbtValue.func_74762_e("X"), nbtValue.func_74762_e("Y"), nbtValue.func_74762_e("Z"));
                            nbtValue.func_74768_a("X", blockPosNew.func_177958_n());
                            nbtValue.func_74768_a("Y", blockPosNew.func_177956_o());
                            nbtValue.func_74768_a("Z", blockPosNew.func_177952_p());
                        } else {
                            WarpDrive.logger.warn(String.format("Missing X/Y/Z components for tank#%d of controller %s:%s %s", index, block, metadata, nbtTileEntity));
                        }
                        listTanks.func_150304_a(index, (NBTBase)nbtValue);
                    }
                }
                if (nbtTileEntity.func_150297_b("insidePos", 10)) {
                    NBTTagCompound nbtInsidePos = nbtTileEntity.func_74775_l("insidePos");
                    if (nbtInsidePos.func_150297_b("X", 3) && nbtInsidePos.func_150297_b("Y", 3) && nbtInsidePos.func_150297_b("Z", 3)) {
                        BlockPos blockPosNew = transformation.apply(nbtInsidePos.func_74762_e("X"), nbtInsidePos.func_74762_e("Y"), nbtInsidePos.func_74762_e("Z"));
                        nbtInsidePos.func_74768_a("X", blockPosNew.func_177958_n());
                        nbtInsidePos.func_74768_a("Y", blockPosNew.func_177956_o());
                        nbtInsidePos.func_74768_a("Z", blockPosNew.func_177952_p());
                    } else {
                        WarpDrive.logger.warn(String.format("Missing X/Y/Z components for insidePos of controller %s:%s %s", block, metadata, nbtTileEntity));
                    }
                }
            }
        }
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockRack.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotRack[metadata];
                }
                case 2: {
                    return mrotRack[mrotRack[metadata]];
                }
                case 3: {
                    return mrotRack[mrotRack[mrotRack[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockSearedFurnaceController.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHorizontal[metadata];
                }
                case 2: {
                    return mrotHorizontal[mrotHorizontal[metadata]];
                }
                case 3: {
                    return mrotHorizontal[mrotHorizontal[mrotHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockFaucet.isInstance(block) || classBlockSmelteryController.isInstance(block) || classBlockTinkerTankController.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFacing[metadata];
                }
                case 2: {
                    return mrotFacing[mrotFacing[metadata]];
                }
                case 3: {
                    return mrotFacing[mrotFacing[mrotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockSmelteryIO.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDrain[metadata];
                }
                case 2: {
                    return mrotDrain[mrotDrain[metadata]];
                }
                case 3: {
                    return mrotDrain[mrotDrain[mrotDrain[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockStairsBase.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotStair[metadata];
                }
                case 2: {
                    return mrotStair[mrotStair[metadata]];
                }
                case 3: {
                    return mrotStair[mrotStair[mrotStair[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotStair = new int[]{2, 3, 1, 0, 6, 7, 5, 4, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotHorizontal = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotDrain = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
        mrotRack = new int[]{14, 15, 6, 7, 8, 9, 4, 5, 2, 3, 12, 13, 10, 11, 0, 1};
        rotSlimeDirection = new int[]{2, 3, 4, 5, 6, 7, 0, 1, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

