/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatTechguns
implements IBlockTransformer {
    private static Class<?> classBlockTGDoor3x3;
    private static Class<?> classBlockBasicMachine;
    private static Class<?> classBlockExplosiveCharge;
    private static Class<?> classBlockSimpleMachine;
    private static Class<?> classBlockMultiBlockMachine;
    private static final int[] mrotExplosiveCharge;
    private static final int[] mrotDoor3x3;
    private static final byte[] rotBasicMachine;
    private static final int[] mrotSimpleMachine;
    private static final byte[] rotMultiblockDirection;

    public static void register() {
        try {
            classBlockTGDoor3x3 = Class.forName("techguns.blocks.BlockTGDoor3x3");
            classBlockBasicMachine = Class.forName("techguns.blocks.machines.BasicMachine");
            classBlockExplosiveCharge = Class.forName("techguns.blocks.machines.BlockExplosiveCharge");
            classBlockSimpleMachine = Class.forName("techguns.blocks.machines.SimpleMachine");
            classBlockMultiBlockMachine = Class.forName("techguns.blocks.machines.MultiBlockMachine");
            WarpDriveConfig.registerBlockTransformer("Techguns", new CompatTechguns());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockTGDoor3x3.isInstance(block) || classBlockBasicMachine.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (classBlockTGDoor3x3.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDoor3x3[metadata];
                }
                case 2: {
                    return mrotDoor3x3[mrotDoor3x3[metadata]];
                }
                case 3: {
                    return mrotDoor3x3[mrotDoor3x3[mrotDoor3x3[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockBasicMachine.isInstance(block) && !classBlockExplosiveCharge.isInstance(block) && !classBlockSimpleMachine.isInstance(block) && !classBlockMultiBlockMachine.isInstance(block) && nbtTileEntity != null) {
            if (nbtTileEntity.func_74764_b("rotation")) {
                byte rotation = nbtTileEntity.func_74771_c("rotation");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotBasicMachine[rotation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotBasicMachine[rotBasicMachine[rotation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("turretDeath")) {
                nbtTileEntity.func_74757_a("turretDeath", true);
                nbtTileEntity.func_74768_a("repairTime", 0);
            }
        }
        if (classBlockExplosiveCharge.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotExplosiveCharge[metadata];
                }
                case 2: {
                    return mrotExplosiveCharge[mrotExplosiveCharge[metadata]];
                }
                case 3: {
                    return mrotExplosiveCharge[mrotExplosiveCharge[mrotExplosiveCharge[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockSimpleMachine.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotSimpleMachine[metadata];
                }
                case 2: {
                    return mrotSimpleMachine[mrotSimpleMachine[metadata]];
                }
                case 3: {
                    return mrotSimpleMachine[mrotSimpleMachine[mrotSimpleMachine[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockMultiBlockMachine.isInstance(block) && nbtTileEntity != null) {
            if (nbtTileEntity.func_74764_b("hasMaster") && nbtTileEntity.func_74767_n("hasMaster")) {
                int xMaster = nbtTileEntity.func_74762_e("masterX");
                int yMaster = nbtTileEntity.func_74762_e("masterY");
                int zMaster = nbtTileEntity.func_74762_e("masterZ");
                BlockPos chunkCoordinatesMaster = transformation.apply(xMaster, yMaster, zMaster);
                nbtTileEntity.func_74768_a("masterX", chunkCoordinatesMaster.func_177958_n());
                nbtTileEntity.func_74768_a("masterY", chunkCoordinatesMaster.func_177956_o());
                nbtTileEntity.func_74768_a("masterZ", chunkCoordinatesMaster.func_177952_p());
            } else if (nbtTileEntity.func_74764_b("multiblockDirection")) {
                byte rotation = nbtTileEntity.func_74771_c("multiblockDirection");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("multiblockDirection", rotMultiblockDirection[rotation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("multiblockDirection", rotMultiblockDirection[rotMultiblockDirection[rotation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("multiblockDirection", rotMultiblockDirection[rotMultiblockDirection[rotMultiblockDirection[rotation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotExplosiveCharge = new int[]{0, 1, 2, 3, 10, 11, 8, 9, 4, 5, 6, 7, 12, 13, 14, 15};
        mrotDoor3x3 = new int[]{4, 1, 2, 3, 0, 5, 6, 7, 12, 9, 10, 11, 8, 13, 14, 15};
        rotBasicMachine = new byte[]{1, 2, 3, 0};
        mrotSimpleMachine = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
        rotMultiblockDirection = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 14, 13, 11, 12, 15};
    }
}

