/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatUndergroundBiomes
implements IBlockTransformer {
    private static Class<?> classBlockUBStoneButton;
    private static Class<?> classBlockUBStoneStairs;
    private static final Map<String, String> rotFacingNames;

    public static void register() {
        try {
            classBlockUBStoneButton = Class.forName("exterminatorjeff.undergroundbiomes.common.block.button.UBStoneButton");
            classBlockUBStoneStairs = Class.forName("exterminatorjeff.undergroundbiomes.common.block.stairs.UBStoneStairs");
            WarpDriveConfig.registerBlockTransformer("UndergroundBiomesConstructs", new CompatUndergroundBiomes());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockUBStoneButton.isInstance(block) || classBlockUBStoneStairs.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        String facingNew;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return;
        }
        ResourceLocation registryNameOld = blockState.func_177230_c().getRegistryName();
        assert (registryNameOld != null);
        String pathOld = registryNameOld.func_110623_a();
        int indexSeparator = pathOld.lastIndexOf(95);
        if (indexSeparator < 0) {
            WarpDrive.logger.error(String.format("Invalid registry name for UndergroundBiomes blocks, unable to proceed with rotation: %s", registryNameOld));
            return;
        }
        String facing = pathOld.substring(indexSeparator + 1);
        if (!rotFacingNames.containsKey(facing)) {
            return;
        }
        String pathNoFacing = pathOld.substring(0, indexSeparator + 1);
        switch (rotationSteps) {
            case 1: {
                facingNew = rotFacingNames.get(facing);
                break;
            }
            case 2: {
                facingNew = rotFacingNames.get(rotFacingNames.get(facing));
                break;
            }
            case 3: {
                facingNew = rotFacingNames.get(rotFacingNames.get(rotFacingNames.get(facing)));
                break;
            }
            default: {
                facingNew = facing;
            }
        }
        ResourceLocation registryNameNew = new ResourceLocation(registryNameOld.func_110624_b(), pathNoFacing + facingNew);
        Block blockNew = (Block)Block.field_149771_c.func_82594_a((Object)registryNameNew);
        if (blockNew == Blocks.field_150350_a) {
            WarpDrive.logger.error(String.format("Invalid new registry name for UndergroundBiomes, unable to proceed with rotation: old is %s, new is %s", registryNameOld, registryNameNew));
            return;
        }
        IBlockState blockStateNew = blockNew.func_176203_a(blockState.func_177230_c().func_176201_c(blockState));
        world.func_180501_a(blockPos, blockStateNew, 2);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("north", "east");
        map.put("east", "south");
        map.put("south", "west");
        map.put("west", "north");
        rotFacingNames = Collections.unmodifiableMap(map);
    }
}

