/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatVariedCommodities
implements IBlockTransformer {
    private static Class<?> classBlockBasicContainer;
    private static Class<?> classBlockBlood;
    private static Class<?> classBlockCarpentryBench;
    private static final int[] mrotCarpentryBench;
    private static final int[] rot4;
    private static final int[] rot8;

    public static void register() {
        try {
            classBlockBasicContainer = Class.forName("noppes.vc.blocks.BlockBasicContainer");
            classBlockBlood = Class.forName("noppes.vc.blocks.BlockBlood");
            classBlockCarpentryBench = Class.forName("noppes.vc.blocks.BlockCarpentryBench");
            WarpDriveConfig.registerBlockTransformer("VariedCommodities", new CompatVariedCommodities());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBasicContainer.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("BannerRotation")) {
            int[] rot;
            String idTileEntity;
            switch (idTileEntity = nbtTileEntity.func_74779_i("id")) {
                case "variedcommodities:barrel": 
                case "variedcommodities:campfire": 
                case "variedcommodities:candle": 
                case "variedcommodities:lamp": {
                    rot = rot8;
                    break;
                }
                default: {
                    rot = rot4;
                }
            }
            int BannerRotation = nbtTileEntity.func_74762_e("BannerRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("BannerRotation", rot[BannerRotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("BannerRotation", rot[rot[BannerRotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("BannerRotation", rot[rot[rot[BannerRotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockCarpentryBench.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotCarpentryBench[metadata];
                }
                case 2: {
                    return mrotCarpentryBench[mrotCarpentryBench[metadata]];
                }
                case 3: {
                    return mrotCarpentryBench[mrotCarpentryBench[mrotCarpentryBench[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("SignRotation")) {
            int SignRotation = nbtTileEntity.func_74762_e("SignRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("SignRotation", rot4[SignRotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("SignRotation", rot4[rot4[SignRotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("SignRotation", rot4[rot4[rot4[SignRotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockBlood.isInstance(block) && nbtTileEntity != null) {
            boolean HideNorth = nbtTileEntity.func_74767_n("HideNorth");
            boolean HideEast = nbtTileEntity.func_74767_n("HideEast");
            boolean HideSouth = nbtTileEntity.func_74767_n("HideSouth");
            boolean HideWest = nbtTileEntity.func_74767_n("HideWest");
            int Rotation2 = nbtTileEntity.func_74762_e("Rotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74757_a("HideNorth", HideWest);
                    nbtTileEntity.func_74757_a("HideEast", HideNorth);
                    nbtTileEntity.func_74757_a("HideSouth", HideEast);
                    nbtTileEntity.func_74757_a("HideWest", HideSouth);
                    nbtTileEntity.func_74768_a("Rotation", rot4[Rotation2]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74757_a("HideNorth", HideSouth);
                    nbtTileEntity.func_74757_a("HideEast", HideWest);
                    nbtTileEntity.func_74757_a("HideSouth", HideNorth);
                    nbtTileEntity.func_74757_a("HideWest", HideEast);
                    nbtTileEntity.func_74768_a("Rotation", rot4[rot4[Rotation2]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74757_a("HideNorth", HideEast);
                    nbtTileEntity.func_74757_a("HideEast", HideSouth);
                    nbtTileEntity.func_74757_a("HideSouth", HideWest);
                    nbtTileEntity.func_74757_a("HideWest", HideNorth);
                    nbtTileEntity.func_74768_a("Rotation", rot4[rot4[rot4[Rotation2]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotCarpentryBench = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
        rot4 = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rot8 = new int[]{2, 3, 4, 5, 6, 7, 0, 1, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

