/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.breathing.BlockAirFlow;
import cr0s.warpdrive.block.breathing.BlockAirSource;
import cr0s.warpdrive.block.detection.TileEntityCloakingCore;
import cr0s.warpdrive.block.hull.BlockHullSlab;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatWarpDrive
implements IBlockTransformer {
    private static final short[] mrotDirection = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final short[] mrotHorizontalSpinning = new short[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 12, 13, 14, 15};
    private static final short[] mrotHullSlab = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 15, 14};

    public static void register() {
        WarpDriveConfig.registerBlockTransformer("WarpDrive", new CompatWarpDrive());
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return block instanceof BlockAbstractBase || block instanceof BlockAbstractContainer;
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        if (tileEntity instanceof TileEntityCloakingCore && ((TileEntityCloakingCore)tileEntity).getIsEnabled()) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.cloaking_field_overlapping", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (block instanceof BlockAirFlow || block instanceof BlockAirSource) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData == null) {
                return null;
            }
            int dataAir = chunkData.getDataAir(x, y, z);
            if (dataAir == 0x60000C0) {
                return null;
            }
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("dataAir", dataAir);
            return tagCompound;
        }
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (block instanceof BlockAirFlow || block instanceof BlockAirSource) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData == null) {
                return;
            }
            chunkData.setDataAir(x, y, z, 0x60000C0);
        }
        if (tileEntity instanceof IGlobalRegionProvider) {
            GlobalRegionManager.removeFromRegistry((IGlobalRegionProvider)tileEntity);
        }
    }

    private byte[] rotate_byteArray(byte rotationSteps, byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatWarpDrive.mrotDirection[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        IBlockState blockState;
        byte rotationSteps = transformation.getRotationSteps();
        if (block instanceof BlockHullSlab) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHullSlab[metadata];
                }
                case 2: {
                    return mrotHullSlab[mrotHullSlab[metadata]];
                }
                case 3: {
                    return mrotHullSlab[mrotHullSlab[mrotHullSlab[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity != null) {
            if (nbtTileEntity.func_74764_b("modeSide")) {
                nbtTileEntity.func_74773_a("modeSide", this.rotate_byteArray(rotationSteps, nbtTileEntity.func_74770_j("modeSide")));
            }
            if (nbtTileEntity.func_74764_b("reactorFace") && rotationSteps != 0) {
                String reactorFaceOriginal = nbtTileEntity.func_74779_i("reactorFace");
                Pattern patternFacing = Pattern.compile("(laser\\.[a-z]+\\.)([a-z]+)([+-]*)");
                Matcher matcher = patternFacing.matcher(reactorFaceOriginal);
                if (!matcher.matches()) {
                    throw new RuntimeException(String.format("Failed to parse reactor facing %s: unrecognized format", reactorFaceOriginal));
                }
                String prefix = matcher.group(1);
                String nameFacing = matcher.group(2);
                String suffix = matcher.group(3);
                EnumFacing enumFacing = EnumFacing.func_176739_a((String)nameFacing);
                if (enumFacing == null) {
                    throw new RuntimeException(String.format("Failed to parse reactor facing %s: unrecognized facing %s", reactorFaceOriginal, nameFacing));
                }
                switch (rotationSteps) {
                    case 1: {
                        enumFacing = enumFacing.func_176746_e();
                        break;
                    }
                    case 2: {
                        enumFacing = enumFacing.func_176746_e().func_176746_e();
                        break;
                    }
                    case 3: {
                        enumFacing = enumFacing.func_176746_e().func_176746_e().func_176746_e();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                String reactorFaceUpdated = prefix + enumFacing.name().toLowerCase() + suffix;
                nbtTileEntity.func_74778_a("reactorFace", reactorFaceUpdated);
            }
        }
        if ((blockState = block.func_176203_a(metadata)).func_177228_b().containsKey(BlockProperties.HORIZONTAL_SPINNING)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHorizontalSpinning[metadata];
                }
                case 2: {
                    return mrotHorizontalSpinning[mrotHorizontalSpinning[metadata]];
                }
                case 3: {
                    return mrotHorizontalSpinning[mrotHorizontalSpinning[mrotHorizontalSpinning[metadata]]];
                }
            }
            return metadata;
        }
        if (blockState.func_177228_b().containsKey((Object)BlockProperties.FACING) || blockState.func_177228_b().containsKey((Object)BlockProperties.FACING_HORIZONTAL)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDirection[metadata & 7] | metadata & 8;
                }
                case 2: {
                    return mrotDirection[mrotDirection[metadata & 7]] | metadata & 8;
                }
                case 3: {
                    return mrotDirection[mrotDirection[mrotDirection[metadata & 7]]] | metadata & 8;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        if (nbtBase == null) {
            return;
        }
        if (!(nbtBase instanceof NBTTagCompound)) {
            return;
        }
        if (((NBTTagCompound)nbtBase).func_74764_b("dataAir")) {
            byte rotationSteps = transformation.getRotationSteps();
            int dataAir = ((NBTTagCompound)nbtBase).func_74762_e("dataAir");
            ChunkData chunkData = ChunkHandler.getChunkData(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            if (chunkData == null) {
                return;
            }
            int dataAirRotated = StateAir.rotate(dataAir, rotationSteps);
            chunkData.setDataAir(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), dataAirRotated);
        }
    }
}

