/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.XmlRandomCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class GenericSetManager<E extends IXmlRepresentableUnit>
extends XmlFileManager {
    private final String prefixFilename;
    private final String nameElementUnit;
    private final String nameElementSet;
    private final E unitDefault;
    private HashMap<String, XmlRandomCollection<GenericSet<E>>> genericSetsByGroup;

    public GenericSetManager(String prefixFilename, String nameElementUnit, String nameElementSet, E unitDefault) {
        this.prefixFilename = prefixFilename;
        this.nameElementUnit = nameElementUnit;
        this.nameElementSet = nameElementSet;
        this.unitDefault = unitDefault;
    }

    public void load(File dir) {
        this.genericSetsByGroup = new HashMap();
        this.load(dir, this.prefixFilename, this.nameElementSet);
        this.propagateGenericSets();
    }

    @Override
    protected void parseRootElement(String location, Element elementGenericSet) throws InvalidXmlException {
        XmlRandomCollection xmlRandomCollection;
        GenericSet<E> genericSet;
        String group = elementGenericSet.getAttribute("group");
        if (group.isEmpty()) {
            throw new InvalidXmlException(location + " is missing a group attribute!");
        }
        String name = elementGenericSet.getAttribute("name");
        if (name.isEmpty()) {
            throw new InvalidXmlException(location + " is missing a name attribute!");
        }
        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
            WarpDrive.logger.info(String.format("- found %s %s:%s", this.nameElementSet, group, name));
        }
        if ((genericSet = (GenericSet<E>)(xmlRandomCollection = this.genericSetsByGroup.computeIfAbsent(group, k -> new XmlRandomCollection())).getNamedEntry(name)) == null) {
            genericSet = new GenericSet<E>(group, name, this.unitDefault, this.nameElementUnit);
        }
        xmlRandomCollection.loadFromXML(genericSet, elementGenericSet);
    }

    private void propagateGenericSets() {
        HashMap<GenericSet, ArrayList> genericSetsDependencies = new HashMap<GenericSet, ArrayList>();
        for (XmlRandomCollection<GenericSet<E>> genericSets : this.genericSetsByGroup.values()) {
            for (GenericSet genericSet : genericSets.elements()) {
                ArrayList dependencies = genericSetsDependencies.computeIfAbsent(genericSet, k -> new ArrayList());
                dependencies.addAll(genericSet.getImportGroupNames());
            }
        }
        int iterationCount = 0;
        while (!genericSetsDependencies.isEmpty() && iterationCount++ < 10) {
            HashMap genericSetsLeftToImport = new HashMap();
            for (Map.Entry entry : genericSetsDependencies.entrySet()) {
                ArrayList<String> newDependencies = new ArrayList<String>();
                for (String dependency : (ArrayList)entry.getValue()) {
                    GenericSet<E> genericSet = this.getGenericSet(dependency);
                    if (genericSet == null) {
                        WarpDrive.logger.error(String.format("Ignoring missing %s %s dependency in %s %s", this.nameElementSet, dependency, this.nameElementSet, entry.getKey()));
                        continue;
                    }
                    if (genericSetsDependencies.containsKey(genericSet)) {
                        newDependencies.add(dependency);
                        continue;
                    }
                    try {
                        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                            WarpDrive.logger.info(String.format("Importing %s %s in %s ", this.nameElementSet, genericSet.getFullName(), ((GenericSet)entry.getKey()).getFullName()));
                        }
                        ((GenericSet)entry.getKey()).loadFrom(genericSet);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        WarpDrive.logger.error(String.format("While importing %s into %s %s", dependency, this.nameElementSet, ((GenericSet)entry.getKey()).getFullName()));
                    }
                }
                if (newDependencies.isEmpty()) continue;
                genericSetsLeftToImport.put(entry.getKey(), newDependencies);
            }
            genericSetsDependencies = genericSetsLeftToImport;
        }
        if (!genericSetsDependencies.isEmpty()) {
            WarpDrive.logger.error("Too many import recursions, ignoring the remaining ones:");
            for (Map.Entry entry : genericSetsDependencies.entrySet()) {
                WarpDrive.logger.warn(String.format("- %s %s is pending:", this.nameElementSet, entry.getKey()));
                for (String dependency : (ArrayList)entry.getValue()) {
                    WarpDrive.logger.warn(String.format(" + %s", dependency));
                }
            }
        }
    }

    public boolean doesGroupExist(String groupName) {
        return this.genericSetsByGroup.get(groupName) != null;
    }

    public GenericSet<E> getRandomSetFromGroup(Random random, String groupName) {
        XmlRandomCollection<GenericSet<E>> group = this.genericSetsByGroup.get(groupName);
        if (group == null) {
            WarpDrive.logger.warn(String.format("Invalid group %s, try one of %s", groupName, StringUtils.join(this.genericSetsByGroup.keySet(), (String)", ")));
            return null;
        }
        return (GenericSet)group.getRandomEntry(random);
    }

    public GenericSet<E> getGenericSet(String groupAndName) {
        String[] parts = groupAndName.split(":");
        if (parts.length != 2) {
            WarpDrive.logger.error(String.format("Invalid %s '%s'. Expecting '{group}:{name}'", this.nameElementSet, groupAndName));
            return null;
        }
        XmlRandomCollection<GenericSet<E>> group = this.genericSetsByGroup.get(parts[0]);
        if (group == null) {
            return null;
        }
        return (GenericSet)group.getNamedEntry(parts[1]);
    }
}

