/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.compat.CompatActuallyAdditions;
import cr0s.warpdrive.compat.CompatAdvancedRepulsionSystems;
import cr0s.warpdrive.compat.CompatAppliedEnergistics2;
import cr0s.warpdrive.compat.CompatArsMagica2;
import cr0s.warpdrive.compat.CompatBiblioCraft;
import cr0s.warpdrive.compat.CompatBlockcraftery;
import cr0s.warpdrive.compat.CompatBotania;
import cr0s.warpdrive.compat.CompatBuildCraft;
import cr0s.warpdrive.compat.CompatCarpentersBlocks;
import cr0s.warpdrive.compat.CompatComputerCraft;
import cr0s.warpdrive.compat.CompatCustomNPCs;
import cr0s.warpdrive.compat.CompatDecocraft;
import cr0s.warpdrive.compat.CompatDeepResonance;
import cr0s.warpdrive.compat.CompatDraconicEvolution;
import cr0s.warpdrive.compat.CompatEmbers;
import cr0s.warpdrive.compat.CompatEnderIO;
import cr0s.warpdrive.compat.CompatEnvironmentalTech;
import cr0s.warpdrive.compat.CompatEvilCraft;
import cr0s.warpdrive.compat.CompatExtraUtilities2;
import cr0s.warpdrive.compat.CompatForgeMultipart;
import cr0s.warpdrive.compat.CompatGalacticraft;
import cr0s.warpdrive.compat.CompatGregTech;
import cr0s.warpdrive.compat.CompatImmersiveEngineering;
import cr0s.warpdrive.compat.CompatIndustrialCraft2;
import cr0s.warpdrive.compat.CompatIndustrialForegoing;
import cr0s.warpdrive.compat.CompatIronChest;
import cr0s.warpdrive.compat.CompatMekanism;
import cr0s.warpdrive.compat.CompatMetalChests;
import cr0s.warpdrive.compat.CompatMysticalAgriculture;
import cr0s.warpdrive.compat.CompatNatura;
import cr0s.warpdrive.compat.CompatOpenComputers;
import cr0s.warpdrive.compat.CompatParziStarWars;
import cr0s.warpdrive.compat.CompatPneumaticCraft;
import cr0s.warpdrive.compat.CompatRealFilingCabinet;
import cr0s.warpdrive.compat.CompatRedstonePaste;
import cr0s.warpdrive.compat.CompatRefinedStorage;
import cr0s.warpdrive.compat.CompatRoots;
import cr0s.warpdrive.compat.CompatRustic;
import cr0s.warpdrive.compat.CompatSGCraft;
import cr0s.warpdrive.compat.CompatStorageDrawers;
import cr0s.warpdrive.compat.CompatTConstruct;
import cr0s.warpdrive.compat.CompatTechguns;
import cr0s.warpdrive.compat.CompatThaumcraft;
import cr0s.warpdrive.compat.CompatThermalDynamics;
import cr0s.warpdrive.compat.CompatThermalExpansion;
import cr0s.warpdrive.compat.CompatUndergroundBiomes;
import cr0s.warpdrive.compat.CompatVariedCommodities;
import cr0s.warpdrive.compat.CompatWarpDrive;
import cr0s.warpdrive.compat.CompatWoot;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSetManager;
import cr0s.warpdrive.config.Loot;
import cr0s.warpdrive.config.ShipMovementCosts;
import cr0s.warpdrive.config.WarpDriveDataFixer;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumDisplayAlignment;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.EnumTooltipCondition;
import cr0s.warpdrive.network.PacketHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class WarpDriveConfig {
    private static final boolean unused = false;
    private static String stringConfigDirectory;
    private static File fileConfigDirectory;
    private static DocumentBuilder xmlDocumentBuilder;
    private static final String[] defaultXML_fillerSets;
    private static final String[] defaultXML_lootSets;
    private static final String[] defaultXML_schematicSets;
    private static final String[] defaultXML_structures;
    private static final String[] defaultXML_celestialObjects;
    private static final String[] defaultSchematics;
    public static GenericSetManager<Filler> FillerManager;
    public static GenericSetManager<Loot> LootManager;
    public static boolean isAdvancedRepulsionSystemLoaded;
    public static boolean isRedstoneFluxLoaded;
    public static boolean isComputerCraftLoaded;
    public static boolean isCCTweakedLoaded;
    public static boolean isEnderIOLoaded;
    public static boolean isForgeMultipartLoaded;
    public static boolean isGregtechLoaded;
    public static boolean isICBMClassicLoaded;
    public static boolean isIndustrialCraft2Loaded;
    public static boolean isMatterOverdriveLoaded;
    public static boolean isNotEnoughItemsLoaded;
    public static boolean isOpenComputersLoaded;
    public static boolean isThermalExpansionLoaded;
    public static boolean isThermalFoundationLoaded;
    public static ItemStack IC2_compressedAir;
    public static ItemStack IC2_emptyCell;
    public static Block IC2_rubberWood;
    public static ItemStack IC2_Resin;
    public static int G_SPACE_BIOME_ID;
    public static int G_SPACE_PROVIDER_ID;
    public static int G_HYPERSPACE_PROVIDER_ID;
    public static int G_ENTITY_SPHERE_GENERATOR_ID;
    public static int G_ENTITY_STAR_CORE_ID;
    public static int G_ENTITY_CAMERA_ID;
    public static int G_ENTITY_PARTICLE_BUNCH_ID;
    public static int G_ENTITY_LASER_EXPLODER_ID;
    public static int G_ENTITY_NPC_ID;
    public static int G_ENTITY_OFFLINE_AVATAR_ID;
    public static int G_ENTITY_SEAT_ID;
    public static final int LUA_SCRIPTS_NONE = 0;
    public static final int LUA_SCRIPTS_TEMPLATES = 1;
    public static final int LUA_SCRIPTS_ALL = 2;
    public static int G_LUA_SCRIPTS;
    public static String G_SCHEMATICS_LOCATION;
    private static int G_ASSEMBLY_SCAN_INTERVAL_SECONDS;
    public static int G_ASSEMBLY_SCAN_INTERVAL_TICKS;
    public static int G_PARAMETERS_UPDATE_INTERVAL_TICKS;
    private static int G_REGISTRY_UPDATE_INTERVAL_SECONDS;
    public static int G_REGISTRY_UPDATE_INTERVAL_TICKS;
    public static boolean G_ENFORCE_VALID_CELESTIAL_OBJECTS;
    public static int G_BLOCKS_PER_TICK;
    public static boolean G_ENABLE_FAST_SET_BLOCKSTATE;
    public static boolean G_ENABLE_PROTECTION_CHECKS;
    public static boolean G_ENABLE_EXPERIMENTAL_REFRESH;
    public static boolean G_ENABLE_EXPERIMENTAL_UNLOAD;
    public static int G_MINIMUM_DIMENSION_UNLOAD_QUEUE_DELAY;
    public static boolean G_ENABLE_FORGE_CHUNK_MANAGER;
    public static float G_BLAST_RESISTANCE_CAP;
    public static boolean CLIENT_BREATHING_OVERLAY_FORCED;
    public static float CLIENT_LOCATION_SCALE;
    public static String CLIENT_LOCATION_NAME_PREFIX;
    public static int CLIENT_LOCATION_BACKGROUND_COLOR;
    public static int CLIENT_LOCATION_TEXT_COLOR;
    public static boolean CLIENT_LOCATION_HAS_SHADOW;
    public static EnumDisplayAlignment CLIENT_LOCATION_SCREEN_ALIGNMENT;
    public static int CLIENT_LOCATION_SCREEN_OFFSET_X;
    public static int CLIENT_LOCATION_SCREEN_OFFSET_Y;
    public static EnumDisplayAlignment CLIENT_LOCATION_TEXT_ALIGNMENT;
    public static float CLIENT_LOCATION_WIDTH_RATIO;
    public static int CLIENT_LOCATION_WIDTH_MIN;
    public static EnumTooltipCondition TOOLTIP_ENABLE_DEDUPLICATION;
    public static String[] TOOLTIP_CLEANUP_LIST;
    public static EnumTooltipCondition TOOLTIP_ADD_REGISTRY_NAME;
    public static EnumTooltipCondition TOOLTIP_ADD_ORE_DICTIONARY_NAME;
    public static EnumTooltipCondition TOOLTIP_ADD_ARMOR_POINTS;
    public static EnumTooltipCondition TOOLTIP_ADD_BLOCK_MATERIAL;
    public static EnumTooltipCondition TOOLTIP_ADD_BURN_TIME;
    public static EnumTooltipCondition TOOLTIP_ADD_DURABILITY;
    public static EnumTooltipCondition TOOLTIP_ADD_ENCHANTABILITY;
    public static EnumTooltipCondition TOOLTIP_ADD_ENTITY_ID;
    public static EnumTooltipCondition TOOLTIP_ADD_FLAMMABILITY;
    public static EnumTooltipCondition TOOLTIP_ADD_FLUID;
    public static EnumTooltipCondition TOOLTIP_ADD_HARDNESS;
    public static EnumTooltipCondition TOOLTIP_ADD_HARVESTING;
    public static EnumTooltipCondition TOOLTIP_ADD_OPACITY;
    public static EnumTooltipCondition TOOLTIP_ADD_REPAIR_WITH;
    public static long LOGGING_THROTTLE_MS;
    public static boolean LOGGING_JUMP;
    public static boolean LOGGING_JUMPBLOCKS;
    public static boolean LOGGING_ENERGY;
    public static boolean LOGGING_EFFECTS;
    public static boolean LOGGING_CLOAKING;
    public static boolean LOGGING_VIDEO_CHANNEL;
    public static boolean LOGGING_TARGETING;
    public static boolean LOGGING_WEAPON;
    public static boolean LOGGING_CAMERA;
    public static boolean LOGGING_BUILDING;
    public static boolean LOGGING_COLLECTION;
    public static boolean LOGGING_TRANSPORTER;
    public static boolean LOGGING_LUA;
    public static boolean LOGGING_RADAR;
    public static boolean LOGGING_BREATHING;
    public static boolean LOGGING_WORLD_GENERATION;
    public static boolean LOGGING_PROFILING_CPU_USAGE;
    public static boolean LOGGING_PROFILING_MEMORY_ALLOCATION;
    public static boolean LOGGING_PROFILING_THREAD_SAFETY;
    public static boolean LOGGING_DICTIONARY;
    public static boolean LOGGING_GLOBAL_REGION_REGISTRY;
    public static boolean LOGGING_BREAK_PLACE;
    public static boolean LOGGING_FORCE_FIELD;
    public static boolean LOGGING_FORCE_FIELD_REGISTRY;
    public static boolean LOGGING_ACCELERATOR;
    public static boolean LOGGING_XML_PREPROCESSOR;
    public static boolean LOGGING_RENDERING;
    public static boolean LOGGING_CHUNK_HANDLER;
    public static boolean LOGGING_CHUNK_RELOADING;
    public static boolean LOGGING_CHUNK_LOADING;
    public static boolean LOGGING_ENTITY_FX;
    public static boolean LOGGING_CLIENT_SYNCHRONIZATION;
    public static boolean LOGGING_GRAVITY;
    public static boolean LOGGING_OFFLINE_AVATAR;
    public static String ENERGY_DISPLAY_UNITS;
    public static boolean ENERGY_ENABLE_IC2_EU;
    public static boolean ENERGY_ENABLE_FE;
    public static boolean ENERGY_ENABLE_GTCE_EU;
    public static boolean ENERGY_ENABLE_RF;
    public static float ENERGY_OVERVOLTAGE_SHOCK_FACTOR;
    public static float ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR;
    public static int ENERGY_SCAN_INTERVAL_TICKS;
    public static int SPACE_GENERATOR_Y_MIN_CENTER;
    public static int SPACE_GENERATOR_Y_MAX_CENTER;
    public static int SPACE_GENERATOR_Y_MIN_BORDER;
    public static int SPACE_GENERATOR_Y_MAX_BORDER;
    public static ShipMovementCosts.Factors[] SHIP_MOVEMENT_COSTS_FACTORS;
    public static int[] SHIP_MAX_ENERGY_STORED_BY_TIER;
    public static int[] SHIP_MASS_MAX_BY_TIER;
    public static int[] SHIP_MASS_MIN_BY_TIER;
    public static int SHIP_MASS_MAX_ON_PLANET_SURFACE;
    public static int SHIP_MASS_MIN_FOR_HYPERSPACE;
    public static int[] SHIP_SIZE_MAX_PER_SIDE_BY_TIER;
    public static int SHIP_COLLISION_TOLERANCE_BLOCKS;
    public static int SHIP_WARMUP_RANDOM_TICKS;
    public static int SHIP_VOLUME_SCAN_BLOCKS_PER_TICK;
    public static int SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS;
    public static String[] SHIP_MASS_UNLIMITED_PLAYER_NAMES;
    public static int[] JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER;
    public static int BIOMETRIC_SCANNER_DURATION_TICKS;
    public static int BIOMETRIC_SCANNER_RANGE_BLOCKS;
    public static int CAMERA_IMAGE_RECOGNITION_INTERVAL_TICKS;
    public static int CAMERA_RANGE_BASE_BLOCKS;
    public static int CAMERA_RANGE_UPGRADE_BLOCKS;
    public static int CAMERA_RANGE_UPGRADE_MAX_QUANTITY;
    public static boolean OFFLINE_AVATAR_ENABLE;
    public static boolean OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS;
    public static boolean OFFLINE_AVATAR_FORGET_ON_DEATH;
    public static float OFFLINE_AVATAR_MODEL_SCALE;
    public static boolean OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG;
    public static float OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL;
    public static float OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL;
    public static int OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS;
    public static int OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS;
    public static int RADAR_MAX_ENERGY_STORED;
    public static int RADAR_SCAN_MIN_ENERGY_COST;
    public static double[] RADAR_SCAN_ENERGY_COST_FACTORS;
    public static int RADAR_SCAN_MIN_DELAY_SECONDS;
    public static double[] RADAR_SCAN_DELAY_FACTORS_SECONDS;
    public static int RADAR_MAX_ISOLATION_RANGE;
    public static int RADAR_MIN_ISOLATION_BLOCKS;
    public static int RADAR_MAX_ISOLATION_BLOCKS;
    public static double RADAR_MIN_ISOLATION_EFFECT;
    public static double RADAR_MAX_ISOLATION_EFFECT;
    public static float[] SIREN_RANGE_BLOCKS_BY_TIER;
    public static float[] SPEAKER_RANGE_BLOCKS_BY_TIER;
    public static float SPEAKER_QUEUE_MAX_MESSAGES;
    public static float SPEAKER_RATE_MAX_MESSAGES;
    public static int SPEAKER_RATE_PERIOD_TICKS;
    public static int SS_MAX_DEPLOY_RADIUS_BLOCKS;
    public static int SS_SEARCH_INTERVAL_TICKS;
    public static int SS_SCAN_BLOCKS_PER_SECOND;
    public static int SS_DEPLOY_BLOCKS_PER_INTERVAL;
    public static int SS_DEPLOY_INTERVAL_TICKS;
    public static int[] VIRTUAL_ASSISTANT_ENERGY_PER_TICK_BY_TIER;
    public static boolean VIRTUAL_ASSISTANT_HIDE_COMMANDS_IN_CHAT;
    public static int[] VIRTUAL_ASSISTANT_MAX_ENERGY_STORED_BY_TIER;
    public static float[] VIRTUAL_ASSISTANT_RANGE_BLOCKS_BY_TIER;
    public static int[] LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER;
    public static double[] LASER_MEDIUM_FACTOR_BY_TIER;
    public static int LASER_CANNON_MAX_MEDIUMS_COUNT;
    public static int LASER_CANNON_MAX_LASER_ENERGY;
    public static int LASER_CANNON_EMIT_FIRE_DELAY_TICKS;
    public static int LASER_CANNON_EMIT_SCAN_DELAY_TICKS;
    public static double LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK;
    public static int LASER_CANNON_RANGE_MAX;
    public static int LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY;
    public static int LASER_CANNON_ENTITY_HIT_BASE_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_MAX_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MIN;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MAX;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH;
    public static int MINING_LASER_MAX_MEDIUMS_COUNT;
    public static int MINING_LASER_RADIUS_NO_LASER_MEDIUM;
    public static int MINING_LASER_RADIUS_PER_LASER_MEDIUM;
    public static int MINING_LASER_SETUP_UPDATE_PARAMETERS_TICKS;
    public static int MINING_LASER_WARMUP_DELAY_TICKS;
    public static int MINING_LASER_SCAN_DELAY_TICKS;
    public static int MINING_LASER_MINE_DELAY_TICKS;
    public static int MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_VOID;
    public static int MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_ATMOSPHERE;
    public static int MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_VOID;
    public static int MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_ATMOSPHERE;
    public static double MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR;
    public static double MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR;
    public static int MINING_LASER_MINE_SILKTOUCH_DEUTERIUM_MB;
    public static double MINING_LASER_MINE_FORTUNE_ENERGY_FACTOR;
    public static int TREE_FARM_MAX_MEDIUMS_COUNT;
    public static int TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM;
    public static int TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM;
    public static int TREE_FARM_totalMaxRadius;
    public static int TREE_FARM_MAX_DISTANCE_NO_LASER_MEDIUM;
    public static int TREE_FARM_MAX_DISTANCE_PER_MEDIUM;
    public static int TREE_FARM_WARM_UP_DELAY_TICKS;
    public static int TREE_FARM_SCAN_DELAY_TICKS;
    public static int TREE_FARM_HARVEST_LOG_DELAY_TICKS;
    public static int TREE_FARM_BREAK_LEAF_DELAY_TICKS;
    public static int TREE_FARM_SILKTOUCH_LEAF_DELAY_TICKS;
    public static int TREE_FARM_TAP_WET_SPOT_DELAY_TICKS;
    public static int TREE_FARM_TAP_DRY_SPOT_DELAY_TICKS;
    public static int TREE_FARM_TAP_RUBBER_LOG_DELAY_TICKS;
    public static int TREE_FARM_PLANT_DELAY_TICKS;
    public static int TREE_FARM_SCAN_ENERGY_PER_SURFACE;
    public static int TREE_FARM_TAP_WET_SPOT_ENERGY_PER_BLOCK;
    public static int TREE_FARM_TAP_RUBBER_LOG_ENERGY_PER_BLOCK;
    public static int TREE_FARM_HARVEST_LOG_ENERGY_PER_BLOCK;
    public static int TREE_FARM_HARVEST_LEAF_ENERGY_PER_BLOCK;
    public static int TREE_FARM_SILKTOUCH_LOG_ENERGY_PER_BLOCK;
    public static int TREE_FARM_SILKTOUCH_LEAF_ENERGY_PER_BLOCK;
    public static int TREE_FARM_PLANT_ENERGY_PER_BLOCK;
    public static int CLOAKING_MAX_ENERGY_STORED;
    public static int CLOAKING_COIL_CAPTURE_BLOCKS;
    public static int CLOAKING_MAX_FIELD_RADIUS;
    public static int CLOAKING_TIER1_ENERGY_PER_BLOCK;
    public static int CLOAKING_TIER2_ENERGY_PER_BLOCK;
    public static int CLOAKING_TIER1_FIELD_REFRESH_INTERVAL_TICKS;
    public static int CLOAKING_TIER2_FIELD_REFRESH_INTERVAL_TICKS;
    public static int CLOAKING_VOLUME_SCAN_BLOCKS_PER_TICK;
    public static int CLOAKING_VOLUME_SCAN_AGE_TOLERANCE_SECONDS;
    public static int BREATHING_ENERGY_PER_CANISTER;
    public static int[] BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER;
    public static int[] BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER;
    public static int[] BREATHING_MAX_ENERGY_STORED_BY_TIER;
    public static int BREATHING_AIR_GENERATION_TICKS;
    public static int[] BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER;
    public static int BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS;
    public static int BREATHING_AIR_SIMULATION_DELAY_TICKS;
    public static final boolean BREATHING_AIR_BLOCK_DEBUG = false;
    public static boolean BREATHING_AIR_AT_ENTITY_DEBUG;
    public static int BREATHING_AIR_TANK_BREATH_DURATION_TICKS;
    public static int[] BREATHING_AIR_TANK_CAPACITY_BY_TIER;
    public static int IC2_REACTOR_MAX_HEAT_STORED;
    public static int IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_COOLING_PER_INTERVAL;
    public static double IC2_REACTOR_ENERGY_PER_HEAT;
    public static int IC2_REACTOR_COOLING_INTERVAL_TICKS;
    public static int TRANSPORTER_MAX_ENERGY_STORED;
    public static int TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS;
    public static int TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS;
    public static int TRANSPORTER_RANGE_BASE_BLOCKS;
    public static int TRANSPORTER_RANGE_UPGRADE_BLOCKS;
    public static int TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY;
    public static double[] TRANSPORTER_LOCKING_ENERGY_FACTORS;
    public static double TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK;
    public static double TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
    public static double TRANSPORTER_LOCKING_STRENGTH_AT_BEACON;
    public static double TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER;
    public static double TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR;
    public static double TRANSPORTER_LOCKING_STRENGTH_UPGRADE;
    public static double TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
    public static double TRANSPORTER_LOCKING_SPEED_AT_BEACON;
    public static double TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER;
    public static double TRANSPORTER_LOCKING_SPEED_UPGRADE;
    public static int TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS;
    public static int TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY;
    public static int TRANSPORTER_JAMMED_COOLDOWN_TICKS;
    public static double[] TRANSPORTER_ENERGIZING_ENERGY_FACTORS;
    public static double TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR;
    public static int TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE;
    public static double TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS;
    public static int TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE;
    public static double TRANSPORTER_ENERGIZING_LOCKING_LOST;
    public static int TRANSPORTER_ENERGIZING_CHARGING_TICKS;
    public static int TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
    public static double TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
    public static int TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS;
    public static int TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS;
    public static int TRANSPORTER_BEACON_MAX_ENERGY_STORED;
    public static int TRANSPORTER_BEACON_ENERGY_PER_TICK;
    public static int TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS;
    public static int[] ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER;
    public static final int ENAN_REACTOR_UPDATE_INTERVAL_TICKS = 5;
    public static final int ENAN_REACTOR_FREEZE_INTERVAL_TICKS = 40;
    public static int[] ENAN_REACTOR_MAX_LASERS_PER_SECOND;
    public static int[] ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER;
    public static int[] ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER;
    public static int[] ENAN_REACTOR_EXPLOSION_MAX_RADIUS_BY_TIER;
    public static double[] ENAN_REACTOR_EXPLOSION_MAX_REMOVAL_CHANCE_BY_TIER;
    public static int[] ENAN_REACTOR_EXPLOSION_COUNT_BY_TIER;
    public static float[] ENAN_REACTOR_EXPLOSION_STRENGTH_MIN_BY_TIER;
    public static float[] ENAN_REACTOR_EXPLOSION_STRENGTH_MAX_BY_TIER;
    public static int[] FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER;
    public static double FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE;
    public static double FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED;
    public static double FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP;
    public static int[] CAPACITOR_MAX_ENERGY_STORED_BY_TIER;
    public static String[] CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER;
    public static String[] CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER;
    public static int[] CAPACITOR_FLUX_RATE_INPUT_BY_TIER;
    public static int[] CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER;
    public static double[] CAPACITOR_EFFICIENCY_PER_UPGRADE;
    public static int LIFT_MAX_ENERGY_STORED;
    public static int LIFT_ENERGY_PER_ENTITY;
    public static int LIFT_UPDATE_INTERVAL_TICKS;
    public static int LIFT_ENTITY_COOLDOWN_TICKS;
    public static int CHUNK_LOADER_MAX_ENERGY_STORED;
    public static int CHUNK_LOADER_MAX_RADIUS;
    public static int CHUNK_LOADER_ENERGY_PER_CHUNK;
    public static float[] HULL_HARDNESS;
    public static float[] HULL_BLAST_RESISTANCE;
    public static int[] HULL_HARVEST_LEVEL;
    public static HashMap<String, IBlockTransformer> blockTransformers;
    public static boolean ACCELERATOR_ENABLE;
    public static final double[] ACCELERATOR_TEMPERATURES_K;
    public static final double ACCELERATOR_THRESHOLD_DEFAULT = 0.95;
    public static int ACCELERATOR_MAX_PARTICLE_BUNCHES;
    public static int[] ELECTROMAGNETIC_CELL_CAPACITY_BY_TIER;
    public static int[] PLASMA_TORCH_CAPACITY_BY_TIER;

    @Nonnull
    public static Block getBlockOrFire(@Nonnull String registryName) {
        ResourceLocation resourceLocation = new ResourceLocation(registryName);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
        if (block == Blocks.field_150350_a) {
            WarpDrive.logger.error(String.format("Failed to get mod block for %s", registryName));
            return Blocks.field_150480_ab;
        }
        return block;
    }

    @Nonnull
    public static ItemStack getItemStackOrFire(@Nonnull String registryName, int meta, String stringNBT) {
        Object object = WarpDriveConfig.getOreOrItemStackOrNull(registryName, meta);
        if (!(object instanceof ItemStack)) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = (ItemStack)object;
        if (stringNBT == null || stringNBT.isEmpty()) {
            return itemStack;
        }
        try {
            NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)stringNBT);
            itemStack.func_77982_d(tagCompound);
        }
        catch (NBTException exception) {
            WarpDrive.logger.error(exception.getMessage());
            exception.printStackTrace((PrintStream)WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Invalid NBT for %s@%d %s", registryName, meta, stringNBT));
            return ItemStack.field_190927_a;
        }
        return itemStack;
    }

    @Nonnull
    public static ItemStack getItemStackOrFire(@Nonnull String registryName, int meta) {
        return WarpDriveConfig.getItemStackOrFire(registryName, meta, "");
    }

    @Nullable
    private static Object getOreOrItemStackOrNull(@Nonnull String registryName, int meta) {
        ItemStack itemStack;
        assert (registryName.contains(":"));
        if (registryName.startsWith("ore:")) {
            String ore = registryName.substring(4);
            if (OreDictionary.doesOreNameExist((String)ore) && !OreDictionary.getOres((String)ore).isEmpty()) {
                return ore;
            }
            WarpDrive.logger.info(String.format("Skipping missing ore dictionary entry %s", ore));
            return null;
        }
        ResourceLocation resourceLocation = new ResourceLocation(registryName);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation);
        if (item == null) {
            WarpDrive.logger.info(String.format("Skipping missing mod item %s@%d", registryName, meta));
            return null;
        }
        try {
            if (meta == -1) {
                itemStack = new ItemStack(item);
            } else {
                itemStack = new ItemStack(item, 1, meta);
                if (itemStack.func_77960_j() != meta) {
                    throw new RuntimeException(String.format("Invalid meta value found %d, expected %d", itemStack.func_77960_j(), meta));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Failed to get mod item for %s@%d", registryName, meta));
            return null;
        }
        return itemStack;
    }

    public static Object getOreOrItemStack(String registryName1, int meta1, Object ... args) {
        assert (args.length % 2 == 0);
        for (int index = 0; index < args.length; index += 2) {
            assert (args[index] instanceof String);
            assert (((String)args[index]).contains(":"));
            assert (args[index + 1] instanceof Integer);
        }
        Object object = WarpDriveConfig.getOreOrItemStackOrNull(registryName1, meta1);
        if (object != null) {
            return object;
        }
        for (int index = 0; index < args.length; index += 2) {
            object = WarpDriveConfig.getOreOrItemStackOrNull((String)args[index], (Integer)args[index + 1]);
            if (object == null) continue;
            return object;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getOreDictionaryEntry(String ore) {
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            WarpDrive.logger.info(String.format("Skipping missing ore named %s", ore));
            return ItemStack.field_190927_a;
        }
        NonNullList itemStacks = OreDictionary.getOres((String)ore);
        if (itemStacks.isEmpty()) {
            WarpDrive.logger.error(String.format("Failed to get item from empty ore dictionary %s", ore));
            return ItemStack.field_190927_a;
        }
        return (ItemStack)itemStacks.get(0);
    }

    protected static double[] getDoubleList(@Nonnull Configuration config, String category, String key, String comment, double[] valuesDefault) {
        double[] valuesRead = config.get(category, key, valuesDefault, comment).getDoubleList();
        if (valuesRead.length != valuesDefault.length) {
            valuesRead = (double[])valuesDefault.clone();
        }
        return valuesRead;
    }

    public static void reload(@Nonnull MinecraftServer server) {
        CelestialObjectManager.clearForReload(false);
        WarpDriveConfig.onFMLpreInitialization(stringConfigDirectory);
        WarpDriveConfig.onFMLPostInitialization();
        List entityPlayers = server.func_184103_al().func_181057_v();
        for (EntityPlayerMP entityPlayerMP : entityPlayers) {
            if (entityPlayerMP instanceof FakePlayer) continue;
            CelestialObject celestialObject = CelestialObjectManager.get(entityPlayerMP.field_70170_p, MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v));
            PacketHandler.sendClientSync(entityPlayerMP, celestialObject);
        }
    }

    public static void onFMLpreInitialization(String stringConfigDirectory) {
        WarpDriveConfig.stringConfigDirectory = stringConfigDirectory;
        fileConfigDirectory = new File(stringConfigDirectory, "warpdrive");
        fileConfigDirectory.mkdir();
        if (!fileConfigDirectory.isDirectory()) {
            throw new RuntimeException(String.format("Unable to create config directory %s", fileConfigDirectory));
        }
        WarpDriveConfig.unpackResourcesToFolder("fillerSets", ".xml", defaultXML_fillerSets, "config", fileConfigDirectory);
        WarpDriveConfig.unpackResourcesToFolder("lootSets", ".xml", defaultXML_lootSets, "config", fileConfigDirectory);
        WarpDriveConfig.unpackResourcesToFolder("schematicSets", ".xml", defaultXML_schematicSets, "config", fileConfigDirectory);
        WarpDriveConfig.unpackResourcesToFolder("structures", ".xml", defaultXML_structures, "config", fileConfigDirectory);
        WarpDriveConfig.unpackResourcesToFolder("celestialObjects", ".xml", defaultXML_celestialObjects, "config", fileConfigDirectory);
        WarpDriveConfig.unpackResourceToFolder("WarpDrive.xsd", "config", fileConfigDirectory);
        WarpDriveConfig.loadConfig(new File(fileConfigDirectory, "config.yml"));
        WarpDriveConfig.loadDictionary(new File(fileConfigDirectory, "dictionary.yml"));
        WarpDriveConfig.loadDataFixer(new File(fileConfigDirectory, "dataFixer.yml"));
        CelestialObjectManager.load(fileConfigDirectory);
        File fileSchematicsDirectory = new File(G_SCHEMATICS_LOCATION);
        fileSchematicsDirectory.mkdir();
        if (!fileSchematicsDirectory.isDirectory()) {
            throw new RuntimeException(String.format("Unable to create schematic directory %s", fileSchematicsDirectory));
        }
        WarpDriveConfig.unpackResourcesToFolder("default", ".schematic", defaultSchematics, "schematics", fileSchematicsDirectory);
        isRedstoneFluxLoaded = Loader.isModLoaded((String)"redstoneflux");
        isComputerCraftLoaded = Loader.isModLoaded((String)"computercraft");
        isCCTweakedLoaded = Loader.isModLoaded((String)"cctweaked");
        isEnderIOLoaded = Loader.isModLoaded((String)"enderio");
        isGregtechLoaded = Loader.isModLoaded((String)"gregtech");
        isIndustrialCraft2Loaded = Loader.isModLoaded((String)"ic2");
        isOpenComputersLoaded = Loader.isModLoaded((String)"opencomputers");
        isAdvancedRepulsionSystemLoaded = Loader.isModLoaded((String)"AdvancedRepulsionSystems");
        isForgeMultipartLoaded = Loader.isModLoaded((String)"forgemultipartcbe");
        isICBMClassicLoaded = Loader.isModLoaded((String)"icbmclassic");
        isMatterOverdriveLoaded = Loader.isModLoaded((String)"matteroverdrive");
        isNotEnoughItemsLoaded = Loader.isModLoaded((String)"NotEnoughItems");
        isThermalExpansionLoaded = Loader.isModLoaded((String)"thermalexpansion");
        isThermalFoundationLoaded = Loader.isModLoaded((String)"thermalfoundation");
    }

    public static void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        G_SPACE_BIOME_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_biome_id", G_SPACE_BIOME_ID, "Space biome ID").getInt());
        G_SPACE_PROVIDER_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_provider_id", G_SPACE_PROVIDER_ID, "Space dimension provider ID").getInt());
        G_HYPERSPACE_PROVIDER_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "hyperspace_provider_id", G_HYPERSPACE_PROVIDER_ID, "Hyperspace dimension provider ID").getInt());
        G_ENTITY_SPHERE_GENERATOR_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_sphere_generator_id", G_ENTITY_SPHERE_GENERATOR_ID, "Entity sphere generator ID").getInt());
        G_ENTITY_STAR_CORE_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_star_core_id", G_ENTITY_STAR_CORE_ID, "Entity star core ID").getInt());
        G_ENTITY_CAMERA_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_camera_id", G_ENTITY_CAMERA_ID, "Entity camera ID").getInt());
        G_ENTITY_PARTICLE_BUNCH_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_particle_bunch_id", G_ENTITY_PARTICLE_BUNCH_ID, "Entity particle bunch ID").getInt());
        G_ENTITY_LASER_EXPLODER_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_laser_exploder_id", G_ENTITY_LASER_EXPLODER_ID, "Entity laser exploder ID").getInt());
        G_ENTITY_NPC_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_NPC_id", G_ENTITY_NPC_ID, "Entity NPC ID").getInt());
        G_ENTITY_OFFLINE_AVATAR_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_offline_avatar_id", G_ENTITY_OFFLINE_AVATAR_ID, "Entity offline avatar ID").getInt());
        G_ENTITY_SEAT_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_seat_id", G_ENTITY_SEAT_ID, "Entity seat ID").getInt());
        G_LUA_SCRIPTS = Commons.clamp(0, 2, config.get("general", "lua_scripts", G_LUA_SCRIPTS, "LUA scripts to load when connecting machines: 0 = none, 1 = templates in a subfolder, 2 = ready to roll (templates are still provided)").getInt());
        G_SCHEMATICS_LOCATION = config.get("general", "schematics_location", G_SCHEMATICS_LOCATION, "Root folder where to load and save ship schematics").getString();
        G_ASSEMBLY_SCAN_INTERVAL_SECONDS = Commons.clamp(0, 300, config.get("general", "assembly_scanning_interval", G_ASSEMBLY_SCAN_INTERVAL_SECONDS, "Reaction delay when updating blocks in an assembly (measured in seconds)").getInt());
        G_ASSEMBLY_SCAN_INTERVAL_TICKS = 20 * G_ASSEMBLY_SCAN_INTERVAL_SECONDS;
        G_PARAMETERS_UPDATE_INTERVAL_TICKS = Commons.clamp(0, 300, config.get("general", "parameters_update_interval", G_PARAMETERS_UPDATE_INTERVAL_TICKS, "Complex computation delay in an assembly (measured in ticks)").getInt());
        G_REGISTRY_UPDATE_INTERVAL_SECONDS = Commons.clamp(0, 300, config.get("general", "registry_update_interval", G_REGISTRY_UPDATE_INTERVAL_SECONDS, "Registration period for an assembly (measured in seconds)").getInt());
        G_REGISTRY_UPDATE_INTERVAL_TICKS = 20 * G_REGISTRY_UPDATE_INTERVAL_SECONDS;
        G_ENFORCE_VALID_CELESTIAL_OBJECTS = config.get("general", "enforce_valid_celestial_objects", G_ENFORCE_VALID_CELESTIAL_OBJECTS, "Disable to boot the game even when celestial objects are invalid. Use at your own risk!").getBoolean();
        G_BLOCKS_PER_TICK = Commons.clamp(100, 100000, config.get("general", "blocks_per_tick", G_BLOCKS_PER_TICK, "Number of blocks to move per ticks, too high will cause lag spikes on ship jumping or deployment, too low may break the ship wirings").getInt());
        G_ENABLE_FAST_SET_BLOCKSTATE = config.get("general", "enable_fast_set_blockstate", G_ENABLE_FAST_SET_BLOCKSTATE, "Enable fast blockstate placement, skipping light computation. Disable if you have world implementations conflicts").getBoolean(G_ENABLE_FAST_SET_BLOCKSTATE);
        G_ENABLE_PROTECTION_CHECKS = config.get("general", "enable_protection_checks", G_ENABLE_PROTECTION_CHECKS, "Enable area protection checks from other mods or plugins, disable if you use the event system exclusively").getBoolean(G_ENABLE_PROTECTION_CHECKS);
        G_ENABLE_EXPERIMENTAL_REFRESH = config.get("general", "enable_experimental_refresh", G_ENABLE_EXPERIMENTAL_REFRESH, "Enable experimental refresh during jump to prevent duping, use at your own risk").getBoolean(G_ENABLE_EXPERIMENTAL_REFRESH);
        G_ENABLE_EXPERIMENTAL_UNLOAD = config.get("general", "enable_experimental_unload", G_ENABLE_EXPERIMENTAL_UNLOAD, "Enable experimental tile entity unloading during jump to force a cleanup, required for IC2 Classic, may cause issues with other mods").getBoolean(G_ENABLE_EXPERIMENTAL_UNLOAD);
        G_MINIMUM_DIMENSION_UNLOAD_QUEUE_DELAY = Commons.clamp(0, 1000, config.get("general", "minimum_dimension_unload_queue_delay_ticks", G_MINIMUM_DIMENSION_UNLOAD_QUEUE_DELAY, "Enforce a minimum value for Forge's dimensionUnloadQueueDelay to fix various dimension transition issues from unloading the world too soon (set below 100 at your own risk)").getInt());
        ForgeModContainer.dimensionUnloadQueueDelay = Math.max(ForgeModContainer.dimensionUnloadQueueDelay, G_MINIMUM_DIMENSION_UNLOAD_QUEUE_DELAY);
        WarpDrive.logger.info(String.format("Forge's dimensionUnloadQueueDelay is set to %d ticks", ForgeModContainer.dimensionUnloadQueueDelay));
        if (ForgeModContainer.dimensionUnloadQueueDelay < 100) {
            FMLLog.bigWarning((String)"Forge's dimensionUnloadQueueDelay is lower than 100 ticks, world transitions won't work properly!", (Object[])new Object[0]);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        G_ENABLE_FORGE_CHUNK_MANAGER = config.get("general", "enable_forge_chunk_manager", G_ENABLE_FORGE_CHUNK_MANAGER, "Enable automatic configuration of Forge's ChunkManager for WarpDrive. Disable to control manually WarpDrive specific settings.").getBoolean(G_ENABLE_FORGE_CHUNK_MANAGER);
        G_BLAST_RESISTANCE_CAP = Commons.clamp(10.0f, 6000.0f, (float)config.get("general", "blast_resistance_cap", (double)G_BLAST_RESISTANCE_CAP, "Maximum allowed blast resistance for non-hull, breakable blocks from other mods. Required to fix non-sense scaling in modded fluids, etc. Default is basic hull resistance (60).").getDouble((double)G_BLAST_RESISTANCE_CAP));
        CLIENT_BREATHING_OVERLAY_FORCED = config.get("client", "breathing_overlay_forced", CLIENT_BREATHING_OVERLAY_FORCED, "Force rendering the breathing overlay to compensate HUD modifications").getBoolean(false);
        CLIENT_LOCATION_SCALE = Commons.clamp(0.25f, 4.0f, (float)config.get("client", "location_scale", (double)CLIENT_LOCATION_SCALE, "Scale for location text font").getDouble());
        CLIENT_LOCATION_NAME_PREFIX = config.get("client", "location_name_prefix", CLIENT_LOCATION_NAME_PREFIX, "Prefix for location name, useful to add formatting").getString();
        String stringValue = config.get("client", "location_background_color", String.format("0x%6X", CLIENT_LOCATION_BACKGROUND_COLOR), "Hexadecimal color code for location background (0xAARRGGBB where AA is alpha, RR is Red, GG is Green and BB is Blue component)").getString();
        CLIENT_LOCATION_BACKGROUND_COLOR = (int)(Long.decode(stringValue) & 0xFFFFFFFFL);
        stringValue = config.get("client", "location_text_color", String.format("0x%6X", CLIENT_LOCATION_TEXT_COLOR), "Hexadecimal color code for location foreground (0xAARRGGBB where AA is alpha, RR is Red, GG is Green and BB is Blue component)").getString();
        CLIENT_LOCATION_TEXT_COLOR = (int)(Long.decode(stringValue) & 0xFFFFFFFFL);
        CLIENT_LOCATION_HAS_SHADOW = config.get("client", "location_has_shadow", CLIENT_LOCATION_HAS_SHADOW, "Shadow casting option for current celestial object name").getBoolean(CLIENT_LOCATION_HAS_SHADOW);
        CLIENT_LOCATION_SCREEN_ALIGNMENT = EnumDisplayAlignment.valueOf(config.get("client", "location_screen_alignment", CLIENT_LOCATION_SCREEN_ALIGNMENT.name(), "Alignment on screen: TOP_LEFT, TOP_CENTER, TOP_RIGHT, MIDDLE_LEFT, MIDDLE_CENTER, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER or BOTTOM_RIGHT").getString());
        CLIENT_LOCATION_SCREEN_OFFSET_X = config.get("client", "location_offset_x", CLIENT_LOCATION_SCREEN_OFFSET_X, "Horizontal offset on screen, increase to move to the right").getInt();
        CLIENT_LOCATION_SCREEN_OFFSET_Y = config.get("client", "location_offset_y", CLIENT_LOCATION_SCREEN_OFFSET_Y, "Vertical offset on screen, increase to move down").getInt();
        CLIENT_LOCATION_TEXT_ALIGNMENT = EnumDisplayAlignment.valueOf(config.get("client", "location_text_alignment", CLIENT_LOCATION_TEXT_ALIGNMENT.name(), "Text alignment: TOP_LEFT, TOP_CENTER, TOP_RIGHT, MIDDLE_LEFT, MIDDLE_CENTER, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER or BOTTOM_RIGHT").getString());
        CLIENT_LOCATION_WIDTH_RATIO = (float)config.get("client", "location_width_ratio", (double)CLIENT_LOCATION_WIDTH_RATIO, "Text width as a ratio of full screen width").getDouble();
        CLIENT_LOCATION_WIDTH_MIN = config.get("client", "location_width_min", CLIENT_LOCATION_WIDTH_MIN, "Text width as a minimum 'pixel' count").getInt();
        String commentTooltip = "When to show %s in tooltips. Valid values are " + EnumTooltipCondition.formatAllValues() + ".";
        TOOLTIP_ADD_REGISTRY_NAME = EnumTooltipCondition.valueOf(config.get("tooltip", "add_registry_name", TOOLTIP_ADD_REGISTRY_NAME.name(), String.format(commentTooltip, "registry name")).getString());
        TOOLTIP_ADD_ORE_DICTIONARY_NAME = EnumTooltipCondition.valueOf(config.get("tooltip", "add_ore_dictionary_name", TOOLTIP_ADD_ORE_DICTIONARY_NAME.name(), String.format(commentTooltip, "ore dictionary names")).getString());
        TOOLTIP_ADD_ARMOR_POINTS = EnumTooltipCondition.valueOf(config.get("tooltip", "add_armor_points", TOOLTIP_ADD_ARMOR_POINTS.name(), String.format(commentTooltip, "armor points")).getString());
        TOOLTIP_ADD_BLOCK_MATERIAL = EnumTooltipCondition.valueOf(config.get("tooltip", "add_block_material", TOOLTIP_ADD_BLOCK_MATERIAL.name(), String.format(commentTooltip, "block material")).getString());
        TOOLTIP_ADD_BURN_TIME = EnumTooltipCondition.valueOf(config.get("tooltip", "add_burn_time", TOOLTIP_ADD_BURN_TIME.name(), String.format(commentTooltip, "burn time")).getString());
        TOOLTIP_ADD_DURABILITY = EnumTooltipCondition.valueOf(config.get("tooltip", "add_durability", TOOLTIP_ADD_DURABILITY.name(), String.format(commentTooltip, "durability")).getString());
        TOOLTIP_ADD_ENCHANTABILITY = EnumTooltipCondition.valueOf(config.get("tooltip", "add_enchantability", TOOLTIP_ADD_ENCHANTABILITY.name(), String.format(commentTooltip, "armor & tool enchantability")).getString());
        TOOLTIP_ADD_ENTITY_ID = EnumTooltipCondition.valueOf(config.get("tooltip", "add_entity_id", TOOLTIP_ADD_ENTITY_ID.name(), String.format(commentTooltip, "entity id")).getString());
        TOOLTIP_ADD_FLAMMABILITY = EnumTooltipCondition.valueOf(config.get("tooltip", "add_flammability", TOOLTIP_ADD_FLAMMABILITY.name(), String.format(commentTooltip, "flammability")).getString());
        TOOLTIP_ADD_FLUID = EnumTooltipCondition.valueOf(config.get("tooltip", "add_fluid_stats", TOOLTIP_ADD_FLUID.name(), String.format(commentTooltip, "fluid stats")).getString());
        TOOLTIP_ADD_HARDNESS = EnumTooltipCondition.valueOf(config.get("tooltip", "add_hardness", TOOLTIP_ADD_HARDNESS.name(), String.format(commentTooltip, "hardness & explosion resistance")).getString());
        TOOLTIP_ADD_HARVESTING = EnumTooltipCondition.valueOf(config.get("tooltip", "add_harvesting_stats", TOOLTIP_ADD_HARVESTING.name(), String.format(commentTooltip, "harvesting stats")).getString());
        TOOLTIP_ADD_OPACITY = EnumTooltipCondition.valueOf(config.get("tooltip", "add_opacity", TOOLTIP_ADD_OPACITY.name(), String.format(commentTooltip, "opacity")).getString());
        TOOLTIP_ADD_REPAIR_WITH = EnumTooltipCondition.valueOf(config.get("tooltip", "add_repair_material", TOOLTIP_ADD_REPAIR_WITH.name(), String.format(commentTooltip, "repair material")).getString());
        TOOLTIP_CLEANUP_LIST = config.get("tooltip", "cleanup_list", TOOLTIP_CLEANUP_LIST, "List of lines to remove from tooltips before adding ours. This can be a partial match in a line. Must be lowercase without formatting.").getStringList();
        for (int index = 0; index < TOOLTIP_CLEANUP_LIST.length; ++index) {
            String old = TOOLTIP_CLEANUP_LIST[index];
            WarpDriveConfig.TOOLTIP_CLEANUP_LIST[index] = Commons.removeFormatting(old).toLowerCase();
        }
        TOOLTIP_ENABLE_DEDUPLICATION = EnumTooltipCondition.valueOf(config.get("tooltip", "enable_deduplication", TOOLTIP_ENABLE_DEDUPLICATION.name(), String.format("When to remove duplicate lines in tooltips. Valid values are %s.", EnumTooltipCondition.formatAllValues())).getString());
        LOGGING_THROTTLE_MS = Commons.clamp(0L, 600000L, config.get("logging", "throttle_ms", (double)LOGGING_THROTTLE_MS, "How many milliseconds to wait before logging another occurrence in a time sensitive section of the mod (rendering, events, etc.)").getLong(LOGGING_THROTTLE_MS));
        LOGGING_JUMP = config.get("logging", "enable_jump_logs", LOGGING_JUMP, "Basic jump logs, should always be enabled").getBoolean(true);
        LOGGING_JUMPBLOCKS = config.get("logging", "enable_jumpblocks_logs", LOGGING_JUMPBLOCKS, "Detailed jump logs to help debug the mod, will spam your logs...").getBoolean(false);
        LOGGING_ENERGY = config.get("logging", "enable_energy_logs", LOGGING_ENERGY, "Detailed energy logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        if (WarpDrive.isDev) {
            LOGGING_EFFECTS = config.get("logging", "enable_effects_logs", LOGGING_EFFECTS, "Detailed effects logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_CLOAKING = config.get("logging", "enable_cloaking_logs", LOGGING_CLOAKING, "Detailed cloaking logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_VIDEO_CHANNEL = config.get("logging", "enable_videoChannel_logs", LOGGING_VIDEO_CHANNEL, "Detailed video channel logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_TARGETING = config.get("logging", "enable_targeting_logs", LOGGING_TARGETING, "Detailed targeting logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_CLIENT_SYNCHRONIZATION = config.get("logging", "enable_client_synchronization_logs", LOGGING_CLIENT_SYNCHRONIZATION, "Detailed client synchronization logs to help debug the mod.").getBoolean(false);
        } else {
            LOGGING_EFFECTS = false;
            LOGGING_CLOAKING = false;
            LOGGING_VIDEO_CHANNEL = false;
            LOGGING_TARGETING = false;
            LOGGING_CLIENT_SYNCHRONIZATION = false;
        }
        LOGGING_WEAPON = config.get("logging", "enable_weapon_logs", LOGGING_WEAPON, "Detailed weapon logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_CAMERA = config.get("logging", "enable_camera_logs", LOGGING_CAMERA, "Detailed camera logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BUILDING = config.get("logging", "enable_building_logs", LOGGING_BUILDING, "Detailed building logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_COLLECTION = config.get("logging", "enable_collection_logs", LOGGING_COLLECTION, "Detailed collection logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_TRANSPORTER = config.get("logging", "enable_transporter_logs", LOGGING_TRANSPORTER, "Detailed transporter logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_LUA = config.get("logging", "enable_LUA_logs", LOGGING_LUA, "Detailed LUA logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_RADAR = config.get("logging", "enable_radar_logs", LOGGING_RADAR, "Detailed radar logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BREATHING = config.get("logging", "enable_breathing_logs", LOGGING_BREATHING, "Detailed breathing logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_WORLD_GENERATION = config.get("logging", "enable_world_generation_logs", LOGGING_WORLD_GENERATION, "Detailed world generation logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_PROFILING_CPU_USAGE = config.get("logging", "enable_profiling_CPU_time", LOGGING_PROFILING_CPU_USAGE, "Profiling logs for CPU time, enable it to check for lag").getBoolean(true);
        LOGGING_PROFILING_MEMORY_ALLOCATION = config.get("logging", "enable_profiling_memory_allocation", LOGGING_PROFILING_MEMORY_ALLOCATION, "Profiling logs for memory allocation, enable it to check for lag").getBoolean(true);
        LOGGING_PROFILING_THREAD_SAFETY = config.get("logging", "enable_profiling_thread_safety", LOGGING_PROFILING_THREAD_SAFETY, "Profiling logs for multi-threading, enable it to check for ConcurrentModificationException").getBoolean(false);
        LOGGING_DICTIONARY = config.get("logging", "enable_dictionary_logs", LOGGING_DICTIONARY, "Dictionary logs, enable it to dump blocks hardness and blast resistance at boot").getBoolean(true);
        LOGGING_GLOBAL_REGION_REGISTRY = config.get("logging", "enable_global_region_registry_logs", LOGGING_GLOBAL_REGION_REGISTRY, "GlobalRegion registry logs, enable it to dump global region registry updates").getBoolean(false);
        LOGGING_BREAK_PLACE = config.get("logging", "enable_break_place_logs", LOGGING_BREAK_PLACE, "Detailed break/place event logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCE_FIELD = config.get("logging", "enable_force_field_logs", LOGGING_FORCE_FIELD, "Detailed force field logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCE_FIELD_REGISTRY = config.get("logging", "enable_force_field_registry_logs", LOGGING_FORCE_FIELD_REGISTRY, "ForceField registry logs, enable it to dump force field registry updates").getBoolean(false);
        LOGGING_ACCELERATOR = config.get("logging", "enable_accelerator_logs", LOGGING_ACCELERATOR, "Detailed accelerator logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_XML_PREPROCESSOR = config.get("logging", "enable_XML_preprocessor_logs", LOGGING_XML_PREPROCESSOR, "Save XML preprocessor results as output*.xml file, enable it to debug your XML configuration files").getBoolean(false);
        LOGGING_RENDERING = config.get("logging", "enable_rendering_logs", LOGGING_RENDERING, "Detailed rendering logs to help debug the mod.").getBoolean(false);
        LOGGING_CHUNK_HANDLER = config.get("logging", "enable_chunk_handler_logs", LOGGING_CHUNK_HANDLER, "Detailed chunk data logs to help debug the mod.").getBoolean(false);
        LOGGING_CHUNK_RELOADING = config.get("logging", "enable_experimental_chunk_reloading_logs", LOGGING_CHUNK_RELOADING, "Report in logs when a chunk is reloaded shortly after being unloaded, usually associated with server lag.").getBoolean(false);
        LOGGING_CHUNK_LOADING = config.get("logging", "enable_chunk_loading_logs", LOGGING_CHUNK_LOADING, "Chunk loading logs, enable it to report chunk loaders updates").getBoolean(false);
        LOGGING_ENTITY_FX = config.get("logging", "enable_entity_fx_logs", LOGGING_ENTITY_FX, "EntityFX logs, enable it to dump entityFX registry updates").getBoolean(false);
        LOGGING_GRAVITY = config.get("logging", "enable_gravity_logs", LOGGING_GRAVITY, "Gravity logs, enable it before reporting fall damage and related issues").getBoolean(false);
        LOGGING_OFFLINE_AVATAR = config.get("logging", "enable_offline_avatar_logs", LOGGING_OFFLINE_AVATAR, "Offline avatar logs, enable it before reporting related issues").getBoolean(true);
        ENERGY_DISPLAY_UNITS = config.get("energy", "display_units", ENERGY_DISPLAY_UNITS, "display units for energy (EU, RF, FE, \u0230I)").getString();
        ENERGY_ENABLE_FE = config.get("energy", "enable_FE", ENERGY_ENABLE_FE, "Enable Forge energy support, disable it for a pure EU or RF energy support").getBoolean(true);
        ENERGY_ENABLE_GTCE_EU = config.get("energy", "enable_GTCE_EU", ENERGY_ENABLE_GTCE_EU, "Enable Gregtech EU energy support when the GregtechCE mod is present, disable otherwise").getBoolean(true);
        ENERGY_ENABLE_IC2_EU = config.get("energy", "enable_IC2_EU", ENERGY_ENABLE_IC2_EU, "Enable IC2 EU energy support when the IndustrialCraft2 mod is present, disable otherwise").getBoolean(true);
        ENERGY_ENABLE_RF = config.get("energy", "enable_RF", ENERGY_ENABLE_RF, "Enable RF energy support when the RedstoneFlux mod is present, disable otherwise").getBoolean(true);
        ENERGY_OVERVOLTAGE_SHOCK_FACTOR = Commons.clamp(0.0f, 10.0f, (float)config.get("energy", "overvoltage_shock_factor", (double)ENERGY_OVERVOLTAGE_SHOCK_FACTOR, "Shock damage factor to entities in case of EU voltage overload, set to 0 to disable completely").getDouble());
        ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR = Commons.clamp(0.0f, 10.0f, (float)config.get("energy", "overvoltage_explosion_factor", (double)ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR, "Explosion strength factor in case of EU voltage overload, set to 0 to disable completely").getDouble());
        ENERGY_SCAN_INTERVAL_TICKS = Commons.clamp(1, 300, config.get("energy", "scan_interval_ticks", ENERGY_SCAN_INTERVAL_TICKS, "delay between scan for energy receivers (measured in ticks)").getInt());
        SHIP_MOVEMENT_COSTS_FACTORS = new ShipMovementCosts.Factors[EnumShipMovementType.length];
        for (EnumShipMovementType shipMovementType : EnumShipMovementType.values()) {
            WarpDriveConfig.SHIP_MOVEMENT_COSTS_FACTORS[shipMovementType.ordinal()] = new ShipMovementCosts.Factors(shipMovementType.maximumDistanceDefault, shipMovementType.energyRequiredDefault, shipMovementType.warmupDefault, shipMovementType.sicknessDefault, shipMovementType.cooldownDefault);
            if (!shipMovementType.hasConfiguration) continue;
            SHIP_MOVEMENT_COSTS_FACTORS[shipMovementType.ordinal()].load(config, "ship_movement_costs", shipMovementType.func_176610_l(), shipMovementType.getDescription());
        }
        SHIP_MAX_ENERGY_STORED_BY_TIER = config.get("ship", "max_energy_stored_by_tier", SHIP_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, SHIP_MAX_ENERGY_STORED_BY_TIER);
        SHIP_MASS_MAX_BY_TIER = config.get("ship", "mass_max_by_tier", SHIP_MASS_MAX_BY_TIER, "Maximum ship mass (in blocks) for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, SHIP_MASS_MAX_BY_TIER);
        SHIP_MASS_MIN_BY_TIER = config.get("ship", "mass_min_by_tier", SHIP_MASS_MIN_BY_TIER, "Minimum ship mass (in blocks) for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, SHIP_MASS_MIN_BY_TIER);
        SHIP_MASS_MAX_ON_PLANET_SURFACE = Commons.clamp(0, 10000000, config.get("ship", "volume_max_on_planet_surface", SHIP_MASS_MAX_ON_PLANET_SURFACE, "Maximum ship mass (in blocks) to jump on a planet").getInt());
        SHIP_MASS_MIN_FOR_HYPERSPACE = Commons.clamp(0, 10000000, config.get("ship", "volume_min_for_hyperspace", SHIP_MASS_MIN_FOR_HYPERSPACE, "Minimum ship mass (in blocks) to enter or exit hyperspace without a jumpgate").getInt());
        SHIP_MASS_UNLIMITED_PLAYER_NAMES = config.get("ship", "mass_unlimited_player_names", SHIP_MASS_UNLIMITED_PLAYER_NAMES, "List of player names which have unlimited block counts to their ship").getStringList();
        SHIP_SIZE_MAX_PER_SIDE_BY_TIER = config.get("ship", "size_max_per_side_by_tier", SHIP_SIZE_MAX_PER_SIDE_BY_TIER, "Maximum ship size on each axis in blocks, for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, SHIP_SIZE_MAX_PER_SIDE_BY_TIER);
        SHIP_COLLISION_TOLERANCE_BLOCKS = Commons.clamp(0, 30000000, config.get("ship", "collision_tolerance_blocks", SHIP_COLLISION_TOLERANCE_BLOCKS, "Tolerance in block in case of collision before causing damages...").getInt());
        SHIP_WARMUP_RANDOM_TICKS = Commons.clamp(10, 200, config.get("ship", "warmup_random_ticks", SHIP_WARMUP_RANDOM_TICKS, "Random variation added to warm-up (measured in ticks)").getInt());
        SHIP_VOLUME_SCAN_BLOCKS_PER_TICK = Commons.clamp(100, 100000, config.get("ship", "volume_scan_blocks_per_tick", SHIP_VOLUME_SCAN_BLOCKS_PER_TICK, "Number of blocks to scan per tick when getting ship bounds, too high will cause lag spikes when resizing a ship").getInt());
        SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = Commons.clamp(0, 300, config.get("ship", "volume_scan_age_tolerance", SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS, "Ship volume won't be refreshed unless it's older than that many seconds").getInt());
        JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER = config.get("jump_gate", "size_max_per_side_by_tier", JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER, "Maximum jump gate size on each axis in blocks, for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER);
        OFFLINE_AVATAR_ENABLE = config.get("offline_avatar", "enable", OFFLINE_AVATAR_ENABLE, "Enable creation of offline avatars to follow ship movements. This only disable creating new ones.").getBoolean(OFFLINE_AVATAR_ENABLE);
        OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS = config.get("offline_avatar", "create_only_aboard_ships", OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS, "Only create an offline avatar when player disconnects while inside a ship. Disabling may cause lag in spawn areas...").getBoolean(OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS);
        OFFLINE_AVATAR_FORGET_ON_DEATH = config.get("offline_avatar", "forget_on_death", OFFLINE_AVATAR_FORGET_ON_DEATH, "Enable to forget current avatar position when it's killed, or disable player teleportation to last known avatar's position").getBoolean(OFFLINE_AVATAR_FORGET_ON_DEATH);
        OFFLINE_AVATAR_MODEL_SCALE = (float)Commons.clamp(0.2, 2.0, config.get("offline_avatar", "model_scale", (double)OFFLINE_AVATAR_MODEL_SCALE, "Scale of offline avatar compared to a normal player").getDouble((double)OFFLINE_AVATAR_MODEL_SCALE));
        OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG = config.get("offline_avatar", "always_render_name_tag", OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG, "Should avatar name tag always be visible?").getBoolean(OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG);
        OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL = (float)Commons.clamp(0.1, 10.0, config.get("offline_avatar", "min_range_for_removal", (double)OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL, "Minimum range between a player and their avatar to consider it for removal (i.e. ensuring connection was successful)").getDouble((double)OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL));
        OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL = (float)Commons.clamp(Math.max(3.0, (double)OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL), 3.4028234663852886E38, config.get("offline_avatar", "max_range_for_removal", (double)OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL, "Maximum range between a player and his/her avatar to consider it for removal").getDouble((double)OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL));
        OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS = Commons.clamp(0, 300, config.get("offline_avatar", "delay_for_removal_s", OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS, "Delay before removing an avatar when their related player is in range (measured in seconds)").getInt());
        OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS = OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS * 20;
        RADAR_MAX_ENERGY_STORED = Commons.clamp(0, Integer.MAX_VALUE, config.get("radar", "max_energy_stored", RADAR_MAX_ENERGY_STORED, "maximum energy stored").getInt());
        RADAR_SCAN_MIN_ENERGY_COST = Commons.clamp(0, Integer.MAX_VALUE, config.get("radar", "min_energy_cost", RADAR_SCAN_MIN_ENERGY_COST, "minimum energy cost per scan (0+), independently of radius").getInt());
        RADAR_SCAN_ENERGY_COST_FACTORS = config.get("radar", "factors_energy_cost", RADAR_SCAN_ENERGY_COST_FACTORS, "energy cost factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3").getDoubleList();
        if (RADAR_SCAN_ENERGY_COST_FACTORS.length != 4) {
            RADAR_SCAN_ENERGY_COST_FACTORS = new double[4];
            Arrays.fill(RADAR_SCAN_ENERGY_COST_FACTORS, 1.0);
        }
        RADAR_SCAN_MIN_DELAY_SECONDS = Commons.clamp(1, Integer.MAX_VALUE, config.get("radar", "scan_min_delay_seconds", RADAR_SCAN_MIN_DELAY_SECONDS, "minimum scan delay per scan (1+), (measured in seconds)").getInt());
        if ((RADAR_SCAN_DELAY_FACTORS_SECONDS = config.get("radar", "scan_delay_factors_seconds", RADAR_SCAN_DELAY_FACTORS_SECONDS, "scan delay factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3, (measured in seconds)").getDoubleList()).length != 4) {
            RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[4];
            Arrays.fill(RADAR_SCAN_DELAY_FACTORS_SECONDS, 1.0);
        }
        RADAR_MAX_ISOLATION_RANGE = Commons.clamp(2, 8, config.get("radar", "max_isolation_range", RADAR_MAX_ISOLATION_RANGE, "radius around core where isolation blocks count (2 to 8), higher is lagger").getInt());
        RADAR_MIN_ISOLATION_BLOCKS = Commons.clamp(0, 20, config.get("radar", "min_isolation_blocks", RADAR_MIN_ISOLATION_BLOCKS, "number of isolation blocks required to get some isolation (0 to 20)").getInt());
        RADAR_MAX_ISOLATION_BLOCKS = Commons.clamp(5, 94, config.get("radar", "max_isolation_blocks", RADAR_MAX_ISOLATION_BLOCKS, "number of isolation blocks required to reach maximum effect (5 to 94)").getInt());
        RADAR_MIN_ISOLATION_EFFECT = Commons.clamp(0.01, 0.95, config.get("radar", "min_isolation_effect", RADAR_MIN_ISOLATION_EFFECT, "isolation effect achieved with min number of isolation blocks (0.01 to 0.95)").getDouble(0.12));
        RADAR_MAX_ISOLATION_EFFECT = Commons.clamp(0.01, 1.0, config.get("radar", "max_isolation_effect", RADAR_MAX_ISOLATION_EFFECT, "isolation effect achieved with max number of isolation blocks (0.01 to 1.00)").getDouble(1.0));
        SS_MAX_DEPLOY_RADIUS_BLOCKS = Commons.clamp(5, 150, config.get("ship_scanner", "max_deploy_radius_blocks", SS_MAX_DEPLOY_RADIUS_BLOCKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SEARCH_INTERVAL_TICKS = Commons.clamp(5, 150, config.get("ship_scanner", "search_interval_ticks", SS_SEARCH_INTERVAL_TICKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SCAN_BLOCKS_PER_SECOND = Commons.clamp(1, 50000, config.get("ship_scanner", "scan_blocks_per_second", SS_SCAN_BLOCKS_PER_SECOND, "Scanning speed, measured in blocks (1-5000)").getInt());
        SS_DEPLOY_BLOCKS_PER_INTERVAL = Commons.clamp(1, 3000, config.get("ship_scanner", "deploy_blocks_per_interval", SS_DEPLOY_BLOCKS_PER_INTERVAL, "Deployment speed, measured in blocks (1-3000)").getInt());
        SS_DEPLOY_INTERVAL_TICKS = Commons.clamp(1, 60, config.get("ship_scanner", "deploy_interval_ticks", SS_DEPLOY_INTERVAL_TICKS, "Delay between deployment of 2 sets of blocks, measured in ticks (1-60)").getInt());
        LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER = config.get("laser_medium", "max_energy_stored_by_tier", LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER);
        LASER_MEDIUM_FACTOR_BY_TIER = config.get("laser_medium", "bonus_factor_by_tier", LASER_MEDIUM_FACTOR_BY_TIER, "Bonus multiplier of a laser medium line for a given tier").getDoubleList();
        WarpDriveConfig.clampByTier(0.0, 4.0, LASER_MEDIUM_FACTOR_BY_TIER);
        LASER_CANNON_MAX_MEDIUMS_COUNT = Commons.clamp(1, 64, config.get("laser_cannon", "max_mediums_count", LASER_CANNON_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums per laser").getInt());
        LASER_CANNON_MAX_LASER_ENERGY = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "max_laser_energy", LASER_CANNON_MAX_LASER_ENERGY, "Maximum energy in beam after accounting for boosters beams").getInt());
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = Commons.clamp(1, 100, config.get("laser_cannon", "emit_fire_delay_ticks", LASER_CANNON_EMIT_FIRE_DELAY_TICKS, "Delay while booster beams are accepted, before actually shooting").getInt());
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = Commons.clamp(1, 100, config.get("laser_cannon", "emit_scan_delay_ticks", LASER_CANNON_EMIT_SCAN_DELAY_TICKS, "Delay while booster beams are accepted, before actually scanning").getInt());
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = Commons.clamp(0.01, 10.0, config.get("laser_cannon", "booster_beam_energy_efficiency", LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY, "Energy factor applied from boosting to main laser").getDouble(0.6));
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = Commons.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK, "Energy attenuation when going through air blocks (on a planet or any gas in space)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = Commons.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_void_block", LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK, "Energy attenuation when going through void blocks (in space or hyperspace)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "energy_attenuation_per_broken_block", LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK, "Energy attenuation when going through a broken block").getDouble());
        LASER_CANNON_RANGE_MAX = Commons.clamp(64, 512, config.get("laser_cannon", "range_max", LASER_CANNON_RANGE_MAX, "Maximum distance travelled").getInt());
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = Commons.clamp(0, 300, config.get("laser_cannon", "entity_hit_set_on_fire_seconds", LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS, "Duration of fire effect on entity hit (in seconds)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy", LASER_CANNON_ENTITY_HIT_ENERGY, "Base energy consumed from hitting an entity").getInt());
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_base_damage", LASER_CANNON_ENTITY_HIT_BASE_DAMAGE, "Minimum damage to entity hit (measured in half hearts)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy_per_damage", LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE, "Energy required by additional hit point (won't be consumed)").getInt());
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_max_damage", LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, "Maximum damage to entity hit, set to 0 to disable damage completely").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_energy_threshold_for_explosion", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD, "Minimum energy to cause explosion effect").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = (float)Commons.clamp(0.0, 100.0, config.get("laser_cannon", "entity_hit_explosion_base_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_explosion_energy_per_strength", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "entity_hit_explosion_max_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_min", LASER_CANNON_BLOCK_HIT_ENERGY_MIN, "Minimum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_per_block_hardness", LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS, "Energy cost per block hardness for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_max", LASER_CANNON_BLOCK_HIT_ENERGY_MAX, "Maximum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_per_block_hardness", LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS, "Probability of energy absorption (i.e. block not breaking) per block hardness. Set to 1.0 to always break the block.").getDouble());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_max", LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX, "Maximum probability of energy absorption (i.e. block not breaking)").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = (float)Commons.clamp(0.0, 10000.0, config.get("laser_cannon", "block_hit_explosion_hardness_threshold", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD, "Minimum block hardness required to cause an explosion").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_base_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_explosion_energy_per_strength", LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_max_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        MINING_LASER_MAX_MEDIUMS_COUNT = Commons.clamp(1, 10, config.get("mining_laser", "max_mediums_count", MINING_LASER_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        MINING_LASER_RADIUS_NO_LASER_MEDIUM = Commons.clamp(0, 15, config.get("mining_laser", "radius_no_laser_medium", MINING_LASER_RADIUS_NO_LASER_MEDIUM, "Mining radius without any laser medium, measured in blocks").getInt());
        MINING_LASER_RADIUS_PER_LASER_MEDIUM = Commons.clamp(1, 8, config.get("mining_laser", "radius_per_laser_medium", MINING_LASER_RADIUS_PER_LASER_MEDIUM, "Bonus to mining radius per laser medium, measured in blocks").getInt());
        MINING_LASER_WARMUP_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "warmup_delay_ticks", MINING_LASER_WARMUP_DELAY_TICKS, "Warmup duration (buffer on startup when energy source is weak)").getInt());
        MINING_LASER_SCAN_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "scan_delay_ticks", MINING_LASER_SCAN_DELAY_TICKS, "Scan duration per layer").getInt());
        MINING_LASER_MINE_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "mine_delay_ticks", MINING_LASER_MINE_DELAY_TICKS, "Mining duration per scanned block").getInt());
        MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_ATMOSPHERE = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "scan_energy_per_layer_in_atmosphere", MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_ATMOSPHERE, "Energy cost per layer on a planet with atmosphere").getInt());
        MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_ATMOSPHERE = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "mine_energy_per_block_in_atmosphere", MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_ATMOSPHERE, "Energy cost per block on a planet with atmosphere").getInt());
        MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_VOID = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "scan_energy_per_layer_in_void", MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_VOID, "Energy cost per layer in space or a planet without atmosphere").getInt());
        MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_VOID = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "mine_energy_per_block_in_void", MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_VOID, "Energy cost per block in space or a planet without atmosphere").getInt());
        MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR = Commons.clamp(1.5, 1000.0, config.get("mining_laser", "mine_ores_only_energy_factor", MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR, "Energy cost multiplier per block when mining only ores").getDouble(MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR));
        MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR = Commons.clamp(1.5, 1000.0, config.get("mining_laser", "mine_silktouch_energy_factor", MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR, "Energy cost multiplier per block when mining with silktouch").getDouble(MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR));
        TREE_FARM_MAX_MEDIUMS_COUNT = Commons.clamp(1, 10, config.get("tree_farm", "max_mediums_count", TREE_FARM_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM = Commons.clamp(0, 15, config.get("tree_farm", "max_radius_no_laser_medium", TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM, "Maximum scan radius without any laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM = Commons.clamp(1, 8, config.get("tree_farm", "max_radius_per_laser_medium", TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM, "Bonus to maximum scan radius per laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_totalMaxRadius = TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM + TREE_FARM_MAX_MEDIUMS_COUNT * TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM;
        TREE_FARM_MAX_DISTANCE_NO_LASER_MEDIUM = Commons.clamp(1, 64, config.get("tree_farm", "max_reach_distance_no_laser_medium", TREE_FARM_MAX_DISTANCE_NO_LASER_MEDIUM, "Maximum reach distance of the laser without any laser medium, measured in blocks").getInt());
        TREE_FARM_MAX_DISTANCE_PER_MEDIUM = Commons.clamp(0, 16, config.get("tree_farm", "max_reach_distance_per_laser_medium", TREE_FARM_MAX_DISTANCE_PER_MEDIUM, "Bonus to maximum reach distance per laser medium, measured in blocks").getInt());
        CLOAKING_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("cloaking", "max_energy_stored", CLOAKING_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        CLOAKING_COIL_CAPTURE_BLOCKS = Commons.clamp(0, 30, config.get("cloaking", "coil_capture_blocks", CLOAKING_COIL_CAPTURE_BLOCKS, "Extra blocks covered after the outer coils").getInt());
        CLOAKING_MAX_FIELD_RADIUS = Commons.clamp(CLOAKING_COIL_CAPTURE_BLOCKS + 3, 128, config.get("cloaking", "max_field_radius", CLOAKING_MAX_FIELD_RADIUS, "Maximum distance between cloaking core and any cloaked side").getInt());
        CLOAKING_TIER1_ENERGY_PER_BLOCK = Commons.clamp(0, Integer.MAX_VALUE, config.get("cloaking", "tier1_energy_per_block", CLOAKING_TIER1_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier1 cloak").getInt());
        CLOAKING_TIER2_ENERGY_PER_BLOCK = Commons.clamp(CLOAKING_TIER1_ENERGY_PER_BLOCK, Integer.MAX_VALUE, config.get("cloaking", "tier2_energy_per_block", CLOAKING_TIER2_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier2 cloak").getInt());
        CLOAKING_TIER1_FIELD_REFRESH_INTERVAL_TICKS = Commons.clamp(20, 600, config.get("cloaking", "tier1_field_refresh_interval_ticks", CLOAKING_TIER1_FIELD_REFRESH_INTERVAL_TICKS, "Update speed of a Tier1 cloak").getInt());
        CLOAKING_TIER2_FIELD_REFRESH_INTERVAL_TICKS = Commons.clamp(20, 600, config.get("cloaking", "tier2_field_refresh_interval_ticks", CLOAKING_TIER2_FIELD_REFRESH_INTERVAL_TICKS, "Update speed of a Tier2 cloak").getInt());
        CLOAKING_VOLUME_SCAN_BLOCKS_PER_TICK = Commons.clamp(100, 100000, config.get("cloaking", "volume_scan_blocks_per_tick", CLOAKING_VOLUME_SCAN_BLOCKS_PER_TICK, "Number of blocks to scan per tick when getting cloak bounds, too high will cause lag spikes when resizing a cloak").getInt());
        CLOAKING_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = Commons.clamp(0, 300, config.get("cloaking", "volume_scan_age_tolerance", CLOAKING_VOLUME_SCAN_AGE_TOLERANCE_SECONDS, "Cloak volume won't be refreshed unless it's older than that many seconds").getInt());
        BREATHING_MAX_ENERGY_STORED_BY_TIER = config.get("breathing", "max_energy_stored_by_tier", BREATHING_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, BREATHING_MAX_ENERGY_STORED_BY_TIER);
        BREATHING_ENERGY_PER_CANISTER = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[1], config.get("breathing", "energy_per_canister", BREATHING_ENERGY_PER_CANISTER, "Energy cost per air canister refilled").getInt());
        BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER = config.get("breathing", "energy_per_new_air_block_by_tier", BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER, "Energy cost to start air distribution per open side per interval for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[2], BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[0] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[0], BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[0]);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[1] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[1], BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[1]);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[2] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[2], BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER[2]);
        BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER = config.get("breathing", "energy_per_existing_air_block_by_tier", BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER, "Energy cost to sustain air distribution per open side per interval").getIntList();
        WarpDriveConfig.clampByTier(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[2], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[0] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[0], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[0]);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[1] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[1], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[1]);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[2] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED_BY_TIER[2], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER[2]);
        BREATHING_AIR_GENERATION_TICKS = Commons.clamp(1, 300, config.get("breathing", "air_generation_interval_ticks", BREATHING_AIR_GENERATION_TICKS, "Update speed of air generation").getInt());
        BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER = config.get("breathing", "air_generation_range_blocks", BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER, "Maximum range of an air generator for each tier, measured in block").getIntList();
        WarpDriveConfig.clampByTier(8, 256, BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER);
        BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS = Commons.clamp(10, 256, config.get("breathing", "volume_update_depth_blocks", BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS, "Maximum depth of blocks to update when a volume has changed.\nHigher values may cause TPS lag spikes, Lower values will exponentially increase the repressurization time").getInt());
        BREATHING_AIR_SIMULATION_DELAY_TICKS = Commons.clamp(1, 90, config.get("breathing", "simulation_delay_ticks", BREATHING_AIR_SIMULATION_DELAY_TICKS, "Minimum delay between consecutive air propagation updates of the same block.").getInt());
        BREATHING_AIR_AT_ENTITY_DEBUG = config.get("breathing", "enable_air_at_entity_debug", BREATHING_AIR_AT_ENTITY_DEBUG, "Spam creative players with air status around them, use at your own risk.").getBoolean(false);
        BREATHING_AIR_TANK_BREATH_DURATION_TICKS = Commons.clamp(100, 1200, config.get("breathing", "air_tank_breath_duration_ticks", BREATHING_AIR_TANK_BREATH_DURATION_TICKS, "Duration of a single breath cycle measured in ticks.").getInt());
        BREATHING_AIR_TANK_CAPACITY_BY_TIER = config.get("breathing", "air_tank_capacity_by_tier", BREATHING_AIR_TANK_CAPACITY_BY_TIER, "Number of breaths cycles available in a air tank, by tier (canister, normal, advanced, superior).").getIntList();
        WarpDriveConfig.clampByTier(8, Short.MAX_VALUE, BREATHING_AIR_TANK_CAPACITY_BY_TIER);
        IC2_REACTOR_MAX_HEAT_STORED = Commons.clamp(1, Short.MAX_VALUE, config.get("ic2_reactor_laser", "max_heat_stored", IC2_REACTOR_MAX_HEAT_STORED, "Maximum heat stored in the focus").getInt());
        IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "component_heat_transfer_per_tick", IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK, "Maximum component heat added to the focus every reactor tick").getInt());
        IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "focus_heat_transfer_per_tick", IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK, "Maximum heat transferred between 2 connected focus every reactor tick").getInt());
        IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "reactor_heat_transfer_per_tick", IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK, "Maximum reactor heat added to the focus every reactor tick").getInt());
        IC2_REACTOR_COOLING_PER_INTERVAL = Commons.clamp(1, Short.MAX_VALUE, config.get("ic2_reactor_laser", "cooling_per_interval", IC2_REACTOR_COOLING_PER_INTERVAL, "Heat extracted from the focus by interval").getInt());
        IC2_REACTOR_ENERGY_PER_HEAT = Commons.clamp(2.0, 100000.0, config.get("ic2_reactor_laser", "energy_per_heat", IC2_REACTOR_ENERGY_PER_HEAT, "Energy cost per heat absorbed").getDouble());
        IC2_REACTOR_COOLING_INTERVAL_TICKS = Commons.clamp(0, 1200, config.get("ic2_reactor_laser", "cooling_interval_ticks", IC2_REACTOR_COOLING_INTERVAL_TICKS, "Update speed of the check for reactors to cool down. Use 10 to tick as fast as the reactor simulation").getInt());
        TRANSPORTER_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("transporter", "max_energy_stored", TRANSPORTER_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER = config.get("enantiomorphic_reactor", "max_energy_stored_by_tier", ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored in the core for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER);
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = config.get("enantiomorphic_reactor", "max_lasers", ENAN_REACTOR_MAX_LASERS_PER_SECOND, "Maximum number of stabilisation laser shots per seconds before loosing efficiency").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, ENAN_REACTOR_MAX_LASERS_PER_SECOND);
        ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER = config.get("enantiomorphic_reactor", "min_generation_RF_by_tier", ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER, "Minimum energy added to the core when enabled, measured in RF/t, for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER);
        ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER = config.get("enantiomorphic_reactor", "max_generation_RF_by_tier", ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER, "Maximum energy added to the core when enabled, measured in RF/t, for a given tier").getIntList();
        WarpDriveConfig.clampByTier(1, Integer.MAX_VALUE, ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER);
        FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER = config.get("force_field", "projector_max_energy_stored_by_tier", FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored for each projector tier").getIntList();
        WarpDriveConfig.clampByTier(0, Integer.MAX_VALUE, FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER);
        FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE = Commons.clamp(1.0, 1000.0, config.get("force_field", "projector_explosion_scale", FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE, "Scale applied to explosion strength, increase the value to reduce explosion impact on a force field. Enable weapon logs to see the damage level.").getDouble(FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE));
        FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED = Commons.clamp(1.0, 1000.0, config.get("force_field", "projector_max_laser_required", FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED, "Number of maxed out laser cannons required to break a superior force field.").getDouble(FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED));
        FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP = Commons.clamp(3.0, 1000.0, config.get("force_field", "explosion_strength_vanilla_cap", FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP, "Maximum strength for vanilla explosion object used by simple explosives like TechGuns rockets.").getDouble(FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP));
        CAPACITOR_MAX_ENERGY_STORED_BY_TIER = config.get("capacitor", "max_energy_stored_by_tier", CAPACITOR_MAX_ENERGY_STORED_BY_TIER, "Maximum energy stored for each subspace capacitor tier").getIntList();
        WarpDriveConfig.clampByTier(0, Integer.MAX_VALUE, CAPACITOR_MAX_ENERGY_STORED_BY_TIER);
        CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER = config.get("capacitor", "ic2_sink_tier_name_by_tier", CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER, "IC2 energy sink tier (ULV, LV, MV, HV, EV, IV, LuV, ZPMV, UV, MaxV) for each subspace capacitor tier").getStringList();
        WarpDriveConfig.clampByEnergyTierName("ULV", "MaxV", CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER);
        CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER = config.get("capacitor", "ic2_source_tier_name_by_tier", CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER, "IC2 energy source tier (ULV, LV, MV, HV, EV, IV, LuV, ZPMV, UV, MaxV) for each subspace capacitor tier").getStringList();
        WarpDriveConfig.clampByEnergyTierName("ULV", "MaxV", CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER);
        CAPACITOR_FLUX_RATE_INPUT_BY_TIER = config.get("capacitor", "flux_rate_input_per_tick_by_tier", CAPACITOR_FLUX_RATE_INPUT_BY_TIER, "Flux energy transferred per tick for each subspace capacitor tier").getIntList();
        WarpDriveConfig.clampByTier(0, 0x19999999, CAPACITOR_FLUX_RATE_INPUT_BY_TIER);
        CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER = config.get("capacitor", "flux_rate_output_per_tick_by_tier", CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER, "Flux energy transferred per tick for each subspace capacitor tier").getIntList();
        WarpDriveConfig.clampByTier(0, 0x19999999, CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER);
        CAPACITOR_EFFICIENCY_PER_UPGRADE = config.get("capacitor", "efficiency_per_upgrade", CAPACITOR_EFFICIENCY_PER_UPGRADE, "Energy transfer efficiency for each upgrade apply, first value is without upgrades (0.8 means 20% loss)").getDoubleList();
        assert (CAPACITOR_EFFICIENCY_PER_UPGRADE.length >= 1);
        WarpDriveConfig.CAPACITOR_EFFICIENCY_PER_UPGRADE[0] = Math.min(1.0, Commons.clamp(0.5, CAPACITOR_EFFICIENCY_PER_UPGRADE[1], CAPACITOR_EFFICIENCY_PER_UPGRADE[0]));
        WarpDriveConfig.CAPACITOR_EFFICIENCY_PER_UPGRADE[1] = Math.min(1.0, Commons.clamp(CAPACITOR_EFFICIENCY_PER_UPGRADE[0], CAPACITOR_EFFICIENCY_PER_UPGRADE[2], CAPACITOR_EFFICIENCY_PER_UPGRADE[1]));
        WarpDriveConfig.CAPACITOR_EFFICIENCY_PER_UPGRADE[2] = Math.min(1.0, Commons.clamp(CAPACITOR_EFFICIENCY_PER_UPGRADE[1], 2.147483647E9, CAPACITOR_EFFICIENCY_PER_UPGRADE[2]));
        LIFT_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("lift", "max_energy_stored", LIFT_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        LIFT_ENERGY_PER_ENTITY = Commons.clamp(1, Integer.MAX_VALUE, config.get("lift", "energy_per_entity", LIFT_ENERGY_PER_ENTITY, "Energy consumed per entity moved").getInt());
        LIFT_UPDATE_INTERVAL_TICKS = Commons.clamp(1, 60, config.get("lift", "update_interval_ticks", LIFT_UPDATE_INTERVAL_TICKS, "Update speed of the check for entities").getInt());
        LIFT_ENTITY_COOLDOWN_TICKS = Commons.clamp(1, 6000, config.get("lift", "entity_cooldown_ticks", LIFT_ENTITY_COOLDOWN_TICKS, "Cooldown after moving an entity").getInt());
        CHUNK_LOADER_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("chunk_loader", "max_energy_stored", CHUNK_LOADER_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        CHUNK_LOADER_MAX_RADIUS = Commons.clamp(1, 1000, config.get("chunk_loader", "max_radius", CHUNK_LOADER_MAX_RADIUS, "Maximum radius when loading a square shape, measured in chunks. A linear shape can be up to 1 chunk wide by (radius + 1 + radius) ^ 2 chunks long.").getInt());
        CHUNK_LOADER_ENERGY_PER_CHUNK = Commons.clamp(1, 100, config.get("chunk_loader", "energy_per_chunk", CHUNK_LOADER_ENERGY_PER_CHUNK, "Energy consumed per chunk loaded").getInt());
        ACCELERATOR_ENABLE = config.get("accelerator", "enable", ACCELERATOR_ENABLE, "Enable accelerator blocks. Requires a compatible server, as it won't work in single player").getBoolean(false);
        ACCELERATOR_MAX_PARTICLE_BUNCHES = Commons.clamp(2, 100, config.get("accelerator", "max_particle_bunches", ACCELERATOR_MAX_PARTICLE_BUNCHES, "Maximum number of particle bunches per accelerator controller").getInt());
        if (G_ENABLE_FORGE_CHUNK_MANAGER) {
            Property propertyMaximumChunksPerTicket;
            int sideShipMax_chunks = (int)Math.ceil((float)SHIP_SIZE_MAX_PER_SIDE_BY_TIER[3] / 16.0f) + 1;
            int sizeShipMax_chunks = sideShipMax_chunks * sideShipMax_chunks;
            int sizeChunkLoaderMax_chunks = (1 + 2 * CHUNK_LOADER_MAX_RADIUS) * (1 + 2 * CHUNK_LOADER_MAX_RADIUS);
            int sizeMax_chunks = Math.max(sizeShipMax_chunks, sizeChunkLoaderMax_chunks);
            Configuration configForgeChunks = ForgeChunkManager.getConfig();
            Property propertyMaximumTicketCount = configForgeChunks.get("warpdrive", "maximumTicketCount", 100);
            if (propertyMaximumTicketCount.getInt() < 2) {
                propertyMaximumTicketCount.set(2);
            }
            if ((propertyMaximumChunksPerTicket = configForgeChunks.get("warpdrive", "maximumChunksPerTicket", sizeMax_chunks)).getInt() < sizeMax_chunks) {
                propertyMaximumChunksPerTicket.set(sizeMax_chunks);
            }
            if (configForgeChunks.hasChanged()) {
                configForgeChunks.save();
            }
        }
        config.save();
    }

    public static void clampByTier(int min, int max, @Nonnull int[] values) {
        if (values.length != EnumTier.length) {
            WarpDrive.logger.error(String.format("Invalid configuration value, expected %d values, got %d %s. Update your configuration and restart your game!", EnumTier.length, values.length, Arrays.toString(values)));
            assert (false);
            return;
        }
        values[0] = Commons.clamp(min, max, values[0]);
        values[1] = Commons.clamp(min, values[2], values[1]);
        values[2] = Commons.clamp(values[1], values[3], values[2]);
        values[3] = Commons.clamp(values[2], max, values[3]);
    }

    public static void clampByTier(double min, double max, @Nonnull double[] values) {
        if (values.length != EnumTier.length) {
            WarpDrive.logger.error(String.format("Invalid configuration value, expected %d values, got %d %s. Update your configuration and restart your game!", EnumTier.length, values.length, Arrays.toString(values)));
            assert (false);
            return;
        }
        values[0] = Commons.clamp(min, max, values[0]);
        values[1] = Commons.clamp(min, values[2], values[1]);
        values[2] = Commons.clamp(values[1], values[3], values[2]);
        values[3] = Commons.clamp(values[2], max, values[3]);
    }

    public static void clampByEnergyTierName(String nameMin, String nameMax, @Nonnull String[] names) {
        int index;
        if (names.length != EnumTier.length) {
            WarpDrive.logger.error(String.format("Invalid configuration value, expected %d string, got %d %s. Update your configuration and restart your game!", EnumTier.length, names.length, Arrays.toString(names)));
            assert (false);
            return;
        }
        int min = EnergyWrapper.EU_getTierByName(nameMin);
        int max = EnergyWrapper.EU_getTierByName(nameMax);
        int[] values = new int[EnumTier.length];
        for (index = 0; index < EnumTier.length; ++index) {
            values[index] = EnergyWrapper.EU_getTierByName(names[index]);
        }
        WarpDriveConfig.clampByTier(min, max, values);
        for (index = 0; index < EnumTier.length; ++index) {
            names[index] = EnergyWrapper.EU_nameTier[values[index]];
        }
    }

    public static void loadDictionary(File file) {
        Configuration config = new Configuration(file);
        config.load();
        Dictionary.loadConfig(config);
        config.save();
    }

    public static void loadDataFixer(File file) {
        Configuration config = new Configuration(file);
        config.load();
        WarpDriveDataFixer.loadConfig(config);
        config.save();
    }

    public static void registerBlockTransformer(String modId, IBlockTransformer blockTransformer) {
        blockTransformers.put(modId, blockTransformer);
        WarpDrive.logger.info(modId + " blockTransformer registered");
    }

    public static void onFMLInitialization() {
        boolean isWootloaded;
        boolean isVariedCommoditiesLoaded;
        boolean isUndergroundBiomesLoaded;
        boolean isThermalDynamicsLoaded;
        boolean isThaumcraftLoaded;
        boolean isTechgunsLoaded;
        boolean isTConstructLoaded;
        boolean isStorageDrawersLoaded;
        boolean isSGCraftLoaded;
        boolean isRefinedStorageLoaded;
        boolean isRealFilingCabinetLoaded;
        boolean isRedstonePasteLoaded;
        boolean isParziStarWarsLoaded;
        boolean isRusticLoaded;
        boolean isRootsLoaded;
        boolean isPneumaticCraftLoaded;
        boolean isNaturaLoaded;
        boolean isMysticalAgricultureLoaded;
        boolean isMetalChestsLoaded;
        boolean isMekanismLoaded;
        boolean isIronChestLoaded;
        boolean isIndustrialForegoingLoaded;
        boolean isGalacticraftCoreLoaded;
        boolean isEvilCraftLoaded;
        boolean isExtraUtilities2Loaded;
        boolean isEnvironmentalTechLoaded;
        boolean isEmbersLoaded;
        boolean isDraconicEvolutionLoaded;
        boolean isDeepResonanceLoaded;
        boolean isDecocraftLoaded;
        boolean isCustomNPCsLoaded;
        boolean isCarpentersBlocksLoaded;
        boolean isBuildCraftLoaded;
        boolean isBlockcrafteryLoaded;
        boolean isBiblioCraftLoaded;
        boolean isBotaniaLoaded;
        boolean isImmersiveEngineeringLoaded;
        boolean isArsMagica2Loaded;
        boolean isActuallyAdditionsLoaded;
        boolean isAppliedEnergistics2Loaded;
        CompatWarpDrive.register();
        if (isAdvancedRepulsionSystemLoaded) {
            CompatAdvancedRepulsionSystems.register();
        }
        if (isAppliedEnergistics2Loaded = Loader.isModLoaded((String)"appliedenergistics2")) {
            CompatAppliedEnergistics2.register();
        }
        if (isActuallyAdditionsLoaded = Loader.isModLoaded((String)"actuallyadditions")) {
            CompatActuallyAdditions.register();
        }
        if (isArsMagica2Loaded = Loader.isModLoaded((String)"arsmagica2")) {
            CompatArsMagica2.register();
        }
        if (isComputerCraftLoaded) {
            CompatComputerCraft.register(isCCTweakedLoaded);
        }
        if (isEnderIOLoaded) {
            CompatEnderIO.register();
        }
        if (isForgeMultipartLoaded) {
            isForgeMultipartLoaded = CompatForgeMultipart.register();
        }
        if (isImmersiveEngineeringLoaded = Loader.isModLoaded((String)"immersiveengineering")) {
            CompatImmersiveEngineering.register();
        }
        if (isIndustrialCraft2Loaded) {
            WarpDriveConfig.loadIC2();
            CompatIndustrialCraft2.register();
        }
        if (isOpenComputersLoaded) {
            CompatOpenComputers.register();
        }
        if (isThermalExpansionLoaded) {
            CompatThermalExpansion.register();
        }
        if (isBotaniaLoaded = Loader.isModLoaded((String)"botania")) {
            CompatBotania.register();
        }
        if (isBiblioCraftLoaded = Loader.isModLoaded((String)"bibliocraft")) {
            CompatBiblioCraft.register();
        }
        if (isBlockcrafteryLoaded = Loader.isModLoaded((String)"blockcraftery")) {
            CompatBlockcraftery.register();
        }
        if (isBuildCraftLoaded = Loader.isModLoaded((String)"buildcraftcore")) {
            CompatBuildCraft.register();
        }
        if (isCarpentersBlocksLoaded = Loader.isModLoaded((String)"CarpentersBlocks")) {
            CompatCarpentersBlocks.register();
        }
        if (isCustomNPCsLoaded = Loader.isModLoaded((String)"customnpcs")) {
            CompatCustomNPCs.register();
        }
        if (isDecocraftLoaded = Loader.isModLoaded((String)"props")) {
            CompatDecocraft.register();
        }
        if (isDeepResonanceLoaded = Loader.isModLoaded((String)"deepresonance")) {
            CompatDeepResonance.register();
        }
        if (isDraconicEvolutionLoaded = Loader.isModLoaded((String)"draconicevolution")) {
            CompatDraconicEvolution.register();
        }
        if (isEmbersLoaded = Loader.isModLoaded((String)"embers")) {
            CompatEmbers.register();
        }
        if (isEnvironmentalTechLoaded = Loader.isModLoaded((String)"environmentaltech")) {
            CompatEnvironmentalTech.register();
        }
        if (isExtraUtilities2Loaded = Loader.isModLoaded((String)"extrautils2")) {
            CompatExtraUtilities2.register();
        }
        if (isEvilCraftLoaded = Loader.isModLoaded((String)"evilcraft")) {
            CompatEvilCraft.register();
        }
        if (isGalacticraftCoreLoaded = Loader.isModLoaded((String)"galacticraftcore")) {
            CompatGalacticraft.register();
        }
        if (isGregtechLoaded) {
            CompatGregTech.register();
        }
        if (isIndustrialForegoingLoaded = Loader.isModLoaded((String)"industrialforegoing")) {
            CompatIndustrialForegoing.register();
        }
        if (isIronChestLoaded = Loader.isModLoaded((String)"ironchest")) {
            CompatIronChest.register();
        }
        if (isMekanismLoaded = Loader.isModLoaded((String)"mekanism")) {
            CompatMekanism.register();
        }
        if (isMetalChestsLoaded = Loader.isModLoaded((String)"metalchests")) {
            CompatMetalChests.register();
        }
        if (isMysticalAgricultureLoaded = Loader.isModLoaded((String)"mysticalagriculture")) {
            CompatMysticalAgriculture.register();
        }
        if (isNaturaLoaded = Loader.isModLoaded((String)"natura")) {
            CompatNatura.register();
        }
        if (isPneumaticCraftLoaded = Loader.isModLoaded((String)"pneumaticcraft")) {
            CompatPneumaticCraft.register();
        }
        if (isRootsLoaded = Loader.isModLoaded((String)"roots")) {
            CompatRoots.register();
        }
        if (isRusticLoaded = Loader.isModLoaded((String)"rustic")) {
            CompatRustic.register();
        }
        if (isParziStarWarsLoaded = Loader.isModLoaded((String)"starwarsmod")) {
            CompatParziStarWars.register();
        }
        if (isRedstonePasteLoaded = Loader.isModLoaded((String)"redstonepaste")) {
            CompatRedstonePaste.register();
        }
        if (isRealFilingCabinetLoaded = Loader.isModLoaded((String)"realfilingcabinet")) {
            CompatRealFilingCabinet.register();
        }
        if (isRefinedStorageLoaded = Loader.isModLoaded((String)"refinedstorage")) {
            CompatRefinedStorage.register();
        }
        if (isSGCraftLoaded = Loader.isModLoaded((String)"sgcraft")) {
            CompatSGCraft.register();
        }
        if (isStorageDrawersLoaded = Loader.isModLoaded((String)"storagedrawers")) {
            CompatStorageDrawers.register();
        }
        if (isTConstructLoaded = Loader.isModLoaded((String)"tconstruct")) {
            CompatTConstruct.register();
        }
        if (isTechgunsLoaded = Loader.isModLoaded((String)"techguns")) {
            CompatTechguns.register();
        }
        if (isThaumcraftLoaded = Loader.isModLoaded((String)"thaumcraft")) {
            CompatThaumcraft.register();
        }
        if (isThermalDynamicsLoaded = Loader.isModLoaded((String)"thermaldynamics")) {
            CompatThermalDynamics.register();
        }
        if (isUndergroundBiomesLoaded = Loader.isModLoaded((String)"undergroundbiomes")) {
            CompatUndergroundBiomes.register();
        }
        if (isVariedCommoditiesLoaded = Loader.isModLoaded((String)"variedcommodities")) {
            CompatVariedCommodities.register();
        }
        if (isWootloaded = Loader.isModLoaded((String)"woot")) {
            CompatWoot.register();
        }
    }

    public static void onFMLPostInitialization() {
        FillerManager.load(fileConfigDirectory);
        LootManager.load(fileConfigDirectory);
        StructureManager.load(fileConfigDirectory);
        Dictionary.apply();
        WarpDriveDataFixer.apply();
    }

    private static void loadIC2() {
        try {
            IC2_emptyCell = (ItemStack)WarpDriveConfig.getOreOrItemStack("ic2:fluid_cell", 0, new Object[0]);
            if (!IC2_emptyCell.func_190926_b()) {
                IC2_compressedAir = WarpDriveConfig.getItemStackOrFire("ic2:fluid_cell", 0, "{Fluid:{FluidName:\"ic2air\",Amount:1000}}");
                IC2_rubberWood = WarpDriveConfig.getBlockOrFire("ic2:rubber_wood");
                IC2_Resin = WarpDriveConfig.getItemStackOrFire("ic2:misc_resource", 4);
            } else {
                IC2_emptyCell = WarpDriveConfig.getItemStackOrFire("ic2:itemcellempty", 0);
                IC2_compressedAir = WarpDriveConfig.getItemStackOrFire("ic2:itemmisc", 100);
                IC2_rubberWood = WarpDriveConfig.getBlockOrFire("ic2:blockrubwood");
                IC2_Resin = WarpDriveConfig.getItemStackOrFire("ic2:itemharz", 0);
            }
            if (IC2_emptyCell.func_190926_b() || IC2_compressedAir.func_190926_b() || IC2_rubberWood == Blocks.field_150480_ab || IC2_Resin.func_190926_b()) {
                throw new RuntimeException("Unsupported IC2 blocks & items, unable to proceed further");
            }
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Error loading IndustrialCraft2 blocks and items");
            exception.printStackTrace(WarpDrive.printStreamError);
        }
    }

    public static boolean isIC2CompressedAir(@Nonnull ItemStack itemStack) {
        NBTTagCompound nbtCompressedAir = IC2_compressedAir.func_77978_p();
        return !itemStack.func_190926_b() && itemStack.func_77969_a(IC2_compressedAir) && (nbtCompressedAir == null || itemStack.func_77978_p() != null && nbtCompressedAir.equals((Object)itemStack.func_77978_p()));
    }

    public static DocumentBuilder getXmlDocumentBuilder() {
        if (xmlDocumentBuilder == null) {
            ErrorHandler xmlErrorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML warning at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML fatal error at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }

                @Override
                public void error(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML error at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }
            };
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            try {
                xmlDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
            }
            xmlDocumentBuilder.setErrorHandler(xmlErrorHandler);
        }
        return xmlDocumentBuilder;
    }

    private static void unpackResourcesToFolder(String prefix, String suffix, String[] filenames, String resourcePathSource, File folderTarget) {
        File[] files = fileConfigDirectory.listFiles((file_notUsed, name) -> name.startsWith(prefix) && name.endsWith(suffix));
        if (files == null) {
            throw new RuntimeException(String.format("Critical error accessing target directory, searching for %s*%s files: %s", prefix, suffix, folderTarget));
        }
        if (files.length == 0) {
            for (String filename : filenames) {
                WarpDriveConfig.unpackResourceToFolder(filename, resourcePathSource, folderTarget);
            }
        }
    }

    private static void unpackResourceToFolder(String filename, String resourcePathSource, File folderTarget) {
        String resourceName = resourcePathSource + "/" + filename;
        File destination = new File(folderTarget, filename);
        try {
            int bytesRead;
            InputStream inputStream = WarpDrive.class.getClassLoader().getResourceAsStream(resourceName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] byteBuffer = new byte[Math.max(8192, inputStream.available())];
            while ((bytesRead = inputStream.read(byteBuffer)) >= 0) {
                outputStream.write(byteBuffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Failed to unpack resource '%s' into '%s'", resourceName, destination));
        }
    }

    static {
        defaultXML_fillerSets = new String[]{"fillerSets-default.xml", "fillerSets-GTCEu.xml", "fillerSets-netherores.xml", "fillerSets-undergroundbiomes.xml", "fillerSets-undergroundBiomes_GTCEu.xml"};
        defaultXML_lootSets = new String[]{"lootSets-default.xml"};
        defaultXML_schematicSets = new String[]{"schematicSets-default.xml"};
        defaultXML_structures = new String[]{"structures-default.xml", "structures-netherores.xml", "structures-ship.xml"};
        defaultXML_celestialObjects = new String[]{"celestialObjects-default.xml", "celestialObjects-Galacticraft+ExtraPlanets.xml"};
        defaultSchematics = new String[]{"default-legacy_1.schematic", "default-legacy_2.schematic"};
        FillerManager = new GenericSetManager<Filler>("filler", "filler", "fillerSet", Filler.DEFAULT);
        LootManager = new GenericSetManager<Loot>("loot", "loot", "lootSet", Loot.DEFAULT);
        isAdvancedRepulsionSystemLoaded = false;
        isRedstoneFluxLoaded = false;
        isComputerCraftLoaded = false;
        isCCTweakedLoaded = false;
        isEnderIOLoaded = false;
        isForgeMultipartLoaded = false;
        isGregtechLoaded = false;
        isICBMClassicLoaded = false;
        isIndustrialCraft2Loaded = false;
        isMatterOverdriveLoaded = false;
        isNotEnoughItemsLoaded = false;
        isOpenComputersLoaded = false;
        isThermalExpansionLoaded = false;
        isThermalFoundationLoaded = false;
        G_SPACE_BIOME_ID = 95;
        G_SPACE_PROVIDER_ID = 14;
        G_HYPERSPACE_PROVIDER_ID = 15;
        G_ENTITY_SPHERE_GENERATOR_ID = 241;
        G_ENTITY_STAR_CORE_ID = 242;
        G_ENTITY_CAMERA_ID = 243;
        G_ENTITY_PARTICLE_BUNCH_ID = 244;
        G_ENTITY_LASER_EXPLODER_ID = 245;
        G_ENTITY_NPC_ID = 246;
        G_ENTITY_OFFLINE_AVATAR_ID = 247;
        G_ENTITY_SEAT_ID = 248;
        G_LUA_SCRIPTS = 2;
        G_SCHEMATICS_LOCATION = "warpDrive_schematics";
        G_ASSEMBLY_SCAN_INTERVAL_SECONDS = 10;
        G_ASSEMBLY_SCAN_INTERVAL_TICKS = 20 * G_ASSEMBLY_SCAN_INTERVAL_SECONDS;
        G_PARAMETERS_UPDATE_INTERVAL_TICKS = 20;
        G_REGISTRY_UPDATE_INTERVAL_SECONDS = 10;
        G_REGISTRY_UPDATE_INTERVAL_TICKS = 20 * G_REGISTRY_UPDATE_INTERVAL_SECONDS;
        G_ENFORCE_VALID_CELESTIAL_OBJECTS = true;
        G_BLOCKS_PER_TICK = 3500;
        G_ENABLE_FAST_SET_BLOCKSTATE = false;
        G_ENABLE_PROTECTION_CHECKS = true;
        G_ENABLE_EXPERIMENTAL_REFRESH = false;
        G_ENABLE_EXPERIMENTAL_UNLOAD = true;
        G_MINIMUM_DIMENSION_UNLOAD_QUEUE_DELAY = 100;
        G_ENABLE_FORGE_CHUNK_MANAGER = true;
        G_BLAST_RESISTANCE_CAP = 60.0f;
        CLIENT_BREATHING_OVERLAY_FORCED = true;
        CLIENT_LOCATION_SCALE = 1.0f;
        CLIENT_LOCATION_NAME_PREFIX = "\u00c2\u00a7l";
        CLIENT_LOCATION_BACKGROUND_COLOR = Commons.colorARGBtoInt(64, 48, 48, 48);
        CLIENT_LOCATION_TEXT_COLOR = Commons.colorARGBtoInt(230, 180, 180, 240);
        CLIENT_LOCATION_HAS_SHADOW = true;
        CLIENT_LOCATION_SCREEN_ALIGNMENT = EnumDisplayAlignment.MIDDLE_RIGHT;
        CLIENT_LOCATION_SCREEN_OFFSET_X = 0;
        CLIENT_LOCATION_SCREEN_OFFSET_Y = -20;
        CLIENT_LOCATION_TEXT_ALIGNMENT = EnumDisplayAlignment.TOP_RIGHT;
        CLIENT_LOCATION_WIDTH_RATIO = 0.0f;
        CLIENT_LOCATION_WIDTH_MIN = 90;
        TOOLTIP_ENABLE_DEDUPLICATION = EnumTooltipCondition.ALWAYS;
        TOOLTIP_CLEANUP_LIST = new String[]{"fuel details", "burn time", "durability"};
        TOOLTIP_ADD_REGISTRY_NAME = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_ORE_DICTIONARY_NAME = EnumTooltipCondition.ALWAYS;
        TOOLTIP_ADD_ARMOR_POINTS = EnumTooltipCondition.NEVER;
        TOOLTIP_ADD_BLOCK_MATERIAL = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_BURN_TIME = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_DURABILITY = EnumTooltipCondition.ALWAYS;
        TOOLTIP_ADD_ENCHANTABILITY = EnumTooltipCondition.ON_SNEAK;
        TOOLTIP_ADD_ENTITY_ID = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_FLAMMABILITY = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_FLUID = EnumTooltipCondition.ALWAYS;
        TOOLTIP_ADD_HARDNESS = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_HARVESTING = EnumTooltipCondition.ALWAYS;
        TOOLTIP_ADD_OPACITY = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        TOOLTIP_ADD_REPAIR_WITH = EnumTooltipCondition.ON_SNEAK;
        LOGGING_THROTTLE_MS = 5000L;
        LOGGING_JUMP = true;
        LOGGING_JUMPBLOCKS = false;
        LOGGING_ENERGY = false;
        LOGGING_EFFECTS = false;
        LOGGING_CLOAKING = false;
        LOGGING_VIDEO_CHANNEL = false;
        LOGGING_TARGETING = false;
        LOGGING_WEAPON = false;
        LOGGING_CAMERA = false;
        LOGGING_BUILDING = false;
        LOGGING_COLLECTION = false;
        LOGGING_TRANSPORTER = false;
        LOGGING_LUA = false;
        LOGGING_RADAR = false;
        LOGGING_BREATHING = false;
        LOGGING_WORLD_GENERATION = false;
        LOGGING_PROFILING_CPU_USAGE = true;
        LOGGING_PROFILING_MEMORY_ALLOCATION = false;
        LOGGING_PROFILING_THREAD_SAFETY = false;
        LOGGING_DICTIONARY = false;
        LOGGING_GLOBAL_REGION_REGISTRY = false;
        LOGGING_BREAK_PLACE = false;
        LOGGING_FORCE_FIELD = false;
        LOGGING_FORCE_FIELD_REGISTRY = false;
        LOGGING_ACCELERATOR = false;
        LOGGING_XML_PREPROCESSOR = false;
        LOGGING_RENDERING = false;
        LOGGING_CHUNK_HANDLER = false;
        LOGGING_CHUNK_RELOADING = false;
        LOGGING_CHUNK_LOADING = true;
        LOGGING_ENTITY_FX = false;
        LOGGING_CLIENT_SYNCHRONIZATION = false;
        LOGGING_GRAVITY = false;
        LOGGING_OFFLINE_AVATAR = true;
        ENERGY_DISPLAY_UNITS = "RF";
        ENERGY_ENABLE_IC2_EU = true;
        ENERGY_ENABLE_FE = true;
        ENERGY_ENABLE_GTCE_EU = true;
        ENERGY_ENABLE_RF = true;
        ENERGY_OVERVOLTAGE_SHOCK_FACTOR = 1.0f;
        ENERGY_OVERVOLTAGE_EXPLOSION_FACTOR = 1.0f;
        ENERGY_SCAN_INTERVAL_TICKS = 20;
        SPACE_GENERATOR_Y_MIN_CENTER = 55;
        SPACE_GENERATOR_Y_MAX_CENTER = 128;
        SPACE_GENERATOR_Y_MIN_BORDER = 5;
        SPACE_GENERATOR_Y_MAX_BORDER = 200;
        SHIP_MOVEMENT_COSTS_FACTORS = null;
        SHIP_MAX_ENERGY_STORED_BY_TIER = new int[]{0, 500000, 10000000, 100000000};
        SHIP_MASS_MAX_BY_TIER = new int[]{2000000, 3456, 13824, 110592};
        SHIP_MASS_MIN_BY_TIER = new int[]{0, 64, 1728, 6912};
        SHIP_MASS_MAX_ON_PLANET_SURFACE = 3000;
        SHIP_MASS_MIN_FOR_HYPERSPACE = 4000;
        SHIP_SIZE_MAX_PER_SIDE_BY_TIER = new int[]{127, 24, 48, 96};
        SHIP_COLLISION_TOLERANCE_BLOCKS = 3;
        SHIP_WARMUP_RANDOM_TICKS = 60;
        SHIP_VOLUME_SCAN_BLOCKS_PER_TICK = 1000;
        SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = 120;
        SHIP_MASS_UNLIMITED_PLAYER_NAMES = new String[]{"notch", "someone"};
        JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER = new int[]{127, 32, 64, 127};
        BIOMETRIC_SCANNER_DURATION_TICKS = 100;
        BIOMETRIC_SCANNER_RANGE_BLOCKS = 3;
        CAMERA_IMAGE_RECOGNITION_INTERVAL_TICKS = 20;
        CAMERA_RANGE_BASE_BLOCKS = 0;
        CAMERA_RANGE_UPGRADE_BLOCKS = 8;
        CAMERA_RANGE_UPGRADE_MAX_QUANTITY = 8;
        OFFLINE_AVATAR_ENABLE = true;
        OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS = true;
        OFFLINE_AVATAR_FORGET_ON_DEATH = false;
        OFFLINE_AVATAR_MODEL_SCALE = 0.5f;
        OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG = false;
        OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL = 1.0f;
        OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL = 5.0f;
        OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS = 1;
        OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS = 20 * OFFLINE_AVATAR_DELAY_FOR_REMOVAL_SECONDS;
        RADAR_MAX_ENERGY_STORED = 100000000;
        RADAR_SCAN_MIN_ENERGY_COST = 10000;
        RADAR_SCAN_ENERGY_COST_FACTORS = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        RADAR_SCAN_MIN_DELAY_SECONDS = 1;
        RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[]{1.0, 0.001, 0.0, 0.0};
        RADAR_MAX_ISOLATION_RANGE = 2;
        RADAR_MIN_ISOLATION_BLOCKS = 2;
        RADAR_MAX_ISOLATION_BLOCKS = 16;
        RADAR_MIN_ISOLATION_EFFECT = 0.12;
        RADAR_MAX_ISOLATION_EFFECT = 1.0;
        SIREN_RANGE_BLOCKS_BY_TIER = new float[]{0.0f, 32.0f, 64.0f, 128.0f};
        SPEAKER_RANGE_BLOCKS_BY_TIER = new float[]{0.0f, 16.0f, 32.0f, 64.0f};
        SPEAKER_QUEUE_MAX_MESSAGES = 12.0f;
        SPEAKER_RATE_MAX_MESSAGES = 3.0f;
        SPEAKER_RATE_PERIOD_TICKS = 60;
        SS_MAX_DEPLOY_RADIUS_BLOCKS = 100;
        SS_SEARCH_INTERVAL_TICKS = 20;
        SS_SCAN_BLOCKS_PER_SECOND = 10;
        SS_DEPLOY_BLOCKS_PER_INTERVAL = 10;
        SS_DEPLOY_INTERVAL_TICKS = 4;
        VIRTUAL_ASSISTANT_ENERGY_PER_TICK_BY_TIER = new int[]{0, 10, 40, 160};
        VIRTUAL_ASSISTANT_HIDE_COMMANDS_IN_CHAT = false;
        VIRTUAL_ASSISTANT_MAX_ENERGY_STORED_BY_TIER = new int[]{1000000, 10000, 30000, 100000};
        VIRTUAL_ASSISTANT_RANGE_BLOCKS_BY_TIER = new float[]{0.0f, 32.0f, 64.0f, 128.0f};
        LASER_MEDIUM_MAX_ENERGY_STORED_BY_TIER = new int[]{1000000, 10000, 30000, 100000};
        LASER_MEDIUM_FACTOR_BY_TIER = new double[]{1.25, 0.5, 1.0, 1.5};
        LASER_CANNON_MAX_MEDIUMS_COUNT = 10;
        LASER_CANNON_MAX_LASER_ENERGY = 3400000;
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = 5;
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = 1;
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = 0.6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = 2.0E-4;
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = 5.0E-6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = 0.23;
        LASER_CANNON_RANGE_MAX = 500;
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = 20;
        LASER_CANNON_ENTITY_HIT_ENERGY = 15000;
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = 3;
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = 30000;
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = 100;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = 900000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = 4.0f;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = 4.0f;
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = 75000;
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = 150000;
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = 750000;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = 0.01;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = 0.8;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = 5.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = 8.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = 50.0f;
        MINING_LASER_MAX_MEDIUMS_COUNT = 3;
        MINING_LASER_RADIUS_NO_LASER_MEDIUM = 4;
        MINING_LASER_RADIUS_PER_LASER_MEDIUM = 1;
        MINING_LASER_SETUP_UPDATE_PARAMETERS_TICKS = 20;
        MINING_LASER_WARMUP_DELAY_TICKS = 20;
        MINING_LASER_SCAN_DELAY_TICKS = 20;
        MINING_LASER_MINE_DELAY_TICKS = 3;
        MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_VOID = 20000;
        MINING_LASER_SCAN_ENERGY_PER_LAYER_IN_ATMOSPHERE = 30000;
        MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_VOID = 1500;
        MINING_LASER_MINE_ENERGY_PER_BLOCK_IN_ATMOSPHERE = 2500;
        MINING_LASER_MINE_ORES_ONLY_ENERGY_FACTOR = 15.0;
        MINING_LASER_MINE_SILKTOUCH_ENERGY_FACTOR = 1.5;
        MINING_LASER_MINE_SILKTOUCH_DEUTERIUM_MB = 0;
        MINING_LASER_MINE_FORTUNE_ENERGY_FACTOR = 1.5;
        TREE_FARM_MAX_MEDIUMS_COUNT = 5;
        TREE_FARM_MAX_RADIUS_NO_LASER_MEDIUM = 3;
        TREE_FARM_MAX_RADIUS_PER_LASER_MEDIUM = 2;
        TREE_FARM_totalMaxRadius = 0;
        TREE_FARM_MAX_DISTANCE_NO_LASER_MEDIUM = 8;
        TREE_FARM_MAX_DISTANCE_PER_MEDIUM = 6;
        TREE_FARM_WARM_UP_DELAY_TICKS = 40;
        TREE_FARM_SCAN_DELAY_TICKS = 40;
        TREE_FARM_HARVEST_LOG_DELAY_TICKS = 4;
        TREE_FARM_BREAK_LEAF_DELAY_TICKS = 2;
        TREE_FARM_SILKTOUCH_LEAF_DELAY_TICKS = 4;
        TREE_FARM_TAP_WET_SPOT_DELAY_TICKS = 4;
        TREE_FARM_TAP_DRY_SPOT_DELAY_TICKS = 1;
        TREE_FARM_TAP_RUBBER_LOG_DELAY_TICKS = 6;
        TREE_FARM_PLANT_DELAY_TICKS = 2;
        TREE_FARM_SCAN_ENERGY_PER_SURFACE = 1;
        TREE_FARM_TAP_WET_SPOT_ENERGY_PER_BLOCK = 1;
        TREE_FARM_TAP_RUBBER_LOG_ENERGY_PER_BLOCK = 2;
        TREE_FARM_HARVEST_LOG_ENERGY_PER_BLOCK = 1;
        TREE_FARM_HARVEST_LEAF_ENERGY_PER_BLOCK = 1;
        TREE_FARM_SILKTOUCH_LOG_ENERGY_PER_BLOCK = 2;
        TREE_FARM_SILKTOUCH_LEAF_ENERGY_PER_BLOCK = 2;
        TREE_FARM_PLANT_ENERGY_PER_BLOCK = 1;
        CLOAKING_MAX_ENERGY_STORED = 500000000;
        CLOAKING_COIL_CAPTURE_BLOCKS = 5;
        CLOAKING_MAX_FIELD_RADIUS = 63;
        CLOAKING_TIER1_ENERGY_PER_BLOCK = 32;
        CLOAKING_TIER2_ENERGY_PER_BLOCK = 128;
        CLOAKING_TIER1_FIELD_REFRESH_INTERVAL_TICKS = 60;
        CLOAKING_TIER2_FIELD_REFRESH_INTERVAL_TICKS = 30;
        CLOAKING_VOLUME_SCAN_BLOCKS_PER_TICK = 1000;
        CLOAKING_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = 120;
        BREATHING_ENERGY_PER_CANISTER = 200;
        BREATHING_ENERGY_PER_NEW_AIR_BLOCK_BY_TIER = new int[]{0, 12, 180, 2610};
        BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK_BY_TIER = new int[]{0, 4, 60, 870};
        BREATHING_MAX_ENERGY_STORED_BY_TIER = new int[]{0, 1400, 21000, 304500};
        BREATHING_AIR_GENERATION_TICKS = 40;
        BREATHING_AIR_GENERATION_RANGE_BLOCKS_BY_TIER = new int[]{200, 16, 48, 144};
        BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS = 256;
        BREATHING_AIR_SIMULATION_DELAY_TICKS = 30;
        BREATHING_AIR_AT_ENTITY_DEBUG = false;
        BREATHING_AIR_TANK_BREATH_DURATION_TICKS = 300;
        BREATHING_AIR_TANK_CAPACITY_BY_TIER = new int[]{20, 32, 64, 128};
        IC2_REACTOR_MAX_HEAT_STORED = 30000;
        IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK = 648;
        IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK = 54;
        IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK = 54;
        IC2_REACTOR_COOLING_PER_INTERVAL = 1080;
        IC2_REACTOR_ENERGY_PER_HEAT = 2.0;
        IC2_REACTOR_COOLING_INTERVAL_TICKS = 10;
        TRANSPORTER_MAX_ENERGY_STORED = 1000000;
        TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS = TRANSPORTER_MAX_ENERGY_STORED / 2;
        TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY = 8;
        TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS = 8;
        TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS = 3;
        TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS = 1;
        TRANSPORTER_RANGE_BASE_BLOCKS = 256;
        TRANSPORTER_RANGE_UPGRADE_BLOCKS = 64;
        TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY = 8;
        TRANSPORTER_LOCKING_ENERGY_FACTORS = new double[]{20.0, 3.0, 0.0, 10.0, 1.0 / Math.sqrt(2.0)};
        TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK = Math.pow(0.01, 0.0033333333333333335);
        TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS = 0.25;
        TRANSPORTER_LOCKING_STRENGTH_AT_BEACON = 0.5;
        TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER = 1.0;
        TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR = 0.5;
        TRANSPORTER_LOCKING_STRENGTH_UPGRADE = 0.15;
        TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS = 0.25;
        TRANSPORTER_LOCKING_SPEED_AT_BEACON = 0.75;
        TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER = 1.0;
        TRANSPORTER_LOCKING_SPEED_UPGRADE = 0.25;
        TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS = 100;
        TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY = 2;
        TRANSPORTER_JAMMED_COOLDOWN_TICKS = 40;
        TRANSPORTER_ENERGIZING_ENERGY_FACTORS = new double[]{10000.0, 1500.0, 0.0, 10.0, 1.0 / Math.sqrt(2.0)};
        TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR = 10.0;
        TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE = 5;
        TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS = 0.2;
        TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE = 100;
        TRANSPORTER_ENERGIZING_LOCKING_LOST = 0.5;
        TRANSPORTER_ENERGIZING_CHARGING_TICKS = 60;
        TRANSPORTER_ENERGIZING_COOLDOWN_TICKS = 200;
        TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS = 1.0;
        TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS = 2;
        TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS = 2;
        TRANSPORTER_BEACON_MAX_ENERGY_STORED = 60000;
        TRANSPORTER_BEACON_ENERGY_PER_TICK = 10;
        TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS = 20;
        ENAN_REACTOR_MAX_ENERGY_STORED_BY_TIER = new int[]{100000000, 100000000, 500000000, 2000000000};
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = new int[]{64, 6, 12, 24};
        ENAN_REACTOR_GENERATION_MIN_RF_BY_TIER = new int[]{4, 4, 4, 4};
        ENAN_REACTOR_GENERATION_MAX_RF_BY_TIER = new int[]{64000, 64000, 192000, 576000};
        ENAN_REACTOR_EXPLOSION_MAX_RADIUS_BY_TIER = new int[]{6, 6, 8, 10};
        ENAN_REACTOR_EXPLOSION_MAX_REMOVAL_CHANCE_BY_TIER = new double[]{0.1, 0.1, 0.1, 0.1};
        ENAN_REACTOR_EXPLOSION_COUNT_BY_TIER = new int[]{3, 3, 3, 3};
        ENAN_REACTOR_EXPLOSION_STRENGTH_MIN_BY_TIER = new float[]{4.0f, 4.0f, 5.0f, 6.0f};
        ENAN_REACTOR_EXPLOSION_STRENGTH_MAX_BY_TIER = new float[]{7.0f, 7.0f, 9.0f, 11.0f};
        FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER = new int[]{20000000, 30000, 90000, 150000};
        FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE = 1000.0;
        FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED = 10.0;
        FORCE_FIELD_EXPLOSION_STRENGTH_VANILLA_CAP = 15.0;
        CAPACITOR_MAX_ENERGY_STORED_BY_TIER = new int[]{20000000, 800000, 4000000, 20000000};
        CAPACITOR_IC2_SINK_TIER_NAME_BY_TIER = new String[]{"MaxV", "MV", "HV", "EV"};
        CAPACITOR_IC2_SOURCE_TIER_NAME_BY_TIER = new String[]{"MaxV", "MV", "HV", "EV"};
        CAPACITOR_FLUX_RATE_INPUT_BY_TIER = new int[]{0x3FFFFFFF, 800, 4000, 20000};
        CAPACITOR_FLUX_RATE_OUTPUT_BY_TIER = new int[]{0x3FFFFFFF, 800, 4000, 20000};
        CAPACITOR_EFFICIENCY_PER_UPGRADE = new double[]{0.95, 0.98, 1.0};
        LIFT_MAX_ENERGY_STORED = 900;
        LIFT_ENERGY_PER_ENTITY = 150;
        LIFT_UPDATE_INTERVAL_TICKS = 10;
        LIFT_ENTITY_COOLDOWN_TICKS = 40;
        CHUNK_LOADER_MAX_ENERGY_STORED = 1000000;
        CHUNK_LOADER_MAX_RADIUS = 2;
        CHUNK_LOADER_ENERGY_PER_CHUNK = 8;
        HULL_HARDNESS = new float[]{666666.0f, 25.0f, 50.0f, 80.0f};
        HULL_BLAST_RESISTANCE = new float[]{666666.0f, 60.0f, 90.0f, 120.0f};
        HULL_HARVEST_LEVEL = new int[]{666666, 2, 3, 3};
        blockTransformers = new HashMap(30);
        ACCELERATOR_ENABLE = true;
        ACCELERATOR_TEMPERATURES_K = new double[]{270.0, 200.0, 7.0};
        ACCELERATOR_MAX_PARTICLE_BUNCHES = 20;
        ELECTROMAGNETIC_CELL_CAPACITY_BY_TIER = new int[]{16000, 500, 1000, 2000};
        PLASMA_TORCH_CAPACITY_BY_TIER = new int[]{16000, 200, 400, 800};
    }
}

