/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.MetaOrbInstance;
import cr0s.warpdrive.config.structures.Orb;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class MetaOrb
extends Orb {
    protected MetaShell metaShell;

    public MetaOrb(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        List<Element> listMetaShells = XmlFileManager.getChildrenElementByTagName(element, "metaShell");
        if (listMetaShells.size() > 1) {
            throw new InvalidXmlException(String.format("Too many metaShell defined in structure %s. Maximum is 1.", this.getFullName()));
        }
        if (listMetaShells.size() == 1) {
            this.metaShell = new MetaShell(this.getFullName());
            this.metaShell.loadFromXmlElement(listMetaShells.get(0));
        }
        return true;
    }

    @Override
    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        return this.instantiate(random).func_180709_b(world, random, blockPos);
    }

    @Override
    public AbstractStructureInstance instantiate(Random random) {
        return new MetaOrbInstance(this, random);
    }

    public class MetaShell
    implements IXmlRepresentable {
        private final String parentFullName;
        protected Block block;
        protected int metadata;
        protected int minCount;
        protected int maxCount;
        protected double minRadius;
        protected double relativeRadius;

        public MetaShell(String parentFullName) {
            this.parentFullName = parentFullName;
        }

        @Nonnull
        public String func_176610_l() {
            return "metaShell";
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            String stringValue;
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info("  + found metaShell");
            }
            if (!(stringValue = element.getAttribute("block")).isEmpty()) {
                this.block = Block.func_149684_b((String)stringValue);
                if (this.block == null) {
                    WarpDrive.logger.warn(String.format("Skipping missing metaShell core block %s in %s", stringValue, this.parentFullName));
                } else {
                    stringValue = element.getAttribute("metadata");
                    if (stringValue.isEmpty()) {
                        this.metadata = 0;
                    } else {
                        try {
                            this.metadata = Integer.parseInt(stringValue);
                        }
                        catch (NumberFormatException exception) {
                            throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid metadata %s, expecting an integer", this.parentFullName, stringValue));
                        }
                    }
                    if (this.metadata < 0 || this.metadata > 15) {
                        throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid metadata %d, expecting a value between 0 and 15 included", this.parentFullName, this.metadata));
                    }
                }
            }
            try {
                this.minCount = Integer.parseInt(element.getAttribute("minCount"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid minCount %s, expecting an integer", this.parentFullName, element.getAttribute("minCount")));
            }
            if (this.minCount < 1) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid minCount %d, expecting greater then 0", this.parentFullName, this.minCount));
            }
            try {
                this.maxCount = Integer.parseInt(element.getAttribute("maxCount"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid maxCount %s, expecting an integer", this.parentFullName, element.getAttribute("maxCount")));
            }
            if (this.maxCount < this.minCount) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid maxCount %d, expecting greater than or equal to minCount %d", this.parentFullName, this.maxCount, this.minCount));
            }
            try {
                stringValue = element.getAttribute("minRadius");
                this.minRadius = stringValue.isEmpty() ? 2.0 : Double.parseDouble(element.getAttribute("minRadius"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid minRadius %s, expecting a double", this.parentFullName, element.getAttribute("minRadius")));
            }
            if (this.minRadius < 0.0 || this.minRadius > 20.0) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid minRadius %.3f, expecting a value between 0.0 and 20.0 included", this.parentFullName, this.minRadius));
            }
            try {
                stringValue = element.getAttribute("relativeRadius");
                this.relativeRadius = stringValue.isEmpty() ? 0.5 : Double.parseDouble(element.getAttribute("relativeRadius"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid relativeRadius %s, expecting a double", this.parentFullName, element.getAttribute("relativeRadius")));
            }
            if (this.relativeRadius < 0.0 || this.relativeRadius > 2.0) {
                throw new InvalidXmlException(String.format("Failed to load metaShell from structure %s due to invalid relativeRadius %.3f, expecting a value between 0.0 and 2.0 included", this.parentFullName, this.relativeRadius));
            }
            return true;
        }
    }
}

