/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.OrbInstance;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Orb
extends AbstractStructure {
    protected OrbShell[] orbShells;
    protected boolean hasStarCore = false;
    protected String schematicName;

    public Orb(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        List<Element> listShells = XmlFileManager.getChildrenElementByTagName(element, "shell");
        this.orbShells = new OrbShell[listShells.size()];
        int shellIndexOut = 0;
        for (Element elementShell : listShells) {
            String orbShellName = elementShell.getAttribute("name");
            this.orbShells[shellIndexOut] = new OrbShell(this.getFullName(), orbShellName);
            try {
                this.orbShells[shellIndexOut].loadFromXmlElement(elementShell);
                ++shellIndexOut;
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Skipping invalid shell %s", orbShellName));
            }
        }
        List<Element> listSchematic = XmlFileManager.getChildrenElementByTagName(element, "schematic");
        if (listSchematic.size() > 1) {
            WarpDrive.logger.error(String.format("Too many schematic defined, only first one will be used in structure %s", this.getFullName()));
        }
        if (listSchematic.size() > 0) {
            this.schematicName = listSchematic.get(0).getAttribute("group");
        }
        return true;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        return this.instantiate(random).func_180709_b(world, random, blockPos);
    }

    @Override
    public AbstractStructureInstance instantiate(Random random) {
        return new OrbInstance(this, random);
    }

    public class OrbShell
    extends GenericSet<Filler> {
        protected int minThickness;
        protected int maxThickness;

        public OrbShell(String parentFullName, String name) {
            super(parentFullName, name, Filler.DEFAULT, "filler");
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info(String.format("  + found shell %s", element.getAttribute("name")));
            }
            super.loadFromXmlElement(element);
            for (String importGroupName : this.getImportGroupNames()) {
                GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getGenericSet(importGroupName);
                if (fillerSet == null) {
                    WarpDrive.logger.warn(String.format("Skipping missing FillerSet %s in shell %s:%s", importGroupName, this.group, this.name));
                    continue;
                }
                this.loadFrom(fillerSet);
            }
            for (String importGroup : this.getImportGroups()) {
                if (WarpDriveConfig.FillerManager.doesGroupExist(importGroup)) continue;
                WarpDrive.logger.warn(String.format("An invalid FillerSet group %s is referenced in shell %s:%s", importGroup, this.group, this.name));
            }
            try {
                this.minThickness = Integer.parseInt(element.getAttribute("minThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Invalid minThickness in shell %s of structure %s", this.name, this.group));
            }
            try {
                this.maxThickness = Integer.parseInt(element.getAttribute("maxThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Invalid maxThickness in shell %s of structure %s", this.name, this.group));
            }
            if (this.maxThickness < this.minThickness) {
                throw new InvalidXmlException(String.format("Invalid maxThickness %d lower than minThickness %s in shell %s of orb %s", this.maxThickness, this.minThickness, this.name, this.group));
            }
            return true;
        }

        public OrbShell instantiate(Random random) {
            OrbShell orbShell = new OrbShell(this.group, this.name);
            orbShell.minThickness = this.minThickness;
            orbShell.maxThickness = this.maxThickness;
            try {
                orbShell.loadFrom(this);
                for (String importGroup : this.getImportGroups()) {
                    GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getRandomSetFromGroup(random, importGroup);
                    if (fillerSet == null) {
                        WarpDrive.logger.warn(String.format("Ignoring invalid group %s in shell %s of structure %s", importGroup, this.name, this.group));
                        continue;
                    }
                    if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                        WarpDrive.logger.info(String.format("Filling %s:%s with %s:%s", this.group, this.name, importGroup, fillerSet.func_176610_l()));
                    }
                    orbShell.loadFrom(fillerSet);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to instantiate shell %s from structure %s", this.name, this.group));
            }
            if (orbShell.isEmpty()) {
                if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                    WarpDrive.logger.info(String.format("Ignoring empty shell %s in structure %s", this.name, this.group));
                }
                return null;
            }
            return orbShell;
        }
    }
}

