/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.Schematic;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.world.WorldGenStructure;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicInstance
extends AbstractStructureInstance {
    protected JumpShip jumpShip;
    protected Schematic.Replacement[] replacements;
    protected Schematic.Insertion[] insertions;

    public SchematicInstance(Schematic schematic, Random random) {
        super(schematic, random);
        WarpDriveText reason = new WarpDriveText();
        this.jumpShip = JumpShip.createFromFile(schematic.filename, reason);
        if (this.jumpShip == null) {
            WarpDrive.logger.error(String.format("Failed to instantiate schematic structure %s due to %s", new Object[]{schematic.getFullName(), reason}));
            return;
        }
        this.replacements = new Schematic.Replacement[schematic.replacements.length];
        int replacementIndexOut = 0;
        for (int replacementIndexIn = 0; replacementIndexIn < schematic.replacements.length; ++replacementIndexIn) {
            Schematic.Replacement replacement = schematic.replacements[replacementIndexIn].instantiate(random);
            if (replacement == null) continue;
            this.replacements[replacementIndexOut] = replacement;
            ++replacementIndexOut;
        }
        this.insertions = new Schematic.Insertion[schematic.insertions.length];
        int insertionIndexOut = 0;
        for (int insertionIndexIn = 0; insertionIndexIn < schematic.replacements.length; ++insertionIndexIn) {
            Schematic.Insertion insertion = schematic.insertions[insertionIndexIn].instantiate(random);
            if (insertion == null) continue;
            this.insertions[insertionIndexOut] = insertion;
            ++insertionIndexOut;
        }
    }

    public SchematicInstance(NBTTagCompound tagCompound) {
        super(tagCompound);
    }

    @Override
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        if (this.jumpShip == null) {
            return false;
        }
        int y2 = Commons.clamp(WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + (this.jumpShip.core.func_177956_o() - this.jumpShip.minY), WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - (this.jumpShip.maxY - this.jumpShip.core.func_177956_o()), blockPos.func_177956_o());
        new WorldGenStructure(random.nextFloat() < 0.2f, random).deployShip(world, this.jumpShip, blockPos.func_177958_n(), y2, blockPos.func_177952_p(), (byte)0);
        return true;
    }
}

