/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.core;

import cr0s.warpdrive.core.FMLLoadingPlugin;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private static final HashMap<String, String> nodeMap = new HashMap();
    public static ConcurrentSkipListMap<String, Integer> countClass = new ConcurrentSkipListMap();
    public static ConcurrentHashMap<String, Long> sizeClass = new ConcurrentHashMap(8192);
    private static final String GRAVITY_MANAGER_CLASS = "cr0s/warpdrive/data/GravityManager";
    private static final String CLOAK_MANAGER_CLASS = "cr0s/warpdrive/data/CloakManager";
    private static final String CELESTIAL_OBJECT_MANAGER_CLASS = "cr0s/warpdrive/data/CelestialObjectManager";
    private static final boolean debugLog = false;
    private static final String ASM_DUMP_BEFORE = "asm/warpdrive.before";
    private static final String ASM_DUMP_AFTER = "asm/warpdrive.after";
    private static final String ASM_DUMP_FAILED = "asm/warpdrive.failed";
    private static boolean opcodeToString_firstDump = true;

    public ClassTransformer() {
        nodeMap.put("EntityLivingBase.class", "vn");
        nodeMap.put("travel.name", "func_191986_a");
        nodeMap.put("travel.desc", "(FFF)V");
        nodeMap.put("EntityItem.class", "acj");
        nodeMap.put("onUpdate.name", "func_70071_h_");
        nodeMap.put("onUpdate.desc", "()V");
        nodeMap.put("WorldClient.class", "brz");
        nodeMap.put("invalidateRegionAndSetBlock.name", "func_180503_b");
        nodeMap.put("invalidateRegionAndSetBlock.desc", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z");
        nodeMap.put("setBlockState.name", "func_180501_a");
        nodeMap.put("NetHandlerPlayClient.class", "brx");
        nodeMap.put("handleUpdateTileEntity.name", "func_147273_a");
        nodeMap.put("handleUpdateTileEntity.desc", "(Lnet/minecraft/network/play/server/SPacketUpdateTileEntity;)V");
        nodeMap.put("Chunk.class", "axu");
        nodeMap.put("read.name", "func_186033_a");
        nodeMap.put("read.desc", "(Lnet/minecraft/network/PacketBuffer;IZ)V");
        nodeMap.put("generateHeightMap.name", "func_76590_a");
        nodeMap.put("generateHeightMap.desc", "()V");
        nodeMap.put("AdvancementManager.class", "nq");
        nodeMap.put("loadBuiltInAdvancements.name", "func_192777_a");
        nodeMap.put("loadBuiltInAdvancements.desc", "(Ljava/util/Map;)V");
        nodeMap.put("ForgeHooks.class", "ForgeHooks");
        nodeMap.put("loadAdvancements.name", "lambda$loadAdvancements$0");
        nodeMap.put("loadAdvancements.desc", "(Lnet/minecraftforge/fml/common/ModContainer;Ljava/util/Map;Lnet/minecraftforge/common/crafting/JsonContext;Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/lang/Boolean;");
        nodeMap.put("RenderGlobal.class", "buw");
        nodeMap.put("renderWorldBorder.name", "func_180449_a");
        nodeMap.put("renderWorldBorder.desc", "(Lnet/minecraft/entity/Entity;F)V");
        nodeMap.put("getWorldBorder.name", "func_175723_af");
        nodeMap.put("getWorldBorder.desc", "()Lnet/minecraft/world/border/WorldBorder;");
    }

    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, byte[] bytesOld) {
        byte[] bytesNew;
        if (bytesOld == null) {
            return null;
        }
        switch (transformedName) {
            case "net.minecraft.entity.EntityLivingBase": {
                bytesNew = this.transformMinecraftEntityLivingBase(bytesOld);
                break;
            }
            case "net.minecraft.entity.item.EntityItem": {
                bytesNew = this.transformMinecraftEntityItem(bytesOld);
                break;
            }
            case "com.creativemd.itemphysic.physics.ServerPhysic": {
                bytesNew = this.transformItemPhysicEntityItem(bytesOld);
                break;
            }
            case "micdoodle8.mods.galacticraft.core.TransformerHooks": {
                bytesNew = this.transformGalacticraftTransformerHooks(bytesOld);
                break;
            }
            case "net.minecraft.client.multiplayer.WorldClient": {
                bytesNew = this.transformMinecraftWorldClient(bytesOld);
                break;
            }
            case "net.minecraft.client.network.NetHandlerPlayClient": {
                bytesNew = this.transformMinecraftNetHandlerPlayClient(bytesOld);
                break;
            }
            case "net.minecraft.world.chunk.Chunk": {
                bytesNew = this.transformMinecraftChunk(bytesOld);
                break;
            }
            case "net.minecraft.advancements.AdvancementManager": {
                bytesNew = this.transformMinecraftAdvancementManager(bytesOld);
                break;
            }
            case "net.minecraftforge.common.ForgeHooks": {
                bytesNew = this.transformMinecraftForgeHooks(bytesOld);
                break;
            }
            case "net.minecraft.client.renderer.RenderGlobal": {
                bytesNew = this.transformMinecraftRenderGlobal(bytesOld);
                break;
            }
            default: {
                bytesNew = null;
            }
        }
        try {
            ClassTransformer.collectClientValidation(transformedName, bytesOld);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bytesNew == null) {
            return bytesOld;
        }
        if (bytesNew == bytesOld) {
            this.saveClassToFile(ASM_DUMP_FAILED, transformedName, bytesOld);
            return bytesOld;
        }
        this.saveClassToFile(ASM_DUMP_AFTER, transformedName, bytesNew);
        return bytesNew;
    }

    private static void collectClientValidation(@Nonnull String transformedName, @Nonnull byte[] bytes) {
        String[] names = transformedName.split("[.$]");
        String shortName = names[0] + "." + (names.length > 1 ? names[1] : "");
        Integer count = countClass.get(shortName);
        Long size = sizeClass.get(shortName);
        if (count == null) {
            count = 0;
            size = 0L;
        }
        countClass.put(shortName, count + 1);
        sizeClass.put(shortName, size + (long)bytes.length);
    }

    @Nonnull
    public static String getClientValidation() {
        StringBuilder result = new StringBuilder().append(new Date().toString());
        for (String key : countClass.keySet()) {
            result.append("\n").append(key).append("\t").append(countClass.get(key)).append("\t").append(sizeClass.get(key));
        }
        return result.toString();
    }

    private byte[] transformMinecraftEntityLivingBase(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int countExpected = 2;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("travel.name")) && !methodNode.name.equals("travel") || !methodNode.desc.equals(nodeMap.get("travel.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(-0.08)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getNegGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++countTransformed;
                    continue;
                }
                if (!nodeAt.cst.equals(0.08)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++countTransformed;
            }
        }
        if (countTransformed != 2) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 2));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftEntityItem(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int countExpected = 2;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("onUpdate.name")) && !methodNode.name.equals("onUpdate") || !methodNode.desc.equals(nodeMap.get("onUpdate.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (abstractNode instanceof LdcInsnNode) {
                    MethodInsnNode overwriteNode;
                    VarInsnNode beforeNode;
                    LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                    if (nodeAt.cst.equals(0.04f)) {
                        beforeNode = new VarInsnNode(25, 0);
                        overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                        methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                        methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++countTransformed;
                    }
                    if (!nodeAt.cst.equals(0.98f)) continue;
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++countTransformed;
                    continue;
                }
                if (!(abstractNode instanceof MethodInsnNode) || abstractNode.getOpcode() != 184) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractNode;
                if (!methodInsnNode.owner.equals("zmaster587/advancedRocketry/util/GravityHandler")) continue;
                methodInsnNode.owner = GRAVITY_MANAGER_CLASS;
                methodInsnNode.name = "applyEntityItemGravity";
                methodInsnNode.desc = "(Lnet/minecraft/entity/item/EntityItem;)V";
                ++countTransformed;
            }
        }
        if (countTransformed != 2) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 2));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformItemPhysicEntityItem(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int countExpected = 2;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("update") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)V")) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++countTransformed;
                }
                if (!nodeAt.cst.equals(0.98)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++countTransformed;
            }
        }
        if (countTransformed != 2) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 2));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformGalacticraftTransformerHooks(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int countExpected = 7;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            MethodInsnNode overwriteNode;
            VarInsnNode beforeNode;
            LdcInsnNode nodeAt;
            AbstractInsnNode abstractNode;
            int indexInstruction;
            if (methodNode.name.equals("getGravityForEntity") && methodNode.desc.equals("(Lnet/minecraft/entity/Entity;)D")) {
                FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
                for (indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                    abstractNode = methodNode.instructions.get(indexInstruction);
                    if (!(abstractNode instanceof LdcInsnNode)) continue;
                    nodeAt = (LdcInsnNode)abstractNode;
                    if (!nodeAt.cst.equals(0.08)) continue;
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++countTransformed;
                }
            }
            if (!methodNode.name.equals("getItemGravity") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)D")) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.04f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++countTransformed;
            }
        }
        if (countTransformed != 7) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 7));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftWorldClient(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("invalidateRegionAndSetBlock.name")) && !methodNode.name.equals("invalidateRegionAndSetBlock") || !methodNode.desc.equals(nodeMap.get("invalidateRegionAndSetBlock.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(nodeMap.get("setBlockState.name")) && !nodeAt.name.equals("setBlockState")) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "WorldClient_invalidateRegionAndSetBlock_setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", false);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftNetHandlerPlayClient(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("handleUpdateTileEntity.name")) && !methodNode.name.equals("handleUpdateTileEntity") || !methodNode.desc.equals(nodeMap.get("handleUpdateTileEntity.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNodeToRemove;
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!(nodeAt.cst instanceof String) || !((String)nodeAt.cst).contains("Received invalid update packet for null tile entity at ") || !((abstractNodeToRemove = methodNode.instructions.get(indexInstruction - 1)) instanceof FieldInsnNode) || !((FieldInsnNode)abstractNodeToRemove).desc.equals("Lorg/apache/logging/log4j/Logger;")) continue;
                this.removeInstruction(methodNode, --indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                --indexInstruction;
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftChunk(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (Thread.currentThread().getName().equals("Server thread")) {
            FMLLoadingPlugin.logger.info(String.format("Skipping client-side only transformation for %s", classNode.name));
            return bytes;
        }
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("read.name")) && !methodNode.name.equals("read") || !methodNode.desc.equals(nodeMap.get("read.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(nodeMap.get("generateHeightMap.name")) && !nodeAt.name.equals("generateHeightMap") || !nodeAt.desc.equals(nodeMap.get("generateHeightMap.desc"))) continue;
                MethodInsnNode insertMethodNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "Chunk_read", "(Lnet/minecraft/world/chunk/Chunk;)V", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertMethodNode);
                ++indexInstruction;
                VarInsnNode insertVarNode = new VarInsnNode(25, 0);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertVarNode);
                ++indexInstruction;
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftAdvancementManager(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("loadBuiltInAdvancements.name")) && !methodNode.name.equals("loadBuiltInAdvancements") || !methodNode.desc.equals(nodeMap.get("loadBuiltInAdvancements.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNodeToRemove;
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!(nodeAt.cst instanceof String) || !((String)nodeAt.cst).contains("Parsing error loading built-in advancement ") || !((abstractNodeToRemove = methodNode.instructions.get(indexInstruction - 4)) instanceof FieldInsnNode) || !((FieldInsnNode)abstractNodeToRemove).desc.equals("Lorg/apache/logging/log4j/Logger;")) continue;
                this.removeInstruction(methodNode, indexInstruction -= 4);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                --indexInstruction;
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftForgeHooks(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("loadAdvancements.name")) && !methodNode.name.equals("loadAdvancements") || !methodNode.desc.equals(nodeMap.get("loadAdvancements.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNodeToRemove;
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!(nodeAt.cst instanceof String) || !((String)nodeAt.cst).contains("Parsing error loading built-in advancement ") || !((abstractNodeToRemove = methodNode.instructions.get(indexInstruction - 4)) instanceof FieldInsnNode) || !((FieldInsnNode)abstractNodeToRemove).desc.equals("Lorg/apache/logging/log4j/Logger;")) continue;
                this.removeInstruction(methodNode, indexInstruction -= 4);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                this.removeInstruction(methodNode, indexInstruction);
                --indexInstruction;
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private byte[] transformMinecraftRenderGlobal(@Nonnull byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean countExpected = true;
        int countTransformed = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("renderWorldBorder.name")) && !methodNode.name.equals("renderWorldBorder") || !methodNode.desc.equals(nodeMap.get("renderWorldBorder.desc"))) continue;
            FMLLoadingPlugin.logger.debug(String.format("Found method to transform: %s %s %s", classNode.name, methodNode.name, methodNode.desc));
            for (int indexInstruction = 0; indexInstruction < methodNode.instructions.size(); ++indexInstruction) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(indexInstruction);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(nodeMap.get("getWorldBorder.name")) && !nodeAt.name.equals("getWorldBorder")) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CELESTIAL_OBJECT_MANAGER_CLASS, "World_getWorldBorder", "(Lnet/minecraft/world/World;)Lnet/minecraft/world/border/WorldBorder;", false);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++countTransformed;
            }
        }
        if (countTransformed != 1) {
            FMLLoadingPlugin.logger.error(String.format("Transformation failed for %s (%d/%d), aborting...", classNode.name, countTransformed, 1));
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] bytesNew = writer.toByteArray();
        FMLLoadingPlugin.logger.info(String.format("Successful injection in %s", classNode.name));
        return bytesNew;
    }

    private void removeInstruction(@Nonnull MethodNode methodNode, int indexInstruction) {
        AbstractInsnNode abstractNodeToRemove = methodNode.instructions.get(indexInstruction);
        methodNode.instructions.remove(abstractNodeToRemove);
    }

    private void saveClassToFile(String path, String nameClass, byte[] bytes) {
        try {
            File fileDir = new File(path);
            if (!(fileDir.exists() && fileDir.isDirectory() || fileDir.mkdirs())) {
                FMLLoadingPlugin.logger.error("Unable to create ASM dump folder, skipping...");
                return;
            }
            String nameClass_clean = nameClass.replace("/", "_").replace("\\", "_").replace(" ", "_");
            File fileClass = new File(fileDir, nameClass_clean + ".class");
            FileOutputStream fileOutputStream = new FileOutputStream(fileClass);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.write(bytes);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String opcodeToString(int opcode) {
        Field[] fields;
        for (Field field : fields = Opcodes.class.getFields()) {
            if (field.getType() != Integer.TYPE) continue;
            try {
                if (field.getInt(null) != opcode) continue;
                return field.getName();
            }
            catch (Throwable throwable) {
                if (!opcodeToString_firstDump) continue;
                throwable.printStackTrace();
                opcodeToString_firstDump = false;
            }
        }
        return String.format("0x%x", opcode);
    }

    private static void decompile(AbstractInsnNode abstractNode) {
        if (abstractNode == null) {
            FMLLoadingPlugin.logger.error(String.format("%20s %-20s %s", "NULL", "NULL", "null node"));
            return;
        }
        String opcode = ClassTransformer.opcodeToString(abstractNode.getOpcode());
        if (abstractNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s", opcode, "Field", node.owner, node.name, node.desc));
        } else if (abstractNode instanceof FrameNode) {
            FrameNode node = (FrameNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %d %s %s", opcode, "Frame", node.type, node.local, node.stack));
        } else if (abstractNode instanceof IincInsnNode) {
            IincInsnNode node = (IincInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s var %s %s", opcode, "Instruction", node.var, node.incr));
        } else if (abstractNode instanceof InsnNode) {
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Instruction", "-"));
        } else if (abstractNode instanceof IntInsnNode) {
            IntInsnNode node = (IntInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Instruction", node.operand));
        } else if (abstractNode instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode node = (InvokeDynamicInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s %s", opcode, "Instruction", node.name, node.desc, node.bsm, Arrays.toString(node.bsmArgs)));
        } else if (abstractNode instanceof JumpInsnNode) {
            JumpInsnNode node = (JumpInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Jump", node.label.getLabel()));
        } else if (abstractNode instanceof LabelNode) {
            LabelNode node = (LabelNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Label", node.getLabel()));
        } else if (abstractNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Load", node.cst));
        } else if (abstractNode instanceof LineNumberNode) {
            LineNumberNode node = (LineNumberNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Line", node.line));
        } else if (abstractNode instanceof LookupSwitchInsnNode) {
            LookupSwitchInsnNode node = (LookupSwitchInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s", opcode, "Instruction", node.dflt, node.keys, node.labels));
        } else if (abstractNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s %s", opcode, "Method", node.owner, node.name, node.desc, node.itf));
        } else if (abstractNode instanceof MultiANewArrayInsnNode) {
            MultiANewArrayInsnNode node = (MultiANewArrayInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s", opcode, "Instruction", node.desc, node.dims));
        } else if (abstractNode instanceof TableSwitchInsnNode) {
            TableSwitchInsnNode node = (TableSwitchInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s %s", opcode, "Instruction", node.dflt, node.min, node.max, node.labels));
        } else if (abstractNode instanceof TypeInsnNode) {
            TypeInsnNode node = (TypeInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Typed instruction", node.desc));
        } else if (abstractNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Var", node.var));
        } else {
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s", opcode, "Instruction", abstractNode.getOpcode(), abstractNode.getType(), abstractNode));
        }
    }
}

