/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.data.CelestialObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.w3c.dom.Element;

public class CelestialObjectManager
extends XmlFileManager {
    private static final CelestialObjectManager SERVER = new CelestialObjectManager();
    private static final CelestialObjectManager CLIENT = new CelestialObjectManager();
    private HashMap<String, CelestialObject> celestialObjectsById = new HashMap();
    public CelestialObject[] celestialObjects = new CelestialObject[0];
    private double maxWorldBorder = 0.0;

    public static void clearForReload(boolean isRemote) {
        (isRemote ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjectsById = new HashMap();
    }

    public static CelestialObject get(boolean isRemote, String id) {
        return (isRemote ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjectsById.get(id);
    }

    public static CelestialObject get(World world, int x, int z) {
        if (world == null) {
            return null;
        }
        return (world.field_72995_K ? CLIENT : SERVER).get(world.field_73011_w.getDimension(), x, z);
    }

    public static CelestialObject get(boolean isRemote, int dimensionId, int x, int z) {
        return (isRemote ? CLIENT : SERVER).get(dimensionId, x, z);
    }

    public static CelestialObject getClosestChild(World world, int x, int z) {
        double closestPlanetDistance = Double.POSITIVE_INFINITY;
        CelestialObject celestialObjectClosest = null;
        if (world != null) {
            for (CelestialObject celestialObject : (world.field_72995_K ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjects) {
                if (celestialObject.isHyperspace()) continue;
                double distanceSquared = celestialObject.getSquareDistanceInParent(world.field_73011_w.getDimension(), x, z);
                if (distanceSquared <= 0.0) {
                    return celestialObject;
                }
                if (!(closestPlanetDistance > distanceSquared)) continue;
                closestPlanetDistance = distanceSquared;
                celestialObjectClosest = celestialObject;
            }
        }
        return celestialObjectClosest;
    }

    public static boolean isInSpace(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject != null && celestialObject.isSpace();
    }

    public static boolean isInHyperspace(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject != null && celestialObject.isHyperspace();
    }

    public static boolean hasAtmosphere(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject == null || celestialObject.hasAtmosphere();
    }

    public static boolean isPlanet(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject == null || !celestialObject.isSpace() && !celestialObject.isHyperspace();
    }

    public static double getGravity(@Nonnull Entity entity) {
        CelestialObject celestialObject = CelestialObjectManager.get(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v));
        return celestialObject == null ? 1.0 : celestialObject.getGravity();
    }

    public static int getSpaceDimensionId(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        if (celestialObject == null) {
            return world.field_73011_w.getDimension();
        }
        if (celestialObject.isSpace()) {
            return celestialObject.dimensionId;
        }
        if (celestialObject.isHyperspace()) {
            celestialObject = CelestialObjectManager.getClosestChild(world, x, z);
            return celestialObject == null ? 0 : celestialObject.dimensionId;
        }
        while (celestialObject != null && !celestialObject.isSpace()) {
            celestialObject = celestialObject.parent;
        }
        return celestialObject == null ? 0 : celestialObject.dimensionId;
    }

    public static int getHyperspaceDimensionId(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        if (celestialObject == null) {
            return world.field_73011_w.getDimension();
        }
        if (celestialObject.isHyperspace()) {
            return celestialObject.dimensionId;
        }
        if (celestialObject.isSpace()) {
            return celestialObject.parent.dimensionId;
        }
        while (celestialObject != null && !celestialObject.isSpace()) {
            celestialObject = celestialObject.parent;
        }
        return celestialObject == null || celestialObject.parent == null ? 0 : celestialObject.parent.dimensionId;
    }

    public static int getDimensionId(String stringDimension, Entity entity) {
        switch (stringDimension.toLowerCase()) {
            case "world": 
            case "overworld": 
            case "0": {
                return 0;
            }
            case "nether": 
            case "thenether": 
            case "-1": {
                return -1;
            }
            case "s": 
            case "space": {
                return CelestialObjectManager.getSpaceDimensionId(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70161_v);
            }
            case "h": 
            case "hyper": 
            case "hyperspace": {
                return CelestialObjectManager.getHyperspaceDimensionId(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70161_v);
            }
        }
        try {
            return Integer.parseInt(stringDimension);
        }
        catch (Exception exception) {
            WarpDrive.logger.info(String.format("Invalid dimension %s, expecting integer or overworld/nether/end/theend/space/hyper/hyperspace", stringDimension));
            return 0;
        }
    }

    public static double getMaxWorldBorder(World world) {
        return (world.field_72995_K ? CLIENT : SERVER).getMaxWorldBorder();
    }

    public static void onFMLInitialization() {
        block10: for (CelestialObject celestialObject : CelestialObjectManager.SERVER.celestialObjects) {
            if (celestialObject.isVirtual()) continue;
            switch (celestialObject.provider) {
                case "WarpDriveSpace": {
                    if (celestialObject.isSpace()) {
                        DimensionManager.registerDimension((int)celestialObject.dimensionId, (DimensionType)WarpDrive.dimensionTypeSpace);
                        continue block10;
                    }
                    WarpDrive.logger.error(String.format("Only a space dimension can be provided by WarpDriveSpace. Dimension %d is not one of those.", celestialObject.dimensionId));
                    continue block10;
                }
                case "WarpDriveHyperspace": {
                    if (celestialObject.isHyperspace()) {
                        DimensionManager.registerDimension((int)celestialObject.dimensionId, (DimensionType)WarpDrive.dimensionTypeHyperSpace);
                        continue block10;
                    }
                    WarpDrive.logger.error(String.format("Only an hyperspace dimension can be provided by WarpDriveHyperspace. Dimension %d is not one of those.", celestialObject.dimensionId));
                    continue block10;
                }
                case "other": {
                    continue block10;
                }
                default: {
                    WarpDrive.logger.error(String.format("Unknown dimension provider %s for dimension %d, ignoring...", celestialObject.provider, celestialObject.dimensionId));
                }
            }
        }
    }

    public static void load(File dir) {
        SERVER.load(dir, "celestialObjects", "celestialObject");
        SERVER.rebuildAndValidate(false);
    }

    public static void updateInRegistry(CelestialObject celestialObject) {
        SERVER.addOrUpdateInRegistry(celestialObject, true);
        SERVER.rebuildAndValidate(true);
    }

    public static NBTBase writeClientSync(EntityPlayerMP entityPlayerMP, CelestialObject celestialObject) {
        NBTTagList nbtTagList = new NBTTagList();
        if (celestialObject != null) {
            CelestialObject celestialObjectParent = celestialObject;
            while (celestialObjectParent != null) {
                nbtTagList.func_74742_a((NBTBase)celestialObjectParent.writeToNBT(new NBTTagCompound()));
                celestialObjectParent = celestialObjectParent.parent;
            }
            for (CelestialObject celestialObjectChild : CelestialObjectManager.SERVER.celestialObjects) {
                if (!celestialObjectChild.parentId.equals(celestialObject.id)) continue;
                nbtTagList.func_74742_a((NBTBase)celestialObjectChild.writeToNBT(new NBTTagCompound()));
            }
        }
        return nbtTagList;
    }

    public static boolean onOpeningNetherPortal(@Nonnull World world, @Nonnull BlockPos blockPos) {
        CelestialObject celestialObjectPortal = CelestialObjectManager.get(world, blockPos.func_177958_n(), blockPos.func_177952_p());
        if (celestialObjectPortal != null && !celestialObjectPortal.isInsideBorder(blockPos.func_177958_n(), blockPos.func_177952_p())) {
            EntityPlayer entityPlayer = world.func_184137_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0, false);
            if (entityPlayer != null) {
                entityPlayer.func_146105_b((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.world_border.portal_denied", new Object[0]), true);
            }
            WarpDrive.logger.info(String.format("Nether portal opening cancelled %s for player %s: portal entry is outside the world border", entityPlayer == null ? "-null-" : entityPlayer.func_70005_c_(), Commons.format(world, blockPos)));
            return false;
        }
        boolean isInTheNether = world.field_73011_w.getDimension() == -1;
        CelestialObject celestialObjectExit = CelestialObjectManager.get(false, isInTheNether ? 0 : -1, 0, 0);
        if (celestialObjectExit != null) {
            double factor = isInTheNether ? 8.0 : 0.125;
            int xExit = (int)Math.floor((double)blockPos.func_177958_n() * factor);
            int zExit = (int)Math.floor((double)blockPos.func_177952_p() * factor);
            if (Math.abs(xExit - celestialObjectExit.dimensionCenterX) > celestialObjectExit.borderRadiusX || Math.abs(zExit - celestialObjectExit.dimensionCenterZ) > celestialObjectExit.borderRadiusZ) {
                EntityPlayer entityPlayer = world.func_184137_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0, false);
                if (entityPlayer != null) {
                    entityPlayer.func_146105_b((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.world_border.portal_denied", new Object[0]), true);
                }
                WarpDrive.logger.info(String.format("Nether portal opening cancelled for player %s %s: portal exit is outside the world border", entityPlayer == null ? "-null-" : entityPlayer.func_70005_c_(), Commons.format(world, blockPos)));
                return false;
            }
        }
        if (WarpDrive.isDev) {
            WarpDrive.logger.info(String.format("Opening Nether portal %s", Commons.format(world, blockPos)));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void readClientSync(NBTTagList nbtTagList) {
        CelestialObjectManager.clearForReload(true);
        if (nbtTagList != null && nbtTagList.func_74745_c() > 0) {
            for (int index = 0; index < nbtTagList.func_74745_c(); ++index) {
                CelestialObject celestialObject = new CelestialObject(nbtTagList.func_150305_b(index));
                CLIENT.addOrUpdateInRegistry(celestialObject, false);
            }
        }
        CLIENT.rebuildAndValidate(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static CelestialObject[] getRenderStack() {
        return CelestialObjectManager.CLIENT.celestialObjects;
    }

    @SideOnly(value=Side.CLIENT)
    public static WorldBorder World_getWorldBorder(@Nonnull World world) {
        WorldBorder worldBorder = world.func_175723_af();
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayer == null || entityPlayer.field_70170_p != world) {
            return worldBorder;
        }
        CelestialObject celestialObject = CelestialObjectManager.get(world, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70161_v);
        if (celestialObject == null) {
            return worldBorder;
        }
        return celestialObject.getWorldBorder();
    }

    private void addOrUpdateInRegistry(@Nonnull CelestialObject celestialObject, boolean isUpdating) {
        CelestialObject celestialObjectExisting = this.celestialObjectsById.get(celestialObject.id);
        if (celestialObjectExisting == null || isUpdating) {
            this.celestialObjectsById.put(celestialObject.id, celestialObject);
        } else {
            WarpDrive.logger.warn(String.format("Celestial object %s is already defined, keeping original definition", celestialObject.id));
        }
    }

    private void rebuildAndValidate(boolean isRemote) {
        int count = this.celestialObjectsById.size();
        CelestialObject[] celestialObjectsTemp = new CelestialObject[count];
        int index = 0;
        for (CelestialObject celestialObject : this.celestialObjectsById.values()) {
            celestialObjectsTemp[index++] = celestialObject;
            celestialObject.resolveParent(this.celestialObjectsById.get(celestialObject.parentId));
        }
        int countErrors = 0;
        int countHyperspace = 0;
        int countSpace = 0;
        double maxWorldBorderTemp = 0.0;
        for (int indexCelestialObject1 = 0; indexCelestialObject1 < count; ++indexCelestialObject1) {
            CelestialObject celestialObject1 = celestialObjectsTemp[indexCelestialObject1];
            celestialObject1.lateUpdate();
            if (celestialObject1.isHyperspace()) {
                ++countHyperspace;
            } else if (celestialObject1.isSpace()) {
                ++countSpace;
            }
            AxisAlignedBB worldBorderArea1 = celestialObject1.getWorldBorderArea();
            maxWorldBorderTemp = Math.max(maxWorldBorderTemp, 2.0 * Math.max(Math.max(Math.abs(worldBorderArea1.field_72340_a), Math.abs(worldBorderArea1.field_72339_c)), Math.max(Math.abs(worldBorderArea1.field_72336_d), Math.abs(worldBorderArea1.field_72334_f))));
            if (!celestialObject1.isVirtual()) {
                if (celestialObject1.parent == null || celestialObject1.parent.dimensionId != celestialObject1.dimensionId) {
                    CelestialObject celestialObjectParent = this.get(celestialObject1.parentId);
                    if (celestialObjectParent == null) {
                        if (!isRemote && celestialObject1.parentId != null && !celestialObject1.parentId.isEmpty()) {
                            WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nCelestial object %s refers to unknown parent %s", ++countErrors, celestialObject1.id, celestialObject1.parentId));
                        }
                    } else if (celestialObject1.parentCenterX - celestialObject1.borderRadiusX < celestialObjectParent.dimensionCenterX - celestialObjectParent.borderRadiusX || celestialObject1.parentCenterZ - celestialObject1.borderRadiusZ < celestialObjectParent.dimensionCenterZ - celestialObjectParent.borderRadiusZ || celestialObject1.parentCenterX + celestialObject1.borderRadiusX > celestialObjectParent.dimensionCenterX + celestialObjectParent.borderRadiusX || celestialObject1.parentCenterZ + celestialObject1.borderRadiusZ > celestialObjectParent.dimensionCenterZ + celestialObjectParent.borderRadiusZ) {
                        WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nCelestial object %s is outside its parent border.\n%s\n%s\n%s's area in parent %s is outside %s's border %s", ++countErrors, celestialObject1.id, celestialObject1, celestialObjectParent, celestialObject1.id, celestialObject1.getAreaInParent(), celestialObjectParent.id, celestialObjectParent.getWorldBorderArea()));
                    }
                }
                if (celestialObject1.dimensionCenterX - celestialObject1.borderRadiusX < -30000000 || celestialObject1.dimensionCenterZ - celestialObject1.borderRadiusZ < -30000000 || celestialObject1.dimensionCenterX + celestialObject1.borderRadiusX >= 30000000 || celestialObject1.dimensionCenterZ + celestialObject1.borderRadiusZ >= 30000000) {
                    WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nCelestial object %s is outside the game border +/-30000000.\n%s\n%s border is %s", ++countErrors, celestialObject1.id, celestialObject1, celestialObject1.id, celestialObject1.getWorldBorderArea()));
                }
            }
            for (int indexCelestialObject2 = indexCelestialObject1 + 1; indexCelestialObject2 < count; ++indexCelestialObject2) {
                AxisAlignedBB worldBorderArea2;
                AxisAlignedBB areaInParent2;
                AxisAlignedBB areaInParent1;
                CelestialObject celestialObject2 = celestialObjectsTemp[indexCelestialObject2];
                if (!celestialObject1.isHyperspace() && !celestialObject2.isHyperspace() && celestialObject1.parent != null && celestialObject2.parent != null && celestialObject1.parent.dimensionId == celestialObject2.parent.dimensionId && (areaInParent1 = celestialObject1.getAreaInParent()).func_72326_a(areaInParent2 = celestialObject2.getAreaInParent())) {
                    WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nOverlapping parent areas detected in dimension %d between %s and %s\nArea1 %s from %s\nArea2 %s from %s", ++countErrors, celestialObject1.parent.dimensionId, celestialObject1.id, celestialObject2.id, areaInParent1, celestialObject1, areaInParent2, celestialObject2));
                }
                if (celestialObject1.isVirtual() || celestialObject2.isVirtual() || celestialObject1.dimensionId != celestialObject2.dimensionId || !worldBorderArea1.func_72326_a(worldBorderArea2 = celestialObject2.getWorldBorderArea())) continue;
                WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nOverlapping areas detected in dimension %d between %s and %s\nArea1 %s from %s\nArea2 %s from %s", ++countErrors, celestialObject1.dimensionId, celestialObject1.id, celestialObject2.id, worldBorderArea1, celestialObject1, worldBorderArea2, celestialObject2));
            }
        }
        if (!isRemote && countHyperspace == 0) {
            WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nAt least one hyperspace celestial object should be defined!", ++countErrors));
        } else if (!isRemote && countSpace == 0) {
            WarpDrive.logger.error(String.format("CelestialObjects validation error #%d\nAt least one space celestial object should be defined!", ++countErrors));
        }
        if (WarpDriveConfig.G_ENFORCE_VALID_CELESTIAL_OBJECTS) {
            if (countErrors == 1) {
                throw new RuntimeException("Invalid celestial objects definition: update your configuration to fix this validation error, search your logs for 'CelestialObjects validation error' to get more details.");
            }
            if (countErrors > 0) {
                throw new RuntimeException(String.format("Invalid celestial objects definition: update your configuration to fix those %d validation errors, search your logs for 'CelestialObjects validation error' to get more details.", countErrors));
            }
        } else {
            FMLLog.bigWarning((String)"Invalid celestial objects definition: bad things will happen, fix those before reporting any issue!", (Object[])new Object[0]);
        }
        this.celestialObjects = celestialObjectsTemp;
        this.maxWorldBorder = maxWorldBorderTemp;
    }

    @Override
    protected void parseRootElement(String location, Element elementCelestialObject) throws InvalidXmlException {
        this.parseCelestiaObjectElement(location, elementCelestialObject, "");
    }

    private void parseCelestiaObjectElement(String location, Element elementCelestialObject, String parentId) throws InvalidXmlException {
        CelestialObject celestialObjectRead = new CelestialObject(location, parentId, elementCelestialObject);
        this.addOrUpdateInRegistry(celestialObjectRead, false);
        List<Element> listChildren = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "celestialObject");
        if (!listChildren.isEmpty()) {
            for (int indexElement = 0; indexElement < listChildren.size(); ++indexElement) {
                Element elementChild = listChildren.get(indexElement);
                String locationChild = String.format("%s Celestial object %s > child %d/%d", location, celestialObjectRead.id, indexElement + 1, listChildren.size());
                this.parseCelestiaObjectElement(locationChild, elementChild, celestialObjectRead.id);
            }
        }
    }

    public CelestialObject get(String id) {
        return this.celestialObjectsById.get(id);
    }

    public CelestialObject get(int dimensionId, int x, int z) {
        double distanceClosest = Double.POSITIVE_INFINITY;
        CelestialObject celestialObjectClosest = null;
        for (CelestialObject celestialObject : this.celestialObjects) {
            if (celestialObject == null || celestialObject.isVirtual() || dimensionId != celestialObject.dimensionId) continue;
            double distanceSquared = celestialObject.getSquareDistanceOutsideBorder(x, z);
            if (distanceSquared <= 0.0) {
                return celestialObject;
            }
            if (!(distanceClosest > distanceSquared)) continue;
            distanceClosest = distanceSquared;
            celestialObjectClosest = celestialObject;
        }
        return celestialObjectClosest;
    }

    public double getMaxWorldBorder() {
        return this.maxWorldBorder < 1000.0 ? 6.0E7 : this.maxWorldBorder;
    }
}

