/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.network.PacketHandler;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CloakManager {
    private static final CopyOnWriteArraySet<CloakedArea> cloaks = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<CloakedArea> cloakToRefresh = new CopyOnWriteArraySet();

    public void onChunkLoaded(EntityPlayerMP player, int chunkPosX, int chunkPosZ) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != player.field_70170_p.field_73011_w.getDimension() || area.minX > chunkPosX << 19 || area.maxX < chunkPosX << 4 || area.minZ > chunkPosZ << 19 || area.maxZ < chunkPosZ << 4) continue;
            PacketHandler.sendCloakPacket(player, area, false);
        }
    }

    public void onPlayerJoinWorld(EntityPlayerMP entityPlayerMP, World world) {
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(String.format("CloakManager.onPlayerJoinWorld %s", entityPlayerMP));
        }
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != world.field_73011_w.getDimension() || !((double)area.minX > entityPlayerMP.field_70165_t || (double)area.maxX < entityPlayerMP.field_70165_t || (double)area.minY > entityPlayerMP.field_70163_u || (double)area.maxY < entityPlayerMP.field_70163_u || (double)area.minZ > entityPlayerMP.field_70161_v) && !((double)area.maxZ < entityPlayerMP.field_70161_v)) continue;
            PacketHandler.sendCloakPacket(entityPlayerMP, area, false);
        }
    }

    public boolean isAreaExists(World world, BlockPos blockPos) {
        return this.getCloakedArea(world, blockPos) != null;
    }

    public CloakedArea updateCloakedArea(@Nonnull World world, @Nonnull BlockPos blockPosCore, boolean isFullyTransparent, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        CloakedArea cloakedAreaNew = new CloakedArea(world, world.field_73011_w.getDimension(), blockPosCore, isFullyTransparent, minX, minY, minZ, maxX, maxY, maxZ);
        for (CloakedArea cloakedArea : cloaks) {
            if (cloakedArea.dimensionId != world.field_73011_w.getDimension() || !cloakedArea.blockPosCore.equals((Object)blockPosCore)) continue;
            cloaks.remove(cloakedArea);
            break;
        }
        cloaks.add(cloakedAreaNew);
        if (world.field_72995_K) {
            cloakToRefresh.add(cloakedAreaNew);
        }
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(String.format("Cloak count is %s", cloaks.size()));
        }
        return cloakedAreaNew;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientTick() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        CloakedArea[] cloakedAreas = cloakToRefresh.toArray(new CloakedArea[0]);
        cloakToRefresh.clear();
        for (CloakedArea cloakedArea : cloakedAreas) {
            cloakedArea.clientCloak(player);
        }
    }

    public void removeCloakedArea(int dimensionId, BlockPos blockPos) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != dimensionId || !area.blockPosCore.equals((Object)blockPos)) continue;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                area.clientDecloak();
            } else {
                area.sendCloakPacketToPlayersEx(true);
            }
            cloaks.remove(area);
            break;
        }
    }

    public CloakedArea getCloakedArea(World world, BlockPos blockPos) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != world.field_73011_w.getDimension() || !area.blockPosCore.equals((Object)blockPos)) continue;
            return area;
        }
        return null;
    }

    public void updatePlayer(EntityPlayerMP entityPlayerMP) {
        for (CloakedArea area : cloaks) {
            area.updatePlayer(entityPlayerMP);
        }
    }

    @Nullable
    public static CloakedArea getContainingArea(@Nonnull World world, @Nonnull BlockPos blockPos1, @Nullable BlockPos blockPos2) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != world.field_73011_w.getDimension() || !area.isBlockWithinArea(blockPos1)) continue;
            return blockPos2 == null || area.isBlockWithinArea(blockPos2) ? area : null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean WorldClient_invalidateRegionAndSetBlock_setBlockState(BlockPos blockPos, IBlockState blockState, int flags) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        assert (world != null);
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            for (CloakedArea area : cloaks) {
                if (!area.isBlockWithinArea(blockPos)) continue;
                if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info("CloakManager block is inside");
                }
                if (area.isEntityWithinArea((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) continue;
                if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info("CloakManager player is outside");
                }
                return world.func_180501_a(blockPos, area.blockStateFog, flags);
            }
        }
        return world.func_180501_a(blockPos, blockState, flags);
    }

    @SideOnly(value=Side.CLIENT)
    public static void Chunk_read(Chunk chunk) {
        int chunkX_min = chunk.field_76635_g * 16;
        int chunkX_max = chunk.field_76635_g * 16 + 15;
        int chunkZ_min = chunk.field_76647_h * 16;
        int chunkZ_max = chunk.field_76647_h * 16 + 15;
        if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(String.format("CloakManager Chunk_read (%d %d) %d cloak(s) from (%d %d) to (%d %d)", chunk.field_76635_g, chunk.field_76647_h, cloaks.size(), chunkX_min, chunkZ_min, chunkX_max, chunkZ_max));
        }
        for (CloakedArea area : cloaks) {
            if (area.minX > chunkX_max || area.maxX < chunkX_min || area.minZ > chunkZ_max || area.maxZ < chunkZ_min) continue;
            if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info("CloakManager chunk is inside");
            }
            if (area.isEntityWithinArea((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) continue;
            if (WarpDrive.isDev && WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info("CloakManager player is outside");
            }
            int areaX_min = Math.max(chunkX_min, area.minX) & 0xF;
            int areaX_max = Math.min(chunkX_max, area.maxX) & 0xF;
            int areaZ_min = Math.max(chunkZ_min, area.minZ) & 0xF;
            int areaZ_max = Math.min(chunkZ_max, area.maxZ) & 0xF;
            for (int x = areaX_min; x <= areaX_max; ++x) {
                for (int z = areaZ_min; z <= areaZ_max; ++z) {
                    for (int y = area.maxY; y >= area.minY; --y) {
                        if (chunk.func_177435_g(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_150350_a) continue;
                        chunk.func_177436_a(new BlockPos(x, y, z), area.blockStateFog);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientChangingDimension() {
        cloaks.clear();
    }
}

