/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import java.io.DataOutput;
import javax.annotation.Nonnull;

class DataOutputLength
implements DataOutput {
    protected int countBytes;

    private void increaseCount(int value) {
        int countBytes_new = this.countBytes + value;
        if (countBytes_new < 0) {
            countBytes_new = Integer.MAX_VALUE;
        }
        this.countBytes = countBytes_new;
    }

    @Override
    public void write(int b) {
        this.increaseCount(1);
    }

    @Override
    public void write(@Nonnull byte[] bytes) {
        this.increaseCount(bytes.length);
    }

    @Override
    public void write(@Nonnull byte[] bytes, int offset, int len) {
        this.increaseCount(len);
    }

    @Override
    public final void writeBoolean(boolean value) {
        this.increaseCount(1);
    }

    @Override
    public final void writeByte(int value) {
        this.increaseCount(1);
    }

    @Override
    public final void writeShort(int value) {
        this.increaseCount(2);
    }

    @Override
    public final void writeChar(int value) {
        this.increaseCount(2);
    }

    @Override
    public final void writeInt(int value) {
        this.increaseCount(4);
    }

    @Override
    public final void writeLong(long value) {
        this.increaseCount(8);
    }

    @Override
    public final void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public final void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public final void writeBytes(String value) {
        int length = value.length();
        this.increaseCount(length);
    }

    @Override
    public final void writeChars(String value) {
        int length = value.length();
        this.increaseCount(length * 2);
    }

    @Override
    public final void writeUTF(String string) {
        int length = Math.round((float)string.length() * 1.5f);
        this.increaseCount(length);
    }

    public final int getLength() {
        return this.countBytes;
    }
}

