/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.AbstractEntityFX;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityFXRegistry {
    private static final HashMap<Integer, CopyOnWriteArraySet<WeakReference<AbstractEntityFX>>> REGISTRY = new HashMap();
    private static int countAdd = 0;
    private static int countRemove = 0;
    private static int countRead = 0;

    private static int computeHashcode(AbstractEntityFX entityFX) {
        return EntityFXRegistry.computeHashcode(entityFX.getWorld().field_73011_w.getDimension(), MathHelper.func_76128_c((double)entityFX.getX()), MathHelper.func_76128_c((double)entityFX.getY()), MathHelper.func_76128_c((double)entityFX.getZ()));
    }

    private static int computeHashcode(World world, Vector3 v3Position) {
        return EntityFXRegistry.computeHashcode(world.field_73011_w.getDimension(), MathHelper.func_76128_c((double)v3Position.x), MathHelper.func_76128_c((double)v3Position.y), MathHelper.func_76128_c((double)v3Position.z));
    }

    private static int computeHashcode(int dimensionId, int x, int y, int z) {
        return dimensionId << 24 ^ (x & 0xFFFF) << 8 ^ y << 16 ^ z & 0xFFFF;
    }

    private static void logStats(int trigger) {
        if ((trigger & 0x3FF) != 0) {
            return;
        }
        int sizeTotal = 0;
        int sizeClusterMax = 0;
        for (CopyOnWriteArraySet<WeakReference<AbstractEntityFX>> items : REGISTRY.values()) {
            int size = items.size();
            sizeTotal += size;
            sizeClusterMax = Math.max(sizeClusterMax, size);
        }
        WarpDrive.logger.info(String.format("AbstractEntityFX REGISTRY stats: read %d add %d remove %d => %.3f read, currently holding %d items %d hashes %d maxCluster", countRead, countAdd, countRemove, Float.valueOf((float)countRead / (float)(countRemove + countRead + countAdd)), sizeTotal, REGISTRY.size(), sizeClusterMax));
    }

    public static AbstractEntityFX get(World world, Vector3 v3Position, double rangeMax) {
        Integer hashcode;
        CopyOnWriteArraySet<WeakReference<AbstractEntityFX>> setRegistryItems;
        ++countRead;
        if (WarpDriveConfig.LOGGING_ENTITY_FX) {
            EntityFXRegistry.logStats(countRead);
        }
        if ((setRegistryItems = REGISTRY.get(hashcode = Integer.valueOf(EntityFXRegistry.computeHashcode(world, v3Position)))) == null) {
            return null;
        }
        double rangeMaxSquare = rangeMax * rangeMax;
        for (WeakReference<AbstractEntityFX> weakEntityFX : setRegistryItems) {
            if (weakEntityFX == null) {
                ++countRemove;
                setRegistryItems.remove(null);
                continue;
            }
            AbstractEntityFX entityFX = (AbstractEntityFX)((Object)weakEntityFX.get());
            if (entityFX == null || !entityFX.func_187113_k()) {
                ++countRemove;
                setRegistryItems.remove(weakEntityFX);
                continue;
            }
            double rangeSquared = v3Position.distanceTo_square(entityFX);
            if (!(rangeSquared < rangeMaxSquare)) continue;
            return entityFX;
        }
        return null;
    }

    public static boolean add(AbstractEntityFX entityFX) {
        Integer hashcode;
        CopyOnWriteArraySet<WeakReference<AbstractEntityFX>> setRegistryItems;
        ++countRead;
        if (WarpDriveConfig.LOGGING_ENTITY_FX) {
            EntityFXRegistry.logStats(countRead);
        }
        if ((setRegistryItems = REGISTRY.get(hashcode = Integer.valueOf(EntityFXRegistry.computeHashcode(entityFX)))) == null) {
            setRegistryItems = new CopyOnWriteArraySet();
            REGISTRY.put(hashcode, setRegistryItems);
        } else {
            Vector3 v3Position = new Vector3(entityFX);
            for (WeakReference<AbstractEntityFX> weakEntityFX : setRegistryItems) {
                if (weakEntityFX == null) {
                    ++countRemove;
                    setRegistryItems.remove(null);
                    continue;
                }
                AbstractEntityFX entityFX_existing = (AbstractEntityFX)((Object)weakEntityFX.get());
                if (entityFX_existing == null || !entityFX_existing.func_187113_k()) {
                    ++countRemove;
                    setRegistryItems.remove(weakEntityFX);
                    continue;
                }
                if (entityFX == entityFX_existing) {
                    if (WarpDriveConfig.LOGGING_ENTITY_FX) {
                        EntityFXRegistry.printRegistry("already registered");
                    }
                    return false;
                }
                if (!(v3Position.distanceTo_square(entityFX) < 0.01)) continue;
                if (WarpDriveConfig.LOGGING_ENTITY_FX) {
                    EntityFXRegistry.printRegistry("existing entity at location");
                }
                return false;
            }
        }
        ++countAdd;
        setRegistryItems.add(new WeakReference<AbstractEntityFX>(entityFX));
        if (WarpDriveConfig.LOGGING_ENTITY_FX) {
            EntityFXRegistry.printRegistry("added");
        }
        return true;
    }

    private static void printRegistry(String trigger) {
        WarpDrive.logger.info(String.format("AbstractEntityFX REGISTRY (%d entries after %s):", REGISTRY.size(), trigger));
        for (Map.Entry<Integer, CopyOnWriteArraySet<WeakReference<AbstractEntityFX>>> entryRegistryItems : REGISTRY.entrySet()) {
            StringBuilder message = new StringBuilder();
            Iterator<WeakReference<AbstractEntityFX>> iterator = entryRegistryItems.getValue().iterator();
            while (iterator.hasNext()) {
                WeakReference<AbstractEntityFX> weakEntityFX = iterator.next();
                if (weakEntityFX == null) {
                    ++countRemove;
                    iterator.remove();
                    continue;
                }
                AbstractEntityFX entityFX = (AbstractEntityFX)((Object)weakEntityFX.get());
                if (entityFX == null) {
                    ++countRemove;
                    iterator.remove();
                    continue;
                }
                message.append(String.format("\n- %s", new Object[]{entityFX}));
            }
            WarpDrive.logger.info(String.format("- %d entries with hashcode 0x%8X: %s", entryRegistryItems.getValue().size(), entryRegistryItems.getKey(), message.toString()));
        }
    }
}

