/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumShipCommand;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;

public enum EnumShipMovementType implements IStringSerializable
{
    HYPERSPACE_ENTERING(true, "hyperspace_entering", "entering hyperspace", new double[]{100.0, 0.1, 0.0, 0.0, 0.0}, new double[]{1.0E7, 0.0, 0.0, 0.0, 0.0}, new double[]{40.0, 0.0, 0.0, 0.0, 0.0}, new double[]{10.0, 0.0, 0.0, 0.0, 0.0}, new double[]{60.0, 0.0, 0.0, 0.0, 0.0}),
    HYPERSPACE_EXITING(true, "hyperspace_exiting", "existing hyperspace", new double[]{100.0, 0.1, 0.0, 0.0, 0.0}, new double[]{1.0E7, 0.0, 0.0, 0.0, 0.0}, new double[]{40.0, 0.0, 0.0, 0.0, 0.0}, new double[]{10.0, 0.0, 0.0, 0.0, 0.0}, new double[]{60.0, 0.0, 0.0, 0.0, 0.0}),
    HYPERSPACE_MOVING(true, "hyperspace_moving", "moving in hyperspace", new double[]{200.0, 0.5, 0.0, 0.0, 0.0}, new double[]{10000.0, 1.0, 10.0, 0.0, 0.0}, new double[]{20.0, 0.0, 0.0, 0.0, 0.0}, new double[]{10.0, 0.0, 0.0, 0.0, 0.0}, new double[]{30.0, 0.0, 0.0, 0.0, 0.0}),
    PLANET_LANDING(true, "planet_landing", "landing on a planet", new double[]{50.0, 0.1, 0.0, 0.0, 0.0}, new double[]{10000.0, 10.0, 100.0, 0.0, 0.0}, new double[]{20.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{60.0, 0.0, 0.0, 0.0, 0.0}),
    PLANET_MOVING(true, "planet_moving", "moving on a planet", new double[]{50.0, 0.1, 0.0, 0.0, 0.0}, new double[]{100.0, 10.0, 100.0, 0.0, 0.0}, new double[]{20.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{40.0, 0.0, 0.0, 0.0, 0.0}),
    PLANET_TAKEOFF(true, "planet_takeoff", "taking off a planet", new double[]{50.0, 0.1, 0.0, 0.0, 0.0}, new double[]{10000.0, 10.0, 100.0, 0.0, 0.0}, new double[]{20.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{90.0, 0.0, 0.0, 0.0, 0.0}),
    SPACE_MOVING(true, "space_moving", "moving in space", new double[]{100.0, 0.1, 0.0, 0.0, 0.0}, new double[]{1000.0, 10.0, 100.0, 0.0, 0.0}, new double[]{10.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{30.0, 0.0, 0.0, 0.0, 0.0}),
    GATE_ACTIVATING(true, "gate_activating", "activating a jumpgate", new double[]{100000.0, 0.1, 0.0, 0.0, 0.0}, new double[]{20000.0, 10.0, 100.0, 0.0, 0.0}, new double[]{10.0, 0.0, 0.0, 0.0, 0.0}, new double[]{3.0, 0.0, 0.0, 0.0, 0.0}, new double[]{20.0, 0.0, 0.0, 0.0, 0.0}),
    INSTANTIATE(false, "", "generation/ship token", new double[]{999999.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}),
    RESTORE(false, "", "admin command", new double[]{999999.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}),
    NONE(false, "", "idle, disabled, etc.", new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0});

    public final boolean hasConfiguration;
    private final String name;
    private final String description;
    public final double[] maximumDistanceDefault;
    public final double[] energyRequiredDefault;
    public final double[] warmupDefault;
    public final double[] sicknessDefault;
    public final double[] cooldownDefault;
    public static final int length;
    private static final HashMap<Integer, EnumShipMovementType> ID_MAP;

    private EnumShipMovementType(boolean hasConfiguration, String name, String description, double[] maximumDistanceDefault, double[] energyRequiredDefault, double[] warmupDefault, double[] sicknessDefault, double[] cooldownDefault) {
        this.hasConfiguration = hasConfiguration;
        this.name = name;
        this.description = description;
        this.maximumDistanceDefault = maximumDistanceDefault;
        this.energyRequiredDefault = energyRequiredDefault;
        this.warmupDefault = warmupDefault;
        this.sicknessDefault = sicknessDefault;
        this.cooldownDefault = cooldownDefault;
    }

    public static EnumShipMovementType get(int damage) {
        return ID_MAP.get(damage);
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public static EnumShipMovementType compute(World worldSource, int xCurrent, int yMin, int yMax, int zCurrent, EnumShipCommand command, int yMove, WarpDriveText reason) {
        if (command == EnumShipCommand.GATE) {
            return GATE_ACTIVATING;
        }
        CelestialObject celestialObjectSource = CelestialObjectManager.get(worldSource, xCurrent, zCurrent);
        boolean isInSpace = celestialObjectSource != null && celestialObjectSource.isSpace();
        boolean isInHyperSpace = celestialObjectSource != null && celestialObjectSource.isHyperspace();
        switch (command) {
            case HYPERDRIVE: {
                if (isInHyperSpace) {
                    return HYPERSPACE_EXITING;
                }
                if (isInSpace) {
                    return HYPERSPACE_ENTERING;
                }
                reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_reach_hyperspace_from_planet", new Object[0]);
                return null;
            }
            case MANUAL: {
                boolean fromSpace;
                boolean toSpace;
                boolean bl = toSpace = yMove > 0 && yMax + yMove > 255 && !isInSpace && !isInHyperSpace;
                if (toSpace) {
                    return PLANET_TAKEOFF;
                }
                boolean bl2 = fromSpace = yMove < 0 && yMin + yMove < 0 && !isInHyperSpace;
                if (fromSpace) {
                    return PLANET_LANDING;
                }
                if (isInHyperSpace) {
                    return HYPERSPACE_MOVING;
                }
                if (isInSpace) {
                    return SPACE_MOVING;
                }
                return PLANET_MOVING;
            }
            case IDLE: 
            case MAINTENANCE: 
            case OFFLINE: {
                return NONE;
            }
        }
        WarpDrive.logger.error(String.format("Invalid command '%s'", new Object[]{command}));
        reason.append(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]);
        return null;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumShipMovementType.values().length;
        for (EnumShipMovementType shipMovementType : EnumShipMovementType.values()) {
            ID_MAP.put(shipMovementType.ordinal(), shipMovementType);
        }
    }
}

