/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.IRarity;

public enum EnumTier implements IStringSerializable
{
    CREATIVE("creative", 0, (IRarity)EnumRarity.EPIC),
    BASIC("basic", 1, (IRarity)EnumRarity.COMMON),
    ADVANCED("advanced", 2, (IRarity)EnumRarity.UNCOMMON),
    SUPERIOR("superior", 3, (IRarity)EnumRarity.RARE);

    private final String name;
    private final int index;
    private final IRarity rarity;
    public static final int length;
    private static final HashMap<Integer, EnumTier> ID_MAP;
    private static final EnumTier[] tblNonCreatives;

    private EnumTier(@Nonnull String name, int index, IRarity rarity) {
        this.name = name;
        this.index = index;
        this.rarity = rarity;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public static EnumTier get(int index) {
        return ID_MAP.get(index);
    }

    public int getIndex() {
        return this.index;
    }

    @Nonnull
    public IRarity getForgeRarity() {
        return this.rarity;
    }

    public static EnumTier[] nonCreative() {
        return tblNonCreatives;
    }

    static {
        length = EnumTier.values().length;
        ID_MAP = new HashMap(length);
        ArrayList<EnumTier> list = new ArrayList<EnumTier>(length);
        for (EnumTier enumTier : EnumTier.values()) {
            ID_MAP.put(enumTier.index, enumTier);
            if (enumTier == CREATIVE) continue;
            list.add(enumTier);
        }
        tblNonCreatives = list.toArray(new EnumTier[0]);
    }
}

