/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidWrapper {
    public static final String TAG_FLUID = "fluid";
    public static final int MB_PER_TINY_PILE = 16;
    public static final int MB_PER_SMALL_PILE = 36;
    public static final int MB_PER_NUGGET = 16;
    public static final int MB_PER_INGOT = 144;
    public static final int MB_PER_BLOCK = 1296;
    public static final int MB_PER_BUCKET = 1000;
    private static final CopyOnWriteArraySet<Block> blockInvalidFluid = new CopyOnWriteArraySet();

    public static String format(long energy, String units) {
        return Commons.format(FluidWrapper.convert(energy, units));
    }

    public static void formatAndAppendCharge(@Nonnull WarpDriveText warpDriveText, long energyStored, long maxStorage, String units) {
        String unitsToUse = units == null ? "WarpDriveConfig.FLUID_DISPLAY_UNITS" : units;
        String energyStored_units = FluidWrapper.format(energyStored, unitsToUse);
        String energyMaxStorage_units = FluidWrapper.format(maxStorage, unitsToUse);
        WarpDriveText textRate = new WarpDriveText(null, "warpdrive.fluid.status_line.charge", new Object[0]).appendInLine(null, " ", new Object[0]).appendInLine(Commons.getStyleValue(), energyStored_units, new Object[0]).appendInLine(null, " / ", new Object[0]).appendInLine(Commons.getStyleValue(), energyMaxStorage_units, new Object[0]).appendInLine(null, String.format(" %s.", unitsToUse), new Object[0]);
        warpDriveText.append((ITextComponent)textRate);
    }

    public static void formatAndAppendInputRate(@Nonnull WarpDriveText warpDriveText, long rate, String units) {
        FluidWrapper.formatAndAppendRate(warpDriveText, "warpdrive.fluid.status_line.input_rate", rate, units);
    }

    public static void formatAndAppendOutputRate(@Nonnull WarpDriveText warpDriveText, long rate, String units) {
        FluidWrapper.formatAndAppendRate(warpDriveText, "warpdrive.fluid.status_line.output_rate", rate, units);
    }

    public static long convert(long value, String units) {
        String unitsToUse;
        switch (unitsToUse = units == null ? WarpDriveConfig.ENERGY_DISPLAY_UNITS : units) {
            case "bucket": {
                return (long)Math.floor((double)value / 1000.0);
            }
            case "ingot": {
                return (long)Math.floor((double)value / 144.0);
            }
        }
        return value;
    }

    private static void formatAndAppendRate(@Nonnull WarpDriveText warpDriveText, @Nonnull String translationKey, long rate, String units) {
        String unitsToUse = units == null ? WarpDriveConfig.ENERGY_DISPLAY_UNITS : units;
        WarpDriveText textRate = new WarpDriveText(null, translationKey, new Object[0]).appendInLine(Commons.getStyleValue(), String.format(" %d", FluidWrapper.convert(rate, unitsToUse)), new Object[0]).appendInLine(null, String.format(" %s/t.", unitsToUse), new Object[0]);
        warpDriveText.append((ITextComponent)textRate);
    }

    public static boolean isFluid(@Nonnull IBlockState blockState) {
        return FluidWrapper.getFluid(blockState) != null;
    }

    @Nullable
    public static Fluid getFluid(@Nonnull IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
            Fluid fluid;
            Fluid fluid2 = fluid = block instanceof IFluidBlock ? ((IFluidBlock)block).getFluid() : Commons.fluid_getByBlock(block);
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(String.format("Block %s %s Fluid %s with viscosity %d: %s %s", block.func_149739_a(), blockState, fluid == null ? null : fluid.getName(), fluid == null ? 0 : fluid.getViscosity(), block, fluid));
            }
            if (fluid == null) {
                if (!blockInvalidFluid.contains(block)) {
                    WarpDrive.logger.error(String.format("Block %s %s is not a valid fluid! %s", block.func_149739_a(), blockState, block));
                    blockInvalidFluid.add(block);
                }
                return null;
            }
            return fluid;
        }
        return null;
    }

    public static boolean isSourceBlock(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        Block block = blockState.func_177230_c();
        int metadata = block.func_176201_c(blockState);
        return block instanceof BlockLiquid && metadata == 0 || block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, blockPos);
    }

    public static boolean isFluidContainer(@Nonnull ItemStack itemStack) {
        return itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static boolean isFluidContainer(@Nonnull TileEntity tileEntity) {
        return tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public static FluidStack drain(@Nonnull ItemStack itemStack, @Nonnull FluidStack fluidStack, boolean doNotSimulate) {
        IFluidHandler fluidHandler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler == null) {
            return new FluidStack(fluidStack, 0);
        }
        return fluidHandler.drain(fluidStack, doNotSimulate);
    }

    public static int fill(@Nonnull ItemStack itemStack, @Nonnull FluidStack fluidStack, boolean doNotSimulate) {
        IFluidHandler fluidHandler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler == null) {
            return 0;
        }
        return fluidHandler.fill(fluidStack, doNotSimulate);
    }

    @Nullable
    public static FluidStack getFluidStored(@Nonnull ItemStack itemStack) {
        IFluidTankProperties[] fluidTankPropertiesAll;
        IFluidHandler fluidHandler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler == null) {
            return null;
        }
        for (IFluidTankProperties fluidTankPropertiesOne : fluidTankPropertiesAll = fluidHandler.getTankProperties()) {
            FluidStack fluidStackContent = fluidTankPropertiesOne.getContents();
            if (fluidStackContent == null) continue;
            return fluidStackContent;
        }
        return null;
    }
}

