/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalPosition;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class GlobalRegion
extends GlobalPosition {
    public final EnumGlobalRegionType type;
    public final UUID uuid;
    public String name;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    public int mass;
    public double isolationRate;
    private AxisAlignedBB cache_aabbArea;

    private GlobalRegion(int dimensionId, BlockPos blockPos, EnumGlobalRegionType type, UUID uuid, String name, AxisAlignedBB aabbArea, int mass, double isolationRate) {
        super(dimensionId, blockPos);
        this.type = type;
        this.uuid = uuid;
        if (aabbArea == null) {
            this.minX = blockPos.func_177958_n();
            this.minY = blockPos.func_177956_o();
            this.minZ = blockPos.func_177952_p();
            this.maxX = blockPos.func_177958_n();
            this.maxY = blockPos.func_177956_o();
            this.maxZ = blockPos.func_177952_p();
        } else {
            this.minX = (int)aabbArea.field_72340_a;
            this.minY = (int)aabbArea.field_72338_b;
            this.minZ = (int)aabbArea.field_72339_c;
            this.maxX = (int)aabbArea.field_72336_d - 1;
            this.maxY = (int)aabbArea.field_72337_e - 1;
            this.maxZ = (int)aabbArea.field_72334_f - 1;
        }
        this.mass = mass;
        this.isolationRate = isolationRate;
        this.name = name;
        this.cache_aabbArea = null;
    }

    public GlobalRegion(IGlobalRegionProvider globalRegionProvider) {
        this(globalRegionProvider.getDimension(), globalRegionProvider.getBlockPos(), globalRegionProvider.getGlobalRegionType(), globalRegionProvider.getSignatureUUID(), globalRegionProvider.getSignatureName(), globalRegionProvider.getGlobalRegionArea(), globalRegionProvider.getMass(), globalRegionProvider.getIsolationRate());
    }

    public boolean sameCoordinates(IGlobalRegionProvider globalRegionProvider) {
        return this.dimensionId == globalRegionProvider.getDimension() && this.x == globalRegionProvider.getBlockPos().func_177958_n() && this.y == globalRegionProvider.getBlockPos().func_177956_o() && this.z == globalRegionProvider.getBlockPos().func_177952_p();
    }

    public void update(IGlobalRegionProvider globalRegionProvider) {
        AxisAlignedBB aabbAreaUpdated;
        if (WarpDrive.isDev) {
            assert (this.type == globalRegionProvider.getGlobalRegionType());
            assert (this.uuid.equals(globalRegionProvider.getSignatureUUID()));
        }
        if ((aabbAreaUpdated = globalRegionProvider.getGlobalRegionArea()) != null) {
            this.minX = (int)aabbAreaUpdated.field_72340_a;
            this.minY = (int)aabbAreaUpdated.field_72338_b;
            this.minZ = (int)aabbAreaUpdated.field_72339_c;
            this.maxX = (int)aabbAreaUpdated.field_72336_d - 1;
            this.maxY = (int)aabbAreaUpdated.field_72337_e - 1;
            this.maxZ = (int)aabbAreaUpdated.field_72334_f - 1;
            this.cache_aabbArea = null;
        }
        this.mass = globalRegionProvider.getMass();
        this.isolationRate = globalRegionProvider.getIsolationRate();
        this.name = globalRegionProvider.getSignatureName();
    }

    public boolean contains(@Nonnull BlockPos blockPos) {
        return this.minX <= blockPos.func_177958_n() && blockPos.func_177958_n() <= this.maxX && this.minY <= blockPos.func_177956_o() && blockPos.func_177956_o() <= this.maxY && this.minZ <= blockPos.func_177952_p() && blockPos.func_177952_p() <= this.maxZ;
    }

    public AxisAlignedBB getArea() {
        if (this.cache_aabbArea == null) {
            this.cache_aabbArea = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX + 1.0, (double)this.maxY + 1.0, (double)this.maxZ + 1.0);
        }
        return this.cache_aabbArea;
    }

    public GlobalRegion(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.type = EnumGlobalRegionType.getByName(tagCompound.func_74779_i("type"));
        this.name = tagCompound.func_74779_i("name");
        UUID uuidLocal = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuidLocal.getMostSignificantBits() == 0L && uuidLocal.getLeastSignificantBits() == 0L) {
            uuidLocal = UUID.randomUUID();
        }
        this.uuid = uuidLocal;
        this.maxX = tagCompound.func_74762_e("maxX");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.minX = tagCompound.func_74762_e("minX");
        this.minY = tagCompound.func_74762_e("minY");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.mass = tagCompound.func_74762_e("mass");
        this.isolationRate = tagCompound.func_74769_h("isolationRate");
        this.cache_aabbArea = null;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74778_a("type", this.type.func_176610_l());
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("name", this.name);
        }
        if (this.uuid != null) {
            tagCompound.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("mass", this.mass);
        tagCompound.func_74780_a("isolationRate", this.isolationRate);
    }

    public String getFormattedLocation() {
        CelestialObject celestialObject = CelestialObjectManager.get(false, this.dimensionId, this.x, this.z);
        if (celestialObject == null) {
            return String.format("DIM%d @ (%d %d %d)", this.dimensionId, this.x, this.y, this.z);
        }
        return String.format("%s [DIM%d] @ (%d %d %d)", celestialObject.getDisplayName(), this.dimensionId, this.x, this.y, this.z);
    }

    @Override
    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }

    @Override
    public String toString() {
        return String.format("%s '%s' %s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", new Object[]{this.getClass().getSimpleName(), this.type, this.uuid, this.dimensionId, this.x, this.y, this.z, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }
}

