/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.block.atomic.BlockAcceleratorCore;
import cr0s.warpdrive.block.detection.BlockVirtualAssistant;
import cr0s.warpdrive.block.detection.TileEntityVirtualAssistant;
import cr0s.warpdrive.block.movement.BlockShipCore;
import cr0s.warpdrive.block.movement.BlockTransporterCore;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.RadarEcho;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.text.WordUtils;

public class GlobalRegionManager {
    public static String GALAXY_UNDEFINED = "???";
    private static final HashMap<Integer, CopyOnWriteArraySet<GlobalRegion>> registry = new HashMap();
    private static int countAdd = 0;
    private static int countRemove = 0;
    private static int countRead = 0;
    private static boolean isExceptionReported = false;

    public static void updateInRegistry(@Nonnull IGlobalRegionProvider globalRegionProvider) {
        CopyOnWriteArraySet<GlobalRegion> setRegistryItems;
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to GlobalRegionManager:updateInRegistry outside main thread, for %s", globalRegionProvider));
            return;
        }
        if (globalRegionProvider.getSignatureUUID() == null) {
            WarpDrive.logger.error(String.format("Ignoring invalid IGlobalRegionProvider with no UUID %s", globalRegionProvider));
            return;
        }
        if (WarpDriveConfig.LOGGING_GLOBAL_REGION_REGISTRY && ++countRead % 1000 == 0) {
            WarpDrive.logger.info(String.format("Global region registry stats: read %d add %d remove %d => %.2f%% read", countRead, countAdd, countRemove, Float.valueOf((float)countRead / (float)(countRemove + countRead + countAdd))));
        }
        if ((setRegistryItems = registry.get(globalRegionProvider.getDimension())) == null) {
            setRegistryItems = new CopyOnWriteArraySet();
        }
        ArrayList<GlobalRegion> listToRemove = new ArrayList<GlobalRegion>(3);
        UUID uuidTileEntity = globalRegionProvider.getSignatureUUID();
        for (GlobalRegion registryItem : setRegistryItems) {
            if (registryItem.uuid == null) {
                WarpDrive.logger.error(String.format("Removing invalid IGlobalRegionProvider %s", registryItem));
                listToRemove.add(registryItem);
                continue;
            }
            if (!registryItem.sameCoordinates(globalRegionProvider)) continue;
            if (registryItem.type.equals((Object)globalRegionProvider.getGlobalRegionType()) && registryItem.uuid.equals(uuidTileEntity)) {
                registryItem.update(globalRegionProvider);
                setRegistryItems.removeAll(listToRemove);
                if (WarpDriveConfig.LOGGING_GLOBAL_REGION_REGISTRY) {
                    GlobalRegionManager.printRegistry("updated");
                }
                return;
            }
            listToRemove.add(registryItem);
        }
        setRegistryItems.removeAll(listToRemove);
        ++countAdd;
        setRegistryItems.add(new GlobalRegion(globalRegionProvider));
        registry.put(globalRegionProvider.getDimension(), setRegistryItems);
        if (WarpDriveConfig.LOGGING_GLOBAL_REGION_REGISTRY) {
            GlobalRegionManager.printRegistry("added");
        }
    }

    public static void removeFromRegistry(@Nonnull IGlobalRegionProvider globalRegionProvider) {
        ++countRead;
        Set setRegistryItems = registry.get(globalRegionProvider.getDimension());
        if (setRegistryItems == null) {
            return;
        }
        for (GlobalRegion registryItem : setRegistryItems) {
            if (!registryItem.sameCoordinates(globalRegionProvider)) continue;
            ++countRemove;
            setRegistryItems.remove(registryItem);
            return;
        }
    }

    @Nullable
    public static GlobalRegion getByName(EnumGlobalRegionType enumGlobalRegionType, String name) {
        for (Integer dimensionId : registry.keySet()) {
            CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(dimensionId);
            if (setGlobalRegions == null) continue;
            for (GlobalRegion globalRegion : setGlobalRegions) {
                if (enumGlobalRegionType != null && globalRegion.type != enumGlobalRegionType || !globalRegion.name.equals(name)) continue;
                return globalRegion;
            }
        }
        return null;
    }

    @Nullable
    public static GlobalRegion getByUUID(EnumGlobalRegionType enumGlobalRegionType, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Integer dimensionId : registry.keySet()) {
            CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(dimensionId);
            if (setGlobalRegions == null) continue;
            for (GlobalRegion globalRegion : setGlobalRegions) {
                if (enumGlobalRegionType != null && globalRegion.type != enumGlobalRegionType || !globalRegion.uuid.equals(uuid)) continue;
                return globalRegion;
            }
        }
        return null;
    }

    public static String listByKeyword(EnumGlobalRegionType enumGlobalRegionType, String keyword) {
        int MAX_LENGTH = 2000;
        StringBuilder resultMatch = new StringBuilder();
        StringBuilder resultCaseInsensitive = new StringBuilder();
        StringBuilder resultContains = new StringBuilder();
        for (Integer dimensionId : registry.keySet()) {
            CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(dimensionId);
            if (setGlobalRegions == null) continue;
            for (GlobalRegion globalRegion : setGlobalRegions) {
                if (globalRegion.type != enumGlobalRegionType) continue;
                if (globalRegion.name.equals(keyword)) {
                    if (resultMatch.length() < 2000) {
                        if (resultMatch.length() > 0) {
                            resultMatch.append("\n");
                        }
                        resultContains.append(String.format("%s '%s' found in %s", WordUtils.capitalize((String)enumGlobalRegionType.func_176610_l()), globalRegion.name, globalRegion.getFormattedLocation()));
                        continue;
                    }
                    resultMatch.append(".");
                    continue;
                }
                if (globalRegion.name.equalsIgnoreCase(keyword)) {
                    if (resultCaseInsensitive.length() < 2000) {
                        if (resultCaseInsensitive.length() > 0) {
                            resultCaseInsensitive.append("\n");
                        }
                        resultContains.append(String.format("%s '%s' found in %s", WordUtils.capitalize((String)enumGlobalRegionType.func_176610_l()), globalRegion.name, globalRegion.getFormattedLocation()));
                        continue;
                    }
                    resultCaseInsensitive.append(".");
                    continue;
                }
                if (!globalRegion.name.contains(keyword)) continue;
                if (resultContains.length() < 2000) {
                    if (resultContains.length() > 0) {
                        resultContains.append("\n");
                    }
                    resultContains.append(String.format("%s '%s' found in %s", WordUtils.capitalize((String)enumGlobalRegionType.func_176610_l()), globalRegion.name, globalRegion.getFormattedLocation()));
                    continue;
                }
                resultContains.append(".");
            }
        }
        if (resultMatch.length() > 0) {
            return resultMatch.toString();
        }
        if (resultCaseInsensitive.length() > 0) {
            return resultCaseInsensitive.toString();
        }
        if (resultContains.length() > 0) {
            return resultContains.toString();
        }
        return String.format("No %s found with name '%s'", enumGlobalRegionType.func_176610_l(), keyword);
    }

    @Nullable
    public static GlobalRegion getNearest(EnumGlobalRegionType enumGlobalRegionType, @Nonnull World world, @Nonnull BlockPos blockPos) {
        CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(world.field_73011_w.getDimension());
        if (setGlobalRegions == null) {
            return null;
        }
        double distanceSquared_min = Double.MAX_VALUE;
        GlobalRegion result = null;
        for (GlobalRegion globalRegion : setGlobalRegions) {
            double dZ;
            double dY;
            double dX;
            double distanceSquared;
            if (enumGlobalRegionType != null && globalRegion.type != enumGlobalRegionType || !((distanceSquared = (dX = (double)(globalRegion.x - blockPos.func_177958_n())) * dX + (dY = (double)(globalRegion.y - blockPos.func_177956_o())) * dY + (dZ = (double)(globalRegion.z - blockPos.func_177952_p())) * dZ) < distanceSquared_min)) continue;
            distanceSquared_min = distanceSquared;
            result = globalRegion;
        }
        return result;
    }

    @Nonnull
    public static ArrayList<GlobalRegion> getContainers(EnumGlobalRegionType enumGlobalRegionType, @Nonnull World world, @Nonnull BlockPos blockPos) {
        CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(world.field_73011_w.getDimension());
        if (setGlobalRegions == null) {
            return new ArrayList<GlobalRegion>(0);
        }
        ArrayList<GlobalRegion> listContainers = new ArrayList<GlobalRegion>(5);
        for (GlobalRegion globalRegion : setGlobalRegions) {
            if (enumGlobalRegionType != null && globalRegion.type != enumGlobalRegionType || !globalRegion.contains(blockPos)) continue;
            TileEntity tileEntity = world.func_175625_s(globalRegion.getBlockPos());
            if (!(tileEntity instanceof IGlobalRegionProvider)) {
                GlobalRegionManager.cleanup();
                continue;
            }
            listContainers.add(globalRegion);
        }
        return listContainers;
    }

    public static boolean onBlockUpdating(@Nullable Entity entity, @Nonnull World world, @Nonnull BlockPos blockPos, IBlockState blockState) {
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to GlobalRegionManager:onBlockUpdating outside main thread, for %s %s", blockState, Commons.format(world, blockPos)));
            return false;
        }
        CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(world.field_73011_w.getDimension());
        if (setGlobalRegions == null) {
            return true;
        }
        boolean isAllowed = true;
        for (GlobalRegion registryItem : setGlobalRegions) {
            TileEntity tileEntity;
            if (!registryItem.contains(blockPos) || registryItem.getBlockPos().equals((Object)blockPos) || !((tileEntity = world.func_175625_s(registryItem.getBlockPos())) instanceof IGlobalRegionProvider)) continue;
            isAllowed = isAllowed && ((IGlobalRegionProvider)tileEntity).onBlockUpdatingInArea(entity, blockPos, blockState);
        }
        return isAllowed;
    }

    public static boolean onChatReceived(@Nonnull EntityPlayer entityPlayer, @Nonnull String message) {
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to GlobalRegionManager:onChatReceived outside main thread, for %s %s", entityPlayer, message));
            return false;
        }
        CopyOnWriteArraySet<GlobalRegion> setGlobalRegions = registry.get(entityPlayer.field_70170_p.field_73011_w.getDimension());
        if (setGlobalRegions == null) {
            return true;
        }
        BlockPos blockPos = entityPlayer.func_180425_c();
        boolean isCancelled = false;
        for (GlobalRegion registryItem : setGlobalRegions) {
            TileEntity tileEntity;
            if (registryItem.type != EnumGlobalRegionType.VIRTUAL_ASSISTANT || !registryItem.contains(blockPos) || !((tileEntity = entityPlayer.field_70170_p.func_175625_s(registryItem.getBlockPos())) instanceof TileEntityVirtualAssistant)) continue;
            isCancelled = isCancelled || ((TileEntityVirtualAssistant)tileEntity).onChatReceived(entityPlayer, message);
        }
        return isCancelled;
    }

    @Nonnull
    public static ArrayList<RadarEcho> getRadarEchos(@Nonnull TileEntity tileEntity, int radius) {
        ArrayList<RadarEcho> arrayListRadarEchos = new ArrayList<RadarEcho>(registry.size());
        GlobalRegionManager.cleanup();
        CelestialObject celestialObject = CelestialObjectManager.get(tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177952_p());
        Vector3 vectorRadar = GlobalRegionManager.getUniversalCoordinates(celestialObject, tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
        int radius2 = radius * radius;
        for (Map.Entry<Integer, CopyOnWriteArraySet<GlobalRegion>> entryDimension : registry.entrySet()) {
            for (GlobalRegion globalRegion : entryDimension.getValue()) {
                double dZ;
                double dY;
                double dX;
                double distance2;
                Vector3 vectorItem;
                if (!globalRegion.type.hasRadarEcho() || (vectorItem = globalRegion.getUniversalCoordinates(tileEntity.func_145831_w().field_72995_K)) == null || (distance2 = (dX = vectorItem.x - vectorRadar.x) * dX + (dY = vectorItem.y - vectorRadar.y) * dY + (dZ = vectorItem.z - vectorRadar.z) * dZ) > (double)radius2 || globalRegion.isolationRate != 0.0 && tileEntity.func_145831_w().field_73012_v.nextDouble() < globalRegion.isolationRate) continue;
                arrayListRadarEchos.add(new RadarEcho(globalRegion.type.func_176610_l(), vectorItem, globalRegion.mass, globalRegion.name));
            }
        }
        return arrayListRadarEchos;
    }

    public static String getGalaxyName(CelestialObject celestialObject, double x, double y, double z) {
        if (celestialObject == null) {
            return GALAXY_UNDEFINED;
        }
        CelestialObject celestialObjectNode = celestialObject;
        boolean hasHyperspace = celestialObjectNode.isHyperspace();
        while (celestialObjectNode.parent != null) {
            celestialObjectNode = celestialObjectNode.parent;
            hasHyperspace |= celestialObjectNode.isHyperspace();
        }
        return hasHyperspace ? celestialObjectNode.getDisplayName() : GALAXY_UNDEFINED;
    }

    public static Vector3 getUniversalCoordinates(CelestialObject celestialObject, double x, double y, double z) {
        if (celestialObject == null) {
            return null;
        }
        Vector3 vec3Result = new Vector3(x, y + 512.0, z);
        CelestialObject celestialObjectNode = celestialObject;
        boolean hasHyperspace = celestialObjectNode.isHyperspace();
        while (celestialObjectNode.parent != null) {
            VectorI vEntry = celestialObjectNode.getEntryOffset();
            vec3Result.x -= (double)vEntry.x;
            vec3Result.y -= 256.0;
            vec3Result.z -= (double)vEntry.z;
            celestialObjectNode = celestialObjectNode.parent;
            hasHyperspace |= celestialObjectNode.isHyperspace();
        }
        return hasHyperspace ? vec3Result : null;
    }

    public static void printRegistry(String trigger) {
        WarpDrive.logger.info(String.format("Global region registry after %s:", trigger));
        for (Map.Entry<Integer, CopyOnWriteArraySet<GlobalRegion>> entryDimension : registry.entrySet()) {
            StringBuilder message = new StringBuilder();
            for (GlobalRegion registryItem : entryDimension.getValue()) {
                message.append(String.format("\n- %s '%s' @ DIM%d (%d %d %d) with %.3f isolation rate", new Object[]{registryItem.type, registryItem.name, registryItem.dimensionId, registryItem.x, registryItem.y, registryItem.z, registryItem.isolationRate}));
            }
            WarpDrive.logger.info(String.format("- %d entries in dimension %d: %s", entryDimension.getValue().size(), entryDimension.getKey(), message));
        }
    }

    @Nullable
    public static TileEntityShipCore getIntersectingShipCore(@Nonnull TileEntityShipCore shipCore1) {
        GlobalRegionManager.cleanup();
        if (!shipCore1.isAssemblyValid()) {
            WarpDrive.logger.error(String.format("isShipCoreIntersectingWithOthers() with invalid ship %s, assuming intersection", shipCore1));
            return null;
        }
        AxisAlignedBB aabb1 = shipCore1.getGlobalRegionArea();
        CopyOnWriteArraySet<GlobalRegion> setRegistryItems = registry.get(shipCore1.func_145831_w().field_73011_w.getDimension());
        if (setRegistryItems == null) {
            return null;
        }
        for (GlobalRegion registryItem : setRegistryItems) {
            TileEntityShipCore shipCore2;
            TileEntity tileEntity;
            AxisAlignedBB aabb2;
            assert (registryItem.dimensionId == shipCore1.func_145831_w().field_73011_w.getDimension());
            if (registryItem.type != EnumGlobalRegionType.SHIP || registryItem.x == shipCore1.func_174877_v().func_177958_n() && registryItem.y == shipCore1.func_174877_v().func_177956_o() && registryItem.z == shipCore1.func_174877_v().func_177952_p() || !aabb1.func_72326_a(aabb2 = registryItem.getArea()) || !((tileEntity = shipCore1.func_145831_w().func_175625_s(registryItem.getBlockPos())) instanceof TileEntityShipCore) || !(shipCore2 = (TileEntityShipCore)tileEntity).isAssemblyValid() || shipCore2.isOffline() || shipCore2.getTierIndex() < shipCore1.getTierIndex()) continue;
            return shipCore2;
        }
        return null;
    }

    private static void cleanup() {
        if (!Commons.throttleMe("Global region registry cleanup", 180000L)) {
            return;
        }
        LocalProfiler.start("Global region registry cleanup");
        for (Map.Entry<Integer, CopyOnWriteArraySet<GlobalRegion>> entryDimension : registry.entrySet()) {
            WorldServer world = DimensionManager.getWorld((int)entryDimension.getKey());
            if (world == null) continue;
            for (GlobalRegion registryItem : entryDimension.getValue()) {
                boolean isValid = false;
                if (registryItem != null) {
                    boolean isLoaded;
                    if (world.func_72863_F() instanceof ChunkProviderServer) {
                        ChunkProviderServer chunkProviderServer = world.func_72863_F();
                        try {
                            Chunk chunk = (Chunk)chunkProviderServer.field_73244_f.get(ChunkPos.func_77272_a((int)(registryItem.x >> 4), (int)(registryItem.z >> 4)));
                            isLoaded = chunk != null && chunk.func_177410_o();
                        }
                        catch (NoSuchFieldError exception) {
                            if (!isExceptionReported) {
                                exception.printStackTrace(WarpDrive.printStreamError);
                                WarpDrive.logger.info(String.format("Unable to check non-loaded chunks for GlobalRegion %s", registryItem));
                                isExceptionReported = true;
                            }
                            isLoaded = chunkProviderServer.func_73149_a(registryItem.x >> 4, registryItem.z >> 4);
                        }
                    } else {
                        isLoaded = world.func_72863_F().func_73149_a(registryItem.x >> 4, registryItem.z >> 4);
                    }
                    if (!isLoaded) {
                        if (!WarpDrive.isDev || !WarpDriveConfig.LOGGING_GLOBAL_REGION_REGISTRY) continue;
                        WarpDrive.logger.debug(String.format("Skipping non-loaded GlobalRegion %s", registryItem));
                        continue;
                    }
                    Block block = world.func_180495_p(registryItem.getBlockPos()).func_177230_c();
                    TileEntity tileEntity = world.func_175625_s(registryItem.getBlockPos());
                    isValid = true;
                    switch (registryItem.type) {
                        case UNDEFINED: {
                            break;
                        }
                        case SHIP: {
                            isValid = block instanceof BlockShipCore && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                        case JUMP_GATE: {
                            break;
                        }
                        case PLANET: {
                            break;
                        }
                        case STAR: {
                            break;
                        }
                        case STRUCTURE: {
                            break;
                        }
                        case WARP_ECHO: {
                            break;
                        }
                        case ACCELERATOR: {
                            isValid = block instanceof BlockAcceleratorCore && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                        case TRANSPORTER: {
                            isValid = block instanceof BlockTransporterCore && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                        case VIRTUAL_ASSISTANT: {
                            isValid = block instanceof BlockVirtualAssistant && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                    }
                }
                if (isValid) continue;
                if (registryItem == null) {
                    WarpDrive.logger.warn("Cleaning up global region object ~null~");
                } else {
                    WarpDrive.logger.warn(String.format("Cleaning up global region object %s at dimension %d (%d %d %d)", new Object[]{registryItem.type, registryItem.dimensionId, registryItem.x, registryItem.y, registryItem.z}));
                }
                ++countRemove;
                entryDimension.getValue().remove(registryItem);
            }
        }
        LocalProfiler.stop();
    }

    public static void readFromNBT(@Nullable NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b("starMapRegistryItems") && !tagCompound.func_74764_b("globalRegions")) {
            registry.clear();
            return;
        }
        NBTTagList tagList = tagCompound.func_74764_b("starMapRegistryItems") ? tagCompound.func_150295_c("starMapRegistryItems", 10) : tagCompound.func_150295_c("globalRegions", 10);
        GlobalRegion[] registryFlat = new GlobalRegion[tagList.func_74745_c()];
        HashMap<Integer, Integer> sizeDimensions = new HashMap<Integer, Integer>();
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            Integer n;
            Integer n2;
            GlobalRegion globalRegion;
            registryFlat[index] = globalRegion = new GlobalRegion(tagList.func_150305_b(index));
            Integer n3 = n2 = sizeDimensions.computeIfAbsent(globalRegion.dimensionId, k -> 0);
            Integer n4 = n = Integer.valueOf(n2 + 1);
            sizeDimensions.put(globalRegion.dimensionId, n);
        }
        HashMap registryLocal = new HashMap();
        for (Map.Entry entry : sizeDimensions.entrySet()) {
            registryLocal.put(entry.getKey(), new ArrayList((Integer)entry.getValue()));
        }
        for (GlobalRegion globalRegion : registryFlat) {
            ((ArrayList)registryLocal.get(globalRegion.dimensionId)).add(globalRegion);
        }
        registry.clear();
        for (Map.Entry entry : registryLocal.entrySet()) {
            registry.put((Integer)entry.getKey(), new CopyOnWriteArraySet((Collection)entry.getValue()));
        }
    }

    public static void writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (CopyOnWriteArraySet<GlobalRegion> globalRegions : registry.values()) {
            for (GlobalRegion globalRegion : globalRegions) {
                NBTTagCompound tagCompoundItem = new NBTTagCompound();
                globalRegion.writeToNBT(tagCompoundItem);
                tagList.func_74742_a((NBTBase)tagCompoundItem);
            }
        }
        tagCompound.func_74782_a("globalRegions", (NBTBase)tagList);
    }
}

