/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryWrapper {
    public static boolean isInventory(TileEntity tileEntity, EnumFacing facing) {
        boolean isInventory = false;
        if (tileEntity instanceof IInventory) {
            isInventory = true;
        }
        if (!isInventory && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            isInventory = true;
        }
        return isInventory;
    }

    public static Object getInventory(TileEntity tileEntity, EnumFacing facing) {
        if (tileEntity instanceof IInventory) {
            return tileEntity;
        }
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        }
        return null;
    }

    @Nonnull
    public static Collection<Object> getConnectedInventories(World world, BlockPos blockPos) {
        ArrayList<Object> result = new ArrayList<Object>(6);
        ArrayList<IItemHandler> resultCapabilities = new ArrayList<IItemHandler>(6);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            mutableBlockPos.func_181079_c(blockPos.func_177958_n() + side.func_82601_c(), blockPos.func_177956_o() + side.func_96559_d(), blockPos.func_177952_p() + side.func_82599_e());
            TileEntity tileEntity = world.func_175625_s((BlockPos)mutableBlockPos);
            if (tileEntity instanceof IInventory) {
                result.add(tileEntity);
                if (!(tileEntity instanceof TileEntityChest)) continue;
                TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
                tileEntityChest.func_145979_i();
                if (tileEntityChest.field_145991_k != null) {
                    result.add(tileEntityChest.field_145991_k);
                    continue;
                }
                if (tileEntityChest.field_145990_j != null) {
                    result.add(tileEntityChest.field_145990_j);
                    continue;
                }
                if (tileEntityChest.field_145992_i != null) {
                    result.add(tileEntityChest.field_145992_i);
                    continue;
                }
                if (tileEntityChest.field_145988_l == null) continue;
                result.add(tileEntityChest.field_145988_l);
                continue;
            }
            if (tileEntity == null || (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) == null) continue;
            resultCapabilities.add(itemHandler);
        }
        result.addAll(resultCapabilities);
        return result;
    }

    public static boolean addToConnectedInventories(World world, BlockPos blockPos, ItemStack itemStack) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(1);
        itemStacks.add(itemStack);
        Collection<Object> inventories = InventoryWrapper.getConnectedInventories(world, blockPos);
        return InventoryWrapper.addToInventories(world, blockPos, inventories, itemStacks);
    }

    public static boolean addToConnectedInventories(World world, BlockPos blockPos, List<ItemStack> itemStacks) {
        Collection<Object> inventories = InventoryWrapper.getConnectedInventories(world, blockPos);
        return InventoryWrapper.addToInventories(world, blockPos, inventories, itemStacks);
    }

    public static boolean addToInventories(World world, BlockPos blockPos, Collection<Object> inventories, List<ItemStack> itemStacks) {
        boolean overflow = false;
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.func_190926_b()) {
                    WarpDrive.logger.error(String.format("Invalid empty itemStack %s", Commons.format(world, blockPos)));
                    continue;
                }
                int qtyLeft = itemStack.func_190916_E();
                ItemStack itemStackLeft = itemStack;
                for (Object inventory : inventories) {
                    if (inventory instanceof IInventory) {
                        qtyLeft = InventoryWrapper.addToInventory(itemStack, (IInventory)inventory);
                    } else if (inventory instanceof IItemHandler) {
                        qtyLeft = InventoryWrapper.addToInventory(itemStack, (IItemHandler)inventory);
                    } else {
                        WarpDrive.logger.error(String.format("Invalid inventory type %s, please report to mod author: %s", Commons.format(world, blockPos), inventory));
                    }
                    if (qtyLeft <= 0) break;
                    if (itemStackLeft == itemStack) {
                        itemStackLeft = itemStack.func_77946_l();
                    }
                    itemStackLeft.func_190920_e(qtyLeft);
                }
                if (qtyLeft <= 0) continue;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(String.format("Overflow detected %s", Commons.format(world, blockPos)));
                }
                overflow = true;
                while (qtyLeft > 0) {
                    int transfer = Math.min(qtyLeft, itemStackLeft.func_77976_d());
                    ItemStack itemStackDrop = Commons.copyWithSize(itemStackLeft, transfer);
                    EntityItem entityItem = new EntityItem(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.0, (double)blockPos.func_177952_p() + 0.5, itemStackDrop);
                    world.func_72838_d((Entity)entityItem);
                    qtyLeft -= transfer;
                }
            }
        }
        return overflow;
    }

    private static int addToInventory(ItemStack itemStackSource, IInventory inventory) {
        int transfer;
        ItemStack itemStack;
        int indexSlot;
        if (itemStackSource == null || itemStackSource.func_190926_b()) {
            return 0;
        }
        int qtyLeft = itemStackSource.func_190916_E();
        if (inventory == null) {
            return qtyLeft;
        }
        for (indexSlot = 0; indexSlot < inventory.func_70302_i_(); ++indexSlot) {
            if (!inventory.func_94041_b(indexSlot, itemStackSource) || (itemStack = inventory.func_70301_a(indexSlot)).func_190926_b() || !itemStack.func_77969_a(itemStackSource)) continue;
            transfer = Math.min(Math.min(qtyLeft, itemStack.func_77976_d() - itemStack.func_190916_E()), inventory.func_70297_j_());
            itemStack.func_190917_f(transfer);
            if ((qtyLeft -= transfer) > 0) continue;
            return 0;
        }
        for (indexSlot = 0; indexSlot < inventory.func_70302_i_(); ++indexSlot) {
            if (!inventory.func_94041_b(indexSlot, itemStackSource) || !(itemStack = inventory.func_70301_a(indexSlot)).func_190926_b()) continue;
            transfer = Math.min(Math.min(qtyLeft, itemStackSource.func_77976_d()), inventory.func_70297_j_());
            ItemStack dest = Commons.copyWithSize(itemStackSource, transfer);
            inventory.func_70299_a(indexSlot, dest);
            if ((qtyLeft -= transfer) > 0) continue;
            return 0;
        }
        return qtyLeft;
    }

    private static int addToInventory(ItemStack itemStackSource, IItemHandler itemHandler) {
        ItemStack itemStack;
        int indexSlot;
        if (itemStackSource == null || itemStackSource.func_190926_b()) {
            return 0;
        }
        if (itemHandler == null) {
            return itemStackSource.func_190916_E();
        }
        ItemStack itemStackLeft = itemStackSource;
        for (indexSlot = 0; indexSlot < itemHandler.getSlots(); ++indexSlot) {
            if (!itemHandler.isItemValid(indexSlot, itemStackSource) || (itemStack = itemHandler.getStackInSlot(indexSlot)).func_190926_b() || !itemStack.func_77969_a(itemStackSource) || (itemStackLeft = itemHandler.insertItem(indexSlot, itemStackLeft, false)).func_190916_E() > 0) continue;
            return 0;
        }
        for (indexSlot = 0; indexSlot < itemHandler.getSlots(); ++indexSlot) {
            if (!itemHandler.isItemValid(indexSlot, itemStackSource) || !(itemStack = itemHandler.getStackInSlot(indexSlot)).func_190926_b() || (itemStackLeft = itemHandler.insertItem(indexSlot, itemStackSource, false)).func_190916_E() > 0) continue;
            return 0;
        }
        return itemStackLeft.func_190916_E();
    }

    public static int getSize(Object inventory) {
        if (inventory instanceof IInventory) {
            return ((IInventory)inventory).func_70302_i_();
        }
        if (inventory instanceof IItemHandler) {
            return ((IItemHandler)inventory).getSlots();
        }
        if (inventory instanceof ItemStack) {
            return 1;
        }
        WarpDrive.logger.error(String.format("Invalid inventory type, please report to mod author: %s", inventory));
        return 0;
    }

    public static ItemStack getStackInSlot(Object inventory, int indexSlot) {
        if (inventory instanceof IInventory) {
            return ((IInventory)inventory).func_70301_a(indexSlot);
        }
        if (inventory instanceof IItemHandler) {
            return ((IItemHandler)inventory).getStackInSlot(indexSlot);
        }
        if (inventory instanceof ItemStack) {
            return (ItemStack)inventory;
        }
        WarpDrive.logger.error(String.format("Invalid inventory type, please report to mod author: %s", inventory));
        return ItemStack.field_190927_a;
    }

    public static boolean isItemValid(Object inventory, int indexSlot, ItemStack itemStack) {
        if (inventory instanceof IInventory) {
            return ((IInventory)inventory).func_94041_b(indexSlot, itemStack);
        }
        if (inventory instanceof IItemHandler) {
            return ((IItemHandler)inventory).isItemValid(indexSlot, itemStack);
        }
        WarpDrive.logger.error(String.format("Invalid inventory type, please report to mod author: %s", inventory));
        return false;
    }

    public static void insertItem(Object inventory, int indexSlot, ItemStack itemStack) {
        if (inventory instanceof IInventory) {
            ItemStack itemStackExisting = ((IInventory)inventory).func_70301_a(indexSlot);
            if (itemStackExisting.func_190926_b()) {
                ((IInventory)inventory).func_70299_a(indexSlot, itemStack);
            } else {
                WarpDrive.logger.error(String.format("Invalid inventory slot %d for insertion of %s, inventory should be empty first, please report to mod author: %s", indexSlot, itemStack, inventory));
                if (inventory instanceof TileEntity) {
                    World world = ((TileEntity)inventory).func_145831_w();
                    BlockPos blockPos = ((TileEntity)inventory).func_174877_v();
                    EntityItem entityItem = new EntityItem(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.0, (double)blockPos.func_177952_p() + 0.5, itemStack);
                    world.func_72838_d((Entity)entityItem);
                }
            }
        } else if (inventory instanceof IItemHandler) {
            ((IItemHandler)inventory).insertItem(indexSlot, itemStack, false);
        } else {
            WarpDrive.logger.error(String.format("Invalid inventory type, please report to mod author: %s", inventory));
        }
    }

    public static void decrStackSize(Object inventory, int indexSlot, int quantity) {
        if (inventory instanceof IInventory) {
            ((IInventory)inventory).func_70298_a(indexSlot, quantity);
        } else if (inventory instanceof IItemHandler) {
            ((IItemHandler)inventory).extractItem(indexSlot, quantity, false);
        } else {
            WarpDrive.logger.error(String.format("Invalid inventory type, please report to mod author: %s", inventory));
        }
    }
}

