/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.block.movement.BlockShipCore;
import cr0s.warpdrive.compat.CompatForgeMultipart;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.WarpDriveDataFixer;
import cr0s.warpdrive.data.EnumTier;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkManager;
import ic2.api.network.NetworkHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class JumpBlock {
    public Block block;
    public int blockMeta;
    public boolean hasTileEntity;
    public WeakReference<TileEntity> weakTileEntity;
    public NBTTagCompound blockNBT;
    public int x;
    public int y;
    public int z;
    public HashMap<String, NBTBase> externals;
    private static final byte[] mrotNone = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotRail = new byte[]{1, 0, 5, 4, 2, 3, 7, 8, 9, 6, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotAnvil = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotFenceGate = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12};
    private static final byte[] mrotPumpkin = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotEndPortalFrame = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotCocoa = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotRepeater = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12};
    private static final byte[] mrotBed = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotStair = new byte[]{2, 3, 1, 0, 6, 7, 5, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotSign = new byte[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
    private static final byte[] mrotTrapDoor = new byte[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13};
    private static final byte[] mrotLever = new byte[]{7, 3, 4, 2, 1, 6, 5, 0, 15, 11, 12, 10, 9, 14, 13, 8};
    private static final byte[] mrotNetherPortal = new byte[]{0, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotVine = new byte[]{0, 2, 4, 6, 8, 10, 12, 14, 1, 3, 5, 7, 9, 11, 13, 15};
    private static final byte[] mrotButton = new byte[]{0, 3, 4, 2, 1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotMushroom = new byte[]{0, 3, 6, 9, 2, 5, 8, 1, 4, 7, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotForgeDirection = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotPiston = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 13, 12, 10, 11, 14, 15};
    private static final byte[] mrotWoodLog = new byte[]{0, 1, 2, 3, 8, 9, 10, 11, 4, 5, 6, 7, 12, 13, 14, 15};

    public JumpBlock() {
    }

    public JumpBlock(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nullable TileEntity tileEntity) {
        this.x = blockPos.func_177958_n();
        this.y = blockPos.func_177956_o();
        this.z = blockPos.func_177952_p();
        this.block = blockState.func_177230_c();
        this.blockMeta = blockState.func_177230_c().func_176201_c(blockState);
        if (tileEntity == null) {
            this.hasTileEntity = false;
            this.weakTileEntity = null;
            this.blockNBT = null;
        } else {
            this.hasTileEntity = true;
            this.weakTileEntity = new WeakReference<TileEntity>(tileEntity);
            this.blockNBT = new NBTTagCompound();
            tileEntity.func_189515_b(this.blockNBT);
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("Saving from (%d %d %d) with TileEntity %s", this.x, this.y, this.z, this.blockNBT));
            }
        }
        for (Map.Entry<String, IBlockTransformer> entryBlockTransformer : WarpDriveConfig.blockTransformers.entrySet()) {
            if (!entryBlockTransformer.getValue().isApplicable(this.block, this.blockMeta, tileEntity)) continue;
            NBTBase nbtBase = entryBlockTransformer.getValue().saveExternals(world, this.x, this.y, this.z, this.block, this.blockMeta, tileEntity);
            this.setExternal(entryBlockTransformer.getKey(), nbtBase);
        }
    }

    public JumpBlock(@Nonnull Filler filler, int x, int y, int z) {
        if (filler.block == null) {
            WarpDrive.logger.info(String.format("Forcing glass for invalid filler with null block at (%d %d %d)", x, y, z));
            filler.block = Blocks.field_150359_w;
        }
        this.block = filler.block;
        this.blockMeta = filler.metadata;
        this.hasTileEntity = false;
        this.weakTileEntity = null;
        this.blockNBT = filler.tagCompound != null ? filler.tagCompound.func_74737_b() : null;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void refreshSource(@Nonnull World worldSource) {
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        IBlockState blockState = worldSource.func_180495_p(blockPos);
        if (blockState.func_177230_c() != this.block) {
            WarpDrive.logger.error(String.format("Source block has changed to %s, updating in %s", blockState, this));
            this.block = blockState.func_177230_c();
            this.blockMeta = this.block.func_176201_c(blockState);
            this.hasTileEntity = false;
            this.weakTileEntity = null;
            this.blockNBT = null;
            return;
        }
        if (this.block.func_176201_c(blockState) != this.blockMeta) {
            WarpDrive.logger.error(String.format("Source block variation has changed to %s, updating in %s", blockState, this));
            this.blockMeta = this.block.func_176201_c(blockState);
        }
        TileEntity tileEntity = worldSource.func_175625_s(blockPos);
        if (this.hasTileEntity && tileEntity == null || !this.hasTileEntity && tileEntity != null) {
            WarpDrive.logger.error(String.format("Tile entity has changed, refreshing in %s", this));
        }
        this.hasTileEntity = tileEntity != null;
        this.weakTileEntity = this.hasTileEntity ? new WeakReference<TileEntity>(tileEntity) : null;
        this.blockNBT = null;
    }

    public TileEntity getTileEntity(@Nonnull World worldSource) {
        if (!this.hasTileEntity) {
            return null;
        }
        TileEntity tileEntity = (TileEntity)this.weakTileEntity.get();
        if (tileEntity != null) {
            return tileEntity;
        }
        WarpDrive.logger.error(String.format("Tile entity lost in %s", this));
        tileEntity = worldSource.func_175625_s(new BlockPos(this.x, this.y, this.z));
        this.weakTileEntity = new WeakReference<TileEntity>(tileEntity);
        return tileEntity;
    }

    @Nullable
    private NBTTagCompound getBlockNBT(@Nonnull World worldSource) {
        if (!this.hasTileEntity) {
            return this.blockNBT == null ? null : this.blockNBT.func_74737_b();
        }
        TileEntity tileEntity = this.getTileEntity(worldSource);
        if (tileEntity == null) {
            WarpDrive.logger.error(String.format("No more tile entity in %s", this));
            return null;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tileEntity.func_189515_b(tagCompound);
        return tagCompound;
    }

    public NBTBase getExternal(String modId) {
        if (this.externals == null) {
            return null;
        }
        NBTBase nbtExternal = this.externals.get(modId);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info(String.format("Returning externals from (%d %d %d) of %s: %s", this.x, this.y, this.z, modId, nbtExternal));
        }
        if (nbtExternal == null) {
            return null;
        }
        return nbtExternal.func_74737_b();
    }

    private void setExternal(String modId, NBTBase nbtExternal) {
        if (this.externals == null) {
            this.externals = new HashMap();
        }
        this.externals.put(modId, nbtExternal);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info(String.format("Saved externals from (%d %d %d) of %s: %s", this.x, this.y, this.z, modId, nbtExternal));
        }
    }

    private int getMetadataRotation(NBTTagCompound nbtTileEntity, byte rotationSteps) {
        if (rotationSteps == 0) {
            return this.blockMeta;
        }
        byte[] mrot = mrotNone;
        if (this.block instanceof BlockRailBase) {
            mrot = mrotRail;
        } else if (this.block instanceof BlockAnvil) {
            mrot = mrotAnvil;
        } else if (this.block instanceof BlockFenceGate) {
            mrot = mrotFenceGate;
        } else if (this.block instanceof BlockPumpkin || this.block instanceof BlockTripWireHook) {
            mrot = mrotPumpkin;
        } else if (this.block instanceof BlockEndPortalFrame || this.block instanceof BlockDoor) {
            mrot = mrotEndPortalFrame;
        } else if (this.block instanceof BlockCocoa) {
            mrot = mrotCocoa;
        } else if (this.block instanceof BlockRedstoneDiode) {
            mrot = mrotRepeater;
        } else if (this.block instanceof BlockBed) {
            mrot = mrotBed;
        } else if (this.block instanceof BlockStairs) {
            mrot = mrotStair;
        } else if (this.block instanceof BlockSign) {
            mrot = this.block == Blocks.field_150444_as ? mrotForgeDirection : mrotSign;
        } else if (this.block instanceof BlockTrapDoor) {
            mrot = mrotTrapDoor;
        } else if (this.block instanceof BlockLever) {
            mrot = mrotLever;
        } else if (this.block instanceof BlockPortal) {
            mrot = mrotNetherPortal;
        } else if (this.block instanceof BlockVine) {
            mrot = mrotVine;
        } else if (this.block instanceof BlockButton || this.block instanceof BlockTorch) {
            mrot = mrotButton;
        } else if (this.block instanceof BlockHugeMushroom) {
            mrot = mrotMushroom;
        } else if (this.block instanceof BlockFurnace || this.block instanceof BlockDispenser || this.block instanceof BlockHopper || this.block instanceof BlockChest || this.block instanceof BlockEnderChest || this.block instanceof BlockLadder) {
            mrot = mrotForgeDirection;
        } else if (this.block instanceof BlockPistonBase || this.block instanceof BlockPistonExtension || this.block instanceof BlockPistonMoving) {
            mrot = mrotPiston;
        } else if (this.block instanceof BlockLog) {
            mrot = mrotWoodLog;
        } else if (this.block instanceof BlockSkull) {
            byte facing = nbtTileEntity.func_74771_c("Rot");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("Rot", mrotSign[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("Rot", mrotSign[mrotSign[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("Rot", mrotSign[mrotSign[mrotSign[facing]]]);
                    break;
                }
            }
        } else {
            return IBlockTransformer.rotateFirstEnumFacingProperty(this.block, this.blockMeta, rotationSteps);
        }
        switch (rotationSteps) {
            case 1: {
                return mrot[this.blockMeta];
            }
            case 2: {
                return mrot[mrot[this.blockMeta]];
            }
            case 3: {
                return mrot[mrot[mrot[this.blockMeta]]];
            }
        }
        return this.blockMeta;
    }

    @Nullable
    public BlockPos deploy(World worldSource, World worldTarget, ITransformation transformation) {
        try {
            NBTTagCompound nbtToDeploy = this.getBlockNBT(worldSource);
            int newBlockMeta = this.blockMeta;
            if (this.externals != null) {
                for (Map.Entry<String, NBTBase> external : this.externals.entrySet()) {
                    IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                    if (blockTransformer == null) continue;
                    newBlockMeta = blockTransformer.rotate(this.block, this.blockMeta, nbtToDeploy, transformation);
                }
            } else {
                newBlockMeta = this.getMetadataRotation(nbtToDeploy, transformation.getRotationSteps());
            }
            BlockPos target = transformation.apply(this.x, this.y, this.z);
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("Deploying to (%d %d %d) of %s@%d: %s", target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), this.block, newBlockMeta, nbtToDeploy));
            }
            IBlockState blockState = this.block.func_176203_a(newBlockMeta);
            FastSetBlockState.setBlockStateNoLight(worldTarget, target, blockState, 2);
            if (nbtToDeploy != null) {
                NBTTagCompound nbtScreenData;
                nbtToDeploy.func_74768_a("x", target.func_177958_n());
                nbtToDeploy.func_74768_a("y", target.func_177956_o());
                nbtToDeploy.func_74768_a("z", target.func_177952_p());
                if (nbtToDeploy.func_74764_b("screenData") && (nbtScreenData = nbtToDeploy.func_74775_l("screenData")).func_74764_b("minX") && nbtScreenData.func_74764_b("minY") && nbtScreenData.func_74764_b("minZ") && nbtScreenData.func_74764_b("maxX") && nbtScreenData.func_74764_b("maxY") && nbtScreenData.func_74764_b("maxZ")) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(String.format("%s deploy: TileEntity has screenData.min/maxXYZ", this));
                    }
                    BlockPos minTarget = transformation.apply(nbtScreenData.func_74762_e("minX"), nbtScreenData.func_74762_e("minY"), nbtScreenData.func_74762_e("minZ"));
                    nbtScreenData.func_74768_a("minX", minTarget.func_177958_n());
                    nbtScreenData.func_74768_a("minY", minTarget.func_177956_o());
                    nbtScreenData.func_74768_a("minZ", minTarget.func_177952_p());
                    BlockPos maxTarget = transformation.apply(nbtScreenData.func_74762_e("maxX"), nbtScreenData.func_74762_e("maxY"), nbtScreenData.func_74762_e("maxZ"));
                    nbtScreenData.func_74768_a("maxX", maxTarget.func_177958_n());
                    nbtScreenData.func_74768_a("maxY", maxTarget.func_177956_o());
                    nbtScreenData.func_74768_a("maxZ", maxTarget.func_177952_p());
                    nbtToDeploy.func_74782_a("screenData", (NBTBase)nbtScreenData);
                }
                TileEntity newTileEntity = null;
                boolean isForgeMultipart = false;
                if (WarpDriveConfig.isForgeMultipartLoaded && nbtToDeploy.func_74764_b("id") && nbtToDeploy.func_74779_i("id").equals("savedMultipart")) {
                    isForgeMultipart = true;
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(String.format("%s deploy: TileEntity is ForgeMultipart", this));
                    }
                    newTileEntity = (TileEntity)CompatForgeMultipart.methodMultipartHelper_createTileFromNBT.invoke(null, worldTarget, nbtToDeploy);
                }
                if (newTileEntity == null && (newTileEntity = TileEntity.func_190200_a((World)worldTarget, (NBTTagCompound)nbtToDeploy)) == null) {
                    WarpDrive.logger.error(String.format("%s deploy failed to create new tile entity %s block %s:%d", this, Commons.format(worldTarget, this.x, this.y, this.z), this.block, this.blockMeta));
                    WarpDrive.logger.error(String.format("NBT data was %s", nbtToDeploy));
                }
                if (newTileEntity != null) {
                    worldTarget.func_175690_a(target, newTileEntity);
                    if (isForgeMultipart) {
                        CompatForgeMultipart.methodTileMultipart_onChunkLoad.invoke((Object)newTileEntity, new Object[0]);
                        CompatForgeMultipart.methodMultipartHelper_sendDescPacket.invoke(null, worldTarget, newTileEntity);
                    }
                    newTileEntity.onLoad();
                    newTileEntity.func_70296_d();
                }
            }
            return target;
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Deploy failed from (%d %d %d) of %s:%d", this.x, this.y, this.z, this.block, this.blockMeta));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshBlockStateOnClient(@Nonnull World world, @Nonnull BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) return;
        Class<?> teClass = tileEntity.getClass();
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info(String.format("Refreshing clients %s with %s derived from %s", Commons.format(world, blockPos), teClass, teClass.getSuperclass()));
        }
        tileEntity.func_145836_u();
        String className = teClass.getName();
        try {
            if (!WarpDriveConfig.isIndustrialCraft2Loaded || !(tileEntity instanceof INetworkDataProvider)) return;
            List fields = ((INetworkDataProvider)tileEntity).getNetworkedFields();
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("Tile has %d networked fields: %s", fields.size(), fields));
            }
            INetworkManager networkManager = NetworkHelper.getNetworkManager((Side)Side.SERVER);
            for (String field : fields) {
                try {
                    networkManager.updateTileEntityField(tileEntity, field);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.info(String.format("Exception involving TileEntity %s %s", className, Commons.format(world, blockPos)));
        }
    }

    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        String blockName = tagCompound.func_74779_i("block");
        this.blockMeta = tagCompound.func_74771_c("blockMeta");
        String stringBlockState = String.format("%s@%d", blockName, this.blockMeta);
        IBlockState blockState = WarpDriveDataFixer.getBlockState(stringBlockState);
        if (blockState == null) {
            if (WarpDriveConfig.LOGGING_BUILDING) {
                WarpDrive.logger.warn(String.format("Ignoring unknown blockstate %s from tag %s, consider updating your warpdrive/dataFixer.yml", stringBlockState, tagCompound));
            }
            this.block = Blocks.field_150350_a;
            return;
        }
        this.block = blockState.func_177230_c();
        this.blockMeta = blockState.func_177230_c().func_176201_c(blockState);
        this.hasTileEntity = false;
        this.weakTileEntity = null;
        if (tagCompound.func_74764_b("blockNBT")) {
            this.blockNBT = tagCompound.func_74775_l("blockNBT");
            if (this.blockNBT.func_74764_b("computerID")) {
                this.blockNBT.func_82580_o("computerID");
            }
            if (this.blockNBT.func_74764_b("oc:computer")) {
                NBTTagCompound tagComputer = this.blockNBT.func_74775_l("oc:computer");
                tagComputer.func_82580_o("components");
                tagComputer.func_82580_o("node");
                this.blockNBT.func_74782_a("oc:computer", (NBTBase)tagComputer);
            }
        } else {
            this.blockNBT = null;
        }
        this.x = tagCompound.func_74762_e("x");
        this.y = tagCompound.func_74762_e("y");
        this.z = tagCompound.func_74762_e("z");
        if (tagCompound.func_74764_b("externals")) {
            NBTTagCompound tagCompoundExternals = tagCompound.func_74775_l("externals");
            this.externals = new HashMap();
            for (Object key : tagCompoundExternals.func_150296_c()) {
                assert (key instanceof String);
                this.externals.put((String)key, tagCompoundExternals.func_74781_a((String)key));
            }
        } else {
            this.externals = null;
        }
    }

    public void writeToNBT(@Nonnull World worldSource, @Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        tagCompound.func_74774_a("blockMeta", (byte)this.blockMeta);
        NBTTagCompound nbtTileEntity = this.getBlockNBT(worldSource);
        if (nbtTileEntity != null) {
            tagCompound.func_74782_a("blockNBT", (NBTBase)nbtTileEntity);
        }
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
        if (this.externals != null && !this.externals.isEmpty()) {
            NBTTagCompound tagCompoundExternals = new NBTTagCompound();
            for (Map.Entry<String, NBTBase> entry : this.externals.entrySet()) {
                if (entry.getValue() == null) {
                    tagCompoundExternals.func_74778_a(entry.getKey(), "");
                    continue;
                }
                tagCompoundExternals.func_74782_a(entry.getKey(), entry.getValue());
            }
            tagCompound.func_74782_a("externals", (NBTBase)tagCompoundExternals);
        }
    }

    public void removeUniqueIDs() {
        JumpBlock.removeUniqueIDs(this.blockNBT);
    }

    public static void removeUniqueIDs(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("computerID")) {
            tagCompound.func_82580_o("computerID");
            tagCompound.func_82580_o("label");
        }
        if (tagCompound.func_74764_b("uuidMost")) {
            tagCompound.func_82580_o("uuidMost");
            tagCompound.func_82580_o("uuidLeast");
        }
        if (tagCompound.func_74764_b("oc:node")) {
            tagCompound.func_82580_o("oc:node");
        }
        if (tagCompound.func_74764_b("jumpCount")) {
            tagCompound.func_82580_o("jumpCount");
        }
        if (tagCompound.func_74764_b("oc:computer")) {
            NBTTagCompound tagComputer = tagCompound.func_74775_l("oc:computer");
            tagComputer.func_82580_o("chunkX");
            tagComputer.func_82580_o("chunkZ");
            tagComputer.func_82580_o("components");
            tagComputer.func_82580_o("dimension");
            tagComputer.func_82580_o("node");
            tagCompound.func_74782_a("oc:computer", (NBTBase)tagComputer);
        }
        if (tagCompound.func_74764_b("oc:items")) {
            NBTTagList tagListItems = tagCompound.func_150295_c("oc:items", 10);
            for (int indexItemSlot = 0; indexItemSlot < tagListItems.func_74745_c(); ++indexItemSlot) {
                NBTTagCompound tagCompoundItemSlot = tagListItems.func_150305_b(indexItemSlot);
                NBTTagCompound tagCompoundItem = tagCompoundItemSlot.func_74775_l("item");
                NBTTagCompound tagCompoundTag = tagCompoundItem.func_74775_l("tag");
                NBTTagCompound tagCompoundOCData = tagCompoundTag.func_74775_l("oc:data");
                NBTTagCompound tagCompoundNode = tagCompoundOCData.func_74775_l("node");
                if (!tagCompoundNode.func_74764_b("address")) continue;
                tagCompoundNode.func_82580_o("address");
            }
        }
        if (tagCompound.func_74764_b("oc:keyboard")) {
            NBTTagCompound tagCompoundKeyboard = tagCompound.func_74775_l("oc:keyboard");
            tagCompoundKeyboard.func_82580_o("node");
        }
        if (tagCompound.func_74764_b("oc:hasPower")) {
            tagCompound.func_82580_o("node");
        }
        if (tagCompound.func_74764_b("Owner")) {
            tagCompound.func_74778_a("Owner", "None");
        }
        if (tagCompound.func_74764_b("OwnerUUID")) {
            tagCompound.func_82580_o("OwnerUUID");
        }
        if (tagCompound.func_74764_b("owner")) {
            tagCompound.func_74778_a("owner", "None");
        }
        if (tagCompound.func_74764_b("ownerUUID")) {
            tagCompound.func_82580_o("ownerUUID");
        }
    }

    public static void emptyEnergyStorage(@Nonnull NBTTagCompound tagCompound) {
        NBTTagCompound tagCompoundBattery;
        if (tagCompound.func_150297_b("battery", 10) && (tagCompoundBattery = tagCompound.func_74775_l("battery")).func_150297_b("energy", 3)) {
            tagCompoundBattery.func_74768_a("energy", 0);
        }
        if (tagCompound.func_150297_b("mStoredEnergy", 3)) {
            tagCompound.func_74768_a("mStoredEnergy", 0);
        }
        if (tagCompound.func_150297_b("energy", 6)) {
            tagCompound.func_74780_a("energy", 0.0);
        }
        if (tagCompound.func_150297_b("Energy", 3)) {
            tagCompound.func_74768_a("Energy", 0);
        }
        if (tagCompound.func_150297_b("electricityStored", 6)) {
            tagCompound.func_74780_a("electricityStored", 0.0);
        }
        if (tagCompound.func_150297_b("energy", 4)) {
            tagCompound.func_74772_a("energy", 0L);
        }
    }

    public void fillEnergyStorage() {
        EnumTier enumTier;
        if (this.block instanceof IBlockBase && (enumTier = ((IBlockBase)this.block).getTier(null)) != EnumTier.CREATIVE) {
            if (this.block instanceof BlockShipCore) {
                this.blockNBT.func_74772_a("energy", (long)WarpDriveConfig.SHIP_MAX_ENERGY_STORED_BY_TIER[enumTier.getIndex()]);
            }
            if (this.block instanceof BlockCapacitor) {
                this.blockNBT.func_74772_a("energy", (long)WarpDriveConfig.CAPACITOR_MAX_ENERGY_STORED_BY_TIER[enumTier.getIndex()]);
            }
        }
    }

    public String toString() {
        return String.format("%s @ (%d %d %d) %s:%d %s nbt %s", this.getClass().getSimpleName(), this.x, this.y, this.z, this.block.getRegistryName(), this.blockMeta, this.weakTileEntity == null ? null : this.weakTileEntity.get(), this.blockNBT);
    }
}

