/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.entity.EntityOfflineAvatar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class OfflineAvatarManager {
    private static final HashMap<UUID, GlobalPosition> registry = new HashMap(512);

    public static void update(@Nonnull EntityOfflineAvatar entityOfflineAvatar) {
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to OfflineAvatarManager:update outside main thread, for %s", new Object[]{entityOfflineAvatar}));
            return;
        }
        if (entityOfflineAvatar.getPlayerUUID() == null) {
            WarpDrive.logger.error(String.format("Ignoring update for invalid EntityOfflineAvatar with no UUID %s", new Object[]{entityOfflineAvatar}));
            return;
        }
        GlobalPosition globalPositionActual = registry.get(entityOfflineAvatar.getPlayerUUID());
        if (globalPositionActual == null || globalPositionActual.dimensionId != entityOfflineAvatar.field_70170_p.field_73011_w.getDimension() || globalPositionActual.x != (int)Math.floor(entityOfflineAvatar.field_70165_t) || globalPositionActual.y != (int)Math.floor(entityOfflineAvatar.field_70163_u) || globalPositionActual.z != (int)Math.floor(entityOfflineAvatar.field_70161_v)) {
            GlobalPosition globalPositionUpdated = new GlobalPosition((Entity)entityOfflineAvatar);
            registry.put(entityOfflineAvatar.getPlayerUUID(), globalPositionUpdated);
            if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
                if (globalPositionActual == null) {
                    WarpDrive.logger.info(String.format("Added offline avatar for %s (%s) %s", entityOfflineAvatar.getPlayerName(), entityOfflineAvatar.getPlayerUUID(), Commons.format(globalPositionUpdated)));
                } else {
                    WarpDrive.logger.info(String.format("Updated offline avatar for %s (%s) from %s to %s", entityOfflineAvatar.getPlayerName(), entityOfflineAvatar.getPlayerUUID(), Commons.format(globalPositionActual), Commons.format(globalPositionUpdated)));
                }
            }
        }
    }

    public static void remove(@Nonnull EntityOfflineAvatar entityOfflineAvatar) {
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to OfflineAvatarManager:remove outside main thread, for %s", new Object[]{entityOfflineAvatar}));
            return;
        }
        if (entityOfflineAvatar.getPlayerUUID() == null) {
            WarpDrive.logger.error(String.format("Ignoring removal for invalid EntityOfflineAvatar with no UUID %s", new Object[]{entityOfflineAvatar}));
            return;
        }
        GlobalPosition globalPosition = registry.get(entityOfflineAvatar.getPlayerUUID());
        if (globalPosition != null && globalPosition.dimensionId == entityOfflineAvatar.field_70170_p.field_73011_w.getDimension() && globalPosition.x == (int)Math.floor(entityOfflineAvatar.field_70165_t) && globalPosition.y == (int)Math.floor(entityOfflineAvatar.field_70163_u) && globalPosition.z == (int)Math.floor(entityOfflineAvatar.field_70161_v)) {
            registry.remove(entityOfflineAvatar.getPlayerUUID());
            if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
                WarpDrive.logger.info(String.format("Removed offline avatar registration for %s (%s) %s", new Object[]{entityOfflineAvatar.getPlayerName(), entityOfflineAvatar.getPlayerUUID(), entityOfflineAvatar}));
            }
        }
    }

    private static void remove(@Nonnull EntityPlayer entityPlayer) {
        GlobalPosition globalPosition = registry.remove(entityPlayer.func_110124_au());
        if (globalPosition != null && WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
            WarpDrive.logger.info(String.format("Removed offline avatar registration for %s (%s) %s", entityPlayer.func_70005_c_(), entityPlayer.func_110124_au(), Commons.format(globalPosition)));
        }
        List entityOfflineAvatars = entityPlayer.field_70170_p.func_175644_a(EntityOfflineAvatar.class, entity -> entity != null && entity.func_70089_S() && entityPlayer.func_110124_au().equals(entity.getPlayerUUID()));
        for (EntityOfflineAvatar entityOfflineAvatar : entityOfflineAvatars) {
            entityOfflineAvatar.func_70106_y();
        }
    }

    @Nullable
    public static GlobalPosition get(@Nonnull UUID uuidPlayer) {
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to OfflineAvatarManager:get outside main thread, for %s", uuidPlayer));
            return null;
        }
        return registry.get(uuidPlayer);
    }

    public static void readFromNBT(@Nullable NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b("offlineAvatars")) {
            registry.clear();
            return;
        }
        NBTTagList tagList = tagCompound.func_150295_c("offlineAvatars", 10);
        HashMap<UUID, GlobalPosition> registryLocal = new HashMap<UUID, GlobalPosition>(tagList.func_74745_c());
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            NBTTagCompound tagCompoundItem = tagList.func_150305_b(index);
            UUID uuid = tagCompoundItem.func_186857_a("");
            GlobalPosition globalPosition = new GlobalPosition(tagCompoundItem);
            registryLocal.put(uuid, globalPosition);
        }
        registry.clear();
        registry.putAll(registryLocal);
        for (Map.Entry entry : registryLocal.entrySet()) {
            registry.put((UUID)entry.getKey(), (GlobalPosition)entry.getValue());
        }
    }

    public static void writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, GlobalPosition> entry : registry.entrySet()) {
            NBTTagCompound tagCompoundItem = new NBTTagCompound();
            tagCompoundItem.func_186854_a("", entry.getKey());
            entry.getValue().writeToNBT(tagCompoundItem);
            tagList.func_74742_a((NBTBase)tagCompoundItem);
        }
        tagCompound.func_74782_a("offlineAvatars", (NBTBase)tagList);
    }

    public static void onPlayerLoggedOut(@Nonnull EntityPlayer entityPlayer) {
        GlobalRegion globalRegionNearestShip;
        if (entityPlayer.field_70128_L) {
            if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
                WarpDrive.logger.info(String.format("Skipping offline avatar for dead player %s", entityPlayer));
            }
            return;
        }
        World world = entityPlayer.field_70170_p;
        BlockPos blockPos = entityPlayer.func_180425_c();
        if (WarpDriveConfig.OFFLINE_AVATAR_CREATE_ONLY_ABOARD_SHIPS && ((globalRegionNearestShip = GlobalRegionManager.getNearest(EnumGlobalRegionType.SHIP, world, blockPos)) == null || !globalRegionNearestShip.contains(blockPos))) {
            if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
                WarpDrive.logger.info(String.format("Skipping offline avatar for off board player %s", entityPlayer));
            }
            return;
        }
        WarpDrive.logger.debug(String.format("Spawning offline avatar for %s", entityPlayer));
        EntityOfflineAvatar entityOfflineAvatar = new EntityOfflineAvatar(world);
        entityOfflineAvatar.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.1, (double)blockPos.func_177952_p() + 0.5, entityPlayer.field_70177_z, entityPlayer.field_70125_A);
        entityOfflineAvatar.func_96094_a(entityPlayer.getDisplayNameString());
        entityOfflineAvatar.setPlayer(entityPlayer.func_110124_au(), entityPlayer.func_70005_c_());
        entityOfflineAvatar.func_82142_c(entityPlayer.func_175149_v());
        entityOfflineAvatar.func_184224_h(entityPlayer.func_184812_l_() || entityPlayer.func_175149_v());
        for (EntityEquipmentSlot entityEquipmentSlot : EntityEquipmentSlot.values()) {
            ItemStack itemStack = entityPlayer.func_184582_a(entityEquipmentSlot).func_77946_l();
            if (itemStack.func_190926_b() || Dictionary.ITEMS_EXCLUDED_AVATAR.contains(itemStack.func_77973_b())) continue;
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            assert (itemStack.func_77978_p() != null);
            itemStack.func_77978_p().func_74757_a("isFakeItem", true);
            entityOfflineAvatar.func_184201_a(entityEquipmentSlot, itemStack);
            entityOfflineAvatar.func_184642_a(entityEquipmentSlot, 0.0f);
        }
        boolean isSuccess = world.func_72838_d((Entity)entityOfflineAvatar);
        if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
            if (isSuccess) {
                WarpDrive.logger.info(String.format("Spawned offline avatar for %s", entityPlayer));
            } else {
                WarpDrive.logger.error(String.format("Failed to spawn offline avatar for %s", entityPlayer));
            }
        }
    }

    public static void onPlayerLoggedIn(@Nonnull EntityPlayer entityPlayer) {
        double distance;
        assert (!entityPlayer.isAddedToWorld());
        GlobalPosition globalPosition = registry.get(entityPlayer.func_110124_au());
        if (globalPosition == null) {
            return;
        }
        if (globalPosition.dimensionId == entityPlayer.field_71093_bK && (distance = entityPlayer.func_70011_f((double)globalPosition.x + 0.5, (double)globalPosition.y, (double)globalPosition.z + 0.5)) < (double)WarpDriveConfig.OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL) {
            if (WarpDriveConfig.OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS == 0) {
                OfflineAvatarManager.remove(entityPlayer);
            }
            return;
        }
        if (WarpDriveConfig.LOGGING_OFFLINE_AVATAR) {
            WarpDrive.logger.info(String.format("Relocating player %s (%s) %s to their offline avatar %s", entityPlayer.func_70005_c_(), entityPlayer.func_110124_au(), Commons.format((Entity)entityPlayer), Commons.format(globalPosition)));
        }
        entityPlayer.field_71093_bK = globalPosition.dimensionId;
        entityPlayer.func_70107_b((double)globalPosition.x + 0.5, (double)globalPosition.y + 0.1, (double)globalPosition.z + 0.5);
        if (WarpDriveConfig.OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS == 0) {
            OfflineAvatarManager.remove(entityPlayer);
        }
    }

    private static boolean isInRange(@Nonnull EntityPlayer entityPlayer, @Nonnull GlobalPosition globalPosition) {
        float dX = (float)(entityPlayer.field_70165_t - (double)globalPosition.x);
        float dY = (float)(entityPlayer.field_70163_u - (double)globalPosition.y);
        float dZ = (float)(entityPlayer.field_70161_v - (double)globalPosition.z);
        float distance = MathHelper.func_76129_c((float)(dX * dX + dY * dY + dZ * dZ));
        return distance >= WarpDriveConfig.OFFLINE_AVATAR_MIN_RANGE_FOR_REMOVAL && distance <= WarpDriveConfig.OFFLINE_AVATAR_MAX_RANGE_FOR_REMOVAL;
    }

    public static void onTick(@Nonnull EntityPlayer entityPlayer) {
        if (WarpDriveConfig.OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS == 0 || entityPlayer.field_70173_aa == 0 || entityPlayer.field_70173_aa % WarpDriveConfig.OFFLINE_AVATAR_DELAY_FOR_REMOVAL_TICKS != 0) {
            return;
        }
        GlobalPosition globalPosition = registry.get(entityPlayer.func_110124_au());
        if (globalPosition == null) {
            return;
        }
        if (globalPosition.dimensionId == entityPlayer.field_70170_p.field_73011_w.getDimension() && OfflineAvatarManager.isInRange(entityPlayer, globalPosition)) {
            OfflineAvatarManager.remove(entityPlayer);
        }
    }
}

