/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerIdName {
    private final UUID uuid;
    private String name;

    public PlayerIdName(@Nonnull EntityPlayer entityPlayer) {
        this.uuid = entityPlayer.func_110124_au();
        this.name = entityPlayer.func_70005_c_();
    }

    private PlayerIdName(@Nonnull UUID uuid, @Nonnull String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public static PlayerIdName loadFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_150296_c().contains("UUID") || !tagCompound.func_150296_c().contains("name")) {
            return null;
        }
        UUID uuid = UUID.fromString(tagCompound.func_74779_i("UUID"));
        String name = tagCompound.func_74779_i("name");
        return new PlayerIdName(uuid, name);
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("UUID", this.uuid.toString());
        tagCompound.func_74778_a("name", this.name);
        return tagCompound;
    }
}

