/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.block.BlockAbstractOmnipanel;
import cr0s.warpdrive.block.breathing.BlockAirFlow;
import cr0s.warpdrive.block.breathing.BlockAirSource;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.event.ChunkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.BlockFluidBase;

public class StateAir {
    public static final int AIR_DEFAULT = 0x60000C0;
    static final int USED_MASK = 0x77FFFF0F;
    static final int CONCENTRATION_MASK = 31;
    static final int CONCENTRATION_MAX = 31;
    static final int GENERATOR_DIRECTION_MASK = 224;
    static final int GENERATOR_PRESSURE_MASK = 65280;
    static final int VOID_PRESSURE_MASK = 0xFF0000;
    static final int VOID_DIRECTION_MASK = 0x7000000;
    static final int BLOCK_MASK = 0x70000000;
    static final int GENERATOR_DIRECTION_SHIFT = 5;
    static final int GENERATOR_PRESSURE_SHIFT = 8;
    static final int VOID_PRESSURE_SHIFT = 16;
    static final int VOID_DIRECTION_SHIFT = 24;
    static final int GENERATOR_PRESSURE_MAX = 255;
    static final int VOID_PRESSURE_MAX = 255;
    static final int BLOCK_UNKNOWN = 0;
    static final int BLOCK_SEALER = 0x10000000;
    static final int BLOCK_AIR_PLACEABLE = 0x20000000;
    static final int BLOCK_AIR_FLOW = 0x30000000;
    static final int BLOCK_AIR_SOURCE = 0x40000000;
    static final int BLOCK_AIR_NON_PLACEABLE_V = 0x50000000;
    static final int BLOCK_AIR_NON_PLACEABLE_H = 0x60000000;
    static final int BLOCK_AIR_NON_PLACEABLE = 0x70000000;
    static final int TICKING_MASK = 0xFFFF1F;
    private ChunkData chunkData;
    private Chunk chunk;
    private final BlockPos.MutableBlockPos blockPos;
    protected int dataAir;
    protected IBlockState blockState;
    public byte concentration;
    public short pressureGenerator;
    public short pressureVoid;
    public EnumFacing directionGenerator;
    public EnumFacing directionVoid;
    private static final short[] rotDirection = new short[]{0, 1, 5, 4, 2, 3, 6, 7};

    public StateAir(ChunkData chunkData) {
        this.chunkData = chunkData;
        this.chunk = null;
        this.blockPos = new BlockPos.MutableBlockPos();
    }

    public void refresh(World world, int x, int y, int z) throws ExceptionChunkNotLoaded {
        this.blockPos.func_181079_c(x, y, z);
        this.refresh(world);
    }

    public void refresh(World world, StateAir stateAir, EnumFacing forgeDirection) throws ExceptionChunkNotLoaded {
        this.blockPos.func_181079_c(stateAir.blockPos.func_177958_n() + forgeDirection.func_82601_c(), stateAir.blockPos.func_177956_o() + forgeDirection.func_96559_d(), stateAir.blockPos.func_177952_p() + forgeDirection.func_82599_e());
        this.refresh(world);
    }

    private void refresh(World world) throws ExceptionChunkNotLoaded {
        if (this.chunkData == null || !this.chunkData.isInside(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p())) {
            this.chunkData = ChunkHandler.getChunkData(world, this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p());
            if (this.chunkData == null) {
                throw new ExceptionChunkNotLoaded(String.format("Air refresh aborted %s", Commons.format(world, this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p())));
            }
            this.chunk = null;
        }
        if (this.chunk == null) {
            this.chunk = world.func_175726_f((BlockPos)this.blockPos);
        }
        this.blockState = null;
        this.dataAir = this.chunkData.getDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p());
        if (this.dataAir == 0) {
            this.dataAir = 0x60000C0;
        }
        this.concentration = (byte)(this.dataAir & 0x1F);
        this.pressureGenerator = (short)((this.dataAir & 0xFF00) >> 8);
        this.pressureVoid = (short)((this.dataAir & 0xFF0000) >> 16);
        this.directionGenerator = Commons.getDirection((this.dataAir & 0xE0) >> 5);
        this.directionVoid = Commons.getDirection((this.dataAir & 0x7000000) >> 24);
        if ((this.dataAir & 0x70000000) == 0) {
            this.updateBlockCache(world);
        }
        this.updateVoidSource();
    }

    public void clearCache() {
        this.chunkData = null;
        this.chunk = null;
    }

    public IBlockState getBlockState(World world) {
        if (this.blockState == null) {
            this.updateBlockCache(world);
        }
        return this.blockState;
    }

    public void updateBlockCache(World world) {
        this.blockState = this.blockPos.func_177956_o() >= 0 && this.blockPos.func_177956_o() < 256 ? this.chunk.func_186032_a(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()) : Blocks.field_150350_a.func_176223_P();
        this.updateBlockType(world);
    }

    private void updateVoidSource() {
        if (!this.isAir()) {
            this.setGenerator((short)0, null);
            this.setVoid((short)0, null);
        } else if (this.pressureGenerator == 0) {
            this.setVoid((short)0, null);
        } else if (this.pressureGenerator == 1) {
            this.setVoid((short)255, this.directionGenerator.func_176734_d());
        } else if (this.blockPos.func_177956_o() == 0) {
            this.setVoid((short)255, EnumFacing.DOWN);
        } else if (this.blockPos.func_177956_o() == 255) {
            this.setVoid((short)255, EnumFacing.UP);
        } else if (this.blockState != null) {
            boolean isVoid;
            int highestBlock = this.chunk.func_177440_h((BlockPos)this.blockPos).func_177956_o();
            boolean bl = isVoid = highestBlock < this.blockPos.func_177956_o();
            if (isVoid) {
                this.setVoid((short)255, EnumFacing.UP);
            } else if (this.pressureVoid == 255) {
                this.setVoid((short)0, null);
            }
        }
    }

    private void setBlockToNoAir(World world) {
        world.func_180501_a((BlockPos)this.blockPos, Blocks.field_150350_a.func_176223_P(), 2);
        this.blockState = Blocks.field_150350_a.func_176223_P();
        this.updateBlockType(world);
    }

    private void setBlockToAirFlow(World world) {
        world.func_180501_a((BlockPos)this.blockPos, WarpDrive.blockAirFlow.func_176223_P(), 2);
        this.blockState = WarpDrive.blockAirFlow.func_176223_P();
        this.updateBlockType(world);
    }

    public boolean setAirSource(World world, EnumFacing direction, short pressure) {
        boolean updateRequired;
        assert (this.blockState != null);
        boolean isPlaceable = (this.dataAir & 0x70000000) == 0x20000000 || (this.dataAir & 0x70000000) == 0x30000000 || (this.dataAir & 0x70000000) == 0x40000000;
        boolean bl = updateRequired = this.blockState.func_177230_c() != WarpDrive.blockAirSource || this.pressureGenerator != pressure || this.pressureVoid != 0 || this.concentration != 31;
        if (updateRequired && isPlaceable) {
            this.blockState = WarpDrive.blockAirSource.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING, (Comparable)direction);
            world.func_180501_a((BlockPos)this.blockPos, this.blockState, 2);
            this.updateBlockType(world);
            try {
                this.setGeneratorAndUpdateVoid(world, pressure, direction.func_176734_d());
            }
            catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
                // empty catch block
            }
            this.setConcentration(world, (byte)31);
        }
        return updateRequired;
    }

    public void removeAirSource(World world) {
        this.setBlockToAirFlow(world);
        this.setConcentration(world, (byte)1);
    }

    private void updateBlockType(World world) {
        int typeBlock;
        assert (this.blockState != null);
        Block block = this.blockState.func_177230_c();
        if (block instanceof BlockAirFlow) {
            typeBlock = 0x30000000;
        } else if (block == Blocks.field_150350_a) {
            typeBlock = 0x20000000;
        } else if (this.blockState.func_185904_a() == Material.field_151584_j || block.isFoliage((IBlockAccess)world, (BlockPos)this.blockPos)) {
            typeBlock = 0x70000000;
        } else if (block instanceof BlockAirSource) {
            typeBlock = 0x40000000;
        } else if (this.blockState.func_185915_l()) {
            typeBlock = 0x10000000;
        } else if (block instanceof BlockAbstractOmnipanel) {
            typeBlock = 0x10000000;
        } else if (block instanceof BlockStairs) {
            typeBlock = 0x10000000;
        } else if (block instanceof BlockStaticLiquid || block instanceof BlockDynamicLiquid) {
            Block blockAbove = world.func_180495_p(this.blockPos.func_177972_a(EnumFacing.UP)).func_177230_c();
            typeBlock = blockAbove == block || blockAbove instanceof BlockStaticLiquid || blockAbove instanceof BlockDynamicLiquid ? 0x10000000 : 0x60000000;
        } else if (block instanceof BlockFluidBase) {
            int density = BlockFluidBase.getDensity((IBlockAccess)world, (BlockPos)this.blockPos);
            Block blockFlowing = world.func_180495_p(this.blockPos.func_177972_a(density > 0 ? EnumFacing.UP : EnumFacing.DOWN)).func_177230_c();
            typeBlock = blockFlowing == block ? 0x10000000 : 0x60000000;
        } else if (block.isAir(this.blockState, (IBlockAccess)world, (BlockPos)this.blockPos) || block.func_176200_f((IBlockAccess)world, (BlockPos)this.blockPos)) {
            typeBlock = 0x70000000;
        } else if (block instanceof BlockPane) {
            typeBlock = 0x50000000;
        } else {
            AxisAlignedBB axisAlignedBB = this.blockState.func_185890_d((IBlockAccess)world, (BlockPos)this.blockPos);
            if (axisAlignedBB == null) {
                typeBlock = 0x70000000;
            } else {
                boolean fullZ;
                boolean fullX = axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a > 0.99;
                boolean fullY = axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b > 0.99;
                boolean bl = fullZ = axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c > 0.99;
                typeBlock = fullX && fullY && fullZ ? 0x10000000 : (fullX && fullZ ? 0x60000000 : (fullY && (fullX || fullZ) ? 0x50000000 : 0x70000000));
            }
        }
        if ((this.dataAir & 0x70000000) != typeBlock) {
            this.dataAir = this.dataAir & 0x8FFFFFFF | typeBlock;
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
        }
    }

    public void setConcentration(World world, byte concentrationNew) {
        assert (concentrationNew >= 0 && concentrationNew <= 31);
        if (concentrationNew == 0) {
            if (this.isAirFlow()) {
                if (this.blockState == null) {
                    this.updateBlockCache(world);
                }
                if (this.isAirFlow()) {
                    this.setBlockToNoAir(world);
                }
            }
        } else if ((this.dataAir & 0x70000000) == 0x20000000) {
            if (this.blockState == null) {
                int dataAirLegacy = this.dataAir;
                this.updateBlockCache(world);
                if ((this.dataAir & 0x70000000) != 0x20000000) {
                    if (WarpDrive.isDev) {
                        WarpDrive.logger.info(String.format("Desynchronized air state detected %s: %8x -> %s", Commons.format(world, (BlockPos)this.blockPos), dataAirLegacy, this));
                    }
                    return;
                }
            }
            this.setBlockToAirFlow(world);
        }
        if (this.concentration != concentrationNew) {
            this.dataAir = this.dataAir & 0xFFFFFFE0 | concentrationNew;
            this.concentration = concentrationNew;
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
        }
    }

    protected void setGeneratorAndUpdateVoid(World world, short pressureNew, EnumFacing directionNew) throws ExceptionChunkNotLoaded {
        if (pressureNew == 0 && this.pressureVoid > 0) {
            this.removeGeneratorAndCascade(world);
        } else {
            this.setGenerator(pressureNew, directionNew);
            this.updateVoidSource();
        }
    }

    private void setGenerator(short pressureNew, EnumFacing directionNew) {
        boolean isUpdated = false;
        if (pressureNew != this.pressureGenerator) {
            assert (pressureNew >= 0 && pressureNew <= 255);
            this.dataAir = this.dataAir & 0xFFFF00FF | pressureNew << 8;
            this.pressureGenerator = pressureNew;
            isUpdated = true;
        }
        if (directionNew != this.directionGenerator) {
            this.dataAir = this.dataAir & 0xFFFFFF1F | Commons.getOrdinal(directionNew) << 5;
            this.directionGenerator = directionNew;
            isUpdated = true;
        }
        if (isUpdated) {
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
        }
        assert (this.pressureGenerator != 0 || this.directionGenerator == null);
        assert (this.pressureGenerator == 0 || this.pressureGenerator == 255 || this.directionGenerator != null);
        assert (this.pressureGenerator == 0 || this.directionGenerator != null);
    }

    protected void removeGeneratorAndCascade(World world) throws ExceptionChunkNotLoaded {
        this.removeGeneratorAndCascade(world, WarpDriveConfig.BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS);
    }

    private void removeGeneratorAndCascade(World world, int depth) throws ExceptionChunkNotLoaded {
        if (this.pressureGenerator != 0) {
            assert (this.directionGenerator != null);
            this.dataAir = this.dataAir & 0xFFFF001F | Commons.getOrdinal(null) << 5;
            this.pressureGenerator = 0;
            this.directionGenerator = null;
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
            if (depth > 0) {
                StateAir stateAir = new StateAir(this.chunkData);
                for (EnumFacing direction : EnumFacing.values()) {
                    stateAir.refresh(world, this, direction);
                    if (stateAir.pressureGenerator <= 0 || stateAir.directionGenerator != direction.func_176734_d()) continue;
                    stateAir.removeGeneratorAndCascade(world, depth - 1);
                }
            }
        }
    }

    protected void setVoid(short pressureNew, EnumFacing directionNew) {
        boolean isUpdated = false;
        if (pressureNew != this.pressureVoid) {
            assert (pressureNew >= 0 && pressureNew <= 255);
            this.dataAir = this.dataAir & 0xFF00FFFF | pressureNew << 16;
            this.pressureVoid = pressureNew;
            isUpdated = true;
        }
        if (directionNew != this.directionVoid) {
            this.dataAir = this.dataAir & 0xF8FFFFFF | Commons.getOrdinal(directionNew) << 24;
            this.directionVoid = directionNew;
            isUpdated = true;
        }
        if (isUpdated) {
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
        }
        assert (this.pressureVoid != 0 || this.directionVoid == null);
        assert (this.pressureVoid == 0 || this.directionVoid != null);
        assert (this.pressureVoid == 0 || this.pressureVoid == 255 || this.directionVoid != null);
    }

    protected void removeVoidAndCascade(World world) throws ExceptionChunkNotLoaded {
        this.removeVoidAndCascade(world, WarpDriveConfig.BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS);
    }

    private void removeVoidAndCascade(World world, int depth) throws ExceptionChunkNotLoaded {
        if (this.pressureVoid != 0) {
            assert (this.directionVoid != null);
            this.dataAir = this.dataAir & 0xF800FFFF | Commons.getOrdinal(null) << 24;
            this.pressureVoid = 0;
            this.directionVoid = null;
            this.chunkData.setDataAir(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir);
            if (depth > 0) {
                StateAir stateAir = new StateAir(this.chunkData);
                for (EnumFacing direction : EnumFacing.values()) {
                    stateAir.refresh(world, this, direction);
                    if (stateAir.pressureVoid <= 0 || stateAir.directionVoid != direction.func_176734_d()) continue;
                    stateAir.removeVoidAndCascade(world, depth - 1);
                }
            }
        }
    }

    public boolean isAir() {
        return (this.dataAir & 0x70000000) != 0x10000000;
    }

    public boolean isAir(EnumFacing forgeDirection) {
        switch (this.dataAir & 0x70000000) {
            case 0x10000000: {
                return false;
            }
            case 0x20000000: {
                return true;
            }
            case 0x30000000: {
                return true;
            }
            case 0x40000000: {
                return true;
            }
            case 0x50000000: {
                return forgeDirection.func_96559_d() != 0;
            }
            case 0x60000000: {
                return forgeDirection.func_96559_d() == 0;
            }
            case 0x70000000: {
                return true;
            }
        }
        return false;
    }

    public boolean isAirSource() {
        return (this.dataAir & 0x70000000) == 0x40000000;
    }

    public boolean isAirFlow() {
        return (this.dataAir & 0x70000000) == 0x30000000;
    }

    public boolean isVoidSource() {
        return this.pressureVoid == 255;
    }

    protected boolean isLeakingHorizontally() {
        return (this.dataAir & 0x70000000) == 0x60000000;
    }

    protected boolean isLeakingVertically() {
        return (this.dataAir & 0x70000000) == 0x50000000;
    }

    protected static boolean isEmptyData(int dataAir) {
        return (dataAir & 0xFFFF1F) == 0 && (dataAir & 0x70000000) != 0x30000000;
    }

    private static int rotateDirection(int direction, byte rotationSteps) {
        switch (rotationSteps) {
            case 1: {
                return rotDirection[direction];
            }
            case 2: {
                return rotDirection[rotDirection[direction]];
            }
            case 3: {
                return rotDirection[rotDirection[rotDirection[direction]]];
            }
        }
        return direction;
    }

    public static int rotate(int dataAir, byte rotationSteps) {
        int dataNoDirection = dataAir & 0xF8FFFF1F;
        int directionGenerator = StateAir.rotateDirection((dataAir & 0xE0) >> 5, rotationSteps);
        int directionVoid = StateAir.rotateDirection((dataAir & 0x7000000) >> 24, rotationSteps);
        return dataNoDirection | directionGenerator << 5 | directionVoid << 24;
    }

    public static void dumpAroundEntity(EntityPlayer entityPlayer) {
        try {
            StateAir[][][] stateAirs = new StateAir[3][3][3];
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        StateAir stateAir = new StateAir(null);
                        stateAir.refresh(entityPlayer.field_70170_p, MathHelper.func_76128_c((double)entityPlayer.field_70165_t) + dx, MathHelper.func_76128_c((double)entityPlayer.field_70163_u) + dy, MathHelper.func_76128_c((double)entityPlayer.field_70161_v) + dz);
                        stateAirs[dx + 1][dy + 1][dz + 1] = stateAir;
                    }
                }
            }
            StringBuilder message = new StringBuilder("------------------------------------------------\n");
            message.append("\u00c2\u00a73Air, \u00c2\u00a7aGenerator \u00c2\u00a77and \u00c2\u00a7dVoid \u00c2\u00a77stats at ").append(entityPlayer.field_70173_aa);
            for (int indexY = 2; indexY >= 0; --indexY) {
                for (int indexZ = 2; indexZ >= 0; --indexZ) {
                    String stringDirection;
                    String stringValue;
                    StateAir stateAir;
                    int indexX;
                    message.append("\n");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%2d", 100 + stateAir.concentration).substring(1);
                        message.append(String.format("\u00c2\u00a73%s ", stringValue));
                    }
                    message.append("\u00c2\u00a7f| ");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%X", 256 + stateAir.pressureGenerator).substring(1);
                        stringDirection = StateAir.directionToChar(stateAir.directionGenerator);
                        message.append(String.format("\u00c2\u00a7e%s \u00c2\u00a7a%s ", stringValue, stringDirection));
                    }
                    message.append("\u00c2\u00a7f| ");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%X", 256 + stateAir.pressureVoid).substring(1);
                        stringDirection = StateAir.directionToChar(stateAir.directionVoid);
                        message.append(String.format("\u00c2\u00a7e%s \u00c2\u00a7d%s ", stringValue, stringDirection));
                    }
                    if (indexZ == 2) {
                        message.append("\u00c2\u00a7f\\");
                        continue;
                    }
                    if (indexZ == 1) {
                        message.append(String.format("\u00c2\u00a7f  > y = %d", stateAirs[1][indexY][indexZ].blockPos.func_177956_o()));
                        continue;
                    }
                    message.append("\u00c2\u00a7f/");
                }
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentString(message.toString()));
        }
        catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
            // empty catch block
        }
    }

    private static String directionToChar(EnumFacing direction) {
        if (direction == null) {
            return "?";
        }
        switch (direction) {
            case UP: {
                return "U";
            }
            case DOWN: {
                return "D";
            }
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case EAST: {
                return "E";
            }
            case WEST: {
                return "W";
            }
        }
        return "x";
    }

    public String toString() {
        return String.format("StateAir @ (%6d %3d %6d) data 0x%08x, concentration %d, block %s", this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.dataAir, this.concentration, this.blockState);
    }
}

